/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;

public class GroovyClassNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @NotNull
    public String getDisplayName() {
        if ("Class naming convention" == null) {
            GroovyClassNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return "Class naming convention";
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyClassNamingConventionInspection.$$$reportNull$$$0(1);
        }
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            if ("Class name '#ref' is too short" == null) {
                GroovyClassNamingConventionInspection.$$$reportNull$$$0(2);
            }
            return "Class name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            if ("Class name '#ref' is too long" == null) {
                GroovyClassNamingConventionInspection.$$$reportNull$$$0(3);
            }
            return "Class name '#ref' is too long";
        }
        String string = "Class name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string == null) {
            GroovyClassNamingConventionInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        NamingConventionsVisitor namingConventionsVisitor = new NamingConventionsVisitor();
        if (namingConventionsVisitor == null) {
            GroovyClassNamingConventionInspection.$$$reportNull$$$0(5);
        }
        return namingConventionsVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitClassDefinition(@NotNull GrClassDefinition classDefinition) {
            if (classDefinition == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            super.visitClassDefinition(classDefinition);
            String name = classDefinition.getName();
            if (name == null) {
                return;
            }
            if (GroovyClassNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerClassError(classDefinition, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDefinition", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection$NamingConventionsVisitor", "visitClassDefinition"));
        }
    }
}

