/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;

public class GrTraitType
extends PsiType {
    @NotNull
    private final PsiIntersectionType myDelegate;
    @NotNull
    private final PsiType myExprType;
    @NotNull
    private final List<PsiType> myTraitTypes;

    private GrTraitType(@NotNull PsiIntersectionType delegate) {
        if (delegate == null) {
            GrTraitType.$$$reportNull$$$0(0);
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myDelegate = delegate;
        this.myExprType = delegate.getConjuncts()[0];
        this.myTraitTypes = ContainerUtil.newArrayList((Object[])delegate.getConjuncts(), (int)1, (int)delegate.getConjuncts().length);
    }

    @NotNull
    public PsiType getExprType() {
        PsiType psiType = this.myExprType;
        if (psiType == null) {
            GrTraitType.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    @NotNull
    public List<PsiType> getTraitTypes() {
        List<PsiType> list = this.myTraitTypes;
        if (list == null) {
            GrTraitType.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public PsiType[] getConjuncts() {
        PsiType[] psiTypeArray = this.myDelegate.getConjuncts();
        if (psiTypeArray == null) {
            GrTraitType.$$$reportNull$$$0(3);
        }
        return psiTypeArray;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myExprType.getPresentableText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, type -> type.getPresentableText()), (String)", ");
        if (string == null) {
            GrTraitType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myDelegate.getCanonicalText();
        if (string == null) {
            GrTraitType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.myExprType.getCanonicalText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, type -> type.getInternalCanonicalText()), (String)", ");
        if (string == null) {
            GrTraitType.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            GrTraitType.$$$reportNull$$$0(7);
        }
        return this.myDelegate.equalsToText(text);
    }

    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            GrTraitType.$$$reportNull$$$0(8);
        }
        return (A)this.myDelegate.accept(visitor2);
    }

    @Nullable
    public GlobalSearchScope getResolveScope() {
        return this.myDelegate.getResolveScope();
    }

    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = this.myDelegate.getSuperTypes();
        if (psiTypeArray == null) {
            GrTraitType.$$$reportNull$$$0(9);
        }
        return psiTypeArray;
    }

    @Nullable
    public static PsiType createTraitType(@NotNull GrSafeCastExpression safeCastExpression) {
        GrExpression operand;
        PsiType exprType;
        if (safeCastExpression == null) {
            GrTraitType.$$$reportNull$$$0(10);
        }
        if (!((exprType = (operand = safeCastExpression.getOperand()).getType()) instanceof PsiClassType) && !(exprType instanceof GrTraitType)) {
            return null;
        }
        GrTypeElement typeElement = safeCastExpression.getCastTypeElement();
        if (typeElement == null) {
            return null;
        }
        PsiType type = typeElement.getType();
        if (!GrTraitUtil.isTrait(PsiTypesUtil.getPsiClass((PsiType)type))) {
            return null;
        }
        return GrTraitType.createTraitType(exprType, ContainerUtil.newSmartList((Object)type));
    }

    @NotNull
    public static PsiType createTraitType(@NotNull PsiType type, @NotNull List<PsiType> traits) {
        if (type == null) {
            GrTraitType.$$$reportNull$$$0(11);
        }
        if (traits == null) {
            GrTraitType.$$$reportNull$$$0(12);
        }
        PsiType psiType = GrTraitType.createTraitType(ContainerUtil.prepend(traits, (Object[])new PsiType[]{type instanceof GrTraitType ? ((GrTraitType)type).myDelegate : type}));
        if (psiType == null) {
            GrTraitType.$$$reportNull$$$0(13);
        }
        return psiType;
    }

    @NotNull
    public static PsiType createTraitType(@NotNull List<PsiType> types) {
        if (types == null) {
            GrTraitType.$$$reportNull$$$0(14);
        }
        PsiType psiType = GrTraitType.createTraitType(types.toArray(PsiType.createArray((int)types.size())));
        if (psiType == null) {
            GrTraitType.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    @NotNull
    public static PsiType createTraitType(@NotNull PsiType[] types) {
        Set flattened;
        PsiType[] conjuncts;
        if (types == null) {
            GrTraitType.$$$reportNull$$$0(16);
        }
        if ((conjuncts = (flattened = PsiIntersectionType.flatten((PsiType[])types, (Set)new LinkedHashSet<PsiType>(){

            @Override
            public boolean add(PsiType type) {
                this.remove(type);
                return super.add(type);
            }
        })).toArray(PsiType.createArray((int)flattened.size()))).length == 1) {
            PsiType psiType = conjuncts[0];
            if (psiType == null) {
                GrTraitType.$$$reportNull$$$0(17);
            }
            return psiType;
        }
        GrTraitType grTraitType = new GrTraitType((PsiIntersectionType)PsiIntersectionType.createIntersection((boolean)false, (PsiType[])conjuncts));
        if (grTraitType == null) {
            GrTraitType.$$$reportNull$$$0(18);
        }
        return grTraitType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeCastExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traits";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExprType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConjuncts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createTraitType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTraitType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

