/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;

public abstract class GrTypeDefinitionElementType<TypeDef extends GrTypeDefinition>
extends GrStubElementType<GrTypeDefinitionStub, TypeDef> {
    public GrTypeDefinitionElementType(@NotNull String debugName) {
        if (debugName == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @NotNull
    public GrTypeDefinitionStub createStub(@NotNull TypeDef psi, StubElement parentStub) {
        if (psi == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(1);
        }
        byte flags = GrTypeDefinitionStub.buildFlags(psi);
        GrTypeDefinitionStub grTypeDefinitionStub = new GrTypeDefinitionStub(parentStub, psi.getName(), GrStubUtils.getBaseClassName(psi), this, psi.getQualifiedName(), GrStubUtils.getAnnotationNames(psi), flags);
        if (grTypeDefinitionStub == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(2);
        }
        return grTypeDefinitionStub;
    }

    public void serialize(@NotNull GrTypeDefinitionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(4);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getQualifiedName());
        dataStream.writeByte((int)stub.getFlags());
        dataStream.writeName(stub.getBaseClassName());
        GrTypeDefinitionElementType.writeStringArray(dataStream, stub.getAnnotations());
    }

    private static void writeStringArray(StubOutputStream dataStream, String[] names) throws IOException {
        dataStream.writeByte(names.length);
        for (String name : names) {
            dataStream.writeName(name);
        }
    }

    @NotNull
    public GrTypeDefinitionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(5);
        }
        String name = StringRef.toString((StringRef)dataStream.readName());
        String qname = StringRef.toString((StringRef)dataStream.readName());
        byte flags = dataStream.readByte();
        String baseClassName = StringRef.toString((StringRef)dataStream.readName());
        String[] annos = GrTypeDefinitionElementType.readStringArray(dataStream);
        GrTypeDefinitionStub grTypeDefinitionStub = new GrTypeDefinitionStub(parentStub, name, baseClassName, this, qname, annos, flags);
        if (grTypeDefinitionStub == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(6);
        }
        return grTypeDefinitionStub;
    }

    @NotNull
    private static String[] readStringArray(StubInputStream dataStream) throws IOException {
        int supersNumber = dataStream.readByte();
        String[] superClasses = new String[supersNumber];
        for (int i = 0; i < supersNumber; ++i) {
            superClasses[i] = StringRef.toString((StringRef)dataStream.readName());
        }
        if (superClasses == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(7);
        }
        return superClasses;
    }

    @Override
    public void indexStub(@NotNull GrTypeDefinitionStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            GrTypeDefinitionElementType.$$$reportNull$$$0(9);
        }
        if (stub.isAnonymous()) {
            String baseClassName = stub.getBaseClassName();
            if (baseClassName != null) {
                String shortName = PsiNameHelper.getShortClassName((String)baseClassName);
                sink.occurrence(GrAnonymousClassIndex.KEY, (Object)shortName);
            }
        } else {
            String fqn;
            String shortName = stub.getName();
            if (shortName != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)shortName);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(GrFullClassNameIndex.KEY, (Object)fqn.hashCode());
            }
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

