/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrRangeType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class ClosureParameterEnhancer
extends AbstractClosureParameterEnhancer {
    private static final Map<String, String> simpleTypes = new HashMap();
    private static final Set<String> iterations = new HashSet();

    @Override
    @Nullable
    protected PsiType getClosureParameterType(GrClosableBlock closure, int index) {
        if (PsiUtil.isCompileStatic(closure)) {
            return null;
        }
        return ClosureParameterEnhancer.inferType(closure, index);
    }

    @Nullable
    public static PsiType inferType(@NotNull GrClosableBlock closure, int index) {
        PsiElement parent;
        if (closure == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(0);
        }
        if ((parent = closure.getParent()) instanceof GrStringInjection && index == 0) {
            return TypesUtil.createTypeByFQClassName("java.io.StringWriter", closure);
        }
        if (parent instanceof GrArgumentList) {
            parent = parent.getParent();
        }
        if (!(parent instanceof GrMethodCall)) {
            return null;
        }
        String methodName = ClosureParameterEnhancer.findMethodName((GrMethodCall)parent);
        GrExpression expression = ((GrMethodCall)parent).getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return null;
        }
        GrExpression qualifier = ((GrReferenceExpression)expression).getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type = qualifier.getType();
        if (type == null) {
            return null;
        }
        GrParameter[] params = closure.getAllParameters();
        if (params.length == 1 && simpleTypes.containsKey(methodName)) {
            String typeText = simpleTypes.get(methodName);
            if (typeText.indexOf(60) < 0) {
                return TypesUtil.createTypeByFQClassName(typeText, closure);
            }
            return JavaPsiFacade.getElementFactory((Project)closure.getProject()).createTypeFromText(typeText, (PsiElement)closure);
        }
        if (iterations.contains(methodName)) {
            if (params.length == 1) {
                return ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)closure);
            }
            if (params.length == 2 && InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                if (index == 0) {
                    return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)0, (boolean)true);
                }
                return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)1, (boolean)true);
            }
        } else {
            if (GdkMethodUtil.isWithName(methodName) && params.length == 1) {
                return type;
            }
            if ("eachWithIndex".equals(methodName)) {
                PsiType res = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)closure);
                if (params.length == 2 && res != null) {
                    if (index == 0) {
                        return res;
                    }
                    return TypesUtil.createTypeByFQClassName("java.lang.Integer", closure);
                }
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                    if (params.length == 2) {
                        if (index == 0) {
                            return ClosureParameterEnhancer.getEntryForMap(type, closure.getProject(), closure.getResolveScope());
                        }
                        return TypesUtil.createTypeByFQClassName("java.lang.Integer", closure);
                    }
                    if (params.length == 3) {
                        if (index == 0) {
                            return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)0, (boolean)true);
                        }
                        if (index == 1) {
                            return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)1, (boolean)true);
                        }
                        return TypesUtil.createTypeByFQClassName("java.lang.Integer", closure);
                    }
                }
            } else if ("inject".equals(methodName) && params.length == 2) {
                if (index == 0) {
                    return TypesUtil.createTypeByFQClassName("java.lang.Object", closure);
                }
                PsiType res = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)closure);
                if (res != null) {
                    return res;
                }
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                    return ClosureParameterEnhancer.getEntryForMap(type, closure.getProject(), closure.getResolveScope());
                }
            } else {
                if ("eachPermutation".equals(methodName) && params.length == 1) {
                    PsiType itemType = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)closure);
                    if (itemType != null) {
                        return JavaPsiFacade.getElementFactory((Project)closure.getProject()).createTypeFromText("java.util.ArrayList<" + itemType.getCanonicalText() + ">", (PsiElement)closure);
                    }
                    return TypesUtil.createTypeByFQClassName("java.util.ArrayList", closure);
                }
                if ("withDefault".equals(methodName)) {
                    if (params.length == 1 && InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                        return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)0, (boolean)true);
                    }
                } else if ("sort".equals(methodName)) {
                    if (params.length < 3) {
                        return ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)closure);
                    }
                } else if ("withStream".equals(methodName)) {
                    PsiParameter[] parameters;
                    PsiMethod method = ((GrMethodCall)parent).resolveMethod();
                    if (method instanceof GrGdkMethod) {
                        return qualifier.getType();
                    }
                    if (method != null && (parameters = method.getParameterList().getParameters()).length > 0) {
                        return parameters[0].getType();
                    }
                } else if ("withStreams".equals(methodName)) {
                    if (index == 0) {
                        return TypesUtil.createTypeByFQClassName("java.io.InputStream", closure);
                    }
                    if (index == 1) {
                        return TypesUtil.createTypeByFQClassName("java.io.OutputStream", closure);
                    }
                } else if ("withObjectStreams".equals(methodName)) {
                    if (index == 0) {
                        return TypesUtil.createTypeByFQClassName("java.io.ObjectInputStream", closure);
                    }
                    if (index == 1) {
                        return TypesUtil.createTypeByFQClassName("java.io.ObjectOutputStream", closure);
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getEntryForMap(@Nullable PsiType map, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(2);
        }
        PsiType key = com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)map, (String)"java.util.Map", (int)0, (boolean)true);
        PsiType value = com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)map, (String)"java.util.Map", (int)1, (boolean)true);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass entryClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.Map.Entry", scope);
        if (entryClass == null) {
            if (key != null && key != PsiType.NULL && value != null && value != PsiType.NULL) {
                String text = String.format("%s<%s,%s>", "java.util.Map.Entry", key.getCanonicalText(), value.getCanonicalText());
                return factory.createTypeFromText(text, null);
            }
            return factory.createTypeByFQClassName("java.util.Map.Entry", scope);
        }
        return factory.createType(entryClass, new PsiType[]{key, value});
    }

    @Nullable
    public static PsiType findTypeForIteration(@NotNull GrExpression qualifier, @NotNull PsiElement context) {
        PsiType iterType;
        if (qualifier == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(4);
        }
        if ((iterType = qualifier.getType()) == null) {
            return null;
        }
        PsiType type = ClosureParameterEnhancer.findTypeForIteration(iterType, context);
        if (type == null) {
            return null;
        }
        return PsiImplUtil.normalizeWildcardTypeByPosition(type, qualifier);
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static PsiType findTypeForIteration(@Nullable PsiType type, @NotNull PsiElement context) {
        if (context == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(5);
        }
        PsiManager manager = context.getManager();
        GlobalSearchScope resolveScope = context.getResolveScope();
        if (type instanceof PsiArrayType) {
            return TypesUtil.boxPrimitiveType(((PsiArrayType)type).getComponentType(), manager, resolveScope);
        }
        if (type instanceof GrTupleType) {
            PsiType[] types = ((GrTupleType)type).getParameters();
            return types.length == 1 ? types[0] : null;
        }
        if (type instanceof GrRangeType) {
            return ((GrRangeType)type).getIterationType();
        }
        PsiType fromIterator = ClosureParameterEnhancer.findTypeFromIteratorMethod(type, context);
        if (fromIterator != null) {
            return fromIterator;
        }
        PsiType extracted = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)true);
        if (extracted != null) {
            return extracted;
        }
        if (TypesUtil.isClassType(type, "java.lang.String") || TypesUtil.isClassType(type, "java.io.File")) {
            return PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)resolveScope);
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
            return ClosureParameterEnhancer.getEntryForMap(type, manager.getProject(), resolveScope);
        }
        return type;
    }

    @Nullable
    private static PsiType findTypeFromIteratorMethod(@Nullable PsiType type, PsiElement context) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        GroovyResolveResult[] candidates = ResolveUtil.getMethodCandidates(type, "iterator", context, PsiType.EMPTY_ARRAY);
        GroovyResolveResult candidate = PsiImplUtil.extractUniqueResult(candidates);
        PsiElement element = candidate.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiType returnType = PsiUtil.getSmartReturnType((PsiMethod)element);
        PsiType iteratorType = candidate.getSubstitutor().substitute(returnType);
        return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)iteratorType, (String)"java.util.Iterator", (int)0, (boolean)false);
    }

    @Nullable
    private static String findMethodName(@NotNull GrMethodCall methodCall) {
        GrExpression expression;
        if (methodCall == null) {
            ClosureParameterEnhancer.$$$reportNull$$$0(6);
        }
        if ((expression = methodCall.getInvokedExpression()) instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)expression).getReferenceName();
        }
        return null;
    }

    static {
        simpleTypes.put("times", "java.lang.Integer");
        simpleTypes.put("upto", "java.lang.Integer");
        simpleTypes.put("downto", "java.lang.Integer");
        simpleTypes.put("step", "java.lang.Integer");
        simpleTypes.put("withObjectOutputStream", "java.io.ObjectOutputStream");
        simpleTypes.put("withObjectInputStream", "java.io.ObjectInputStream");
        simpleTypes.put("withOutputStream", "java.io.OutputStream");
        simpleTypes.put("withInputStream", "java.io.InputStream");
        simpleTypes.put("withDataOutputStream", "java.io.DataOutputStream");
        simpleTypes.put("withDataInputStream", "java.io.DataInputStream");
        simpleTypes.put("eachLine", "java.lang.String");
        simpleTypes.put("eachFile", "java.io.File");
        simpleTypes.put("eachDir", "java.io.File");
        simpleTypes.put("eachFileRecurse", "java.io.File");
        simpleTypes.put("traverse", "java.io.File");
        simpleTypes.put("eachDirRecurse", "java.io.File");
        simpleTypes.put("eachFileMatch", "java.io.File");
        simpleTypes.put("eachDirMatch", "java.io.File");
        simpleTypes.put("withReader", "java.io.Reader");
        simpleTypes.put("withWriter", "java.io.Writer");
        simpleTypes.put("withWriterAppend", "java.io.Writer");
        simpleTypes.put("withPrintWriter", "java.io.PrintWriter");
        simpleTypes.put("eachByte", "byte");
        simpleTypes.put("transformChar", "String");
        simpleTypes.put("transformLine", "String");
        simpleTypes.put("filterLine", "String");
        simpleTypes.put("accept", "java.net.Socket");
        simpleTypes.put("dropWhile", "java.lang.Character");
        simpleTypes.put("eachMatch", "java.lang.String");
        simpleTypes.put("replaceAll", "java.util.regex.Matcher");
        simpleTypes.put("replaceFirst", "java.util.regex.Matcher");
        simpleTypes.put("splitEachLine", "java.util.List<java.lang.String>");
        simpleTypes.put("withBatch", "groovy.sql.BatchingStatementWrapper");
        iterations.add("each");
        iterations.add("any");
        iterations.add("every");
        iterations.add("reverseEach");
        iterations.add("collect");
        iterations.add("collectAll");
        iterations.add("collectEntries");
        iterations.add("find");
        iterations.add("findAll");
        iterations.add("retainAll");
        iterations.add("removeAll");
        iterations.add("split");
        iterations.add("groupBy");
        iterations.add("groupEntriesBy");
        iterations.add("findLastIndexOf");
        iterations.add("findIndexValues");
        iterations.add("findIndexOf");
        iterations.add("count");
        iterations.add("takeWhile");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/ClosureParameterEnhancer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inferType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEntryForMap";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findTypeForIteration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

