/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeConverter {
    public static final ExtensionPointName<GrTypeConverter> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.typeConverter");

    protected static boolean isMethodCallConversion(GroovyPsiElement context) {
        return PsiUtil.isInMethodCallContext(context);
    }

    @Nullable
    protected static GrLiteral getLiteral(@NotNull GroovyPsiElement context) {
        if (context == null) {
            GrTypeConverter.$$$reportNull$$$0(0);
        }
        GrExpression expression = context instanceof GrTypeCastExpression ? ((GrTypeCastExpression)context).getOperand() : (context instanceof GrAssignmentExpression ? ((GrAssignmentExpression)context).getRValue() : (context instanceof GrVariable ? ((GrVariable)context).getInitializerGroovy() : (context instanceof GrReturnStatement ? ((GrReturnStatement)context).getReturnValue() : (context instanceof GrExpression ? (GrExpression)context : null))));
        return expression instanceof GrLiteral ? (GrLiteral)expression : null;
    }

    @Deprecated
    public boolean isAllowedInMethodCall() {
        return false;
    }

    public boolean isApplicableTo(@NotNull ApplicableTo position) {
        if (position == null) {
            GrTypeConverter.$$$reportNull$$$0(1);
        }
        switch (position) {
            case EXPLICIT_CAST: {
                return false;
            }
            case ASSIGNMENT: {
                return true;
            }
            case METHOD_PARAMETER: {
                return this.isAllowedInMethodCall();
            }
            case RETURN_VALUE: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @Nullable
    public Boolean isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context) {
        if (lType == null) {
            GrTypeConverter.$$$reportNull$$$0(2);
        }
        if (rType == null) {
            GrTypeConverter.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GrTypeConverter.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull ApplicableTo currentPosition) {
        Boolean result;
        if (targetType == null) {
            GrTypeConverter.$$$reportNull$$$0(5);
        }
        if (actualType == null) {
            GrTypeConverter.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GrTypeConverter.$$$reportNull$$$0(7);
        }
        if (currentPosition == null) {
            GrTypeConverter.$$$reportNull$$$0(8);
        }
        return (result = this.isConvertible(targetType, actualType, context)) == null ? null : (result != false ? ConversionResult.OK : ConversionResult.ERROR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPosition";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLiteral";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertible";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertibleEx";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ApplicableTo {
        EXPLICIT_CAST,
        ASSIGNMENT,
        METHOD_PARAMETER,
        GENERIC_PARAMETER,
        RETURN_VALUE;

    }
}

