/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyStringLiteralManipulator
extends AbstractElementManipulator<GrLiteralContainer> {
    private static final Logger LOG = Logger.getInstance(GroovyStringLiteralManipulator.class);

    public GrLiteralContainer handleContentChange(@NotNull GrLiteralContainer expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText;
        String startQuote;
        if (expr == null) {
            GroovyStringLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            GroovyStringLiteralManipulator.$$$reportNull$$$0(1);
        }
        if (!(expr.getValue() instanceof String)) {
            // empty if block
        }
        if (StringUtil.startsWithChar((CharSequence)(startQuote = GrStringUtil.getStartQuote(oldText = expr instanceof GrLiteral ? expr.getText() : expr.getParent().getText())), (char)'\'')) {
            newContent = GrStringUtil.escapeSymbolsForString(newContent, !startQuote.equals("'''"), true);
        } else if (StringUtil.startsWithChar((CharSequence)startQuote, (char)'\"')) {
            newContent = GrStringUtil.escapeSymbolsForGString(newContent, !startQuote.equals("\"\"\""), false);
        } else if ("/".equals(startQuote)) {
            newContent = GrStringUtil.escapeSymbolsForSlashyStrings(newContent);
        } else if ("$/".equals(startQuote)) {
            newContent = GrStringUtil.escapeSymbolsForDollarSlashyStrings(newContent);
        }
        String newText = expr instanceof GrLiteral ? oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset()) : newContent;
        return expr.updateText(newText);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull GrLiteralContainer element) {
        if (element == null) {
            GroovyStringLiteralManipulator.$$$reportNull$$$0(2);
        }
        if (element instanceof GrStringContent) {
            TextRange textRange = TextRange.from((int)0, (int)element.getTextLength());
            if (textRange == null) {
                GroovyStringLiteralManipulator.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        String text = element.getText();
        if (!(element.getValue() instanceof String)) {
            TextRange textRange = super.getRangeInElement((PsiElement)element);
            if (textRange == null) {
                GroovyStringLiteralManipulator.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        TextRange textRange = GroovyStringLiteralManipulator.getLiteralRange(text);
        if (textRange == null) {
            GroovyStringLiteralManipulator.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    public static TextRange getLiteralRange(String text) {
        int start = 1;
        int fin = text.length();
        String begin = text.substring(0, 1);
        if (text.startsWith("$/")) {
            start = 2;
            if (text.endsWith("/$")) {
                return new TextRange(start, Math.max(1, fin - 2));
            }
            return new TextRange(start, fin);
        }
        if (text.startsWith("\"\"\"") || text.startsWith("'''")) {
            start = 3;
            begin = text.substring(0, 3);
        }
        if (text.length() >= begin.length() * 2 && text.endsWith(begin)) {
            fin -= begin.length();
        }
        return new TextRange(start, Math.max(1, fin));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/GroovyStringLiteralManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/GroovyStringLiteralManipulator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

