/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.resolve.GrImportContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ImplicitImportsKt;
import org.jetbrains.plugins.groovy.lang.resolve.ImplicitImportsKt$WhenMappings;
import org.jetbrains.plugins.groovy.lang.resolve.Import;
import org.jetbrains.plugins.groovy.lang.resolve.PackageSkippingProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"getImplicitImports", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/Import;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "processImplicitImports", "", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "groovy-psi"})
public final class ImplicitImportsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Import> getImplicitImports(@NotNull GroovyFile file) {
        void var3_3;
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object[] objectArray = $receiver$iv = GrImportContributor.EP_NAME.getExtensions();
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            GrImportContributor it = (GrImportContributor)element$iv$iv;
            Iterable list$iv$iv = it.getImports(file);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    public static final boolean processImplicitImports(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull GroovyFile file) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ElementClassHint hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
        Lazy packageSkipper2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<PackageSkippingProcessor>(processor){
            final /* synthetic */ PsiScopeProcessor $processor;

            @NotNull
            public final PackageSkippingProcessor invoke() {
                return new PackageSkippingProcessor(this.$processor);
            }
            {
                this.$processor = psiScopeProcessor;
                super(0);
            }
        }));
        Lazy staticMemberFilter2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<processImplicitImports.staticMemberFilter.1>(processor){
            final /* synthetic */ PsiScopeProcessor $processor;

            @NotNull
            public final processImplicitImports.staticMemberFilter.1 invoke() {
                return new DelegatingScopeProcessor(this, this.$processor){
                    final /* synthetic */ processImplicitImports.staticMemberFilter.1 this$0;

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                        return !(element instanceof PsiMember) || !((PsiMember)element).hasModifierProperty("static") || super.execute(element, state);
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1);
                    }
                };
            }
            {
                this.$processor = psiScopeProcessor;
                super(0);
            }
        }));
        block6: for (Import implicitImport : ImplicitImportsKt.getImplicitImports(file)) {
            switch (ImplicitImportsKt$WhenMappings.$EnumSwitchMapping$0[implicitImport.getType().ordinal()]) {
                case 1: {
                    PsiClass clazz;
                    if (!ResolveUtil.shouldProcessClasses(hint)) break;
                    if (facade.findClass(implicitImport.getName(), file.getResolveScope()) == null) {
                        break;
                    }
                    if (ResolveUtil.processElement(processor, (PsiNamedElement)clazz, state)) continue block6;
                    return false;
                }
                case 2: {
                    PsiField field;
                    PsiClass clazz;
                    String className = StringUtil.getPackageName((String)implicitImport.getName());
                    String memberName = StringUtil.getShortName((String)implicitImport.getName());
                    if (StringUtil.isEmptyOrSpaces((String)className)) continue block6;
                    if (StringUtil.isEmptyOrSpaces((String)memberName)) break;
                    if (facade.findClass(className, file.getResolveScope()) == null) {
                        break;
                    }
                    if (ResolveUtil.shouldProcessMethods(hint)) {
                        PsiMethod[] psiMethodArray = clazz.findMethodsByName(memberName, true);
                        for (int i = 0; i < psiMethodArray.length; ++i) {
                            PsiMethod method = psiMethodArray[i];
                            if (ResolveUtil.processElement(processor, (PsiNamedElement)method, state)) continue;
                            return false;
                        }
                    }
                    if (!ResolveUtil.shouldProcessProperties(hint)) continue block6;
                    if (clazz.findFieldByName(memberName, true) == null) {
                        break;
                    }
                    if (ResolveUtil.processElement(processor, (PsiNamedElement)field, state)) continue block6;
                    return false;
                }
                case 3: {
                    PsiPackage pckg;
                    if (facade.findPackage(implicitImport.getName()) == null) {
                        break;
                    }
                    if (pckg.processDeclarations((PsiScopeProcessor)packageSkipper2.getValue(), state, lastParent, place)) continue block6;
                    return false;
                }
                case 4: {
                    PsiClass clazz;
                    if (facade.findClass(implicitImport.getName(), file.getResolveScope()) == null) {
                        break;
                    }
                    if (clazz.processDeclarations((PsiScopeProcessor)staticMemberFilter2.getValue(), state, lastParent, place)) break;
                    return false;
                }
            }
        }
        return true;
    }
}

