/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.delegatesTo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.FromStringHintProcessor;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToProvider;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

public class DefaultDelegatesToProvider
implements GrDelegatesToProvider {
    @Override
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrClosableBlock closableBlock) {
        GrCall call;
        if (closableBlock == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(0);
        }
        if ((call = GrDelegatesToUtilKt.getContainingCall(closableBlock)) == null) {
            return null;
        }
        GroovyResolveResult result = GrDelegatesToUtilKt.resolveActualCall(call);
        PsiElement element = result.getElement();
        if (GdkMethodUtil.isWithOrIdentity(element)) {
            GrExpression qualifier = DefaultDelegatesToProvider.inferCallQualifier((GrMethodCall)call);
            if (qualifier == null) {
                return null;
            }
            return new DelegatesToInfo(qualifier.getType(), 1);
        }
        GrClosureSignature signature = DefaultDelegatesToProvider.inferSignature(element);
        if (signature == null) {
            return null;
        }
        GrClosureSignatureUtil.ArgInfo<PsiElement>[] map = DefaultDelegatesToProvider.mapArgs(closableBlock, call, signature);
        if (map == null) {
            return null;
        }
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)element;
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter parameter = DefaultDelegatesToProvider.findParameter(parameterList, closableBlock, map);
        if (parameter == null) {
            return null;
        }
        String delegateFqnData = (String)parameter.getUserData(GrDelegatesToUtilKt.DELEGATES_TO_KEY);
        Integer strategyData = (Integer)parameter.getUserData(GrDelegatesToUtilKt.DELEGATES_TO_STRATEGY_KEY);
        if (delegateFqnData != null) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType(delegateFqnData, closableBlock), strategyData == null ? 0 : strategyData);
        }
        PsiModifierList modifierList = parameter.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation delegatesTo = modifierList.findAnnotation("groovy.lang.DelegatesTo");
        if (delegatesTo == null) {
            return null;
        }
        PsiType delegateType = DefaultDelegatesToProvider.getFromValue(delegatesTo);
        if (delegateType == null) {
            delegateType = DefaultDelegatesToProvider.getFromTarget(parameterList, delegatesTo, signature, map);
        }
        if (delegateType == null) {
            delegateType = DefaultDelegatesToProvider.getFromType(result, delegatesTo);
        }
        int strategyValue = DefaultDelegatesToProvider.getStrategyValue(delegatesTo.findAttributeValue("strategy"));
        return new DelegatesToInfo(delegateType, strategyValue);
    }

    private static GrClosureSignatureUtil.ArgInfo<PsiElement>[] mapArgs(PsiElement place, GrCall call, GrClosureSignature signature) {
        GrClosureSignature rawSignature = GrClosureSignatureUtil.rawSignature(signature);
        return GrClosureSignatureUtil.mapParametersToArguments(rawSignature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), place, false, false);
    }

    @Nullable
    private static GrClosureSignature inferSignature(@Nullable PsiElement element) {
        GrSignature signature;
        PsiType type;
        if (element instanceof PsiMethod) {
            return GrClosureSignatureUtil.createSignature((PsiMethod)element, PsiSubstitutor.EMPTY);
        }
        if (element instanceof GrVariable && (type = ((GrVariable)element).getTypeGroovy()) instanceof GrClosureType && (signature = ((GrClosureType)type).getSignature()) instanceof GrClosureSignature) {
            return (GrClosureSignature)signature;
        }
        return null;
    }

    @Nullable
    private static PsiParameter findParameter(@NotNull PsiParameterList parameterList, @NotNull GrClosableBlock closableBlock, @NotNull GrClosureSignatureUtil.ArgInfo<PsiElement>[] map) {
        if (parameterList == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(1);
        }
        if (closableBlock == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(2);
        }
        if (map == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(3);
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < map.length; ++i) {
            if (!map[i].args.contains(closableBlock)) continue;
            return parameters[i];
        }
        return null;
    }

    private static PsiType getFromValue(@NotNull PsiAnnotation delegatesTo) {
        PsiAnnotationMemberValue value;
        if (delegatesTo == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(4);
        }
        if ((value = delegatesTo.findDeclaredAttributeValue("value")) instanceof GrReferenceExpression) {
            return DefaultDelegatesToProvider.extractTypeFromClassType(((GrReferenceExpression)value).getType());
        }
        if (value instanceof PsiClassObjectAccessExpression) {
            return DefaultDelegatesToProvider.extractTypeFromClassType(((PsiClassObjectAccessExpression)value).getType());
        }
        if (value == null || value instanceof PsiLiteralExpression && ((PsiLiteralExpression)value).getType() == PsiType.NULL || value instanceof GrLiteral && ((GrLiteral)value).getType() == PsiType.NULL) {
            return null;
        }
        if (value instanceof PsiExpression) {
            return ((PsiExpression)value).getType();
        }
        return null;
    }

    @Nullable
    private static PsiType getFromTarget(PsiParameterList parameterList, PsiAnnotation delegatesTo, GrClosureSignature signature, GrClosureSignatureUtil.ArgInfo<PsiElement>[] map) {
        String target = GrAnnotationUtil.inferStringAttribute(delegatesTo, "target");
        if (target == null) {
            return null;
        }
        int parameter = DefaultDelegatesToProvider.findTargetParameter(parameterList, target);
        if (parameter < 0) {
            return null;
        }
        PsiType type = map[parameter].type;
        Integer index = GrAnnotationUtil.inferIntegerAttribute(delegatesTo, "genericTypeIndex");
        if (index != null) {
            return DefaultDelegatesToProvider.inferGenericArgType(signature, type, index, parameter);
        }
        return type;
    }

    @Nullable
    private static PsiType inferGenericArgType(@NotNull GrClosureSignature signature, @Nullable PsiType targetType, int genericIndex, int param) {
        PsiClassType.ClassResolveResult result;
        PsiClass psiClass;
        if (signature == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(5);
        }
        if (targetType instanceof PsiClassType && (psiClass = (result = ((PsiClassType)targetType).resolveGenerics()).getElement()) != null) {
            PsiTypeParameter[] typeParameters;
            PsiSubstitutor substitutor = result.getSubstitutor();
            PsiType baseType = signature.getParameters()[param].getType();
            PsiClass baseClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
            if (baseClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)baseClass, (boolean)true) && genericIndex < (typeParameters = baseClass.getTypeParameters()).length) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)psiClass, (PsiSubstitutor)substitutor);
                return superClassSubstitutor.substitute(typeParameters[genericIndex]);
            }
        }
        return null;
    }

    private static PsiType getFromType(GroovyResolveResult result, PsiAnnotation delegatesTo) {
        PsiElement element = result.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        String typeValue = GrAnnotationUtil.inferStringAttribute(delegatesTo, "type");
        if (StringUtil.isEmptyOrSpaces((String)typeValue)) {
            return null;
        }
        PsiElement context = FromStringHintProcessor.createContext((PsiMethod)element);
        PsiType type = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeValue, context);
        return result.getSubstitutor().substitute(type);
    }

    private static int findTargetParameter(@NotNull PsiParameterList list, @NotNull String target) {
        if (list == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(6);
        }
        if (target == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(7);
        }
        PsiParameter[] parameters = list.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            String value;
            PsiAnnotation targetAnnotation;
            PsiModifierList modifierList = parameters[i].getModifierList();
            if (modifierList == null || (targetAnnotation = modifierList.findAnnotation("groovy.lang.DelegatesTo.Target")) == null || (value = GrAnnotationUtil.inferStringAttribute(targetAnnotation, "value")) == null || !value.equals(target)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static GrExpression inferCallQualifier(@NotNull GrMethodCall call) {
        GrExpression expression;
        if (call == null) {
            DefaultDelegatesToProvider.$$$reportNull$$$0(8);
        }
        if (!((expression = call.getInvokedExpression()) instanceof GrReferenceExpression)) {
            return null;
        }
        return (GrExpression)((GrReferenceExpression)expression).getQualifier();
    }

    @Nullable
    private static PsiType extractTypeFromClassType(@Nullable PsiType type) {
        PsiType[] parameters;
        PsiClass resolved;
        if (type instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(resolved.getQualifiedName()) && (parameters = ((PsiClassType)type).getParameters()).length == 1) {
            return parameters[0];
        }
        return null;
    }

    private static int getStrategyValue(@Nullable PsiAnnotationMemberValue strategy) {
        if (strategy == null) {
            return -1;
        }
        String text = strategy.getText();
        if ("0".equals(text)) {
            return 0;
        }
        if ("1".equals(text)) {
            return 1;
        }
        if ("2".equals(text)) {
            return 2;
        }
        if ("3".equals(text)) {
            return 3;
        }
        if ("4".equals(text)) {
            return 4;
        }
        if (text.endsWith("OWNER_FIRST")) {
            return 0;
        }
        if (text.endsWith("DELEGATE_FIRST")) {
            return 1;
        }
        if (text.endsWith("OWNER_ONLY")) {
            return 2;
        }
        if (text.endsWith("DELEGATE_ONLY")) {
            return 3;
        }
        if (text.endsWith("TO_SELF")) {
            return 4;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closableBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegatesTo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DefaultDelegatesToProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDelegatesToInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findParameter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFromValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inferGenericArgType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetParameter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "inferCallQualifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

