/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.InaccessibleElementVisitor;
import org.jetbrains.plugins.groovy.annotator.ResolveHighlightingVisitor;
import org.jetbrains.plugins.groovy.annotator.VisitorCallback;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.TypeChecker;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.fixes.BaseFix;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.fixes.EmptyFieldTypeFix;

public class ConvertToStaticProcessor
extends BaseRefactoringProcessor {
    private static final int maxIterations = 5;
    private static final Logger LOG = Logger.getInstance(ConvertToStaticProcessor.class);
    private final GroovyFile[] myFiles;
    private BaseFix[] myFixes = new BaseFix[]{new EmptyFieldTypeFix()};

    protected ConvertToStaticProcessor(Project project, GroovyFile ... files) {
        super(project);
        this.myFiles = files;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(0);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = ConvertToStaticProcessor.this.myFiles;
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return GroovyRefactoringBundle.message("files.to.be.converted", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(1);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (UsageInfo.EMPTY_ARRAY == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(2);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(3);
        }
        ArrayDeque<GroovyFile> files = new ArrayDeque<GroovyFile>(Arrays.asList(this.myFiles));
        while (files.peek() != null) {
            GroovyFile file = (GroovyFile)files.poll();
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)file);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
            LOG.assertTrue(document != null);
            psiDocumentManager.commitDocument(document);
            LOG.assertTrue(file.isValid());
            if (file.isScript()) continue;
            this.applyFixes(file);
            this.putCompileAnnotations(file);
            ConvertToStaticProcessor.checkErrors(file);
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
            this.doPostProcessing(file);
        }
    }

    private void applyFixes(GroovyFile file) {
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                for (BaseFix fix : ConvertToStaticProcessor.this.myFixes) {
                    element.accept((PsiElementVisitor)new GroovyPsiElementVisitor(fix));
                }
                super.visitElement(element);
            }
        });
    }

    private void putCompileAnnotations(@NotNull GroovyFile file) {
        GrTypeDefinition[] classes;
        if (file == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(4);
        }
        HashSet classesWithUnresolvedRef = new HashSet();
        HashSet methodsWithUnresolvedRef = new HashSet();
        VisitorCallback callback = (element, info) -> {
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
            if (containingMethod != null) {
                methodsWithUnresolvedRef.add(containingMethod);
                return;
            }
            GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, GrTypeDefinition.class);
            if (containingClass != null) {
                classesWithUnresolvedRef.add(containingClass);
            }
        };
        file.accept(new ResolveHighlightingVisitor(file, this.myProject, callback));
        file.accept(new InaccessibleElementVisitor(file, this.myProject, callback));
        for (GrTypeDefinition typeDef : classes = file.getTypeDefinitions()) {
            boolean isStaticClass = false;
            if (!classesWithUnresolvedRef.contains(typeDef)) {
                isStaticClass = true;
                this.addAnnotation((PsiModifierListOwner)typeDef, true);
            }
            for (GrMethod method : typeDef.getCodeMethods()) {
                if (methodsWithUnresolvedRef.contains(method) != isStaticClass) continue;
                this.addAnnotation(method, !isStaticClass);
            }
        }
    }

    private static void checkErrors(@NotNull GroovyFile file) {
        if (file == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(5);
        }
        for (int iteration = 0; iteration < 5; ++iteration) {
            final TypeChecker checker = new TypeChecker();
            file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    if (PsiUtil.isCompileStatic(element)) {
                        element.accept((PsiElementVisitor)new GroovyPsiElementVisitor(checker));
                    }
                    super.visitElement(element);
                }
            });
            if (checker.applyFixes() != 0) continue;
            return;
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = GroovyRefactoringBundle.message("converting.files.to.static", new Object[0]);
        if (string == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    void addAnnotation(@NotNull PsiModifierListOwner owner, boolean isStatic) {
        PsiModifierList modifierList;
        if (owner == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(7);
        }
        if ((modifierList = owner.getModifierList()) != null) {
            modifierList.addAnnotation(isStatic ? "groovy.transform.CompileStatic" : "groovy.transform.CompileDynamic");
        }
    }

    private void doPostProcessing(PsiElement newFile) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        newFile = JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(newFile);
        CodeStyleManager.getInstance((Project)this.myProject).reformat(newFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putCompileAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkErrors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

