/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.transformations.TransformationResult;
import org.jetbrains.plugins.groovy.transformations.dsl.MemberBuilder;

public class TransformationContextImpl
implements TransformationContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final JavaPsiFacade myPsiFacade;
    @NotNull
    private final GrTypeDefinition myCodeClass;
    @NotNull
    private final PsiClassType myClassType;
    private final LinkedList<PsiMethod> myMethods;
    private final Collection<GrField> myFields;
    private final Collection<PsiClass> myInnerClasses;
    private final List<PsiClassType> myImplementsTypes;
    private final List<PsiClassType> myExtendsTypes;
    private final MemberBuilder myMemberBuilder;
    private final Map<String, Set<MethodSignature>> mySignaturesCache;

    public TransformationContextImpl(@NotNull GrTypeDefinition codeClass) {
        if (codeClass == null) {
            TransformationContextImpl.$$$reportNull$$$0(0);
        }
        this.myMethods = ContainerUtil.newLinkedList();
        this.myFields = ContainerUtil.newArrayList();
        this.myInnerClasses = ContainerUtil.newArrayList();
        this.myImplementsTypes = ContainerUtil.newArrayList();
        this.myExtendsTypes = ContainerUtil.newArrayList();
        this.myMemberBuilder = new MemberBuilder(this);
        this.mySignaturesCache = FactoryMap.createMap(name -> {
            THashSet result = new THashSet(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
            for (PsiMethod existingMethod : this.myMethods) {
                if (!existingMethod.getName().equals(name)) continue;
                result.add((Object)existingMethod.getSignature(PsiSubstitutor.EMPTY));
            }
            return result;
        });
        this.myProject = codeClass.getProject();
        this.myPsiManager = codeClass.getManager();
        this.myPsiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        this.myCodeClass = codeClass;
        this.myClassType = this.getPsiFacade().getElementFactory().createType((PsiClass)this.getCodeClass());
        ContainerUtil.addAll(this.myFields, (Object[])codeClass.getCodeFields());
        ContainerUtil.addAll(this.myMethods, (Iterable)ContainerUtil.flatten((Iterable)ContainerUtil.map((Object[])codeClass.getCodeMethods(), m -> GrClassImplUtil.expandReflectedMethods(m))));
        ContainerUtil.addAll(this.myInnerClasses, (Object[])codeClass.getCodeInnerClasses());
        ContainerUtil.addAll(this.myImplementsTypes, (Object[])GrClassImplUtil.getReferenceListTypes(codeClass.getImplementsClause()));
        ContainerUtil.addAll(this.myExtendsTypes, (Object[])GrClassImplUtil.getReferenceListTypes(codeClass.getExtendsClause()));
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TransformationContextImpl.$$$reportNull$$$0(1);
        }
        return project;
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myPsiManager;
        if (psiManager == null) {
            TransformationContextImpl.$$$reportNull$$$0(2);
        }
        return psiManager;
    }

    @Override
    @NotNull
    public JavaPsiFacade getPsiFacade() {
        JavaPsiFacade javaPsiFacade = this.myPsiFacade;
        if (javaPsiFacade == null) {
            TransformationContextImpl.$$$reportNull$$$0(3);
        }
        return javaPsiFacade;
    }

    @Override
    @NotNull
    public GrTypeDefinition getCodeClass() {
        GrTypeDefinition grTypeDefinition = this.myCodeClass;
        if (grTypeDefinition == null) {
            TransformationContextImpl.$$$reportNull$$$0(4);
        }
        return grTypeDefinition;
    }

    @Override
    @NotNull
    public PsiClassType getClassType() {
        PsiClassType psiClassType = this.myClassType;
        if (psiClassType == null) {
            TransformationContextImpl.$$$reportNull$$$0(5);
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public Collection<GrField> getFields() {
        Collection<GrField> collection = this.myFields;
        if (collection == null) {
            TransformationContextImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiField> getAllFields(boolean includeSynthetic) {
        if (!includeSynthetic) {
            List<PsiField> list = Arrays.asList(GrClassImplUtil.getAllFields(this.getCodeClass(), false));
            if (list == null) {
                TransformationContextImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        HashSet fields = ContainerUtil.newHashSet(this.myFields);
        ArrayList superTypes = ContainerUtil.newArrayList(this.myExtendsTypes);
        superTypes.addAll(this.myImplementsTypes);
        for (PsiClassType type : superTypes) {
            PsiClass psiClass = type.resolve();
            if (psiClass == null) continue;
            fields.addAll(Arrays.asList(psiClass.getAllFields()));
        }
        HashSet hashSet = fields;
        if (hashSet == null) {
            TransformationContextImpl.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<PsiMethod> getMethods() {
        LinkedList<PsiMethod> linkedList = this.myMethods;
        if (linkedList == null) {
            TransformationContextImpl.$$$reportNull$$$0(9);
        }
        return linkedList;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getInnerClasses() {
        Collection<PsiClass> collection = this.myInnerClasses;
        if (collection == null) {
            TransformationContextImpl.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Override
    @NotNull
    public List<PsiClassType> getImplementsTypes() {
        List<PsiClassType> list = this.myImplementsTypes;
        if (list == null) {
            TransformationContextImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiClassType> getExtendsTypes() {
        List<PsiClassType> list = this.myExtendsTypes;
        if (list == null) {
            TransformationContextImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.myCodeClass.getName();
    }

    @Override
    @Nullable
    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this.getCodeClass(), this.getExtendsListTypesArray());
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String fqn) {
        if (fqn == null) {
            TransformationContextImpl.$$$reportNull$$$0(13);
        }
        return PsiImplUtil.getAnnotation((PsiModifierListOwner)this.getCodeClass(), fqn);
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            TransformationContextImpl.$$$reportNull$$$0(14);
        }
        if (this.getManager().areElementsEquivalent((PsiElement)this.getCodeClass(), (PsiElement)baseClass)) {
            return false;
        }
        if (this.getCodeClass().isInterface() && !baseClass.isInterface()) {
            return false;
        }
        for (PsiClassType superType : this.getSuperTypes()) {
            PsiClass superClass = superType.resolve();
            if (superClass == null) continue;
            if (this.getManager().areElementsEquivalent((PsiElement)superClass, (PsiElement)baseClass)) {
                return true;
            }
            if (!superClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<PsiMethod> findMethodsByName(@NotNull String name, boolean checkBases) {
        PsiClass aClass;
        if (name == null) {
            TransformationContextImpl.$$$reportNull$$$0(15);
        }
        List methods = ContainerUtil.filter(this.myMethods, m -> {
            if (name == null) {
                TransformationContextImpl.$$$reportNull$$$0(35);
            }
            return name.equals(m.getName());
        });
        if (checkBases && (aClass = this.getSuperClass()) != null) {
            ContainerUtil.addAll((Collection)ContainerUtil.newArrayList((Iterable)methods), (Object[])aClass.findMethodsByName(name, true));
        }
        List list = methods;
        if (list == null) {
            TransformationContextImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    private void doAddMethod(@NotNull PsiMethod method, boolean prepend) {
        if (method == null) {
            TransformationContextImpl.$$$reportNull$$$0(17);
        }
        if (method instanceof GrLightMethodBuilder) {
            ((GrLightMethodBuilder)method).setContainingClass(this.myCodeClass);
        } else if (method instanceof LightMethodBuilder) {
            ((LightMethodBuilder)method).setContainingClass((PsiClass)this.myCodeClass);
        }
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        Set<MethodSignature> signatures = this.mySignaturesCache.get(method.getName());
        if (signatures.add(signature)) {
            if (prepend) {
                this.myMethods.addFirst(method);
            } else {
                this.myMethods.addLast(method);
            }
        }
    }

    @Override
    public void addMethod(@NotNull PsiMethod method, boolean prepend) {
        if (method == null) {
            TransformationContextImpl.$$$reportNull$$$0(18);
        }
        for (PsiMethod psiMethod : GrClassImplUtil.expandReflectedMethods(method)) {
            this.doAddMethod(psiMethod, prepend);
        }
    }

    @Override
    public void addMethods(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            TransformationContextImpl.$$$reportNull$$$0(19);
        }
        for (PsiMethod method : methods) {
            this.addMethod(method);
        }
    }

    @Override
    public void addMethods(@NotNull Collection<? extends PsiMethod> methods) {
        if (methods == null) {
            TransformationContextImpl.$$$reportNull$$$0(20);
        }
        for (PsiMethod psiMethod : methods) {
            this.addMethod(psiMethod);
        }
    }

    @Override
    public void removeMethod(@NotNull PsiMethod method) {
        if (method == null) {
            TransformationContextImpl.$$$reportNull$$$0(21);
        }
        Set<MethodSignature> signatures = this.mySignaturesCache.get(method.getName());
        for (PsiMethod psiMethod : GrClassImplUtil.expandReflectedMethods(method)) {
            MethodSignature signature = psiMethod.getSignature(PsiSubstitutor.EMPTY);
            if (!signatures.remove(signature)) continue;
            this.myMethods.removeIf(m -> MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)signature, (Object)m.getSignature(PsiSubstitutor.EMPTY)));
        }
    }

    @Override
    public void addField(@NotNull GrField field) {
        if (field == null) {
            TransformationContextImpl.$$$reportNull$$$0(22);
        }
        if (field instanceof GrLightField) {
            ((GrLightField)field).setContainingClass(this.getCodeClass());
        }
        this.myFields.add(field);
    }

    @Override
    public void addInnerClass(@NotNull PsiClass innerClass) {
        if (innerClass == null) {
            TransformationContextImpl.$$$reportNull$$$0(23);
        }
        if (innerClass instanceof LightPsiClassBuilder) {
            ((LightPsiClassBuilder)innerClass).setContainingClass((PsiClass)this.getCodeClass());
        }
        this.myInnerClasses.add(innerClass);
    }

    @Override
    public void setSuperType(@NotNull String fqn) {
        if (fqn == null) {
            TransformationContextImpl.$$$reportNull$$$0(24);
        }
        this.setSuperType(TypesUtil.createType(fqn, this.getCodeClass()));
    }

    @Override
    public void setSuperType(@NotNull PsiClassType type) {
        if (type == null) {
            TransformationContextImpl.$$$reportNull$$$0(25);
        }
        if (!this.getCodeClass().isInterface()) {
            this.myExtendsTypes.clear();
            this.myExtendsTypes.add(type);
        }
    }

    @Override
    public void addInterface(@NotNull String fqn) {
        if (fqn == null) {
            TransformationContextImpl.$$$reportNull$$$0(26);
        }
        this.addInterface(TypesUtil.createType(fqn, this.getCodeClass()));
    }

    @Override
    public void addInterface(@NotNull PsiClassType type) {
        if (type == null) {
            TransformationContextImpl.$$$reportNull$$$0(27);
        }
        (!this.getCodeClass().isInterface() || this.getCodeClass().isTrait() ? this.myImplementsTypes : this.myExtendsTypes).add(type);
    }

    @Override
    @NotNull
    public MemberBuilder getMemberBuilder() {
        MemberBuilder memberBuilder = this.myMemberBuilder;
        if (memberBuilder == null) {
            TransformationContextImpl.$$$reportNull$$$0(28);
        }
        return memberBuilder;
    }

    @NotNull
    private GrField[] getFieldsArray() {
        GrField[] grFieldArray = this.getFields().toArray(GrField.EMPTY_ARRAY);
        if (grFieldArray == null) {
            TransformationContextImpl.$$$reportNull$$$0(29);
        }
        return grFieldArray;
    }

    @NotNull
    private PsiMethod[] getMethodsArray() {
        PsiMethod[] psiMethodArray = this.getMethods().toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            TransformationContextImpl.$$$reportNull$$$0(30);
        }
        return psiMethodArray;
    }

    @NotNull
    private PsiClass[] getInnerClassesArray() {
        PsiClass[] psiClassArray = this.getInnerClasses().toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            TransformationContextImpl.$$$reportNull$$$0(31);
        }
        return psiClassArray;
    }

    @NotNull
    private PsiClassType[] getImplementsListTypesArray() {
        PsiClassType[] psiClassTypeArray = this.getImplementsTypes().toArray(PsiClassType.EMPTY_ARRAY);
        if (psiClassTypeArray == null) {
            TransformationContextImpl.$$$reportNull$$$0(32);
        }
        return psiClassTypeArray;
    }

    @NotNull
    private PsiClassType[] getExtendsListTypesArray() {
        if (this.getExtendsTypes().size() > 1 && !this.getCodeClass().isInterface()) {
            throw new IllegalStateException("More than one type supertype for non-interface");
        }
        PsiClassType[] psiClassTypeArray = this.getExtendsTypes().toArray(PsiClassType.EMPTY_ARRAY);
        if (psiClassTypeArray == null) {
            TransformationContextImpl.$$$reportNull$$$0(33);
        }
        return psiClassTypeArray;
    }

    @NotNull
    TransformationResult getTransformationResult() {
        TransformationResult transformationResult = new TransformationResult(this.getMethodsArray(), this.getFieldsArray(), this.getInnerClassesArray(), this.getImplementsListTypesArray(), this.getExtendsListTypesArray());
        if (transformationResult == null) {
            TransformationContextImpl.$$$reportNull$$$0(34);
        }
        return transformationResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl";
                break;
            }
            case 13: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 15: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/transformations/TransformationContextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFacade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsTypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberBuilder";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsArray";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsArray";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesArray";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsListTypesArray";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypesArray";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformationResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsByName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doAddMethod";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addMethods";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeMethod";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addField";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addInnerClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setSuperType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addInterface";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findMethodsByName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

