/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.engine.TestEngine;

class ServiceLoaderTestEngineRegistry {
    private static final Logger LOG = Logger.getLogger(ServiceLoaderTestEngineRegistry.class.getName());

    ServiceLoaderTestEngineRegistry() {
    }

    public Iterable<TestEngine> loadTestEngines() {
        ServiceLoader<TestEngine> testEngines = ServiceLoader.load(TestEngine.class, ClassLoaderUtils.getDefaultClassLoader());
        LOG.config(() -> this.createDiscoveredTestEnginesMessage(testEngines));
        return testEngines;
    }

    private String createDiscoveredTestEnginesMessage(Iterable<TestEngine> testEngines) {
        ArrayList<String> details = new ArrayList<String>();
        for (TestEngine engine : testEngines) {
            details.add(String.format("%s (%s)", engine.getId(), String.join((CharSequence)", ", this.computeAttributes(engine))));
        }
        if (details.isEmpty()) {
            return "No TestEngine implementation discovered.";
        }
        return "Discovered TestEngines with IDs: [" + String.join((CharSequence)", ", details) + "]";
    }

    private List<String> computeAttributes(TestEngine engine) {
        ArrayList<String> attributes = new ArrayList<String>();
        engine.getGroupId().ifPresent(groupId -> attributes.add("group ID: " + groupId));
        engine.getArtifactId().ifPresent(artifactId -> attributes.add("artifact ID: " + artifactId));
        engine.getVersion().ifPresent(version -> attributes.add("version: " + version));
        ClassLoaderUtils.getLocation((Object)engine).ifPresent(location -> attributes.add("location: " + location));
        return attributes;
    }
}

