/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Ljava/io/File;)V", "dumpValue", "value", "process", "", "srcFile", "newMap", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "sourceFile", "build-common"})
final class InlineFunctionsMap
extends BasicStringMap<Map<String, ? extends Long>> {
    public final void process(@NotNull File srcFile, @NotNull Map<String, Long> newMap, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull(newMap, (String)"newMap");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        String key = srcFile.getCanonicalPath();
        LazyStorage lazyStorage = this.getStorage();
        String string = key;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
        Map map = (Map)lazyStorage.get(string);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map oldMap = map;
        Map<String, Long> map2 = newMap;
        if (!map2.isEmpty()) {
            this.getStorage().set(key, newMap);
        } else {
            this.getStorage().remove(key);
        }
        for (String fn : SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet())) {
            List fqNameSegments = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)StringsKt.removePrefix((String)fn, (CharSequence)"<get>"), (CharSequence)"<set>"), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            FqName fqName = FqName.fromSegments((List)fqNameSegments);
            FqName fqName2 = fqName.parent();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"fqName.parent()");
            String string2 = fqName.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fqName.shortName().asString()");
            changesCollector.collectMemberIfValueWasChanged(fqName2, string2, oldMap.get(fn), newMap.get(fn));
        }
    }

    public final void remove(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        LazyStorage lazyStorage = this.getStorage();
        String string = sourceFile.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.canonicalPath");
        lazyStorage.remove(string);
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Map<String, Long> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return IncrementalJvmCacheKt.dumpMap(value, dumpValue.1.INSTANCE);
    }

    public InlineFunctionsMap(@NotNull File storageFile) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        super(storageFile, StringToLongMapExternalizer.INSTANCE);
    }
}

