/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.build.FSOperationsHelper;
import org.jetbrains.kotlin.jps.build.JpsICReporter;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJvmCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJvmCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorage;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageProvider;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t\u001a$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u001a\u0016\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$\u001a8\u0010%\u001a\u00020&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002\"(\u0010\u0000\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \u0004*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\u0005\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0004*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"ALL_COMPILED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "PROCESSED_TARGETS_WITH_REMOVED_FILES", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "getAllCompiledFilesContainer", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getDependenciesRecursively", "", "Lorg/jetbrains/jps/model/module/JpsModule;", "module", "kind", "Lorg/jetbrains/jps/model/java/JpsJavaClasspathKind;", "getDependentTargets", "compilingChunk", "Lorg/jetbrains/jps/ModuleChunk;", "getIncrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalJvmCache;", "chunk", "getLookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "getProcessedTargetsWithRemovedFilesContainer", "hasKotlinDirtyOrRemovedFiles", "", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "jvmBuildMetaInfoFile", "target", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "processChangesUsingLookups", "", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "compiledFiles", "fsOperations", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "caches", "", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "jps-plugin"})
public final class KotlinBuilderKt {
    private static final Key<Set<File>> ALL_COMPILED_FILES_KEY = Key.create((String)"_all_kotlin_compiled_files_");
    private static final Key<Set<ModuleBuildTarget>> PROCESSED_TARGETS_WITH_REMOVED_FILES = Key.create((String)"_processed_targets_with_removed_files_");

    /*
     * WARNING - void declaration
     */
    private static final void processChangesUsingLookups(@NotNull ChangesCollector $receiver, Set<? extends File> compiledFiles, BuildDataManager dataManager, FSOperationsHelper fsOperations, Iterable<? extends IncrementalJvmCache> caches) {
        void dirtyLookupSymbols;
        Collection<LookupSymbol> $receiver$iv$iv;
        Iterable<? extends IncrementalJvmCache> $receiver$iv;
        JpsLookupStorage lookupStorage = (JpsLookupStorage)dataManager.getStorage((BuildTarget)KotlinDataContainerTarget.INSTANCE, (StorageProvider)JpsLookupStorageProvider.INSTANCE);
        Iterable<? extends IncrementalJvmCache> iterable = $receiver$iv = caches;
        Collection destination$iv$iv = new ArrayList();
        for (Object iterable2 : $receiver$iv$iv) {
            IncrementalJvmCache it = (IncrementalJvmCache)iterable2;
            Iterable<IncrementalCacheCommon> list$iv$iv = it.getThisWithDependentCaches();
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        List allCaches = (List)destination$iv$iv;
        JpsICReporter reporter = new JpsICReporter();
        reporter.report((Function0<String>)((Function0)processChangesUsingLookups.1.INSTANCE));
        DirtyData dirtyData = BuildUtilKt.getDirtyData($receiver, allCaches, reporter);
        $receiver$iv$iv = dirtyData.component1();
        Collection<FqName> dirtyClassFqNames = dirtyData.component2();
        JpsLookupStorage jpsLookupStorage = lookupStorage;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsLookupStorage, (String)"lookupStorage");
        Set dirtyFiles = SetsKt.plus((Set)BuildUtilKt.mapLookupSymbolsToFiles$default(jpsLookupStorage, (Iterable)dirtyLookupSymbols, reporter, null, 8, null), (Iterable)BuildUtilKt.mapClassesFqNamesToFiles$default(allCaches, dirtyClassFqNames, reporter, null, 8, null));
        Iterable iterable2 = dirtyFiles;
        FSOperationsHelper fSOperationsHelper = fsOperations;
        Iterable iterable3 = iterable2;
        fSOperationsHelper.markInChunkOrDependents(iterable3, compiledFiles);
        reporter.report((Function0<String>)((Function0)processChangesUsingLookups.2.INSTANCE));
    }

    private static final LookupTracker getLookupTracker(JpsProject project) {
        TestingContext testLookupTracker;
        TestingContext testingContext = TestingContextKt.getTestingContext(project);
        if (testingContext == null || (testingContext = testingContext.getLookupTracker()) == null) {
            testingContext = testLookupTracker = (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE;
        }
        if (IncrementalCompilation.isEnabled()) {
            return new LookupTrackerImpl((LookupTracker)testLookupTracker);
        }
        return testLookupTracker;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<ModuleBuildTarget, JpsIncrementalJvmCache> getIncrementalCaches(ModuleChunk chunk, CompileContext context) {
        void $receiver$iv$iv;
        Set<ModuleBuildTarget> dependentTargets = KotlinBuilderKt.getDependentTargets(chunk, context);
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        Map<ModuleBuildTarget, JpsIncrementalJvmCache> chunkCaches2 = CollectionsKt.keysToMap(chunk.getTargets(), (Function1)new Function1<ModuleBuildTarget, JpsIncrementalJvmCache>(dataManager){
            final /* synthetic */ BuildDataManager $dataManager;

            @NotNull
            public final JpsIncrementalJvmCache invoke(ModuleBuildTarget it) {
                ModuleBuildTarget moduleBuildTarget = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                return JpsIncrementalJvmCacheKt.getKotlinCache(this.$dataManager, moduleBuildTarget);
            }
            {
                this.$dataManager = buildDataManager;
                super(1);
            }
        });
        Iterable $receiver$iv = dependentTargets;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            JpsIncrementalJvmCache jpsIncrementalJvmCache = JpsIncrementalJvmCacheKt.getKotlinCache(dataManager, (ModuleBuildTarget)it);
            collection.add(jpsIncrementalJvmCache);
        }
        List dependentCaches = (List)destination$iv$iv;
        for (JpsIncrementalJvmCache chunkCache : chunkCaches2.values()) {
            for (JpsIncrementalJvmCache dependentCache : dependentCaches) {
                chunkCache.addDependentCache(dependentCache);
            }
        }
        return chunkCaches2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ModuleBuildTarget> getDependentTargets(@NotNull ModuleChunk compilingChunk, @NotNull CompileContext context) {
        Iterator iterator2;
        boolean bl;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)compilingChunk, (String)"compilingChunk");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Iterable $receiver$iv = compilingChunk.getTargets();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                    if (!it.isTests()) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean compilingChunkIsTests = bl;
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)compilingChunkIsTests);
        Function1 dependsOnCompilingChunk$ = new Function1<BuildTarget<?>, Boolean>(compilingChunkIsTests, classpathKind, compilingChunk){
            final /* synthetic */ boolean $compilingChunkIsTests;
            final /* synthetic */ JpsJavaClasspathKind $classpathKind;
            final /* synthetic */ ModuleChunk $compilingChunk;

            public final boolean invoke(@NotNull BuildTarget<?> target) {
                Intrinsics.checkParameterIsNotNull(target, (String)"target");
                if (!(target instanceof ModuleBuildTarget) || this.$compilingChunkIsTests && !((ModuleBuildTarget)target).isTests()) {
                    return false;
                }
                JpsModule jpsModule = ((ModuleBuildTarget)target).getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"target.module");
                JpsJavaClasspathKind jpsJavaClasspathKind = this.$classpathKind;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaClasspathKind, (String)"classpathKind");
                Set dependencies = KotlinBuilderKt.access$getDependenciesRecursively(jpsModule, jpsJavaClasspathKind);
                return ContainerUtil.intersects((Collection)dependencies, (Collection)this.$compilingChunk.getModules());
            }
            {
                this.$compilingChunkIsTests = bl;
                this.$classpathKind = jpsJavaClasspathKind;
                this.$compilingChunk = moduleChunk;
                super(1);
            }
        };
        HashSet dependentTargets = new HashSet();
        Iterator sortedChunks = context.getProjectDescriptor().getBuildTargetIndex().getSortedTargetChunks(context).iterator();
        while (sortedChunks.hasNext() && !Intrinsics.areEqual((Object)((BuildTargetChunk)sortedChunks.next()).getTargets(), (Object)compilingChunk.getTargets())) {
        }
        Iterator iterator3 = iterator2 = sortedChunks;
        while (iterator3.hasNext()) {
            void $receiver$iv$iv;
            boolean bl2;
            Iterable $receiver$iv;
            BuildTargetChunk followingChunk;
            block10: {
                followingChunk = (BuildTargetChunk)iterator3.next();
                $receiver$iv = followingChunk.getTargets();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        BuildTarget p1 = (BuildTarget)element$iv;
                        if (!dependsOnCompilingChunk$.invoke(p1)) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) continue;
            $receiver$iv = followingChunk.getTargets();
            HashSet hashSet = dependentTargets;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof ModuleBuildTarget)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            hashSet.addAll(list);
        }
        return dependentTargets;
    }

    private static final Set<JpsModule> getDependenciesRecursively(JpsModule module, JpsJavaClasspathKind kind) {
        Set set = JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursivelyExportedOnly().getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"JpsJavaExtensionService.\u2026elyExportedOnly().modules");
        return set;
    }

    private static final Set<File> getAllCompiledFilesContainer(CompileContext context) {
        Set allCompiledFiles = (Set)ALL_COMPILED_FILES_KEY.get((UserDataHolder)context);
        if (allCompiledFiles == null) {
            allCompiledFiles = (Set)new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            ALL_COMPILED_FILES_KEY.set((UserDataHolder)context, (Object)allCompiledFiles);
        }
        return allCompiledFiles;
    }

    private static final Set<ModuleBuildTarget> getProcessedTargetsWithRemovedFilesContainer(CompileContext context) {
        Set set = (Set)PROCESSED_TARGETS_WITH_REMOVED_FILES.get((UserDataHolder)context);
        if (set == null) {
            set = new HashSet();
            PROCESSED_TARGETS_WITH_REMOVED_FILES.set((UserDataHolder)context, (Object)set);
        }
        return set;
    }

    private static final boolean hasKotlinDirtyOrRemovedFiles(DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleChunk chunk) {
        boolean bl;
        block5: {
            if (!dirtyFilesHolder.hasDirtyFiles() && !dirtyFilesHolder.hasRemovedFiles()) {
                return false;
            }
            if (!KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder).isEmpty()) {
                return true;
            }
            Iterable $receiver$iv = chunk.getTargets();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleBuildTarget it = (ModuleBuildTarget)element$iv;
                    Collection collection = KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, it);
                    if (!(!collection.isEmpty())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final File jvmBuildMetaInfoFile(@NotNull ModuleBuildTarget target, @NotNull BuildDataManager dataManager) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)dataManager, (String)"dataManager");
        return new File(dataManager.getDataPaths().getTargetDataRoot((BuildTarget)target), "jvm-build-meta-info.txt");
    }

    public static final /* synthetic */ boolean access$hasKotlinDirtyOrRemovedFiles(@NotNull DirtyFilesHolder dirtyFilesHolder, @NotNull ModuleChunk chunk) {
        return KotlinBuilderKt.hasKotlinDirtyOrRemovedFiles((DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, chunk);
    }

    @NotNull
    public static final /* synthetic */ LookupTracker access$getLookupTracker(@NotNull JpsProject project) {
        return KotlinBuilderKt.getLookupTracker(project);
    }

    @NotNull
    public static final /* synthetic */ Map access$getIncrementalCaches(@NotNull ModuleChunk chunk, @NotNull CompileContext context) {
        return KotlinBuilderKt.getIncrementalCaches(chunk, context);
    }

    @NotNull
    public static final /* synthetic */ Set access$getAllCompiledFilesContainer(@NotNull CompileContext context) {
        return KotlinBuilderKt.getAllCompiledFilesContainer(context);
    }

    public static final /* synthetic */ void access$processChangesUsingLookups(@NotNull ChangesCollector $receiver, @NotNull Set compiledFiles, @NotNull BuildDataManager dataManager, @NotNull FSOperationsHelper fsOperations, @NotNull Iterable caches) {
        KotlinBuilderKt.processChangesUsingLookups($receiver, compiledFiles, dataManager, fsOperations, caches);
    }

    @NotNull
    public static final /* synthetic */ Set access$getProcessedTargetsWithRemovedFilesContainer(@NotNull CompileContext context) {
        return KotlinBuilderKt.getProcessedTargetsWithRemovedFilesContainer(context);
    }

    @NotNull
    public static final /* synthetic */ Set access$getDependenciesRecursively(@NotNull JpsModule module, @NotNull JpsJavaClasspathKind kind) {
        return KotlinBuilderKt.getDependenciesRecursively(module, kind);
    }
}

