/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AddDataSourceFromPath
extends AnAction
implements DumbAware {
    final DatabaseViewActions.DataSourceFactory myFactory;

    public AddDataSourceFromPath(@NotNull String text, @NotNull String desc, @NotNull Icon icon, @NotNull DatabaseViewActions.DataSourceFactory factory) {
        if (text == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(0);
        }
        if (desc == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(3);
        }
        super(text, desc, icon);
        this.myFactory = factory;
    }

    @NotNull
    private static String getPath(@Nullable String base, @NotNull String path) {
        if (path == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(4);
        }
        String string = base == null || FileUtil.isAbsolute((String)path) ? path : FileUtil.join((String[])new String[]{base, path});
        if (string == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getRelative(@Nullable String base, @NotNull String path) {
        if (path == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(6);
        }
        String string = base == null ? path : (String)ObjectUtils.chooseNotNull((Object)FileUtil.getRelativePath((File)new File(base), (File)new File(path)), (Object)path);
        if (string == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String chooseFile(@NotNull Project project, @Nullable String cur) {
        if (project == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(8);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false);
        descriptor.setTitle("Select Database Location");
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, cur == null ? null : LocalFileSystem.getInstance().findFileByPath(cur));
        return file == null ? null : file.getCanonicalPath();
    }

    public static void newDataSourceFromFileInput(final @NotNull DbPsiFacade facade, final @Nullable String basePath, final @NotNull String path, @NotNull TripleFunction<DbPsiManager, DataSourceTemplate, String, Void> consumer) {
        if (facade == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(9);
        }
        if (path == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(11);
        }
        new AddDataSourceFromUrl.FastDataSourceDialog(facade.getProject(), (manager, template, s) -> {
            if (consumer == null) {
                AddDataSourceFromPath.$$$reportNull$$$0(17);
            }
            consumer.fun(manager, template, (Object)AddDataSourceFromPath.buildUrl((DatabaseDriver)template, AddDataSourceFromPath.getPath(basePath, s)));
            VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
            return null;
        }){
            {
                super(project, (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)consumer);
                this.setTitle("New Data Source");
                this.getNameLabel().setText(UIUtil.replaceMnemonicAmpersand((String)"&Path:"));
                JComponent parent = (JComponent)this.getNameField().getParent();
                GridLayoutManager layout = (GridLayoutManager)parent.getLayout();
                GridConstraints constraints = layout.getConstraintsForComponent((Component)this.getNameField());
                Box panel = new Box(0);
                panel.add(this.getNameField());
                FixedSizeButton button = new FixedSizeButton((JComponent)this.getNameField());
                panel.add((Component)button);
                parent.add((Component)panel, constraints);
                if (!StringUtil.isEmpty((String)path)) {
                    this.getNameField().setText(path);
                }
                button.setAction(new AbstractAction(null, AllIcons.General.Ellipsis){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String file = AddDataSourceFromPath.chooseFile(facade.getProject(), AddDataSourceFromPath.getPath(basePath, this.getNameField().getText()));
                        if (file == null) {
                            return;
                        }
                        this.getNameField().setText(AddDataSourceFromPath.getRelative(basePath, file));
                    }
                });
            }

            @Override
            protected boolean looksLikeOk(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(0);
                }
                return StringUtil.isEmpty((String)path);
            }

            @Override
            @Nullable
            protected DatabaseDriver selectDriver(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(1);
                }
                String fullPath = AddDataSourceFromPath.getPath(basePath, str);
                DatabaseFamilyId family = this.getFamily(LocalFileSystem.getInstance().findFileByPath(fullPath));
                if (family == null) {
                    return null;
                }
                for (Pair driverPair : this.myDrivers) {
                    DatabaseFamilyId familyId;
                    SqlLanguageDialect lang = DatabaseDriverImpl.getLanguage((DatabaseDriver)driverPair.second);
                    if (lang == null || family != (familyId = lang.getDatabaseDialect().getFamilyId())) continue;
                    return (DatabaseDriver)driverPair.second;
                }
                return null;
            }

            @Nullable
            private DatabaseFamilyId getFamily(@Nullable VirtualFile file) {
                if (file == null) {
                    return null;
                }
                if (file.getFileType() instanceof DbStorageFileType.SqliteStorage) {
                    return DatabaseFamilyId.SQLITE;
                }
                if (file.getFileType() instanceof DbStorageFileType.H2Storage) {
                    return DatabaseFamilyId.H2;
                }
                return null;
            }

            @Override
            @NotNull
            protected List<Pair<DbPsiManager, DatabaseDriver>> extractDrivers(@NotNull DbPsiFacade facade2) {
                if (facade2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                List list = ContainerUtil.filter(1.allDrivers(facade2), pair -> AddDataSourceFromPath.isGoodLocations(((DatabaseDriver)pair.second).getSupportedLocations()));
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "facade";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromPath$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromPath$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "extractDrivers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "looksLikeOk";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "selectDriver";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "extractDrivers";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.show();
    }

    private static boolean isGoodLocations(@NotNull EnumSet<StatelessJdbcUrlParser.LocationType> locations) {
        if (locations == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(12);
        }
        return locations.contains((Object)StatelessJdbcUrlParser.LocationType.DIRECTORY) || locations.contains((Object)StatelessJdbcUrlParser.LocationType.FILE);
    }

    @NotNull
    private static String buildUrl(@NotNull DatabaseDriver driver, @NotNull String path) {
        if (driver == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(13);
        }
        if (path == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(14);
        }
        for (StatelessJdbcUrlParser parser : driver.getJDBCUrlParsers()) {
            if (!AddDataSourceFromPath.isGoodLocations(parser.getPossibleLocations())) continue;
            JdbcUrlParser statefull = parser.createStatefull();
            for (String p : statefull.getParameters()) {
                String val = p.equals("file") || p.equals("path") ? path : statefull.getParameterDefValue(p);
                statefull.setParameter(p, StringUtil.notNullize((String)val));
            }
            String string = statefull.getUrlText();
            if (string == null) {
                AddDataSourceFromPath.$$$reportNull$$$0(15);
            }
            return string;
        }
        if ("" == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(16);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelative";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelative";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newDataSourceFromFileInput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isGoodLocations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildUrl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newDataSourceFromFileInput$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Here
    extends AddDataSourceFromPath {
        public Here(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                Here.$$$reportNull$$$0(0);
            }
            super("Data Source", "Creates new data source here", DatabaseIcons.Dbms, factory);
        }

        public void update(AnActionEvent e) {
            IdeView view2 = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
            boolean enabled = !ScratchFileService.isInScratchRoot((VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE))) && view2 != null && view2.getDirectories().length != 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            PsiDirectory directory;
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            IdeView view2 = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
            PsiDirectory psiDirectory = directory = view2 == null ? null : view2.getOrChooseDirectory();
            if (directory == null) {
                return;
            }
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
            Here.newDataSourceFromFileInput(facade, directory.getVirtualFile().getCanonicalPath(), "", (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)((TripleFunction)(manager, template, s) -> {
                this.myFactory.create(facade, (DbPsiManager)manager, (DataSourceTemplate)template, (String)s);
                return null;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/actions/AddDataSourceFromPath$Here", "<init>"));
        }
    }

    public static class FromThat
    extends AddDataSourceFromPath {
        public FromThat(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                FromThat.$$$reportNull$$$0(0);
            }
            super("As Data Source...", "Creates new data source from selected file", DatabaseIcons.Dbms, factory);
        }

        public void update(AnActionEvent e) {
            boolean enabled;
            Project project = e.getProject();
            IdeView view2 = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
            boolean bl = enabled = view2 != null && project != null;
            if (enabled) {
                VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
                enabled = files != null && files.length == 1 && files[0].isInLocalFileSystem() && files[0].getFileType() instanceof DbStorageFileType;
            }
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
            if (files == null || files.length != 1) {
                return;
            }
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
            FromThat.newDataSourceFromFileInput(facade, null, StringUtil.notNullize((String)files[0].getCanonicalPath()), (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)((TripleFunction)(manager, template, s) -> {
                this.myFactory.create(facade, (DbPsiManager)manager, (DataSourceTemplate)template, (String)s);
                return null;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/actions/AddDataSourceFromPath$FromThat", "<init>"));
        }
    }

    public static class FromDialog
    extends AddDataSourceFromPath {
        public FromDialog(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                FromDialog.$$$reportNull$$$0(0);
            }
            super("Data Source from Path", "Creates new data source from file", AllIcons.Actions.Menu_open, factory);
        }

        public void update(AnActionEvent e) {
            boolean enabled = DatabaseViewActions.getDbFacade(e) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            DbPsiFacade facade = DatabaseViewActions.getDbFacade(e);
            if (facade == null) {
                return;
            }
            String path = AddDataSourceFromPath.chooseFile(facade.getProject(), null);
            if (path == null) {
                return;
            }
            FromDialog.newDataSourceFromFileInput(facade, null, path, (TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>)((TripleFunction)(manager, template, s) -> {
                this.myFactory.create(facade, (DbPsiManager)manager, (DataSourceTemplate)template, (String)s);
                return null;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/actions/AddDataSourceFromPath$FromDialog", "<init>"));
        }
    }
}

