/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.autoconfig.JdbcDriversMappings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="DownloadedDatabaseDrivers", storages={@Storage(value="other.xml")})
public class DownloadedDriversHolder
implements PersistentStateComponent<Element> {
    private Map<String, Collection<String>> myDownloadedMap = new TreeMap<String, Collection<String>>();

    public boolean isDownloaded(@NotNull JdbcDriversMappings.JdbcMapping mapping) {
        Collection<String> urls;
        if (mapping == null) {
            DownloadedDriversHolder.$$$reportNull$$$0(0);
        }
        if ((urls = this.myDownloadedMap.get(mapping.getDriverClass())) == null) {
            return false;
        }
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        for (String url : urls) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file != null && file.isValid() && mapping.isUpToDate(file)) continue;
            return false;
        }
        return true;
    }

    public void setDownloaded(String driver, VirtualFile[] files) {
        List urls = ContainerUtil.map((Object[])files, virtualFile -> virtualFile.getUrl());
        Collections.sort(urls);
        this.myDownloadedMap.put(driver, urls);
    }

    public String[] getDownloaded(String driver) {
        return ArrayUtil.toStringArray(this.myDownloadedMap.get(driver));
    }

    public static DownloadedDriversHolder getInstance() {
        return (DownloadedDriversHolder)ServiceManager.getService(DownloadedDriversHolder.class);
    }

    public Element getState() {
        Element element = new Element("drivers");
        for (Map.Entry<String, Collection<String>> entry : this.myDownloadedMap.entrySet()) {
            Element driver = new Element("driver");
            driver.setAttribute("class", entry.getKey());
            for (String url : entry.getValue()) {
                Element file = new Element("file");
                file.setAttribute("url", url);
                driver.addContent(file);
            }
            element.addContent(driver);
        }
        return element;
    }

    public void loadState(Element state) {
        this.myDownloadedMap.clear();
        for (Object o : state.getChildren("driver")) {
            Element driver = (Element)o;
            String clazz = driver.getAttributeValue("class");
            ArrayList<String> urls = new ArrayList<String>();
            for (Object o1 : driver.getChildren("file")) {
                Element file = (Element)o1;
                urls.add(file.getAttributeValue("url"));
            }
            this.myDownloadedMap.put(clazz, urls);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/database/autoconfig/DownloadedDriversHolder", "isDownloaded"));
    }
}

