/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncUtil {
    public static final Executor POOL_EXECUTOR = command -> ApplicationManager.getApplication().executeOnPooledThread(command);
    public static final Executor EDT_EXECUTOR = command -> UIUtil.invokeLaterIfNeeded((Runnable)command);
    public static final Executor NON_EDT_EXECUTOR = command -> {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            POOL_EXECUTOR.execute(command);
        } else {
            command.run();
        }
    };
    private static final Logger LOG = Logger.getInstance(AsyncUtil.class);
    private static final Key<Boolean> ASYNC_FRIENDLY = Key.create((String)"ASYNC_FRIENDLY");

    public static Executor transactionExecutor(@NotNull Disposable d, @Nullable TransactionId transactionId) {
        if (d == null) {
            AsyncUtil.$$$reportNull$$$0(0);
        }
        return command -> {
            if (d == null) {
                AsyncUtil.$$$reportNull$$$0(40);
            }
            TransactionGuard.getInstance().submitTransaction(d, transactionId, command);
        };
    }

    public static Executor transactionExecutor(@NotNull Disposable d) {
        if (d == null) {
            AsyncUtil.$$$reportNull$$$0(1);
        }
        return AsyncUtil.transactionExecutor(d, TransactionGuard.getInstance().getContextTransaction());
    }

    @NotNull
    public static <T, U> Function<T, U> captureIndicator(@NotNull Function<T, U> foo) {
        if (foo == null) {
            AsyncUtil.$$$reportNull$$$0(2);
        }
        ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
        Function<Object, Object> function = x -> {
            if (foo == null) {
                AsyncUtil.$$$reportNull$$$0(38);
            }
            return AsyncUtil.underProgress(() -> {
                if (foo == null) {
                    AsyncUtil.$$$reportNull$$$0(39);
                }
                return foo.apply(x);
            }, indicator);
        };
        if (function == null) {
            AsyncUtil.$$$reportNull$$$0(3);
        }
        return function;
    }

    @NotNull
    public static <T> Supplier<T> captureIndicator(@NotNull Supplier<T> foo) {
        if (foo == null) {
            AsyncUtil.$$$reportNull$$$0(4);
        }
        ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
        Supplier<Object> supplier = () -> {
            if (foo == null) {
                AsyncUtil.$$$reportNull$$$0(36);
            }
            return AsyncUtil.underProgress(() -> AsyncUtil.lambda$null$6((Supplier)foo), indicator);
        };
        if (supplier == null) {
            AsyncUtil.$$$reportNull$$$0(5);
        }
        return supplier;
    }

    @Nullable
    public static ProgressIndicator getAsyncFriendlyIndicator() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (AsyncUtil.isAsyncFriendly(indicator)) {
            return indicator;
        }
        LOG.warn("Expected async friendly progress indicator, got " + indicator);
        return new EmptyProgressIndicator();
    }

    @Nullable
    public static Throwable unwrap(@Nullable Throwable e) {
        Throwable tmp = e;
        while (tmp != null && (tmp instanceof CompletionException || tmp instanceof ExecutionException) && e.getCause() != null) {
            tmp = e.getCause();
        }
        if (tmp instanceof CancellationException) {
            return new ProcessCanceledException();
        }
        return tmp;
    }

    public static void rethrowUnwrapped(@NotNull Exception e) {
        Throwable unwrapped;
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(6);
        }
        if ((unwrapped = AsyncUtil.unwrap(e)) instanceof CancellationException) {
            throw new ProcessCanceledException(unwrapped);
        }
        ExceptionUtil.rethrowAllAsUnchecked((Throwable)unwrapped);
    }

    public static boolean isAsyncFriendly(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof EmptyProgressIndicator || indicator instanceof UserDataHolder && ASYNC_FRIENDLY.get((UserDataHolder)indicator) == Boolean.TRUE;
    }

    public static <T extends ProgressIndicator> T markAsyncFriendly(@Nullable T indicator, boolean friendly) {
        if (indicator instanceof UserDataHolder) {
            ASYNC_FRIENDLY.set((UserDataHolder)indicator, (Object)(friendly ? Boolean.TRUE : null));
        }
        return indicator;
    }

    public static <T> CompletionStage<T> supplyAsync(@NotNull Supplier<CompletionStage<T>> s, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(8);
        }
        return AsyncUtil.thenComposeAsync(CompletableFuture.completedFuture(null), AsyncUtil.captureIndicator((T x) -> {
            if (s == null) {
                AsyncUtil.$$$reportNull$$$0(35);
            }
            return (CompletionStage)s.get();
        }), e);
    }

    public static <U, T> CompletionStage<T> thenComposeAsync(@NotNull CompletionStage<U> s, @NotNull Function<U, CompletionStage<T>> f, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(9);
        }
        if (f == null) {
            AsyncUtil.$$$reportNull$$$0(10);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(11);
        }
        CompletableFuture result2 = new CompletableFuture();
        AsyncUtil.processWhenComplete(s, result2, r -> {
            if (e == null) {
                AsyncUtil.$$$reportNull$$$0(32);
            }
            if (f == null) {
                AsyncUtil.$$$reportNull$$$0(33);
            }
            e.execute(() -> {
                if (f == null) {
                    AsyncUtil.$$$reportNull$$$0(34);
                }
                AsyncUtil.processWhenComplete((CompletionStage)f.apply(r), result2, result2::complete);
            });
        });
        return result2;
    }

    private static <T> void processWhenComplete(@NotNull CompletionStage<T> what, @NotNull CompletableFuture<?> where, @NotNull Consumer<T> cons) {
        if (what == null) {
            AsyncUtil.$$$reportNull$$$0(12);
        }
        if (where == null) {
            AsyncUtil.$$$reportNull$$$0(13);
        }
        if (cons == null) {
            AsyncUtil.$$$reportNull$$$0(14);
        }
        try {
            what.whenComplete((r, th) -> {
                if (where == null) {
                    AsyncUtil.$$$reportNull$$$0(30);
                }
                if (cons == null) {
                    AsyncUtil.$$$reportNull$$$0(31);
                }
                if (th != null) {
                    where.completeExceptionally((Throwable)th);
                } else {
                    try {
                        cons.consume(r);
                    }
                    catch (Throwable ex) {
                        where.completeExceptionally(ex);
                    }
                }
            });
        }
        catch (Throwable ex) {
            where.completeExceptionally(ex);
        }
    }

    public static <T> T underProgress(@NotNull Computable<T> r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(15);
        }
        Ref res = Ref.create();
        AsyncUtil.underProgress(() -> {
            if (r == null) {
                AsyncUtil.$$$reportNull$$$0(29);
            }
            res.set(r.compute());
        }, indicator);
        return (T)res.get();
    }

    public static void underProgress(@NotNull Runnable r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(16);
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        ProgressManager.getInstance().executeProcessUnderProgress(r, indicator);
    }

    @NotNull
    public static <T> CompletionStage<T> runTask(@NotNull Computable<CompletionStage<T>> r, @NotNull ProgressIndicatorEx indicator) {
        CompletionStage<Object> res;
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            AsyncUtil.$$$reportNull$$$0(18);
        }
        indicator.start();
        try {
            res = AsyncUtil.underProgress(r, (ProgressIndicator)indicator);
        }
        catch (Throwable th) {
            indicator.stop();
            indicator.processFinish();
            CompletableFuture<T> completableFuture = AsyncUtil.exceptional(th);
            if (completableFuture == null) {
                AsyncUtil.$$$reportNull$$$0(19);
            }
            return completableFuture;
        }
        res.whenComplete((t, throwable) -> {
            if (indicator == null) {
                AsyncUtil.$$$reportNull$$$0(28);
            }
            indicator.stop();
            indicator.processFinish();
        });
        CompletionStage<Object> completionStage = res;
        if (completionStage == null) {
            AsyncUtil.$$$reportNull$$$0(20);
        }
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T withAsyncFriendly(@Nullable ProgressIndicator indicator, @NotNull ThrowableComputable<T, E> computable) throws E {
        boolean wasFriendly;
        if (computable == null) {
            AsyncUtil.$$$reportNull$$$0(21);
        }
        if (!(wasFriendly = AsyncUtil.isAsyncFriendly(indicator))) {
            AsyncUtil.markAsyncFriendly(indicator, true);
        }
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (!wasFriendly) {
                AsyncUtil.markAsyncFriendly(indicator, false);
            }
        }
    }

    public static ProgressIndicatorEx createBackgroundIndicator(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String name) {
        if (project == null) {
            AsyncUtil.$$$reportNull$$$0(22);
        }
        if (name == null) {
            AsyncUtil.$$$reportNull$$$0(23);
        }
        return (ProgressIndicatorEx)AsyncUtil.markAsyncFriendly(new BackgroundableProcessIndicator(project, name, PerformInBackgroundOption.ALWAYS_BACKGROUND, CommonBundle.getCancelButtonText(), CommonBundle.getCancelButtonText(), true), true);
    }

    public static <T> CompletableFuture<T> cancelled() {
        CompletableFuture res = new CompletableFuture();
        res.cancel(false);
        return res;
    }

    public static <T> CompletableFuture<T> exceptional(@NotNull Throwable th) {
        if (th == null) {
            AsyncUtil.$$$reportNull$$$0(24);
        }
        CompletableFuture res = new CompletableFuture();
        res.completeExceptionally(th);
        return res;
    }

    public static boolean isCancellation(@Nullable Throwable e) {
        return e instanceof ProcessCanceledException || e instanceof CancellationException || (e instanceof CompletionException || e instanceof ExecutionException) && AsyncUtil.isCancellation(e.getCause());
    }

    public static void addUnhandledError(@NotNull ErrorHandler errorHandler, @Nullable Throwable e, @NotNull String name, @NotNull DatabaseFamilyId familyId) {
        if (errorHandler == null) {
            AsyncUtil.$$$reportNull$$$0(25);
        }
        if (name == null) {
            AsyncUtil.$$$reportNull$$$0(26);
        }
        if (familyId == null) {
            AsyncUtil.$$$reportNull$$$0(27);
        }
        if (e != null && !AsyncUtil.isCancellation(e)) {
            errorHandler.addError(JdbcEngine.getErrorMessage(e, name, familyId), e);
        }
    }

    private static /* synthetic */ Object lambda$null$6(@NotNull Supplier foo) {
        if (foo == null) {
            AsyncUtil.$$$reportNull$$$0(37);
        }
        return foo.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 2: 
            case 4: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foo";
                break;
            }
            case 3: 
            case 5: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/AsyncUtil";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 9: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 10: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 13: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 14: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cons";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/AsyncUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "captureIndicator";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "runTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transactionExecutor";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "captureIndicator";
                break;
            }
            case 3: 
            case 5: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rethrowUnwrapped";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "supplyAsync";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "thenComposeAsync";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processWhenComplete";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "underProgress";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withAsyncFriendly";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createBackgroundIndicator";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "exceptional";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addUnhandledError";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runTask$13";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$underProgress$12";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processWhenComplete$11";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$thenComposeAsync$10";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$9";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$supplyAsync$8";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$captureIndicator$7";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$captureIndicator$5";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$transactionExecutor$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

