/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseArtifactManager {
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactManager.class);
    public static final String VERSION_LATEST = "latest";
    private static volatile WeakReference<VirtualFile> myDriversRoot;
    private static final DatabaseArtifactManager INSTANCE;
    private static final int UPDATE_LIST_TIMEOUT_MSEC = 86400000;
    private volatile MultiMap<String, DownloadableFileSetDescription> myArtifacts = MultiMap.create();
    private final EventDispatcher<ArtifactListener> myDispatcher = EventDispatcher.create(ArtifactListener.class);
    private boolean myLoaded = true;
    private Long myLastUpdate = null;
    private final Object myFileLock = new Object();

    public static DatabaseArtifactManager getInstance() {
        return INSTANCE;
    }

    public DatabaseArtifactManager() {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            return;
        }
        File file = DatabaseArtifactManager.getLocalArtifactListPath();
        boolean needsLoad = !file.exists();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (needsLoad) {
                DatabaseArtifactManager.loadArtifactsList();
            }
            this.loadLocalArtifactsList();
        });
    }

    public boolean existsVersion(@NotNull String name, @NotNull String version) {
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(0);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(1);
        }
        return this.getArtifact(name, version) != null;
    }

    @Nullable
    private DownloadableFileSetDescription getArtifactLatest(@NotNull String name) {
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(2);
        }
        return (DownloadableFileSetDescription)DatabaseArtifactManager.latest(this.myArtifacts.get((Object)name));
    }

    @Nullable
    private DownloadableFileSetDescription getArtifact(@NotNull String name, @NotNull String version) {
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(3);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(4);
        }
        this.checkForUpdates();
        if (VERSION_LATEST.equals(version)) {
            return this.getArtifactLatest(name);
        }
        for (DownloadableFileSetDescription description : this.myArtifacts.get((Object)name)) {
            if (!version.equals(description.getVersionString())) continue;
            return description;
        }
        return null;
    }

    @Nullable
    private static <T> T latest(@Nullable Collection<T> col) {
        return (T)ContainerUtil.getFirstItem((List)((List)col));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates() {
        boolean notLoaded;
        boolean outdated;
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            return;
        }
        DatabaseArtifactManager databaseArtifactManager = INSTANCE;
        synchronized (databaseArtifactManager) {
            outdated = this.isOutdated();
            if (outdated) {
                this.setLastUpdate(System.currentTimeMillis());
            }
            notLoaded = !outdated && !this.myLoaded;
            this.myLoaded = true;
        }
        if (outdated) {
            this.updateLists();
        } else if (notLoaded) {
            this.initLocal();
            this.listLoaded();
        }
    }

    private void initLocal() {
        try {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.loadLocalArtifactsList()).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public List<DownloadableFileSetDescription> getArtifacts() {
        this.checkForUpdates();
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)this.myArtifacts.values());
        if (arrayList == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static DownloadableFileSetVersions<DownloadableFileSetDescription> getDriverVersionsFetcher() throws IOException {
        DownloadableFileSetVersions downloadableFileSetVersions = DownloadableFileService.getInstance().createFileSetVersions(null, new URL[]{DatabaseArtifactManager.getLocalArtifactListPath().toURI().toURL()});
        if (downloadableFileSetVersions == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(6);
        }
        return downloadableFileSetVersions;
    }

    private void updateLists() {
        this.setLastUpdate(System.currentTimeMillis());
        new Task.Backgroundable(null, "Update Database Drivers List", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText("Loading database drivers list...");
                try {
                    DatabaseArtifactManager.this.loadRemoteArtifactList();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                DatabaseArtifactManager.this.initLocal();
                DatabaseArtifactManager.this.listLoaded();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseArtifactManager$1", "run"));
            }
        }.queue();
    }

    private void listLoaded() {
        ApplicationManager.getApplication().invokeLater(() -> {
            DatabaseArtifactManager.refreshRecursively(LocalFileSystem.getInstance().refreshAndFindFileByPath(DatabaseDriverImpl.getDriverDownloadDirectory()));
            this.fireChanged(null, null);
        });
    }

    private boolean isOutdated() {
        if (this.myLastUpdate == null) {
            File path = DatabaseArtifactManager.getLocalArtifactListPath();
            if (path.exists()) {
                this.myLastUpdate = path.lastModified();
            } else {
                return true;
            }
        }
        return System.currentTimeMillis() - this.myLastUpdate > 86400000L;
    }

    private void loadRemoteArtifactList() throws IOException {
        DatabaseArtifactManager.loadArtifactsList();
        this.loadLocalArtifactsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalArtifactsList() {
        Object object;
        if (!DatabaseArtifactManager.getLocalArtifactListPath().exists()) {
            return;
        }
        List versions = Collections.emptyList();
        Exception wentWrong = null;
        try {
            object = this.myFileLock;
            synchronized (object) {
                versions = DatabaseArtifactManager.getDriverVersionsFetcher().fetchVersions();
            }
        }
        catch (Exception e) {
            wentWrong = e;
        }
        if (versions.isEmpty()) {
            LOG.warn("Unable to load jdbc-drivers.xml. Will delete", (Throwable)wentWrong);
            FileUtil.delete((File)DatabaseArtifactManager.getLocalArtifactListPath());
            object = INSTANCE;
            synchronized (object) {
                this.myLoaded = false;
                this.setLastUpdate(System.currentTimeMillis() - 86400000L + 300000L);
            }
            return;
        }
        this.setArtifacts(versions);
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            DatabaseArtifactManager.refreshRecursively(LocalFileSystem.getInstance().refreshAndFindFileByPath(DatabaseDriverImpl.getDriverDownloadDirectory()));
            this.fireChanged(null, null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastUpdate(Long lastUpdate) {
        DatabaseArtifactManager databaseArtifactManager = INSTANCE;
        synchronized (databaseArtifactManager) {
            this.myLastUpdate = lastUpdate;
        }
    }

    private static void loadArtifactsList() {
        boolean forced;
        File file = DatabaseArtifactManager.getLocalArtifactListPath();
        boolean bl = forced = !file.exists();
        if (DatabaseArtifactManager.loadProvidedArtifactList(file)) {
            return;
        }
        if (forced) {
            DatabaseArtifactManager.loadArtifactListFromResources(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadProvidedArtifactList(File file) {
        String remoteUrl = DatabaseArtifactManager.createVersionsUrl();
        if (remoteUrl != null) {
            try {
                byte[] text = HttpRequests.request((String)remoteUrl).readBytes(ProgressIndicatorProvider.getGlobalProgressIndicator());
                Object object = DatabaseArtifactManager.INSTANCE.myFileLock;
                synchronized (object) {
                    FileUtil.writeToFile((File)file, (byte[])text);
                }
                return true;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadArtifactListFromResources(File file) {
        URL url = DataSourceConfigUtil.class.getResource("/resources/jdbc-drivers.xml");
        if (url == null) return false;
        try (InputStream stream = url.openStream();){
            byte[] text = StreamUtil.loadFromStream((InputStream)stream);
            Object object = DatabaseArtifactManager.INSTANCE.myFileLock;
            synchronized (object) {
                FileUtil.writeToFile((File)file, (byte[])text);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return false;
    }

    @Nullable
    private static String createVersionsUrl() {
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        return StringUtil.isNotEmpty((String)serviceUrl) ? serviceUrl + "/jdbc-drivers/" : null;
    }

    @NotNull
    private static File getLocalArtifactListPath() {
        File file = new File(DatabaseDriverImpl.getDriverDownloadDirectory(), "jdbc-drivers.xml");
        if (file == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(7);
        }
        return file;
    }

    private void setArtifacts(List<DownloadableFileSetDescription> versions) {
        MultiMap newArtifacts = MultiMap.create();
        for (DownloadableFileSetDescription version : versions) {
            if (!SystemInfo.isWindows) {
                version.getFiles().removeIf(d -> d.getPresentableFileName().contains("win"));
            }
            newArtifacts.putValue((Object)version.getName(), (Object)version);
        }
        this.myArtifacts = newArtifacts;
    }

    public void addListener(@NotNull ArtifactListener listener, @Nullable Disposable parent) {
        if (listener == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(8);
        }
        if (parent != null) {
            this.myDispatcher.addListener((EventListener)listener, parent);
        } else {
            this.myDispatcher.addListener((EventListener)listener);
        }
    }

    private void fireChanged(@Nullable String name, @Nullable String version) {
        ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged(name, version);
    }

    @Nullable
    private static VirtualFile getDriversRoot() {
        VirtualFile root2;
        WeakReference<VirtualFile> rootRef = myDriversRoot;
        VirtualFile virtualFile = root2 = rootRef == null ? null : (VirtualFile)rootRef.get();
        if (root2 != null && !root2.isValid()) {
            root2 = null;
        }
        if (root2 != null) {
            return root2;
        }
        root2 = LocalFileSystem.getInstance().findFileByPath(DatabaseDriverImpl.getDriverDownloadDirectory());
        if (root2 != null) {
            myDriversRoot = new WeakReference<VirtualFile>(root2);
        }
        return root2;
    }

    @Nullable
    private static VirtualFile getArtifactFolder(@NotNull String name, @NotNull String version) {
        VirtualFile root2;
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(9);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(10);
        }
        VirtualFile artifact = (root2 = DatabaseArtifactManager.getDriversRoot()) == null ? null : root2.findFileByRelativePath(name);
        return artifact == null ? null : artifact.findFileByRelativePath(version);
    }

    @NotNull
    private static String getBasePath(@NotNull String name, @NotNull String version) {
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(11);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(12);
        }
        String string = DatabaseDriverImpl.getDriverDownloadDirectory() + "/" + name + "/" + version;
        if (string == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public String getActualVersion(@NotNull String name) {
        DownloadableFileSetDescription artifact;
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(14);
        }
        return (artifact = this.getArtifactLatest(name)) == null ? null : artifact.getVersionString();
    }

    public boolean isValid(@NotNull String name, @NotNull String version) {
        DownloadableFileSetDescription desc;
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(15);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(16);
        }
        if ((desc = this.getArtifact(name, version)) != null) {
            return DatabaseArtifactManager.isValidFileList(name, desc);
        }
        VirtualFile folder = DatabaseArtifactManager.getArtifactFolder(name, version);
        return folder != null && folder.getChildren().length > 0;
    }

    public boolean isFreshFiles(@NotNull String name, @NotNull String version, @NotNull Set<String> fileNames) {
        DownloadableFileSetDescription desc;
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(17);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(18);
        }
        if (fileNames == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(19);
        }
        return (desc = this.getArtifact(name, version)) == null || DatabaseArtifactManager.isAllDownloaded(desc, fileNames);
    }

    public boolean isVersionValid(@NotNull String name, @NotNull String version) {
        DownloadableFileSetDescription desc;
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(20);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(21);
        }
        if ((desc = this.getArtifact(name, version)) == null) {
            return true;
        }
        return DatabaseArtifactManager.isValidFileList(name, desc);
    }

    private static boolean isValidFileList(@NotNull String name, @NotNull DownloadableFileSetDescription desc) {
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(22);
        }
        if (desc == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(23);
        }
        VirtualFile folder = DatabaseArtifactManager.getArtifactFolder(name, desc.getVersionString());
        HashSet existing = ContainerUtil.newHashSet();
        if (folder == null) {
            return false;
        }
        for (VirtualFile file : folder.getChildren()) {
            existing.add(file.getName());
        }
        return DatabaseArtifactManager.isAllDownloaded(desc, existing);
    }

    private static boolean isAllDownloaded(@NotNull DownloadableFileSetDescription desc, Set<String> existing) {
        if (desc == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(24);
        }
        for (DownloadableFileDescription file : desc.getFiles()) {
            if (file.getDefaultFileName().endsWith(".txt") || existing.contains(file.getDefaultFileName())) continue;
            return false;
        }
        return true;
    }

    public void downloadArtifact(@NotNull String name, @NotNull String version, @Nullable Consumer<DownloadableFileSetDescription> onFinish) throws IOException {
        DownloadableFileSetDescription download;
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(25);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(26);
        }
        if ((download = this.getArtifact(name, version)) == null) {
            return;
        }
        String path = DatabaseArtifactManager.getBasePath(name, download.getVersionString());
        FileDownloader downloader = DownloadableFileService.getInstance().createDownloader(download);
        File dir = new File(path);
        downloader.download(dir);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (name == null) {
                DatabaseArtifactManager.$$$reportNull$$$0(30);
            }
            DatabaseArtifactManager.refreshRecursively(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir));
            if (onFinish != null) {
                onFinish.consume((Object)download);
            }
            this.fireChanged(name, download.getVersionString());
        });
    }

    private static void refreshRecursively(@Nullable VirtualFile file) {
        if (file != null) {
            TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
                VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
                RefreshQueue.getInstance().refresh(false, true, null, ModalityState.defaultModalityState(), new VirtualFile[]{file});
            });
        }
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull String name, @NotNull String version) {
        if (name == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(27);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(28);
        }
        if (VERSION_LATEST.equals(version)) {
            throw new AssertionError((Object)"Should be concrete version");
        }
        VirtualFile folder = DatabaseArtifactManager.getArtifactFolder(name, version);
        VirtualFile[] virtualFileArray = folder == null ? VirtualFile.EMPTY_ARRAY : folder.getChildren();
        if (virtualFileArray == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(29);
        }
        return virtualFileArray;
    }

    static {
        INSTANCE = new DatabaseArtifactManager();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 21: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverVersionsFetcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalArtifactListPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "existsVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactLatest";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArtifact";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactFolder";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBasePath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getActualVersion";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isFreshFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isVersionValid";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileList";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAllDownloaded";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifact";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadArtifact$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ArtifactListener
    extends EventListener {
        public void artifactChanged(String var1, String var2);
    }
}

