/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcModificationSession;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.impl.BlackHoleTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.util.GuardedRef;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DbSrcModelStorage
implements ModelTextStorage {
    private static final Logger LOG = Logger.getInstance(DbSrcModelStorage.class);
    private final DbSrcStorage myStorage;
    @Nullable
    private final Project myProject;
    private volatile DbSrcModificationSession myModSession;
    private final Alarm myInvalidUsageReporter;
    public static final ModelFactory DUMB_FACTORY = new ModelFactory(BlackHoleTextStorage.INSTANCE);
    private static final int MESSAGE_DELAY = 500;

    private DbSrcModelStorage(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcModelStorage.$$$reportNull$$$0(0);
        }
        this.myStorage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
        this.myProject = project;
        this.myInvalidUsageReporter = AlarmFactory.getInstance().create(Alarm.ThreadToUse.SWING_THREAD, (Disposable)(project == null ? ApplicationManager.getApplication() : project));
    }

    @NotNull
    public GuardedRef startWriteSession(@NotNull BasicModel model, @Nullable TransactionId transactionId) {
        DbSrcModificationSession session;
        if (model == null) {
            DbSrcModelStorage.$$$reportNull$$$0(1);
        }
        if (this.myModSession != null) {
            LOG.warn("Parallel modification is forbidden");
        }
        this.myModSession = session = new DbSrcModificationSession(this.myProject, this.myStorage, transactionId);
        GuardedRef<DbSrcModificationSession> guardedRef = new GuardedRef<DbSrcModificationSession>(session){

            @Override
            protected void close(@NotNull DbSrcModificationSession ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    session.waitForWriteFinished();
                }
                finally {
                    if (session == DbSrcModelStorage.this.myModSession) {
                        DbSrcModelStorage.this.myModSession = null;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage$1", "close"));
            }
        };
        if (guardedRef == null) {
            DbSrcModelStorage.$$$reportNull$$$0(2);
        }
        return guardedRef;
    }

    @Nullable
    private DbSrcModificationSession getModSession() {
        LOG.assertTrue(this.myModSession != null, (Object)"Session not started");
        return this.myModSession;
    }

    @Override
    public void save(@NotNull BasicSourceAware element, @Nullable CompositeText text) {
        DbSrcModificationSession session;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(3);
        }
        if ((session = this.getModSession()) != null) {
            session.save(element, text);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicElement element) {
        DbSrcModificationSession session;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(4);
        }
        if ((session = this.getModSession()) != null) {
            session.queueDelete(element);
        }
    }

    @Override
    public void processDeleteQueue() {
        DbSrcModificationSession session = this.myModSession;
        if (session == null) {
            return;
        }
        session.beginWrite();
        session.endWrite();
    }

    @Override
    public void writeSession(@NotNull Runnable runnable) {
        DbSrcModificationSession session;
        if (runnable == null) {
            DbSrcModelStorage.$$$reportNull$$$0(5);
        }
        if ((session = this.getModSession()) != null) {
            session.beginWrite();
            try {
                runnable.run();
            }
            finally {
                session.endWrite();
            }
        } else {
            runnable.run();
        }
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware element) {
        boolean outdated;
        DbSrcModificationSession session;
        CompositeText src;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(6);
        }
        CompositeText compositeText = src = (session = this.myModSession) == null ? null : session.getTmpSource(element);
        if (src != null) {
            return src;
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        String text = this.getOriginalContent(srcPath, session != null);
        if (text == null) {
            return null;
        }
        DbSrcStorageDsMetadata.MetaData md = this.myStorage.getMetaData(srcPath);
        BasicModel model = element.getModel();
        Rdbms rdbms = model == null ? UnknownDatabase.RDBMS : model.getRdbms();
        boolean bl = outdated = md != null && md.introContentVersion != DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(rdbms, element.getKind());
        if (outdated && session == null) {
            this.queueInvalidSourceUsageReport(element);
        }
        boolean noRanges = md == null || md.kinds == null || md.kinds.length == 0;
        return noRanges ? new SimpleCompositeText(text, CompositeText.Kind.ORIGINAL_TEXT) : new PersistentMarkup(text, md.offsets, md.kinds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOriginalContent(DbSrcPath srcPath, boolean forceLoad) {
        if (!forceLoad) {
            DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
            VirtualFile file = fs.findFileByPath(DbSrcFileSystem.getPath(this.myProject, this.myStorage.getDataSourceId(), srcPath, DbSrcFileSystem.ItemType.SRC));
            VirtualFile virtualFile = file = file == null ? null : fs.getBaseFile(file, false);
            if (file != null) {
                return DbSrcFileStatus.getContent(file, false);
            }
        }
        try (InputStream is = this.myStorage.getContentInputStream(srcPath, true);){
            if (is == null) {
                String string2 = null;
                return string2;
            }
            String string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(is, "UTF-8")));
            return string;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element) {
        DbSrcPath srcPath;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(7);
        }
        if (this.myStorage.hasChildren(srcPath = DbSrcPath.of(element))) {
            return true;
        }
        return this.myStorage.getSrcAttributes(srcPath, true) != null;
    }

    @Override
    public Long getVersion(@NotNull BasicElement element) {
        DbSrcPath srcPath;
        DbSrcStorageDsMetadata.MetaData data;
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(8);
        }
        return (data = this.myStorage.getMetaData(srcPath = DbSrcPath.of(element))) == null ? null : data.srcVersion;
    }

    @Override
    public void setVersion(@NotNull BasicElement element, Long version) {
        if (element == null) {
            DbSrcModelStorage.$$$reportNull$$$0(9);
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        DbSrcStorageDsMetadata.MetaData data = this.myStorage.getMetaData(srcPath);
        try {
            this.myStorage.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(data, version));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DbSrcModelStorage.$$$reportNull$$$0(10);
        }
        ModelFactory modelFactory = DbSrcModelStorage.createFactory(dataSource.isGlobal() ? null : project, dataSource.getUniqueId());
        if (modelFactory == null) {
            DbSrcModelStorage.$$$reportNull$$$0(11);
        }
        return modelFactory;
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @Nullable String dataSourceId) {
        if (dataSourceId == null) {
            ModelFactory modelFactory = DUMB_FACTORY;
            if (modelFactory == null) {
                DbSrcModelStorage.$$$reportNull$$$0(12);
            }
            return modelFactory;
        }
        ModelFactory modelFactory = new ModelFactory(new DbSrcModelStorage(project, dataSourceId));
        if (modelFactory == null) {
            DbSrcModelStorage.$$$reportNull$$$0(13);
        }
        return modelFactory;
    }

    private void queueInvalidSourceUsageReport(@NotNull BasicSourceAware object) {
        if (object == null) {
            DbSrcModelStorage.$$$reportNull$$$0(14);
        }
        if (!DbSrcValidator.isEnabled()) {
            return;
        }
        this.myInvalidUsageReporter.cancelAllRequests();
        this.myInvalidUsageReporter.addRequest(this::reportInvalidSourceUsage, 500);
    }

    private void reportInvalidSourceUsage() {
        LocalDataSource dataSource = DbSrcUtils.findDataSource(this.myProject, this.myStorage.getDataSourceId());
        if (dataSource == null) {
            return;
        }
        Project project = this.myProject == null ? ProjectManager.getInstance().getDefaultProject() : this.myProject;
        DbSrcValidator.suggestIntrospecting(project, Collections.singletonList(dataSource));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startWriteSession";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startWriteSession";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queueDelete";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSession";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasExistingSources";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFactory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queueInvalidSourceUsageReport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

