/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.TextDecompositionNodes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDecompositionUtil {
    private static final Function<TextDecompositionNodes.SNode, Iterable<? extends TextDecompositionNodes.SNode>> TREE_STRUCTURE = node -> node.children();

    @NotNull
    static List<TextRange> extractBadRanges(@NotNull TextDecompositionNodes.SNode root2) {
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(0);
        }
        List<TextRange> list = new TextDecompositionNodes.NodeVisitor<Void>(){
            private final List<TextRange> myRanges = ContainerUtil.newArrayList();
            private final Set<TextDecompositionNodes.BadGroup> myVisited = ContainerUtil.newHashSet();

            public List<TextRange> getResult(@NotNull TextDecompositionNodes.SNode root2) {
                if (root2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visit(root2);
                return this.myRanges;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextDecompositionNodes.Badable bad = (TextDecompositionNodes.Badable)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.Badable.class);
                TextDecompositionNodes.StartEndBadable sebad = (TextDecompositionNodes.StartEndBadable)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.StartEndBadable.class);
                this.processBadGroup(bad == null ? null : bad.getBadGroup());
                this.processBadGroup(sebad == null ? null : sebad.getStartBadGroup());
                this.processBadGroup(sebad == null ? null : sebad.getEndBadGroup());
                node.visitChildren(this);
                return null;
            }

            private void processBadGroup(TextDecompositionNodes.BadGroup badGroup) {
                if (badGroup != null && !this.myVisited.contains(badGroup)) {
                    assert (badGroup.getFrom() != -1);
                    this.myRanges.add(TextRange.create((int)badGroup.getFrom(), (int)badGroup.getTo()));
                    this.myVisited.add(badGroup);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getResult";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.getResult(root2);
        if (list == null) {
            TextDecompositionUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    static void buildText(final @NotNull StringBuilder builder, @NotNull TextDecompositionNodes.SNode root2) {
        if (builder == null) {
            TextDecompositionUtil.$$$reportNull$$$0(2);
        }
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(3);
        }
        new SimpleNodeVisitor<Void>(){
            private boolean myDisabled = false;
            private Set<TextDecompositionNodes.BadGroup> myVisited = ContainerUtil.newHashSet();

            private boolean processBadGroup(@Nullable TextDecompositionNodes.BadGroup b) {
                if (b != null && !this.myVisited.contains(b)) {
                    int start = builder.length();
                    builder.append(b.getBadText());
                    int end = builder.length();
                    b.setRange(start, end);
                    this.myVisited.add(b);
                }
                return b != null;
            }

            private void processBadTextPre(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.processBadGroup(node instanceof TextDecompositionNodes.StartEndBadable ? ((TextDecompositionNodes.StartEndBadable)((Object)node)).getStartBadGroup() : null);
            }

            private boolean processBadTextInstead(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
                return this.processBadGroup(node instanceof TextDecompositionNodes.Badable ? ((TextDecompositionNodes.Badable)((Object)node)).getBadGroup() : null);
            }

            private void processBadTextPost(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.processBadGroup(node instanceof TextDecompositionNodes.StartEndBadable ? ((TextDecompositionNodes.StartEndBadable)((Object)node)).getEndBadGroup() : null);
            }

            private void updateNodeRange(@NotNull TextDecompositionNodes.SNode node, int start, int end) {
                if (node == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (start == end) {
                    node.setMatchRange(-1, -1);
                } else {
                    node.setMatchRange(start, end);
                }
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(4);
                }
                int start = builder.length();
                this.processBadTextPre(node);
                boolean bad = this.processBadTextInstead(node);
                if (bad || this.myDisabled) {
                    node.visitChildren(this);
                } else {
                    super.visit(node);
                }
                this.processBadTextPost(node);
                int end = builder.length();
                this.updateNodeRange(node, start, end);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ParameterSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(5);
                }
                builder.append(node.getText());
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.TextSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(6);
                }
                builder.append(node.getMatchedText());
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.AntiSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(7);
                }
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.CompositeSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(8);
                }
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.OptionalSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(9);
                }
                assert (!this.myDisabled);
                this.myDisabled = !node.isEnabled();
                node.visitChildren(this);
                this.myDisabled = false;
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListChoiceSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(10);
                }
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListSNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(11);
                }
                boolean first = true;
                for (TextDecompositionNodes.ListChoiceSNode m : node.getMatches()) {
                    if (!m.isEnabled()) continue;
                    if (!first) {
                        builder.append(node.getStateless().getSeparator());
                    } else {
                        first = false;
                    }
                    this.visit((TextDecompositionNodes.SNode)m);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processBadTextPre";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processBadTextInstead";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processBadTextPost";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateNodeRange";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(root2);
    }

    public static void purgeBadGroups(@NotNull TextDecompositionNodes.SNode root2) {
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(4);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                TextDecompositionNodes.Badable bad = (TextDecompositionNodes.Badable)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.Badable.class);
                TextDecompositionNodes.StartEndBadable sebad = (TextDecompositionNodes.StartEndBadable)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.StartEndBadable.class);
                if (bad != null) {
                    bad.setBadGroup(null);
                    TextDecompositionNodes.TextSNode text = (TextDecompositionNodes.TextSNode)ObjectUtils.tryCast((Object)node, TextDecompositionNodes.TextSNode.class);
                    if (text != null) {
                        text.setMatchedText(text.getStateless().getText());
                    }
                }
                if (sebad != null) {
                    sebad.setStartBadGroup(null);
                    sebad.setEndBadGroup(null);
                }
                node.visitChildren(this);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$3", "visit"));
            }
        }.visit(root2);
    }

    public static void assignGroups(@NotNull TextDecompositionNodes.SNode root2) {
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(5);
        }
        new SimpleNodeVisitor<Void>(){
            private int groupNumber = 0;

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ParameterSNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                node.setGroupNumber(this.groupNumber + 1);
                this.groupNumber += node.getStateless().getContainingGroups();
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.TextSNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(1);
                }
                node.setGroupNumber(this.groupNumber + 1);
                this.groupNumber += node.getStateless().getContainingGroups();
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.CompositeSNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(2);
                }
                node.setGroupNumber(this.groupNumber + 1);
                ++this.groupNumber;
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.AntiSNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(3);
                }
                node.setGroupNumber(this.groupNumber + 1);
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.OptionalSNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(4);
                }
                node.setGroupNumber(this.groupNumber + 1);
                node.visitChildren(this);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListChoiceSNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(5);
                }
                assert (false);
                return null;
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.ListSNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(6);
                }
                node.setGroupNumber(this.groupNumber + 1);
                this.groupNumber += node.getStateless().getContainingGroups();
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$4", "visit"));
            }
        }.visit(root2);
    }

    public static void resetDisabledMatchables(@NotNull TextDecompositionNodes.SNode node) {
        if (node == null) {
            TextDecompositionUtil.$$$reportNull$$$0(6);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){
            private boolean myInsideDisabled = false;

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    5.$$$reportNull$$$0(0);
                }
                boolean prev = this.myInsideDisabled;
                if (node instanceof TextDecompositionNodes.OptionalSNode) {
                    this.myInsideDisabled |= !((TextDecompositionNodes.OptionalSNode)node).isEnabled();
                } else if (node instanceof TextDecompositionNodes.ListChoiceSNode) {
                    this.myInsideDisabled |= !((TextDecompositionNodes.ListChoiceSNode)node).isEnabled();
                }
                node.visitChildren(this);
                if (this.myInsideDisabled) {
                    node.setMatch(null);
                }
                this.myInsideDisabled = prev;
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$5", "visit"));
            }
        }.visit(node);
    }

    public static void nullizeMatch(@NotNull TextDecompositionNodes.SNode node) {
        if (node == null) {
            TextDecompositionUtil.$$$reportNull$$$0(7);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    6.$$$reportNull$$$0(0);
                }
                node.setMatch(null);
                node.visitChildren(this);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$6", "visit"));
            }
        }.visit(node);
    }

    @NotNull
    public static TextDecompositionNodes.Matchable[] collectMatchables(@NotNull TextDecompositionNodes.SNode root2) {
        if (root2 == null) {
            TextDecompositionUtil.$$$reportNull$$$0(8);
        }
        final ArrayList res = new ArrayList();
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (!(node instanceof TextDecompositionNodes.ListSNode)) {
                    node.visitChildren(this);
                }
                res.add(node);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$7", "visit"));
            }
        }.visit(root2);
        TextDecompositionNodes.Matchable[] ares = res.toArray(new TextDecompositionNodes.Matchable[res.size()]);
        Arrays.sort(ares, (o1, o2) -> Comparing.compare((int)o1.getGroupNumber(), (int)o2.getGroupNumber()));
        if (ares == null) {
            TextDecompositionUtil.$$$reportNull$$$0(9);
        }
        return ares;
    }

    @NotNull
    public static JBTreeTraverser<TextDecompositionNodes.SNode> traverse(@NotNull TextDecompositionNodes.SNode node) {
        if (node == null) {
            TextDecompositionUtil.$$$reportNull$$$0(10);
        }
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(TREE_STRUCTURE).withRoot((Object)node);
        if (jBTreeTraverser == null) {
            TextDecompositionUtil.$$$reportNull$$$0(11);
        }
        return jBTreeTraverser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecompositionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecompositionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractBadRanges";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMatchables";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractBadRanges";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "purgeBadGroups";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assignGroups";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetDisabledMatchables";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nullizeMatch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchables";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class SimpleNodeVisitor<R>
    implements TextDecompositionNodes.NodeVisitor<R> {
        SimpleNodeVisitor() {
        }

        @Override
        public R visit(@NotNull TextDecompositionNodes.SNode node) {
            if (node == null) {
                SimpleNodeVisitor.$$$reportNull$$$0(0);
            }
            if (node.getClass() == TextDecompositionNodes.ParameterSNode.class) {
                return this.visit((TextDecompositionNodes.ParameterSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.TextSNode.class) {
                return this.visit((TextDecompositionNodes.TextSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.CompositeSNode.class) {
                return this.visit((TextDecompositionNodes.CompositeSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.OptionalSNode.class) {
                return this.visit((TextDecompositionNodes.OptionalSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.AntiSNode.class) {
                return this.visit((TextDecompositionNodes.AntiSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.ListSNode.class) {
                return this.visit((TextDecompositionNodes.ListSNode)node);
            }
            if (node.getClass() == TextDecompositionNodes.ListChoiceSNode.class) {
                return this.visit((TextDecompositionNodes.ListChoiceSNode)node);
            }
            assert (false);
            return null;
        }

        public abstract R visit(@NotNull TextDecompositionNodes.AntiSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ParameterSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.TextSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.CompositeSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.OptionalSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ListSNode var1);

        public abstract R visit(@NotNull TextDecompositionNodes.ListChoiceSNode var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecompositionUtil$SimpleNodeVisitor", "visit"));
        }
    }
}

