/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.ui.CompletionParamEditor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;

public class DatabaseParamEditor
extends CompletionParamEditor<DatabaseInfo> {
    private boolean myCompletionActivated;

    public DatabaseParamEditor(@NotNull String label, final @NotNull DataInterchange interchange) {
        if (label == null) {
            DatabaseParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            DatabaseParamEditor.$$$reportNull$$$0(1);
        }
        super(label, interchange);
        this.myCompletionActivated = false;
        this.setUpdateTitle("Refreshing Databases List");
        this.setForceRefresh("Refresh Databases List");
        this.setSupersedeTasks(true);
        this.setValidateOnDirtyCompletion(true);
        interchange.addUserDataListener(new DataInterchange.UserDataListener(){
            private String prev = null;

            @Override
            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (changed != DataInterchange.ACTIVITY) {
                    return;
                }
                StatelessJdbcUrlParser parser = interchange.getActiveParser();
                if (parser == null) {
                    return;
                }
                LocalDataSource dataSource = interchange.getDataSourceRef();
                if (dataSource.getUrl() == null) {
                    return;
                }
                JdbcUrlParser sparser = parser.createStatefull();
                sparser.setUrlText(dataSource.getUrl());
                sparser.setParameter("database", "");
                StringBuilder key = new StringBuilder();
                key.append(sparser.getUrlText());
                key.append(dataSource.getUsername());
                if (!Comparing.equal((CharSequence)this.prev, (CharSequence)key)) {
                    this.prev = key.toString();
                    DatabaseParamEditor.this.resetVariants();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/DatabaseParamEditor$1", "userDataChanged"));
            }
        }, this);
    }

    @Override
    @NotNull
    protected String getText(@NotNull DatabaseInfo item) {
        if (item == null) {
            DatabaseParamEditor.$$$reportNull$$$0(2);
        }
        String string = item.name;
        if (string == null) {
            DatabaseParamEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void onCompletion(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            DatabaseParamEditor.$$$reportNull$$$0(4);
        }
        if (parameters.isAutoPopup() && !this.myCompletionActivated) {
            return;
        }
        super.onCompletion(parameters);
    }

    @Override
    @NotNull
    protected CompletionStage<List<DatabaseInfo>> getVariants(@NotNull Map<Key, ?> options, @NotNull ErrorHandler errorHandler) {
        if (options == null) {
            DatabaseParamEditor.$$$reportNull$$$0(5);
        }
        if (errorHandler == null) {
            DatabaseParamEditor.$$$reportNull$$$0(6);
        }
        LocalDataSource dataSource = this.getInterchange().buildDataSource();
        SqlLanguageDialect language = DatabaseDriverImpl.getLanguage(dataSource.getDatabaseDriver());
        JdbcUrlParser parser = JdbcUrlParserUtil.stateful(this.getInterchange().getActiveParser());
        if (parser == null || language == null || StringUtil.isEmpty((String)dataSource.getUrl())) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DatabaseParamEditor.$$$reportNull$$$0(7);
            }
            return completableFuture;
        }
        parser.setUrlText(dataSource.getUrl());
        parser.setParameter("database", "");
        dataSource.setUrl(parser.getUrlText());
        CompletionStage<List<DatabaseInfo>> completionStage = DatabaseConnectionManager.getInstance().build(this.getInterchange().getProject(), dataSource).setAskPassword(false).async(connection -> ((DatabaseDialectEx)language.getDatabaseDialect()).tryToLoadDatabaseList(connection), errorHandler).handle((names, th) -> {
            if (errorHandler == null) {
                DatabaseParamEditor.$$$reportNull$$$0(9);
            }
            if (th != null) {
                AsyncUtil.addUnhandledError(errorHandler, th, dataSource.getName(), language.getDatabaseDialect().getFamilyId());
                throw new ProcessCanceledException();
            }
            ArrayList res = ContainerUtil.newArrayListWithCapacity((int)names.size());
            for (String name : names) {
                res.add(new DatabaseInfo(name));
            }
            this.myCompletionActivated = true;
            return res;
        });
        if (completionStage == null) {
            DatabaseParamEditor.$$$reportNull$$$0(8);
        }
        return completionStage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/DatabaseParamEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DatabaseParamEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onCompletion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getVariants$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DatabaseInfo {
        public String name;

        public DatabaseInfo(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseInfo info = (DatabaseInfo)o;
            return !(this.name != null ? !this.name.equals(info.name) : info.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

