/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridFilteringModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridSortingModelImpl;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableGridDataHookUp
extends DatabaseGridDataHookUp {
    @NotNull
    private final VirtualFile myFile;
    private final GridFilteringModelImpl myFilteringModel;
    private final GridSortingModelImpl<DataConsumer.Row, DataConsumer.Column> mySortingModel;

    DatabaseTableGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(2);
        }
        super(project, messageBus);
        this.myFile = file;
        this.setDataSource(DbImplUtil.findDataSource(project, file));
        this.myFilteringModel = new GridFilteringModelImpl(this.createFilterDocument(""), this);
        this.myFilteringModel.setFilteringEnabled(true);
        this.mySortingModel = new GridSortingModelImpl();
        this.mySortingModel.setSortingEnabled(true);
        this.mySortingModel.addListener(new GridSortingModel.Listener(){

            @Override
            public void orderingChanged() {
                DatabaseTableGridDataHookUp.this.myLoader.invalidateQuery();
            }
        }, this);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myFile.getPresentableName();
        if (string == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public GridFilteringModel getFilteringModel() {
        return this.myFilteringModel;
    }

    @Override
    @Nullable
    public GridSortingModel<DataConsumer.Row, DataConsumer.Column> getSortingModel() {
        return this.mySortingModel;
    }

    @Override
    public boolean isReadOnly() {
        ObjectKind kind = DbImplUtil.getKind(this.myFile);
        return !DbImplUtil.isEditableTable(kind) || !this.myFile.isWritable() || super.isReadOnly();
    }

    @Override
    @Nullable
    public String getUnlimitedQueryText() {
        Pair<String, Boolean> pair = ((DatabaseGridDataHookUp.DatabaseLoader)this.myLoader).createQueryTextPure(null);
        return pair == null ? super.getUnlimitedQueryText() : (String)pair.getFirst();
    }

    @Override
    @Nullable
    public DasTable getDatabaseTable() {
        DasTable table = super.getDatabaseTable();
        if (table == null && this.myFile.isValid()) {
            table = (DasTable)ObjectUtils.tryCast((Object)DbImplUtil.findElement(this.getProject(), this.myFile), DasTable.class);
            this.setDatabaseTable(table);
        }
        return table;
    }

    @Override
    @NotNull
    protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
        DatabaseTableLoader databaseTableLoader = new DatabaseTableLoader();
        if (databaseTableLoader == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(5);
        }
        return databaseTableLoader;
    }

    protected void updateFilterDocument() {
        this.myFilteringModel.setDocument(this.createFilterDocument(this.myFilteringModel.getFilterDocument().getText()));
    }

    @NotNull
    private Document createFilterDocument(String initialText) {
        DbDataSource dataSource = this.getDataSource();
        String queryText = this.getQueryText();
        Document document = null;
        if (dataSource != null && queryText != null) {
            SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect((DbElement)dataSource);
            SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)this.getProject());
            DasNamespace nsp = DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect((DbElement)dataSource), (DasObject)this.getDatabaseTable());
            PsiCodeFragment filterFragment = psiFacade.createExpressionFragment((Language)sqlDialect, dataSource, ContainerUtil.createMaybeSingletonList((Object)nsp), initialText, queryText);
            document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument((PsiFile)filterFragment);
        }
        Document document2 = document != null ? document : ((EditorFactory)ObjectUtils.assertNotNull((Object)EditorFactory.getInstance())).createDocument((CharSequence)"");
        if (document2 == null) {
            DatabaseTableGridDataHookUp.$$$reportNull$$$0(6);
        }
        return document2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilterDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DatabaseTableLoader
    extends DatabaseGridDataHookUp.DatabaseLoader {
        private DatabaseTableLoader() {
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns2, int firstRowNum) {
            if (context == null) {
                DatabaseTableLoader.$$$reportNull$$$0(0);
            }
            boolean columnsChanged = !this.sameColumnsAsInModel(columns2);
            super.setColumns(context, resultSetIndex, columns2, firstRowNum);
            if (columnsChanged) {
                DatabaseTableGridDataHookUp.this.updateFilterDocument();
            }
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(1);
            }
            this.invalidateQuery();
            super.loadFirstPage(source);
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(2);
            }
            this.invalidateQuery();
            super.loadLastPage(source);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(3);
            }
            this.invalidateQuery();
            super.loadNextPage(source);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(4);
            }
            this.invalidateQuery();
            super.loadPreviousPage(source);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(5);
            }
            this.invalidateQuery();
            super.updateTotalRowCount(source);
        }

        @Override
        public void load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int startIndex) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(6);
            }
            this.invalidateQuery();
            super.load(source, startIndex);
        }

        @Override
        public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DatabaseTableLoader.$$$reportNull$$$0(7);
            }
            if (!DatabaseTableGridDataHookUp.this.myFilteringModel.isFilteringEnabled()) {
                DatabaseTableGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.invalidateQuery();
            this.invalidateRowCount();
            this.loadFirstPage(source);
        }

        @Override
        protected void appendOrderByClause(@NotNull DdlBuilder builder) {
            if (builder == null) {
                DatabaseTableLoader.$$$reportNull$$$0(8);
            }
            List ordering = DatabaseTableGridDataHookUp.this.mySortingModel.getOrdering();
            boolean orderByAdded = false;
            for (RowSortOrder order : ordering) {
                String sortOrderKeyword;
                DataConsumer.Column column = (DataConsumer.Column)DatabaseTableGridDataHookUp.this.myModel.getColumn(order.getColumn());
                String string = order.getOrder() == RowSortOrder.Type.DESC ? "DESC" : (sortOrderKeyword = order.getOrder() == RowSortOrder.Type.ASC ? "ASC" : null);
                if (column == null || StringUtil.isEmpty((String)sortOrderKeyword)) continue;
                if (!orderByAdded) {
                    builder.space().keywords("ORDER", "BY");
                    orderByAdded = true;
                } else {
                    builder.symbol(",");
                }
                builder.space().columnRef(column.name).space().keyword(sortOrderKeyword);
            }
        }

        @Override
        protected void appendWhereClause(@Nullable String alias, @NotNull DdlBuilder builder) {
            String filterText;
            if (builder == null) {
                DatabaseTableLoader.$$$reportNull$$$0(9);
            }
            boolean append = DatabaseTableGridDataHookUp.this.myFilteringModel.isFilteringEnabled() && DatabaseTableGridDataHookUp.this.myFilteringModel.isFilterApplied();
            String string = filterText = append ? DatabaseTableGridDataHookUp.this.myFilteringModel.getFilterText() : "";
            if (StringUtil.isNotEmpty((String)filterText)) {
                builder.space().keyword("WHERE").space().plain(filterText);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadFirstPage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadLastPage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadNextPage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadPreviousPage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateTotalRowCount";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilter";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendOrderByClause";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendWhereClause";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

