/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.util.SystemProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSettings {
    private static final String IMPORT_MODALITY = "import_modality_state";
    private static final String ERROR_DIRECTORY = "import_error_directory";
    private static final String WRITE_ERRORS = "import_write_errors";
    private static final String INSERT_AS_NULL = "insert_as_null";

    public static void store(@NotNull ImportInfo info, @NotNull DatabaseDialect dialect, @Nullable String version) {
        String path;
        boolean hasPath;
        if (info == null) {
            ImportSettings.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            ImportSettings.$$$reportNull$$$0(1);
        }
        PropertiesComponent props = PropertiesComponent.getInstance();
        ImportType type = info.getType();
        ImportManager manager = ImportManager.of(dialect, version);
        if (type.isTableCreated() && manager.isSupportFastMode()) {
            props.setValue(IMPORT_MODALITY, String.valueOf(info.shouldLockTable()));
        }
        boolean bl = hasPath = (path = info.getErrorTaskInfo().getErrorRecordsPath()) != null;
        if (hasPath) {
            props.setValue(ERROR_DIRECTORY, ImportSettings.getErrorDirectory(path));
        }
        props.setValue(WRITE_ERRORS, hasPath);
        props.setValue(INSERT_AS_NULL, info.isInsertAsNull());
    }

    @NotNull
    private static String getErrorDirectory(@NotNull String errorPath) {
        Path path;
        if (errorPath == null) {
            ImportSettings.$$$reportNull$$$0(2);
        }
        Path dir = Files.isDirectory(path = Paths.get(errorPath, new String[0]), new LinkOption[0]) ? path : path.getParent();
        String string = dir == null ? SystemProperties.getUserHome() : dir.toAbsolutePath().toString();
        if (string == null) {
            ImportSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean getImportModality() {
        return ImportSettings.get(IMPORT_MODALITY);
    }

    public static boolean getWriteErrors() {
        return ImportSettings.get(WRITE_ERRORS);
    }

    public static boolean getInsertAsNull() {
        return ImportSettings.get(INSERT_AS_NULL);
    }

    @Nullable
    public static String getErrorDirectory() {
        return PropertiesComponent.getInstance().getValue(ERROR_DIRECTORY);
    }

    private static boolean get(@NotNull String key) {
        if (key == null) {
            ImportSettings.$$$reportNull$$$0(4);
        }
        return Boolean.valueOf(PropertiesComponent.getInstance().getValue(key));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDirectory";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

