/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.util.DbImplUtil;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DbDiagramElementManager
extends AbstractDiagramElementManager<DbElement> {
    public DbElement findInDataContext(DataContext context) {
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        return element instanceof DbElement ? (DbElement)element : null;
    }

    @NotNull
    public Collection<DbElement> findElementsInDataContext(DataContext context) {
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (elements == null || elements.length == 0) {
            List<DbElement> list = Collections.emptyList();
            if (list == null) {
                DbDiagramElementManager.$$$reportNull$$$0(0);
            }
            return list;
        }
        HashSet<DbElement> result2 = new HashSet<DbElement>();
        for (PsiElement element : elements) {
            if (!this.isAcceptableAsNode(element)) continue;
            result2.add((DbElement)element);
        }
        HashSet<DbElement> hashSet = result2;
        if (hashSet == null) {
            DbDiagramElementManager.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public boolean isAcceptableAsNode(Object element) {
        return DbDiagramElementManager.isAcceptedAsNodeImpl(element);
    }

    public static boolean isAcceptedAsNodeImpl(Object element) {
        return element instanceof DbTable && DbImplUtil.isDataTable((DasTable)((DbTable)element)) || element instanceof DasNamespace || element instanceof DbDataSource;
    }

    public Object[] getNodeItems(DbElement parent) {
        if (!parent.isValid()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        List result2 = ContainerUtil.newSmartList();
        for (DbElement element : parent.getDbChildren(DbElement.class, ObjectKind.NONE)) {
            if (element instanceof DbTableKey) continue;
            result2.add(element);
        }
        return ArrayUtil.toObjectArray((Collection)result2);
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        return element instanceof DbElement ? ((DbElement)element).getIcon() : super.getItemIcon(element, presentation);
    }

    public boolean canCollapse(DbElement element) {
        return false;
    }

    public boolean isContainerFor(DbElement parent, DbElement child) {
        return child.getParent() == parent;
    }

    public String getElementTitle(DbElement element) {
        return element.getName();
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof DbElement) {
            return new SimpleColoredText(((DbElement)element).getName(), DEFAULT_TITLE_ATTR);
        }
        return null;
    }

    public SimpleColoredText getItemType(Object element) {
        if (element instanceof DbColumn) {
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
            String typeName = dialect.getTypeName(((DbColumn)element).getDataType());
            return new SimpleColoredText(StringUtil.toLowerCase((String)typeName), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        return null;
    }

    public String getNodeTooltip(DbElement element) {
        return element.isValid() ? element.getTypeName() + " " + element.getName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diagram/DbDiagramElementManager", "findElementsInDataContext"));
    }
}

