/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.AbstractDb2Dialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.db2.Db2DdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2Dialect
extends AbstractDb2Dialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).build();
    public static final Db2Dialect INSTANCE = new Db2Dialect();
    private String myExplainPlanQuery;

    public Db2Dialect() {
        super(META_MODEL, new TypeHelper.DB2TypeHelper(), new KeywordHelper.Db2Keywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.DB2;
        if (databaseFamilyId == null) {
            Db2Dialect.$$$reportNull$$$0(0);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.DB2;
        if (icon == null) {
            Db2Dialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("DB2" == null) {
            Db2Dialect.$$$reportNull$$$0(2);
        }
        return "DB2";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            Db2Dialect.$$$reportNull$$$0(3);
        }
        return databaseProductName != null && databaseProductName.trim().startsWith("DB2");
    }

    @NotNull
    private static String sysCat(@NotNull DasObject element) {
        if (element == null) {
            Db2Dialect.$$$reportNull$$$0(4);
        }
        LocalDataSource localDataSource = element instanceof DbElement ? DbImplUtil.getLocalDataSource((DatabaseSystem)((DbElement)element).getDataSource()) : null;
        String url = localDataSource == null ? null : localDataSource.getUrl();
        boolean as400 = url != null && url.contains(":as400:");
        String string = as400 ? "SYSIBM" : "SYSCAT";
        if (string == null) {
            Db2Dialect.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) throws UnsupportedOperationException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(6);
        }
        if (column == null) {
            Db2Dialect.$$$reportNull$$$0(7);
        }
        if (attrs == null) {
            Db2Dialect.$$$reportNull$$$0(8);
        }
        boolean autoInc = DasUtil.isAutoGenerated((DasColumn)column);
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keywords("ADD", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        if (autoInc) {
            builder.type("INTEGER");
        } else {
            builder.type((DasTypedObject)column);
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, (autoInc ? "NOT NULL " : "") + "WITH DEFAULT", autoInc ? "0" : column.getDefault());
        builder.newStatement();
        if (autoInc) {
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keywords("ALTER", "COLUMN").space().columnRef((DasObject)column).space().keywords("DROP", "DEFAULT").newStatement();
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keywords("ALTER", "COLUMN").space().columnRef((DasObject)column).space().keywords("SET");
            this.generated(builder).newStatement();
        }
        if (column.isNotNull() && !autoInc) {
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keywords("ADD", "CONSTRAINT").space();
            builder.columnRef((DasObject)column).space();
            builder.keyword("CHECK").space().symbol("(");
            builder.columnRef((DasObject)column).space();
            builder.keyword("IS NOT NULL").symbol(")");
            builder.newStatement();
        }
        if (StringUtil.isNotEmpty((String)column.getComment())) {
            this.sqlAlterColumnComment(builder, column);
            builder.newStatement();
        }
        Db2Dialect.reorgTable(builder, column.getTable());
        if (autoInc) {
            builder.keyword("UPDATE").space();
            builder.qualifiedRef((DasObject)column.getTable()).space();
            builder.keyword("SET").space();
            builder.columnRef((DasObject)column).space().plain("=").space().keyword("DEFAULT").newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    @Override
    public boolean supportsRenameDatabase() {
        return false;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            Db2Dialect.$$$reportNull$$$0(10);
        }
        if (connection == null) {
            Db2Dialect.$$$reportNull$$$0(11);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection, this, "values (current_schema)", 1, DbImplUtil.ConcatenationProps.LINES))) ? null : SearchPath.of(new ObjectPath(ObjectKind.SCHEMA, Collections.singletonList(s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            Db2Dialect.$$$reportNull$$$0(12);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", current.getName());
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            Db2Dialect.$$$reportNull$$$0(13);
        }
        return kind == ObjectKind.PACKAGE ? "MODULE" : super.getNameForKind(kind);
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(14);
        }
        if (pk == null) {
            Db2Dialect.$$$reportNull$$$0(15);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(17);
        }
        super.sqlDefineColumn(builder, column, singlePk);
        DdlBuilder ddlBuilder = DasUtil.isAutoGenerated((DasColumn)column) ? this.generated(builder) : builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(18);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace namespace) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(19);
        }
        if (namespace == null) {
            Db2Dialect.$$$reportNull$$$0(20);
        }
        DdlBuilder ddlBuilder = super.sqlDropSchema(builder, namespace).space().keyword("RESTRICT");
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder generated(@NotNull DdlBuilder builder) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(22);
        }
        DdlBuilder ddlBuilder = builder.space().keywords("GENERATED", "ALWAYS", "AS", "IDENTITY").plain("(").keywords("START", "WITH").space().literal("1").space().keywords("INCREMENT", "BY").space().literal("1").plain(")");
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new Db2DdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            Db2Dialect.$$$reportNull$$$0(24);
        }
        return ddlOperations;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(25);
        }
        if (column == null) {
            Db2Dialect.$$$reportNull$$$0(26);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(28);
        }
        if (column == null) {
            Db2Dialect.$$$reportNull$$$0(29);
        }
        Db2Dialect.getColumnNullableAlterSQL(builder, column, !column.isNotNull());
        builder.newStatement();
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, column.getTable());
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    private static DdlBuilder reorgTable(DdlBuilder builder, DasTable table) {
        builder.keyword("CALL SYSPROC").symbol(".").keyword("ADMIN_CMD").symbol("(");
        String stmt = builder.copied().plain("REORG TABLE ").qualifiedRef((DasObject)table).getStatement();
        builder.literal(DbSqlUtil.getSqlDialect(INSTANCE).asStringLiteral(stmt)).symbol(")");
        builder.newStatement();
        return builder;
    }

    @NotNull
    private static DdlBuilder getColumnNullableAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean nullable) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(31);
        }
        if (column == null) {
            Db2Dialect.$$$reportNull$$$0(32);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keyword("ALTER COLUMN").space();
        builder.columnRef((DasObject)column).space();
        if (nullable) {
            builder.keywords("DROP", "NOT", "NULL");
        } else {
            builder.keywords("SET", "NOT", "NULL");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(33);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(34);
        }
        if (from == null) {
            Db2Dialect.$$$reportNull$$$0(35);
        }
        if (to == null) {
            Db2Dialect.$$$reportNull$$$0(36);
        }
        super.sqlAlterColumnType(builder, from, to);
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, from.getTable());
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(38);
        }
        if (column == null) {
            Db2Dialect.$$$reportNull$$$0(39);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, column);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(40);
        }
        return ddlBuilder;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(41);
        }
        if (column == null) {
            Db2Dialect.$$$reportNull$$$0(42);
        }
        String tableName = column.getTable().getName();
        String columnName = column.getName();
        String sequenceName = tableName.toUpperCase(Locale.ENGLISH) + "_" + columnName.toUpperCase(Locale.ENGLISH) + "_SEQ";
        DdlBuilder ddlBuilder = this.sqlAddColumnAutoIncrement(builder, column, sequenceName);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(44);
        }
        if (table == null) {
            Db2Dialect.$$$reportNull$$$0(45);
        }
        if (constraintName == null) {
            Db2Dialect.$$$reportNull$$$0(46);
        }
        if (columns2 == null) {
            Db2Dialect.$$$reportNull$$$0(47);
        }
        for (DasColumn column : columns2) {
            if (column.isNotNull()) continue;
            Db2Dialect.getColumnNullableAlterSQL(builder, column, false).newStatement();
            Db2Dialect.reorgTable(builder, table);
        }
        DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        builder.newStatement();
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, table);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(48);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(49);
        }
        if (sequence == null) {
            Db2Dialect.$$$reportNull$$$0(50);
        }
        if (increment == null) {
            Db2Dialect.$$$reportNull$$$0(51);
        }
        if (minimum == null) {
            Db2Dialect.$$$reportNull$$$0(52);
        }
        if (maximum == null) {
            Db2Dialect.$$$reportNull$$$0(53);
        }
        if (restart == null) {
            Db2Dialect.$$$reportNull$$$0(54);
        }
        if (cache == null) {
            Db2Dialect.$$$reportNull$$$0(55);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAlterSequenceSQL(builder, sequence, increment, minimum, maximum, restart, cache, cycle ? "CYCLE" : "NO CYCLE");
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(57);
        }
        if (sequence == null) {
            Db2Dialect.$$$reportNull$$$0(58);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, false);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(59);
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            Db2Dialect.$$$reportNull$$$0(60);
        }
        return Pair.create((Object)("SELECT TEXT FROM " + Db2Dialect.sysCat(element) + ".VIEWS WHERE VIEWSCHEMA = '" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(VIEWNAME) = '" + element.getName().toUpperCase(Locale.ENGLISH) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            Db2Dialect.$$$reportNull$$$0(61);
        }
        StringBuilder createViewSql = new StringBuilder();
        DasRoutine.Kind type = element.getRoutineKind();
        createViewSql.append("SELECT TEXT FROM ").append(Db2Dialect.sysCat((DasObject)element)).append(".ROUTINES").append(" WHERE ROUTINESCHEMA='");
        createViewSql.append(DasUtil.getSchema((DasObject)element));
        createViewSql.append("' AND UPPER(ROUTINENAME) = '");
        createViewSql.append(element.getName().toUpperCase(Locale.ENGLISH));
        createViewSql.append("' AND ROUTINETYPE = '");
        createViewSql.append(type == DasRoutine.Kind.FUNCTION ? "F" : "P");
        createViewSql.append("'");
        Pair pair = Pair.create((Object)createViewSql.toString(), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            Db2Dialect.$$$reportNull$$$0(62);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(63);
        }
        if (sequence == null) {
            Db2Dialect.$$$reportNull$$$0(64);
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(this);
        String schema = DasUtil.getSchema((DasObject)sequence);
        builder.keyword("SELECT").space();
        boolean first = true;
        for (String part : new String[]{"NEXTCACHEFIRSTVALUE", "MAXVALUE", "MINVALUE", "CACHE", "INCREMENT", "CYCLE"}) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.ref(null, part);
        }
        builder.space();
        builder.keyword("FROM").space().ref(null, Db2Dialect.sysCat((DasObject)sequence) + ".SEQUENCES").space();
        builder.keyword("WHERE").space();
        if (StringUtil.isNotEmpty((String)schema)) {
            builder.ref(null, "SEQSCHEMA").space().symbol("=").space().plain("upper").symbol("(").literal(language.asStringLiteral(schema)).symbol(")").space().keyword("AND").space();
        }
        String seq = builder.copied().ref((DasObject)sequence, sequence.getName()).getStatement();
        builder.ref(null, "SEQNAME").symbol("=").space().literal(language.asStringLiteral(seq));
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(65);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return true;
    }

    @Override
    public boolean supportsCreateDatabase() {
        return true;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        int token;
        if (table == null) {
            Db2Dialect.$$$reportNull$$$0(66);
        }
        if (connection == null) {
            Db2Dialect.$$$reportNull$$$0(67);
        }
        CallableStatement statement = connection.prepareCall("CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)");
        try {
            statement.setString(1, QNameUtil.getQualifiedName((DasObject)table));
            statement.registerOutParameter(2, 4);
            statement.executeUpdate();
            token = statement.getInt(2);
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
        String string = DbImplUtil.concatStringResults(connection, this, "SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = " + token, 1, DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (string == null) {
            Db2Dialect.$$$reportNull$$$0(68);
        }
        return string;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            Db2Dialect.$$$reportNull$$$0(69);
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    private void ensureScriptLoaded() {
        if (this.myExplainPlanQuery == null) {
            try {
                URL resource = Db2Dialect.class.getClassLoader().getResource("resources/db2.explain_last.sql");
                if (resource != null) {
                    this.myExplainPlanQuery = FileUtil.loadFile((File)new File(resource.toURI()));
                    return;
                }
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.myExplainPlanQuery = "";
        }
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(70);
        }
        if (statement == null) {
            Db2Dialect.$$$reportNull$$$0(71);
        }
        this.ensureScriptLoaded();
        if (this.myExplainPlanQuery.isEmpty()) {
            throw new UnsupportedOperationException("explain_last script not found");
        }
        builder.keywords("explain", "plan").space().keyword("for").space().plain(statement).newStatement().plain(this.myExplainPlanQuery);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(72);
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DatabaseSystem system) {
        String version = system == null ? null : system.getDatabaseProductVersion();
        DatabaseDialectEx.VersionParser parser = this.getVersionParser();
        Version parsed = version == null || parser == null ? null : parser.parseVersion(version);
        return parsed == null || parsed.major > 9 || parsed.major == 9 && parsed.minor > 4;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(73);
        }
        String ridCall = String.format("RID(%s) as \"RID(%s)\"", "t", "t");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal(ridCall);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(74);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return MyVersionParser.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/Db2Dialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 4: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 49: 
            case 57: 
            case 63: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 26: 
            case 29: 
            case 32: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 11: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 45: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 50: 
            case 58: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/Db2Dialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sysCat";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSchema";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generated";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnNullable";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNullableAlterSQL";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnType";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefault";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterSequence";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceInformation";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sysCat";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSchema";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generated";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnNullable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNullableAlterSQL";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVersionParser
    implements DatabaseDialectEx.VersionParser {
        private static final DatabaseDialectEx.VersionParser INSTANCE = new MyVersionParser();

        private MyVersionParser() {
        }

        @Override
        @Nullable
        public Version parseVersion(@NotNull String version) {
            if (version == null) {
                MyVersionParser.$$$reportNull$$$0(0);
            }
            return StringUtil.startsWith((CharSequence)version, (CharSequence)"SQL") ? MyVersionParser.parseInternal(StringUtil.replace((String)version, (String)"SQL", (String)"")) : null;
        }

        @Nullable
        private static Version parseInternal(@NotNull String version) {
            if (version == null) {
                MyVersionParser.$$$reportNull$$$0(1);
            }
            if (version.length() != 5) {
                return null;
            }
            Integer major = MyVersionParser.parseInt(version, 0);
            Integer minor = MyVersionParser.parseInt(version, 2);
            Integer bugfix = MyVersionParser.parseInt(version, 4);
            return major == null || minor == null || bugfix == null ? null : new Version(major.intValue(), minor.intValue(), bugfix.intValue());
        }

        @Nullable
        private static Integer parseInt(@NotNull String s, int begin) {
            if (s == null) {
                MyVersionParser.$$$reportNull$$$0(2);
            }
            try {
                return Integer.parseInt(s.substring(begin, Math.min(s.length(), begin + 2)));
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/Db2Dialect$MyVersionParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseVersion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseInternal";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseInt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

