/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.introspection.GenericIntrospector;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.postgres.PostgresModRoutine;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vendors.postgres.PostgresDialectHelper;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class GenericSourceLoader
implements GenericIntrospector.SourceLoader {
    private static final Logger LOG = Logger.getInstance(GenericSourceLoader.class);
    private final DatabaseDialectEx myDialect;

    public GenericSourceLoader(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            GenericSourceLoader.$$$reportNull$$$0(0);
        }
        this.myDialect = dialect;
    }

    @Override
    public void loadSources(@NotNull Iterable<BasicModSourceAware> objects, @NotNull Connection jdbcConnection) {
        if (objects == null) {
            GenericSourceLoader.$$$reportNull$$$0(1);
        }
        if (jdbcConnection == null) {
            GenericSourceLoader.$$$reportNull$$$0(2);
        }
        Exception first = null;
        Exception last = null;
        int count = 0;
        DatabaseConnection connection = DatabaseConnection.wrap(jdbcConnection);
        for (BasicModSourceAware object : objects) {
            try {
                this.loadSource(object, connection);
            }
            catch (Exception e) {
                object.setSourceText(null);
                if (first == null) {
                    first = e;
                } else {
                    last = e;
                }
                ++count;
            }
        }
        if (count != 0) {
            LOG.warn("Failed to load: " + count + " sources.\nFirst exception:\n" + ExceptionUtil.getUserStackTrace((Throwable)first, (Logger)LOG) + (last == null ? null : "Last exception:\n" + ExceptionUtil.getUserStackTrace((Throwable)last, (Logger)LOG)));
        }
    }

    public void loadSource(@NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection) throws Exception {
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            GenericSourceLoader.$$$reportNull$$$0(4);
        }
        ObjectKind k = object.getKind();
        ObjectKind p = DasUtil.getKind((DasObject)object.getDbParent());
        boolean wasSet = false;
        if (p == ObjectKind.PACKAGE && k == ObjectKind.BODY) {
            wasSet = this.loadPackage(object, connection, true);
        } else if (k == ObjectKind.PACKAGE) {
            wasSet = this.loadPackage(object, connection, false);
        } else if ((p == ObjectKind.SCHEMA || this.myDialect.getFamilyId().isSybase() && p == ObjectKind.PACKAGE) && k == ObjectKind.ROUTINE) {
            wasSet = this.loadRoutine(object, connection);
        } else if (p == ObjectKind.SCHEMA && k == ObjectKind.VIEW) {
            wasSet = this.loadView(object, connection);
        }
        if (!wasSet) {
            object.setSourceText(null);
        }
    }

    private boolean loadView(@NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection) throws SQLException {
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(5);
        }
        if (connection == null) {
            GenericSourceLoader.$$$reportNull$$$0(6);
        }
        if (!this.myDialect.supportsViewDefinition() || !(object instanceof DasTable)) {
            return false;
        }
        DatabaseFamilyId familyId = this.myDialect.getFamilyId();
        Pair<String, DbImplUtil.ConcatenationProps> query = this.myDialect.sqlViewDefinition(object);
        StringBuilder res = new StringBuilder();
        DbImplUtil.concatStringResults(connection, this.myDialect, 0, (String)query.first, res, (DbImplUtil.ConcatenationProps)query.second);
        if (res.length() == 0) {
            return false;
        }
        if (familyId.isPostgres() || familyId.isHsqldb()) {
            DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(false);
            String fullDefinition = this.myDialect.sqlCreateView(builder, (DasTable)object, res.toString(), "").getStatement();
            res.replace(0, res.length(), fullDefinition);
        }
        if (familyId.isSybase()) {
            res.append("\nGO");
        }
        GenericSourceLoader.applySourceText(object, res, familyId.isMysql() || familyId.isH2() || familyId.isHsqldb());
        return true;
    }

    private boolean loadRoutine(@NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection) throws Exception {
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(7);
        }
        if (connection == null) {
            GenericSourceLoader.$$$reportNull$$$0(8);
        }
        if (!this.myDialect.supportsProcedureDefinition() || !(object instanceof DasRoutine)) {
            return false;
        }
        DatabaseFamilyId familyId = this.myDialect.getFamilyId();
        if (familyId.isMysql()) {
            String src = DbImplUtil.concatStringResults(connection, this.myDialect, "select routine_definition from information_schema.routines where routine_name = " + PostgresDialectHelper.str(object.getName()) + "   and routine_schema = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)object)), 0, DbImplUtil.ConcatenationProps.NO_CONCAT);
            if (StringUtil.isEmpty((String)src)) {
                return false;
            }
            GenericSourceLoader.applySourceText(object, src, false);
            return true;
        }
        if (familyId.isPostgres() && object instanceof PostgresModRoutine) {
            DatabaseMetaData md = connection.getMetaData();
            Version curVersion = new Version(md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion(), 0);
            boolean hasUseful = curVersion.isOrGreaterThan(Integer.valueOf(8), Integer.valueOf(4));
            boolean isPre81 = !curVersion.isOrGreaterThan(Integer.valueOf(8), Integer.valueOf(1));
            PostgresModRoutine routine2 = (PostgresModRoutine)object;
            int limit = Math.max(10, routine2.getArguments().size()) + 5;
            Boolean res = (Boolean)DbImplUtil.executeAndGetResult(connection, "select " + (hasUseful ? "       pg_catalog.pg_get_function_arguments(pg_proc.oid) as arguments_def,\n       pg_catalog.pg_get_function_result(pg_proc.oid) as result_def,\n" : "       " + PostgresDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ", " + PostgresDialectHelper.select(limit, isPre81) + "       pronargs,\n       proretset,\n") + "       prosrc,\n       lanname\nfrom pg_proc join pg_namespace nsp on nsp.oid = pronamespace left join pg_language l on l.oid = prolang\n" + (hasUseful ? "" : PostgresDialectHelper.joinType("tr", "prorettype", isPre81) + " " + PostgresDialectHelper.join(limit, isPre81) + "\n") + "where proname = " + PostgresDialectHelper.str(object.getName()) + " and nsp.nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)object)) + "\n", rs -> {
                if (!rs.next()) {
                    return false;
                }
                if (hasUseful) {
                    routine2.setArgumentsDefinition(StringUtil.nullize((String)rs.getString("arguments_def")));
                    routine2.setResultsDefinition(StringUtil.nullize((String)rs.getString("result_def")));
                } else {
                    PostgresDialectHelper.SignatureBuilder sigBuilder = new PostgresDialectHelper.SignatureBuilder(isPre81, (ResultSet)rs);
                    DdlBuilder builder = new DdlBuilder().withDialect(PostgresDialect.INSTANCE);
                    routine2.setArgumentsDefinition(StringUtil.nullize((String)sigBuilder.buildArguments(builder).getStatement()));
                    builder.clear();
                    routine2.setResultsDefinition(StringUtil.nullize((String)sigBuilder.buildReturn(builder).getStatement()));
                }
                routine2.setSourceText(new SimpleCompositeText(rs.getString("prosrc"), CompositeText.Kind.ORIGINAL_TEXT));
                routine2.setLanguageName(StringUtil.nullize((String)rs.getString("lanname")));
                return true;
            });
            return res == Boolean.TRUE;
        }
        String source = this.myDialect.tryToLoadProcedureDefinition((DasRoutine)object, connection);
        if (StringUtil.isNotEmpty((String)source)) {
            GenericSourceLoader.applySourceText(object, source, familyId.isHsqldb());
            return true;
        }
        Pair<String, DbImplUtil.ConcatenationProps> query = this.myDialect.sqlProcedureDefinition((DasRoutine)object);
        StringBuilder res = new StringBuilder();
        if (familyId.isOracle() || familyId.isExasol()) {
            res.append("CREATE ");
        }
        int length = res.length();
        if ((res = DbImplUtil.concatStringResults(connection, this.myDialect, (String)query.first, 0, res, (DbImplUtil.ConcatenationProps)query.second)).length() == length) {
            return false;
        }
        if (familyId.isTransactSql()) {
            res.append("\nGO");
        } else if (!res.toString().trim().endsWith(";")) {
            res.append(";");
        }
        GenericSourceLoader.applySourceText(object, res, familyId.isHsqldb());
        return true;
    }

    private boolean loadPackage(@NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection, boolean body) throws SQLException {
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(9);
        }
        if (connection == null) {
            GenericSourceLoader.$$$reportNull$$$0(10);
        }
        if (this.myDialect.supportsPackageDefinition()) {
            return false;
        }
        Pair<String, DbImplUtil.ConcatenationProps> query = body ? this.myDialect.sqlPackageBodyDefinition(object) : this.myDialect.sqlPackageDefinition(object);
        StringBuilder res = new StringBuilder("CREATE ");
        int length = res.length();
        if (length == (res = DbImplUtil.concatStringResults(connection, this.myDialect, (String)query.first, 0, res, (DbImplUtil.ConcatenationProps)query.second)).length()) {
            return false;
        }
        GenericSourceLoader.applySourceText(object, res, false);
        return true;
    }

    private static void applySourceText(@NotNull BasicModSourceAware object, CharSequence text, boolean format) {
        if (object == null) {
            GenericSourceLoader.$$$reportNull$$$0(11);
        }
        if (text != null && text.length() > 0) {
            SimpleCompositeText ct = new SimpleCompositeText(text, format ? CompositeText.Kind.DECOMPILED_TEXT : CompositeText.Kind.ORIGINAL_TEXT);
            object.setSourceText(ct);
        } else {
            object.setSourceText(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcConnection";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/GenericSourceLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSources";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadView";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "loadRoutine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPackage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "applySourceText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Provider
    implements GenericIntrospector.SourceLoaderProvider {
        @Override
        @Nullable
        public GenericIntrospector.SourceLoader create(@NotNull DBFacade myFacade) {
            Rdbms rdbms;
            if (myFacade == null) {
                Provider.$$$reportNull$$$0(0);
            }
            if ((rdbms = myFacade.rdbms()) == UnknownDatabase.RDBMS) {
                return null;
            }
            DatabaseFamilyId family = GenericIntrospectorLegacyModelUtils.findFamily(rdbms);
            if (family == null || family == DatabaseFamilyId.UNKNOWN) {
                return null;
            }
            for (DatabaseDialectEx dialect : DatabaseDialects.getSupportedDialects()) {
                if (dialect.getFamilyId() != family || dialect == GenericDialect.INSTANCE) continue;
                return new GenericSourceLoader(dialect);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFacade", "com/intellij/database/dialects/GenericSourceLoader$Provider", "create"));
        }
    }
}

