/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractTransactSqlDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.sybase.SybaseDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDialect
extends AbstractTransactSqlDialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.PACKAGE).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.VIEW, ObjectKind.INDEX).put(ObjectKind.VIEW, ObjectKind.TRIGGER).put(ObjectKind.PACKAGE, ObjectKind.ROUTINE).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).build();
    public static final SybaseDialect INSTANCE = new SybaseDialect();

    public SybaseDialect() {
        super(META_MODEL, new TypeHelper.SybaseTypeHelper(), new KeywordHelper.SybaseKeywords(), Casing.create((Case)Case.EXACT, (Case)Case.EXACT));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.SYBASE;
        if (databaseFamilyId == null) {
            SybaseDialect.$$$reportNull$$$0(0);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Sybase;
        if (icon == null) {
            SybaseDialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Sybase" == null) {
            SybaseDialect.$$$reportNull$$$0(2);
        }
        return "Sybase";
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            SybaseDialect.$$$reportNull$$$0(3);
        }
        return kind == ObjectKind.PACKAGE ? "PROCEDURE GROUP" : (kind == ObjectKind.ROUTINE ? "FUNCTION" : super.getNameForKind(kind));
    }

    @Override
    @NotNull
    public String getLengthFunction() {
        if ("datalength" == null) {
            SybaseDialect.$$$reportNull$$$0(4);
        }
        return "datalength";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            SybaseDialect.$$$reportNull$$$0(5);
        }
        if (databaseProductName == null) {
            return false;
        }
        String lname = databaseProductName.trim().toLowerCase(Locale.ENGLISH);
        return lname.startsWith("sybase") || lname.startsWith("adaptive");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(6);
        }
        if (column == null) {
            SybaseDialect.$$$reportNull$$$0(7);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database, @NotNull String name) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(9);
        }
        if (database == null) {
            SybaseDialect.$$$reportNull$$$0(10);
        }
        if (name == null) {
            SybaseDialect.$$$reportNull$$$0(11);
        }
        if (!this.supportsRenameDatabase()) {
            throw new UnsupportedOperationException("Rename database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keyword("USE").space().ref(null, "master").newStatement().keyword("EXEC").space().ref(null, "sp_dboption").space().identifier((DasObject)database, database.getName()).symbol(",").space().literal("single").symbol(",").space().literal("true").newStatement().keyword("USE").space().identifier((DasObject)database, database.getName()).newStatement().keyword("EXEC").space().ref(null, "sp_renamedb").space().identifier((DasObject)database, database.getName()).symbol(",").space().identifier((DasObject)database, name).newStatement().keyword("USE").space().ref(null, "master").newStatement().keyword("EXEC").space().ref(null, "sp_dboption").space().identifier((DasObject)database, name).symbol(",").space().literal("single").symbol(",").space().literal("false").newStatement().keyword("USE").space().identifier((DasObject)database, name).newStatement();
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(12);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(13);
        }
        if (table == null) {
            SybaseDialect.$$$reportNull$$$0(14);
        }
        if (model == null) {
            SybaseDialect.$$$reportNull$$$0(15);
        }
        if (cascadeConstraints) {
            for (DasConstraint keyInfo : model.getExportedKeys(table)) {
                builder.keywords("ALTER", "TABLE").space();
                builder.qualifiedRef((DasObject)keyInfo.getTable());
                builder.keywords("DROP", "CONSTRAINT").space();
                builder.constraintRef((DasObject)keyInfo, keyInfo.getName());
                builder.newStatement();
            }
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new SybaseDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            SybaseDialect.$$$reportNull$$$0(17);
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(18);
        }
        if (pk == null) {
            SybaseDialect.$$$reportNull$$$0(19);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnTypeAndNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean typeChanged) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(21);
        }
        if (column == null) {
            SybaseDialect.$$$reportNull$$$0(22);
        }
        if (column.isNotNull() || !typeChanged) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnNullableAlterSQL(builder, column, "MODIFY", typeChanged);
            if (ddlBuilder == null) {
                SybaseDialect.$$$reportNull$$$0(23);
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnTypeAlterSQL(builder, "MODIFY", "", false, column);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(25);
        }
        if (column == null) {
            SybaseDialect.$$$reportNull$$$0(26);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(27);
        }
        if (column == null) {
            SybaseDialect.$$$reportNull$$$0(28);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(29);
        }
        builder.columnRef((DasObject)column);
        builder.space();
        builder.type((DasTypedObject)column);
        if (DasUtil.isAutoGenerated((DasColumn)column)) {
            builder.space().keyword("IDENTITY");
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        if (singlePk) {
            builder.space().keywords("PRIMARY", "KEY");
        }
        if (column.isNotNull()) {
            builder.space().keywords("NOT", "NULL");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropPackage() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPackage(@NotNull DdlBuilder builder, @NotNull DasSchemaChild pkg) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(31);
        }
        if (pkg == null) {
            SybaseDialect.$$$reportNull$$$0(32);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "PROCEDURE").space().qualifiedRef((DasObject)pkg);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(33);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(34);
        }
        if (table == null) {
            SybaseDialect.$$$reportNull$$$0(35);
        }
        if (indexName == null) {
            SybaseDialect.$$$reportNull$$$0(36);
        }
        builder.keywords("DROP", "INDEX").space();
        builder.qualifiedRef((DasObject)table).symbol(".").identifier((DasObject)index, indexName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(38);
        }
        if (sequence == null) {
            SybaseDialect.$$$reportNull$$$0(39);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropType(@NotNull DdlBuilder builder, @NotNull DasUserDefinedType type) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(40);
        }
        if (type == null) {
            SybaseDialect.$$$reportNull$$$0(41);
        }
        builder.keyword("EXEC").space().plain("sp_droptype").space().symbol("'");
        DdlBuilder.Marker mark = builder.mark();
        builder.qualifiedRef((DasObject)type);
        mark.replace(DbImplUtil.escapeStr(mark.extract()));
        mark.finish();
        DdlBuilder ddlBuilder = builder.symbol("'");
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(42);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(43);
        }
        if (connection == null) {
            SybaseDialect.$$$reportNull$$$0(44);
        }
        Map<String, Object> map2 = DbImplUtil.resultRowAsMap(connection, String.format("EXEC sp_spaceused '%s'", DbImplUtil.escapeStr(QNameUtil.getQualifiedName((DbElement)element))), "rowtotal", "rows");
        if (map2 == null) {
            SybaseDialect.$$$reportNull$$$0(45);
        }
        return map2;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(46);
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlPackageDefinition(element);
        if (pair == null) {
            SybaseDialect.$$$reportNull$$$0(47);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(48);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            SybaseDialect.$$$reportNull$$$0(49);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2) {
        DasObject parent;
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(50);
        }
        if (routine2 == null) {
            SybaseDialect.$$$reportNull$$$0(51);
        }
        boolean inPackage = (parent = routine2.getDbParent()) != null && parent.getKind() == ObjectKind.PACKAGE;
        DasRoutine.Kind kind = inPackage ? DasRoutine.Kind.PROCEDURE : routine2.getRoutineKind();
        String type = kind.name();
        builder.keyword("create").space();
        builder.keyword(type).space().qualifiedRef((DasObject)(inPackage ? parent : routine2));
        if (inPackage) {
            builder.plain(";");
            Object base = DbImplUtil.unwrap((DasObject)routine2);
            if (base instanceof DasPositioned) {
                builder.plain(String.valueOf(((DasPositioned)base).getPosition()));
            } else {
                builder.plain(routine2.getName());
            }
        }
        this.sqlDefinePrototype(builder, routine2, true, true);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(52);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(53);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            SybaseDialect.$$$reportNull$$$0(54);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        DasObject parent;
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(55);
        }
        ObjectKind pkind = (parent = element.getDbParent()) == null ? null : parent.getKind();
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)(pkind == ObjectKind.PACKAGE ? parent : element), this).replace("'", "''") + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            SybaseDialect.$$$reportNull$$$0(56);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            SybaseDialect.$$$reportNull$$$0(57);
        }
        if (qualifier == null) {
            SybaseDialect.$$$reportNull$$$0(58);
        }
        DdlBuilder ddlBuilder = builder.identifier(object, identifier);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(59);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(60);
        }
        if (statement == null) {
            SybaseDialect.$$$reportNull$$$0(61);
        }
        builder.keywords("set", "statement_cache", "off").newLine();
        builder.keywords("set", "showplan", "on").newLine();
        if (!analyze) {
            builder.keywords("set", "noexec", "on").newLine();
        }
        builder.keywords("go").newLine();
        builder.plain(statement).newLine();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(62);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(63);
        }
        if (!analyze) {
            builder.keywords("set", "noexec", "off").newLine();
        }
        builder.keywords("set", "showplan", "off").newLine();
        builder.keywords("set", "statement_cache", "on").newLine();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(64);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            SybaseDialect.$$$reportNull$$$0(65);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "EXEC sp_helpdb", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            SybaseDialect.$$$reportNull$$$0(66);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 65: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 65: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/SybaseDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: 
            case 40: 
            case 50: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 43: 
            case 46: 
            case 48: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 44: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/SybaseDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLengthFunction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameDatabase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnTypeAndNullable";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropPackage";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropType";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageBodyDefinition";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageDefinition";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineProcedure";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPostExplainPlan";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameDatabase";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnTypeAndNullable";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPackage";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropType";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineProcedure";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "sqlPostExplainPlan";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 65: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

