/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabasePluginId;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractorScripts {
    private static final String SCRIPT_DIR = "data/extractors";
    private static final Pattern FILE_PATTERN = Pattern.compile("(.+?)(?:\\.(\\w+))?\\.\\w+");

    private ExtractorScripts() {
    }

    @Nullable
    public static VirtualFile getScriptsDirectory() {
        try {
            return ExtractorScripts.getScriptDirectoryImpl(true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    public static List<VirtualFile> getScriptFiles() {
        List list;
        try {
            VirtualFile directory = ExtractorScripts.getScriptDirectoryImpl(false);
            Object[] scriptDirChildren = directory == null ? VirtualFile.EMPTY_ARRAY : directory.getChildren();
            Condition scriptFileFilter = Conditions.and((Condition)ExtensionsRootType.regularFileFilter(), virtualFile -> FILE_PATTERN.matcher(virtualFile.getName()).matches());
            list = ContainerUtil.filter((Object[])scriptDirChildren, (Condition)scriptFileFilter);
        }
        catch (IOException iOException) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ExtractorScripts.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if (list == null) {
            ExtractorScripts.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public static VirtualFile findScript(String name) {
        try {
            return ExtensionsRootType.getInstance().findResource(DatabasePluginId.get(), "data/extractors/" + name, false);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String getOutputFileExtension(@NotNull VirtualFile script) {
        if (script == null) {
            ExtractorScripts.$$$reportNull$$$0(2);
        }
        String string = ExtractorScripts.getNamePart(script, 2, "txt");
        if (string == null) {
            ExtractorScripts.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getNamePart(@NotNull VirtualFile file, int namePart, String def) {
        String string;
        if (file == null) {
            ExtractorScripts.$$$reportNull$$$0(4);
        }
        Matcher matcher = FILE_PATTERN.matcher(file.getNameSequence());
        try {
            string = matcher.matches() ? StringUtil.notNullize((String)matcher.group(namePart), (String)def) : def;
        }
        catch (Exception ignore) {
            String string2 = def;
            if (string2 == null) {
                ExtractorScripts.$$$reportNull$$$0(6);
            }
            return string2;
        }
        if (string == null) {
            ExtractorScripts.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static VirtualFile getScriptDirectoryImpl(boolean createIfMissing) throws IOException {
        return ExtensionsRootType.getInstance().findResourceDirectory(DatabasePluginId.get(), SCRIPT_DIR, createIfMissing);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ExtractorScripts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFiles";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ExtractorScripts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFileExtension";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePart";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFileExtension";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamePart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

