/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extractors.DataColumn;
import com.intellij.database.extractors.DataColumnImpl;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataRow;
import com.intellij.database.extractors.DataRowImpl;
import com.intellij.database.extractors.DataStream;
import com.intellij.database.extractors.ExtractorScriptBindings;
import com.intellij.database.extractors.ExtractorScripts;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ValueFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.ide.script.IdeScriptEngine;

public class ScriptDataExtractor
implements DataExtractor {
    private final Project myProject;
    private final VirtualFile myScriptFile;
    private final ObjectFormatter myObjectFormatter;
    private final DasTable myDatabaseTable;
    private final boolean myTransposed;

    public ScriptDataExtractor(@Nullable Project project, @NotNull VirtualFile scriptFile, @NotNull ObjectFormatter objectFormatter, @Nullable DasTable databaseTable, boolean transposed) {
        if (scriptFile == null) {
            ScriptDataExtractor.$$$reportNull$$$0(0);
        }
        if (objectFormatter == null) {
            ScriptDataExtractor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myScriptFile = scriptFile;
        this.myObjectFormatter = objectFormatter;
        this.myDatabaseTable = databaseTable;
        this.myTransposed = transposed;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        String string = ExtractorScripts.getOutputFileExtension(this.myScriptFile);
        if (string == null) {
            ScriptDataExtractor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        ExtractionDataConveyor conveyor = new ExtractionDataConveyor();
        ExtractionDataConveyor.DataStreamImpl stream = conveyor.outputStream;
        IdeScriptEngine engine = this.prepareEngine(out, dialect, stream, allColumns, selectedColumns);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ExtensionScriptsUtil.prepareScript(this.myScriptFile);
        }
        PooledThreadExecutor.INSTANCE.submit(() -> {
            Throwable exception = null;
            try {
                String script = ExtensionScriptsUtil.loadScript(this.myProject, this.myScriptFile);
                ExtensionScriptsUtil.evalScript(this.myProject, engine, script);
            }
            catch (Throwable th) {
                exception = th;
                ExtensionScriptsUtil.showScriptExecutionError(this.myProject, th);
            }
            finally {
                stream.close(exception);
            }
        });
        return conveyor.extractionInput;
    }

    @NotNull
    private IdeScriptEngine prepareEngine(CharOut out, DatabaseDialectEx dialect, DataStream<DataRowImpl> stream, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor(this.myProject, this.myScriptFile);
        if (engine == null) {
            throw new ProcessCanceledException();
        }
        ExtensionScriptsUtil.setBindings(engine).bind(ExtractorScriptBindings.DATABASE_DIALECT, dialect).bind(ExtractorScriptBindings.DATABASE_TABLE, this.myDatabaseTable).bind(ExtractorScriptBindings.ALL_COLUMNS, ScriptDataExtractor.createDataColumns(allColumns)).bind(ExtractorScriptBindings.SELECTED_COLUMNS, ScriptDataExtractor.getSelectedDataColumns(ScriptDataExtractor.createDataColumns(allColumns), selectedColumns)).bind(ExtractorScriptBindings.FORMATTER, ScriptDataExtractor.createFormatter(this.myObjectFormatter, dialect)).bind(ExtractorScriptBindings.OUTPUT, ScriptDataExtractor.createOutput(out)).bind(ExtractorScriptBindings.INPUT, stream).bind(ExtractorScriptBindings.TRANSPOSED, this.myTransposed);
        IdeScriptEngine ideScriptEngine = engine;
        if (ideScriptEngine == null) {
            ScriptDataExtractor.$$$reportNull$$$0(3);
        }
        return ideScriptEngine;
    }

    @NotNull
    private static ValueFormatter createFormatter(final ObjectFormatter objectFormatter, final DatabaseDialect dialect) {
        ValueFormatter valueFormatter = new ValueFormatter(){

            @NotNull
            public String format(@NotNull DataRow row, @NotNull DataColumn column) {
                if (row == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (column == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = this.formatValue(row.value(column), column);
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            public String formatValue(@Nullable Object o, @NotNull DataColumn column) {
                if (column == null) {
                    1.$$$reportNull$$$0(3);
                }
                String str = objectFormatter.objectToString(o, ((DataColumnImpl)column).getColumn(), dialect, false);
                String string = StringUtil.notNullize((String)str, (String)"NULL");
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "row";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "column";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/extractors/ScriptDataExtractor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/extractors/ScriptDataExtractor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "format";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "formatValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "format";
                        break;
                    }
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "formatValue";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (valueFormatter == null) {
            ScriptDataExtractor.$$$reportNull$$$0(4);
        }
        return valueFormatter;
    }

    private static List<DataColumnImpl> getSelectedDataColumns(List<DataColumnImpl> allDataColumns, int[] selectedColumns) {
        if (selectedColumns.length == 0) {
            return allDataColumns;
        }
        ArrayList selectedDataColumns = ContainerUtil.newArrayListWithCapacity((int)selectedColumns.length);
        for (int columnIdx : selectedColumns) {
            if (columnIdx < 0 || columnIdx >= allDataColumns.size()) continue;
            selectedDataColumns.add(allDataColumns.get(columnIdx));
        }
        return selectedDataColumns;
    }

    @NotNull
    private static List<DataColumnImpl> createDataColumns(List<DataConsumer.Column> allColumns) {
        List list = ContainerUtil.map(allColumns, column -> new DataColumnImpl((DataConsumer.Column)column));
        if (list == null) {
            ScriptDataExtractor.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static Appendable createOutput(final CharOut out) {
        Appendable appendable = new Appendable(){

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                return this.append(csq, 0, csq.length());
            }

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                out.append(csq.subSequence(start, end));
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                return this.append(String.valueOf(c));
            }
        };
        if (appendable == null) {
            ScriptDataExtractor.$$$reportNull$$$0(6);
        }
        return appendable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectFormatter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ScriptDataExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ScriptDataExtractor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareEngine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormatter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataColumns";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExtractionDataConveyor {
        public final MyExtractionImpl extractionInput = new MyExtractionImpl();
        public final DataStreamImpl outputStream = new DataStreamImpl();
        private final Queue<DataConsumer.Row> myRowsQueue = new ArrayDeque<DataConsumer.Row>();
        private boolean myRowsDequeued;
        private boolean myAllRowsLoaded;
        private boolean myStopped;
        private Throwable myStopReason;

        private ExtractionDataConveyor() {
        }

        public synchronized void enqueue(List<DataConsumer.Row> rows) {
            this.myRowsQueue.addAll(rows);
            this.notifyAll();
            this.waitUntilRowsAreDequeued();
        }

        public synchronized void allRowsEnqueued() {
            this.myAllRowsLoaded = true;
            this.notifyAll();
            this.waitUntilStopped();
        }

        public synchronized DataRowImpl dequeue() {
            this.waitUntilRowsAreEnqueued();
            if (this.myRowsQueue.isEmpty()) {
                throw new AssertionError();
            }
            DataRowImpl dataRow = new DataRowImpl(this.myRowsQueue.remove(), !this.myRowsDequeued, this.myAllRowsLoaded && this.myRowsQueue.isEmpty());
            this.myRowsDequeued = true;
            this.notifyAll();
            return dataRow;
        }

        public synchronized boolean isDepleted() {
            return this.myAllRowsLoaded && this.myRowsQueue.isEmpty();
        }

        public synchronized void stop(@Nullable Throwable error) {
            this.myStopped = true;
            this.myStopReason = error;
            this.notifyAll();
        }

        private synchronized void waitUntilRowsAreEnqueued() {
            while (!this.myAllRowsLoaded && this.myRowsQueue.size() < 2) {
                this.checkStopped();
                this.doWait();
            }
        }

        private synchronized void waitUntilRowsAreDequeued() {
            while (!this.myAllRowsLoaded && this.myRowsQueue.size() > 1) {
                if (this.checkStopped()) {
                    this.myRowsQueue.clear();
                    continue;
                }
                this.doWait();
            }
        }

        private synchronized void waitUntilStopped() {
            while (!this.checkStopped()) {
                this.doWait();
            }
        }

        private synchronized boolean checkStopped() {
            if (this.myStopReason != null) {
                ProcessCanceledException exception = this.myStopReason instanceof ProcessCanceledException ? (ProcessCanceledException)this.myStopReason : new ProcessCanceledException(this.myStopReason);
                throw exception;
            }
            return this.myStopped;
        }

        private synchronized void doWait() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        class DataStreamImpl
        extends DataStream<DataRowImpl> {
            final AtomicReference<Iterator<DataRowImpl>> iterator = new AtomicReference<1>(new Iterator<DataRowImpl>(){

                @Override
                public boolean hasNext() {
                    return !ExtractionDataConveyor.this.isDepleted();
                }

                @Override
                public DataRowImpl next() {
                    return ExtractionDataConveyor.this.dequeue();
                }
            });

            DataStreamImpl() {
            }

            @NotNull
            public Iterator<DataRowImpl> iterator() {
                Iterator result2 = this.iterator.getAndSet(null);
                if (result2 == null) {
                    throw new AssertionError((Object)"This data stream can only be iterated once");
                }
                Iterator iterator = result2;
                if (iterator == null) {
                    DataStreamImpl.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            void close(@Nullable Throwable error) {
                ExtractionDataConveyor.this.stop(error);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ScriptDataExtractor$ExtractionDataConveyor$DataStreamImpl", "iterator"));
            }
        }

        public class MyExtractionImpl
        implements DataExtractor.Extraction {
            @Override
            public void addData(List<DataConsumer.Row> rows) {
                ExtractionDataConveyor.this.enqueue(rows);
            }

            @Override
            public void complete() {
                ExtractionDataConveyor.this.allRowsEnqueued();
            }
        }
    }
}

