/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors.ui;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.FormatsListAndPreviewPanel;
import com.intellij.database.csv.ui.preview.TextCsvFormatPreview;
import com.intellij.database.csv.ui.preview.TextView;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.util.CharOut;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseExtractorForm
implements Disposable {
    private static final String CSV_FORMAT_BASED_EXTRACTOR = "CSV Format";
    private ComboBox myExtractorComboBox;
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private final TextView myTextPreview;
    private final DataGrid myGrid;
    private final CsvFormatsSelectionUI myCsvFormats;

    private ChooseExtractorForm(@Nullable DataGrid grid) {
        this.myGrid = grid;
        this.$$$setupUI$$$();
        if (this.myGrid == null) {
            this.myTextPreview = null;
            this.myCsvFormats = null;
            return;
        }
        this.myTextPreview = new TextView(this);
        this.myCsvFormats = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(this);
        this.myExtractorComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ChooseExtractorForm.this.updatePreview();
            }
        });
        this.setInitialSelection();
    }

    private void createUIComponents() {
        this.myExtractorComboBox = new ComboBox(ContainerUtil.append((List)ContainerUtil.concat(DataExtractorFactories.getLegacy(), DataExtractorFactories.getScripts()), (Object[])new Object[]{CSV_FORMAT_BASED_EXTRACTOR}).toArray());
        this.myExtractorComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value == ChooseExtractorForm.CSV_FORMAT_BASED_EXTRACTOR) {
                    this.setText(ChooseExtractorForm.CSV_FORMAT_BASED_EXTRACTOR);
                } else if (value instanceof DataExtractorFactory) {
                    this.setText(((DataExtractorFactory)value).getName());
                } else {
                    ChooseExtractorForm.throwUnexpectedItem(value);
                }
            }
        });
        this.myPreviewPanel = new JPanel(new BorderLayout());
    }

    private void setInitialSelection() {
        Project project = DataGridUtil.getProject(this.myGrid);
        DataExtractorFactory selectedFactory = DataExtractorProperties.getCurrentExtractorFactory(project);
        String selectedFactoryName = selectedFactory.getName();
        for (int i2 = 0; i2 < this.myExtractorComboBox.getItemCount(); ++i2) {
            DataExtractorFactory f = (DataExtractorFactory)ObjectUtils.tryCast((Object)this.myExtractorComboBox.getItemAt(i2), DataExtractorFactory.class);
            if (f == null || !selectedFactoryName.equals(f.getName())) continue;
            if (this.myExtractorComboBox.getSelectedIndex() == i2) {
                this.updatePreview();
            } else {
                this.myExtractorComboBox.setSelectedIndex(i2);
            }
            return;
        }
        this.myExtractorComboBox.setSelectedItem((Object)CSV_FORMAT_BASED_EXTRACTOR);
        this.myCsvFormats.reset(this.myCsvFormats.getFormats(), selectedFactoryName);
    }

    private void updatePreview() {
        Object selectedItem = this.myExtractorComboBox.getSelectedItem();
        if (selectedItem == CSV_FORMAT_BASED_EXTRACTOR) {
            TextCsvFormatPreview csvPreview = new TextCsvFormatPreview(this.myGrid, this.myTextPreview, false);
            csvPreview.setFormat((CsvFormat)ObjectUtils.assertNotNull((Object)this.myCsvFormats.getSelectedFormat()));
            this.setPreview(new FormatsListAndPreviewPanel(this.myCsvFormats, csvPreview));
        } else if (selectedItem instanceof DataExtractorFactory) {
            DataContext context = DataManager.getInstance().getDataContext((Component)this.myGrid.getPreferredFocusedComponent());
            DataExtractor extractor = ((DataExtractorFactory)selectedItem).createExtractor(context);
            if (extractor != null) {
                String text = DataGridUtil.extractValues(this.myGrid, extractor, CharOut.Util.newSink(), false, false).toString();
                this.myTextPreview.setText(text);
                this.setPreview(this.myTextPreview.getComponent());
            }
        } else {
            ChooseExtractorForm.throwUnexpectedItem(selectedItem);
        }
    }

    private void setPreview(@NotNull JComponent c) {
        if (c == null) {
            ChooseExtractorForm.$$$reportNull$$$0(0);
        }
        this.myPreviewPanel.removeAll();
        this.myPreviewPanel.add((Component)c, "Center");
        this.myPreviewPanel.revalidate();
        this.myPreviewPanel.repaint();
    }

    @NotNull
    public DataExtractorFactory getSelectedExtractorFactory() {
        Object selectedItem = this.myExtractorComboBox.getSelectedItem();
        if (selectedItem instanceof DataExtractorFactory) {
            DataExtractorFactory dataExtractorFactory = (DataExtractorFactory)selectedItem;
            if (dataExtractorFactory == null) {
                ChooseExtractorForm.$$$reportNull$$$0(1);
            }
            return dataExtractorFactory;
        }
        if (selectedItem != CSV_FORMAT_BASED_EXTRACTOR) {
            ChooseExtractorForm.throwUnexpectedItem(selectedItem);
        }
        CsvFormat format = this.myCsvFormats.getSelectedFormat();
        DataExtractorFactory dataExtractorFactory = DataExtractorFactories.create((CsvFormat)ObjectUtils.assertNotNull((Object)format));
        if (dataExtractorFactory == null) {
            ChooseExtractorForm.$$$reportNull$$$0(2);
        }
        return dataExtractorFactory;
    }

    public void dispose() {
    }

    private static void throwUnexpectedItem(Object item) {
        throw new AssertionError((Object)("Unexpected item: " + item));
    }

    @Nullable
    public static DataExtractorFactory chooseExtractorFactory(@NotNull Project project, @Nullable DataGrid grid) {
        if (project == null) {
            ChooseExtractorForm.$$$reportNull$$$0(3);
        }
        ChooseExtractorForm form = new ChooseExtractorForm(grid);
        JPanel panel = form.myPanel;
        panel.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        DialogBuilder dialog = new DialogBuilder(project).title("Choose Extractor").centerPanel((JComponent)panel).dimensionKey(ChooseExtractorForm.class.getName());
        dialog.addDisposable((Disposable)form);
        if (!dialog.showAndGet()) {
            return null;
        }
        return form.getSelectedExtractorFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ui/ChooseExtractorForm";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ui/ChooseExtractorForm";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedExtractorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPreview";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chooseExtractorFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Extractor:");
        jBLabel.setDisplayedMnemonic('X');
        jBLabel.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox = this.myExtractorComboBox;
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JPanel jPanel2 = this.myPreviewPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

