/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.oracle.OraMatView;
import com.intellij.database.model.oracle.OraObjectType;
import com.intellij.database.model.oracle.OraPackage;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.oracle.OraSequence;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.model.oracle.OraSynonym;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraSchema
extends BasicSchema,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            OraSchema.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Nullable
    public OraRoot getRoot();

    @Override
    @Nullable
    default public OraRoot getDbParent() {
        return this.getRoot();
    }

    @Override
    default public @NotNull @Nullable NamingIdentifyingFamily<? extends OraSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraSequence> getSequences();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraCluster> getClusters();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraTable> getTables();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraView> getViews();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraMatView> getMatViews();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraPackage> getPackages();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraObjectType> getObjectTypes();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraCollectionType> getCollectionTypes();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraSingleRoutine> getRoutines();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraSynonym> getSynonyms();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.SEQUENCE, ObjectKind.CLUSTER, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW, ObjectKind.PACKAGE, ObjectKind.OBJECT_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.ROUTINE, ObjectKind.SYNONYM);
        if (list == null) {
            OraSchema.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getSequences(), this.getClusters(), this.getTables(), this.getViews(), this.getMatViews(), this.getPackages(), this.getObjectTypes(), this.getCollectionTypes(), this.getRoutines(), this.getSynonyms());
        if (list == null) {
            OraSchema.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull JBIterable<? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getSequences()).append(this.getClusters()).append(this.getTables()).append(this.getViews()).append(this.getMatViews()).append(this.getPackages()).append(this.getObjectTypes()).append(this.getCollectionTypes()).append(this.getRoutines()).append(this.getSynonyms());
        if (jBIterable == null) {
            OraSchema.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getIntrospectionTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    default public long getCommentsHash() {
        return 0L;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean visible;
        boolean current;
        long commentsHash;
        Date modifiedTimestamp;
        Date createdTimestamp;
        Date introspectionTimestamp;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            OraSchema.$$$reportNull$$$0(4);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", PropertyConverter.export(introspectionTimestamp));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((commentsHash = this.getCommentsHash()) != 0L) {
            consumer.accept("CommentsHash", PropertyConverter.export(commentsHash));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer.accept("Visible", PropertyConverter.export(visible));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "IntrospectionTimestamp", "CreatedTimestamp", "ModifiedTimestamp", "CommentsHash", "Current", "Visible");
        if (list == null) {
            OraSchema.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/oracle/OraSchema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/oracle/OraSchema";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

