/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.postgresbase.PostgresBaseDatabase;
import com.intellij.database.model.postgresbase.PostgresBaseSchema;
import com.intellij.database.model.postgresbase.PostgresBaseTable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"ancestors", "", "Lcom/intellij/database/model/postgres/PostgresTable;", "getAncestors", "(Lcom/intellij/database/model/postgres/PostgresTable;)Ljava/util/List;", "callRoutine", "Lcom/intellij/database/model/postgres/PostgresRoutine;", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "getCallRoutine", "(Lcom/intellij/database/model/postgres/PostgresTrigger;)Lcom/intellij/database/model/postgres/PostgresRoutine;", "callRoutineName", "", "getCallRoutineName", "(Lcom/intellij/database/model/postgres/PostgresTrigger;)Ljava/lang/String;", "successors", "", "getSuccessors", "(Lcom/intellij/database/model/postgres/PostgresTable;)Ljava/util/Set;", "findTableByObjectId", "Lcom/intellij/database/model/postgresbase/PostgresBaseTable;", "Lcom/intellij/database/model/postgresbase/PostgresBaseDatabase;", "id", "", "preferredSchema", "Lcom/intellij/database/model/postgresbase/PostgresBaseSchema;", "database-model-api"})
@JvmName(name="PostgresModelFun")
public final class PostgresModelFun {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PostgresTable> getAncestors(@NotNull PostgresTable $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Long> ancestorIds = $receiver.getAncestorIds();
        if (ancestorIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return CollectionsKt.emptyList();
        }
        PostgresSchema schema = postgresSchema;
        Iterable $receiver$iv = ancestorIds;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            NamingIdentifyingFamily<? extends PostgresTable> namingIdentifyingFamily = schema.getTables();
            void v2 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"id");
            PostgresTable postgresTable = (PostgresTable)namingIdentifyingFamily.getByObjectId(v2.longValue());
            collection.add(postgresTable);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PostgresTable> getSuccessors(@NotNull PostgresTable $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set<Long> successorIds = $receiver.getSuccessorIds();
        if (successorIds.isEmpty()) {
            return SetsKt.emptySet();
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return SetsKt.emptySet();
        }
        PostgresSchema schema = postgresSchema;
        Iterable $receiver$iv = successorIds;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            NamingIdentifyingFamily<? extends PostgresTable> namingIdentifyingFamily = schema.getTables();
            void v2 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"id");
            PostgresTable postgresTable = (PostgresTable)namingIdentifyingFamily.getByObjectId(v2.longValue());
            collection.add(postgresTable);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    @Nullable
    public static final PostgresRoutine getCallRoutine(@NotNull PostgresTrigger $receiver) {
        PostgresRoutine routine2;
        block3: {
            PostgresSchema s;
            PostgresDatabase database;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            long id = $receiver.getCallRoutineId();
            if (id == 0L) {
                return null;
            }
            PostgresSchema postgresSchema = $receiver.getSchema();
            if (postgresSchema == null) {
                return null;
            }
            PostgresSchema schema = postgresSchema;
            routine2 = (PostgresRoutine)schema.getRoutines().getByObjectId(id);
            if (routine2 != null || (database = schema.getDatabase()) == null) break block3;
            Iterator iterator = database.getSchemas().iterator();
            while (iterator.hasNext() && ((s = (PostgresSchema)iterator.next()) == schema || (routine2 = (PostgresRoutine)s.getRoutines().getByObjectId(id)) == null)) {
            }
        }
        return routine2;
    }

    @Nullable
    public static final String getCallRoutineName(@NotNull PostgresTrigger $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PostgresRoutine postgresRoutine = PostgresModelFun.getCallRoutine($receiver);
        return postgresRoutine != null ? postgresRoutine.getName() : null;
    }

    @Nullable
    public static final PostgresBaseTable findTableByObjectId(@NotNull PostgresBaseDatabase $receiver, long id, @Nullable PostgresBaseSchema preferredSchema) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PostgresBaseTable table = null;
        if (preferredSchema != null) {
            table = (PostgresBaseTable)preferredSchema.getTables().getByObjectId(id);
        }
        if (table == null) {
            table = (PostgresBaseTable)$receiver.getSchemas().jbi().filter((Condition)new Condition<PostgresBaseSchema>(preferredSchema){
                final /* synthetic */ PostgresBaseSchema $preferredSchema;

                public final boolean value(PostgresBaseSchema s) {
                    return Intrinsics.areEqual((Object)s, (Object)this.$preferredSchema) ^ true;
                }
                {
                    this.$preferredSchema = postgresBaseSchema;
                }
            }).transform(new Function<E, T>(id){
                final /* synthetic */ long $id;

                @Nullable
                public final PostgresBaseTable fun(PostgresBaseSchema s) {
                    return (PostgresBaseTable)s.getTables().getByObjectId(this.$id);
                }
                {
                    this.$id = l;
                }
            }).filter((Condition)findTableByObjectId.3.INSTANCE).first();
        }
        return table;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PostgresBaseTable findTableByObjectId$default(PostgresBaseDatabase postgresBaseDatabase, long l, PostgresBaseSchema postgresBaseSchema, int n, Object object) {
        if ((n & 2) != 0) {
            postgresBaseSchema = null;
        }
        return PostgresModelFun.findTableByObjectId(postgresBaseDatabase, l, postgresBaseSchema);
    }
}

