/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPlanModelBuilder<State>
extends DataRequest.RawRequest {
    protected static final Logger LOG = Logger.getInstance(AbstractPlanModelBuilder.class);
    public static final Function<NodeDesc, Iterable<? extends NodeDesc>> CHILDREN = desc -> desc.children;
    protected final Logger myLogger;
    private final Consumer<PlanModel> myConsumer;
    private final EnumSet<PlanModel.Feature> myUnsupportedFeatures;
    private List<NodeDesc> myNodes;
    private NodeDesc myRoot;
    protected static final boolean SHOW_RAW = Registry.is((String)"database.explain_plan.show_raw", (boolean)false);
    private boolean myValid;

    protected AbstractPlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull EnumSet<PlanModel.Feature> unsupportedFeatures) {
        if (owner == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (unsupportedFeatures == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(2);
        }
        super(owner);
        this.myLogger = Logger.getInstance(this.getClass());
        this.myNodes = ContainerUtil.newArrayList();
        this.myConsumer = consumer;
        this.myUnsupportedFeatures = unsupportedFeatures;
    }

    @NotNull
    protected abstract String dump();

    protected void openNode() {
        NodeDesc newNode = new NodeDesc();
        NodeDesc prev = (NodeDesc)ContainerUtil.getLastItem(this.myNodes);
        if (prev != null) {
            prev.children.add(newNode);
        }
        this.myNodes.add(newNode);
    }

    protected void closeNode(@NotNull PlanModel.GenericNode node) {
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(3);
        }
        NodeDesc current = (NodeDesc)ContainerUtil.getLastItem(this.myNodes);
        assert (current != null);
        current.node = node;
        this.myNodes.remove(this.myNodes.size() - 1);
        if (this.myNodes.isEmpty()) {
            assert (this.myRoot == null);
            this.myRoot = current;
        }
    }

    protected void addLazyNode(@NotNull Getter<PlanModel.GenericNode> lazy, boolean secondPass) {
        if (lazy == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(4);
        }
        NodeDesc newNode = new NodeDesc();
        newNode.lazy = lazy;
        newNode.onSecondPass = secondPass;
        NodeDesc prev = (NodeDesc)ContainerUtil.getLastItem(this.myNodes);
        if (prev == null) {
            this.myRoot = newNode;
        } else {
            prev.children.add(newNode);
        }
    }

    protected void modelReady() {
        PlanModel model = new PlanModel(this.getRootNode(), this.myUnsupportedFeatures);
        this.myConsumer.consume((Object)model);
    }

    private void expandNodes() {
        JBIterable traversal = ((JBTreeTraverser)new JBTreeTraverser(CHILDREN).withRoot((Object)this.myRoot)).bfsTraversal();
        for (NodeDesc desc : traversal) {
            this.processLazyNode(desc, false);
        }
        for (NodeDesc desc : traversal) {
            this.processLazyNode(desc, true);
        }
        for (NodeDesc parent : traversal) {
            if (parent.node.getChildren().length != 0) continue;
            PlanModel.GenericNode[] children = new PlanModel.GenericNode[parent.children.size()];
            for (int i2 = 0; i2 < parent.children.size(); ++i2) {
                children[i2] = parent.children.get((int)i2).node;
            }
            parent.node.setChildren(children);
        }
        this.detectCycles();
        this.myValid = true;
    }

    private void processLazyNode(@NotNull NodeDesc desc, boolean secondPass) {
        if (desc == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(5);
        }
        if (desc.node != null || desc.onSecondPass && !secondPass) {
            return;
        }
        assert (this.myNodes.isEmpty());
        this.myNodes.add(desc);
        desc.node = (PlanModel.GenericNode)desc.lazy.get();
        assert (this.myNodes.size() == 1);
        this.myNodes.clear();
    }

    @NotNull
    protected PlanModel.GenericNode getRootNode() {
        assert (this.myNodes.isEmpty());
        if (this.myRoot == null) {
            this.myRoot = new NodeDesc();
            this.myRoot.node = new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null);
        } else if (!this.myValid) {
            this.expandNodes();
        }
        PlanModel.GenericNode genericNode = this.myRoot.node;
        if (genericNode == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(6);
        }
        return genericNode;
    }

    protected void resetRoot() {
        this.getRootNode();
        this.myRoot = null;
        this.myValid = false;
    }

    protected void setRootNode(@NotNull PlanModel.GenericNode node) {
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(7);
        }
        assert (this.myNodes.isEmpty());
        this.myRoot = new NodeDesc();
        this.myRoot.node = node;
    }

    @NotNull
    protected PlanModel.GenericNode createNode(final @Nullable State state, @NotNull PlanModel.NodeType type, @Nullable String typeStr) throws PlanRetrievalException {
        if (type == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(8);
        }
        PlanModel.GenericNode node = PlanModel.createNode(type, typeStr);
        if (state != null) {
            node.accept(new PlanModel.PlanVisitor(){

                @Override
                public void visit(@NotNull PlanModel.GenericNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AbstractPlanModelBuilder.this.parseNode(state, node);
                }

                @Override
                public void visit(@NotNull PlanModel.GenericAccessNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    AbstractPlanModelBuilder.this.parseNode(state, node);
                }

                @Override
                public void visit(@NotNull PlanModel.IndexScanNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    AbstractPlanModelBuilder.this.parseNode(state, node);
                }

                @Override
                public void visit(@NotNull PlanModel.SubQueryNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    AbstractPlanModelBuilder.this.parseNode(state, node);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/AbstractPlanModelBuilder$1", "visit"));
                }
            });
        }
        PlanModel.GenericNode genericNode = node;
        if (genericNode == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(9);
        }
        return genericNode;
    }

    public void processDump(@NotNull String dump) {
        if (dump == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(10);
        }
    }

    protected void showRaw() {
        if (!SHOW_RAW) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> Messages.showInfoMessage((String)this.dump(), (String)"Raw Explain Plan Data"));
    }

    @NotNull
    protected abstract String parseRawDescription(@NotNull State var1);

    @Nullable
    protected abstract String parseAccessRelation(@NotNull State var1);

    @Nullable
    protected abstract BigDecimal parsePlanNumRows(@NotNull State var1);

    @Nullable
    protected abstract String parseAccessIndex(@NotNull State var1);

    protected abstract void parsePlan(@NotNull State var1);

    protected abstract void parseSubPlans(@NotNull State var1);

    protected abstract void parseStatement(@NotNull State var1);

    protected void parseNode(@NotNull State state, @NotNull PlanModel.GenericNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(11);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(12);
        }
        node.setRawDescription(this.parseRawDescription(state));
        node.setPlanNumRows(this.parsePlanNumRows(state));
        node.setTotalCost(this.parseTotalCost(state));
        node.setStartupCost(this.parseStartupCost(state));
    }

    @Nullable
    protected abstract Double parseTotalCost(@NotNull State var1);

    @Nullable
    protected abstract Double parseStartupCost(@NotNull State var1);

    protected void parseNode(@NotNull State state, @NotNull PlanModel.SubQueryNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(13);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(14);
        }
        node.setCorrelated(this.parseSubqueryCorrelated(state));
        node.setScalar(this.parseSubqueryScalar(state));
        this.parseDown(state, node);
    }

    protected abstract boolean parseSubqueryCorrelated(@NotNull State var1);

    protected abstract boolean parseSubqueryScalar(@NotNull State var1);

    protected void parseNode(@NotNull State state, @NotNull PlanModel.GenericAccessNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(15);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(16);
        }
        node.setRelation(this.parseAccessRelation(state));
        this.parseDown(state, node);
    }

    protected void parseNode(@NotNull State state, @NotNull PlanModel.IndexScanNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(17);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(18);
        }
        node.setIndex(this.parseAccessIndex(state));
        this.parseDown(state, node);
    }

    protected void parseDown(@NotNull State state, @NotNull PlanModel.IndexScanNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(19);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(20);
        }
        this.parseNode(state, (PlanModel.GenericAccessNode)node);
    }

    protected void parseDown(@NotNull State state, @NotNull PlanModel.GenericAccessNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(21);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(22);
        }
        this.parseNode(state, (PlanModel.GenericNode)node);
    }

    protected void parseDown(@NotNull State state, @NotNull PlanModel.SubQueryNode node) {
        if (state == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(23);
        }
        if (node == null) {
            AbstractPlanModelBuilder.$$$reportNull$$$0(24);
        }
        this.parseNode(state, (PlanModel.GenericNode)node);
    }

    @Contract(value="->fail")
    protected void unsupportedFormat() {
        this.unsupportedFormat(null);
    }

    @Contract(value="_->fail")
    protected void unsupportedFormat(@Nullable String comment) {
        this.unsupportedFormat(null, comment);
    }

    @Contract(value="_,_->fail")
    protected void unsupportedFormat(Throwable e, @Nullable String comment) {
        this.myLogger.error("Database returned plan in unsupported format" + (comment == null ? "" : ": " + comment), new Attachment[]{new Attachment("raw_plan.txt", this.dump())});
        throw new PlanRetrievalException("Database returned plan in unsupported format" + (comment == null ? "" : ": " + comment), e);
    }

    protected static String randomShorterUUID() {
        UUID uuid = UUID.randomUUID();
        return DatatypeConverter.printBase64Binary((byte[])ByteBuffer.allocate(16).putLong(uuid.getLeastSignificantBits()).putLong(uuid.getMostSignificantBits()).array());
    }

    private void detectCycles() {
        HashMap colors = ContainerUtil.newHashMap();
        ArrayList stack = ContainerUtil.newArrayList();
        stack.add(this.myRoot.node);
        colors.put(this.myRoot.node, 0);
        while (!stack.isEmpty()) {
            PlanModel.GenericNode node = (PlanModel.GenericNode)stack.get(stack.size() - 1);
            int color = (Integer)colors.get(node);
            colors.put(node, color + 1);
            if (color != 0) {
                stack.remove(stack.size() - 1);
                continue;
            }
            colors.put(node, 1);
            for (PlanModel.GenericNode child : node.getChildren()) {
                Integer c = (Integer)colors.get(child);
                if (c == null) {
                    colors.put(child, 0);
                    stack.add(child);
                    continue;
                }
                if (c != 1) continue;
                StringBuilder sb = new StringBuilder();
                boolean add = false;
                sb.append((Object)child.getType());
                for (PlanModel.GenericNode item : stack) {
                    if (add) {
                        sb.append("\n -> ").append((Object)item.getType());
                    }
                    if (item != child) continue;
                    add = !add;
                }
                sb.append("\n -> cycle");
                throw new PlanRetrievalException("Cycle detected\n" + sb);
            }
        }
    }

    protected static StateSaver setAutoCommit(final boolean autoCommit) {
        return new StateSaver(){
            private Boolean myAutoCommit = null;

            @Override
            public void save(DatabaseConnection conn) throws PlanRetrievalException {
                try {
                    this.myAutoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(autoCommit);
                }
                catch (SQLException e) {
                    throw new PlanRetrievalException("Failed to set auto commit", e);
                }
            }

            @Override
            public void restore(DatabaseConnection conn) {
                try {
                    if (this.myAutoCommit != null) {
                        conn.setAutoCommit(this.myAutoCommit);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
    }

    protected static void useResults(Statement stmt, ResourceUser<ResultSet> user) {
        ResultSet rs = null;
        try {
            rs = stmt.getResultSet();
            user.use(rs);
        }
        catch (SQLException e) {
            throw new PlanRetrievalException("Failed get result set", e);
        }
        finally {
            JdbcUtil.closeResultSetSafe((ResultSet)rs);
        }
    }

    protected static void useStatement(Statement stmt, ResourceUser<Statement> user) throws PlanRetrievalException, SQLException {
        try {
            user.use(stmt);
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)stmt);
        }
    }

    protected static void useStatementWithPreserved(final DatabaseConnection conn, final ResourceUser<Statement> user, StateSaver ... savers) throws PlanRetrievalException {
        AbstractPlanModelBuilder.withPreserved(conn, new ResourceUser<DatabaseConnection>(){

            @Override
            public void use(DatabaseConnection resource) throws PlanRetrievalException, SQLException {
                Statement statement;
                try {
                    statement = conn.createStatement();
                }
                catch (SQLException e) {
                    throw new PlanRetrievalException("Failed create SQL statement", e);
                }
                AbstractPlanModelBuilder.useStatement(statement, user);
            }
        }, savers);
    }

    protected static void withPreserved(DatabaseConnection conn, ResourceUser<DatabaseConnection> user, StateSaver ... savers) throws PlanRetrievalException {
        int preserved = 0;
        try {
            for (StateSaver saver : savers) {
                ++preserved;
                saver.save(conn);
            }
            user.use(conn);
        }
        catch (SQLException e) {
            throw new PlanRetrievalException("Failed to execute plan retrieval SQL statement", e);
        }
        finally {
            for (int i2 = preserved - 1; i2 >= 0; --i2) {
                try {
                    savers[i2].restore(conn);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsupportedFeatures";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/AbstractPlanModelBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/AbstractPlanModelBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "closeNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLazyNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processLazyNode";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRootNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDump";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseNode";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseDown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface StateSaver {
        public void save(DatabaseConnection var1) throws PlanRetrievalException;

        public void restore(DatabaseConnection var1);
    }

    protected static interface ResourceUser<T> {
        public void use(T var1) throws PlanRetrievalException, SQLException;
    }

    private static class NodeDesc {
        public PlanModel.GenericNode node;
        public Getter<PlanModel.GenericNode> lazy;
        public boolean onSecondPass;
        public List<NodeDesc> children = ContainerUtil.newSmartList();

        private NodeDesc() {
        }
    }
}

