/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCustomUsageSearcher
extends CustomUsageSearcher
implements UsageTypeProvider {
    private static final UsageType SCHEMA_USAGE_TYPE = new UsageType(DatabaseMessages.message((String)"usage.type.schema", (Object[])new Object[0]));

    public void processElementUsages(@NotNull PsiElement element, @NotNull Processor<Usage> processor, @NotNull FindUsagesOptions options) {
        DasObject target;
        if (element == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(2);
        }
        if ((target = DbUtil.getDasObject((Object)element)) == null || !(element instanceof DbElement)) {
            return;
        }
        DbElement dbTarget = (DbElement)element;
        DbDataSource dataSource = dbTarget.getDataSource();
        ObjectKind targetKind = target.getKind();
        if (targetKind == ObjectKind.NONE) {
            return;
        }
        JBTreeTraverser traverser = dataSource.getDelegate().getModel().traverser();
        for (DasObject o : traverser) {
            DbElement oo;
            ProgressManager.checkCanceled();
            if (!DbCustomUsageSearcher.referencesTarget(o, target, targetKind) || processor.process((Object)DbCustomUsageSearcher.createUsage(oo = DbImplUtil.findElement(dataSource, o), dbTarget))) continue;
            return;
        }
    }

    public UsageType getUsageType(PsiElement element) {
        if (element instanceof DbElement) {
            return SCHEMA_USAGE_TYPE;
        }
        return null;
    }

    public static boolean referencesTarget(@NotNull DasObject candidate, @NotNull DasObject target, @NotNull ObjectKind targetKind) {
        if (candidate == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(3);
        }
        if (target == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(4);
        }
        if (targetKind == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(5);
        }
        if (targetKind == ObjectKind.TABLE) {
            if (candidate instanceof DasForeignKey) {
                DasTable refTable = ((DasForeignKey)candidate).getRefTable();
                if (target.equals(refTable)) {
                    return true;
                }
            } else if (target instanceof PostgresTable && candidate instanceof PostgresTable) {
                PostgresTable t = (PostgresTable)target;
                PostgresTable c = (PostgresTable)candidate;
                if (c.getAncestorIds().contains(t.getObjectId())) {
                    return true;
                }
            }
        } else if (targetKind == ObjectKind.COLUMN) {
            if (candidate instanceof DasConstraint) {
                if (ContainerUtil.find((Iterable)((DasConstraint)candidate).getColumnsRef().resolveObjects(), (Object)target) != null) {
                    return true;
                }
                if (candidate instanceof DasForeignKey && ContainerUtil.find((Iterable)((DasForeignKey)candidate).getRefColumns().resolveObjects(), (Object)target) != null) {
                    return true;
                }
            } else if (candidate instanceof DasIndex && ContainerUtil.find((Iterable)((DasIndex)candidate).getColumnsRef().resolveObjects(), (Object)target) != null) {
                return true;
            }
        } else if (targetKind == ObjectKind.ROUTINE) {
            if (candidate instanceof PostgresTrigger && target instanceof PostgresRoutine) {
                PostgresTrigger trigger2 = (PostgresTrigger)candidate;
                PostgresRoutine routine2 = (PostgresRoutine)target;
                if (trigger2.getCallRoutineId() == routine2.getObjectId()) {
                    return true;
                }
            }
        } else if (candidate instanceof DasSynonym && ((DasSynonym)candidate).resolveTarget() == target) {
            return true;
        }
        return false;
    }

    private static Usage createUsage(@NotNull DbElement o, @NotNull DbElement resolveTo) {
        if (o == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(6);
        }
        if (resolveTo == null) {
            DbCustomUsageSearcher.$$$reportNull$$$0(7);
        }
        return new MyUsage(o, resolveTo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveTo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbCustomUsageSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementUsages";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "referencesTarget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyUsage
    implements PsiElementUsage,
    UsagePresentation {
        final TextChunk[] myChunks;
        final String myText;
        final DbElement myO;
        final DbElement myNavigateTo;

        MyUsage(@NotNull DbElement o, final @NotNull DbElement resolveTo) {
            DasTypedObject keyColumn;
            if (o == null) {
                MyUsage.$$$reportNull$$$0(0);
            }
            if (resolveTo == null) {
                MyUsage.$$$reportNull$$$0(1);
            }
            final TextAttributes emptyAttrs = new TextAttributes();
            final ArrayList chunks = ContainerUtil.newArrayList();
            String text = new DdlBuilder.Colored(){

                @Override
                @NotNull
                public DdlBuilder.Colored ref(@Nullable DasObject object, String name) {
                    if (resolveTo.equals(object) || object == null && resolveTo instanceof DasColumn && Comparing.equal((String)resolveTo.getName(), (String)name)) {
                        this.pushStyle(new TextAttributes(null, null, null, null, 1));
                        super.ref(object, name);
                        DdlBuilder.Colored colored = this.popStyle();
                        if (colored == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return colored;
                    }
                    DdlBuilder.Colored colored = super.ref(object, name);
                    if (colored == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return colored;
                }

                @Override
                protected void setAttributes(TextAttributes attributes, boolean enabled) {
                }

                @Override
                @NotNull
                protected DdlBuilder.Colored append(@NotNull String text) {
                    TextAttributes attributes;
                    if (text == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    chunks.add(new TextChunk((attributes = (TextAttributes)this.myStack.peekLast()) == null ? emptyAttrs : attributes, text));
                    DdlBuilder.Colored colored = super.append(text);
                    if (colored == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return colored;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "ref";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "append";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "append";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.configureFor(o).element((DasObject)o).getStatement();
            this.myO = o;
            if (StringUtil.isNotEmpty((String)text)) {
                this.myText = text;
            } else {
                this.myText = DbPresentation.getPresentableName((DasObject)o, true);
                chunks.add(new TextChunk(emptyAttrs, this.myText));
            }
            DbElement navigateTo = o instanceof DbForeignKey ? ((keyColumn = (DasTypedObject)Iterables.getFirst((Iterable)((DbForeignKey)o).getRefColumns().resolveObjects(), null)) instanceof DbElement ? (DbElement)keyColumn : this.myO.getDbParent()) : o;
            chunks.add(new TextChunk(SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes(), " (" + QNameUtil.getQualifiedName(this.myO.getDbParent()) + ")"));
            this.myChunks = chunks.toArray(new TextChunk[chunks.size()]);
            this.myNavigateTo = navigateTo;
        }

        @NotNull
        public UsagePresentation getPresentation() {
            MyUsage myUsage = this;
            if (myUsage == null) {
                MyUsage.$$$reportNull$$$0(2);
            }
            return myUsage;
        }

        public boolean isValid() {
            return this.myO.isValid() && this.myNavigateTo.isValid();
        }

        public boolean isReadOnly() {
            return true;
        }

        public FileEditorLocation getLocation() {
            return null;
        }

        public void selectInEditor() {
        }

        public void highlightInEditor() {
        }

        public void navigate(boolean requestFocus) {
            DatabaseViewOptions viewOptions = DatabaseView.getDatabaseView(this.myNavigateTo.getProject()).getViewOptions();
            if (viewOptions.SHOW_TABLE_DETAILS) {
                this.myO.navigate(requestFocus);
            } else {
                this.myNavigateTo.navigate(requestFocus);
            }
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public PsiElement getElement() {
            return this.myO;
        }

        public boolean isNonCodeUsage() {
            return true;
        }

        @NotNull
        public TextChunk[] getText() {
            if (this.myChunks == null) {
                MyUsage.$$$reportNull$$$0(3);
            }
            return this.myChunks;
        }

        @NotNull
        public String getPlainText() {
            String string = this.myText;
            if (string == null) {
                MyUsage.$$$reportNull$$$0(4);
            }
            return string;
        }

        public Icon getIcon() {
            return this.myO.getIcon();
        }

        public String getTooltipText() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveTo";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlainText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

