/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.autoconfig.JdbcDriversMappings;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.BasicDbPsiManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDbPsiManager
extends BasicDbPsiManager<LocalDataSource> {
    private static final DataSourceTemplate DEFAULT_TEMPLATE = new LocalDataSourceTemplate();
    private final DataSourceStorage myProjectStorage;

    public DefaultDbPsiManager(DbPsiFacade dbFacade, DataSourceStorage.Prj projectStorage) {
        super(dbFacade, projectStorage.getDataSources());
        this.myProjectStorage = projectStorage;
        this.myProjectStorage.addDataSourceListener(new DataSourceListener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                DefaultDbPsiManager.this.attachDataSource(dataSource);
                DefaultDbPsiManager.this.myDbFacade.clearCaches(null);
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                DefaultDbPsiManager.this.detachDataSource(dataSource);
                DefaultDbPsiManager.this.myDbFacade.clearCaches(null);
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null) {
                    DefaultDbPsiManager.this.resetElementMap(DefaultDbPsiManager.this.myProjectStorage.getDataSources());
                    DefaultDbPsiManager.this.myDbFacade.clearCaches(null);
                } else {
                    DefaultDbPsiManager.this.myDbFacade.clearCaches(DefaultDbPsiManager.this.getDataSourceWrapper(dataSource));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/psi/DefaultDbPsiManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myDbFacade.getProject());
    }

    public void removeDataSource(DbDataSource element) {
        DatabaseSystem delegate = element.getDelegate();
        if (!(delegate instanceof LocalDataSource)) {
            throw new UnsupportedOperationException();
        }
        LocalDataSource dataSource = (LocalDataSource)delegate;
        this.processAddOrRemove(dataSource, false);
    }

    @Override
    public void setDataSourceName(@NotNull DbDataSource element, String name) {
        DatabaseSystem delegate;
        if (element == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(0);
        }
        if (!((delegate = element.getDelegate()) instanceof LocalDataSource)) {
            throw new UnsupportedOperationException();
        }
        LocalDataSource dataSource = (LocalDataSource)delegate;
        dataSource.setName(name);
        DataSourceStorage.getProjectStorage(element.getProject()).updateDataSource(dataSource);
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker(@NotNull DbElement element) {
        if (element == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(1);
        }
        ModificationTracker modificationTracker = (ModificationTracker)element.getDataSource().getDelegate();
        if (modificationTracker == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(2);
        }
        return modificationTracker;
    }

    @NotNull
    public Configurable createDataSourceEditor(DbDataSource template) {
        LocalDataSource dataSource = (LocalDataSource)ObjectUtils.assertNotNull((Object)((LocalDataSource)template.getDelegate()));
        DataSourceConfigurable dataSourceConfigurable = new DataSourceConfigurable(this, dataSource, template.getProject());
        if (dataSourceConfigurable == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(3);
        }
        return dataSourceConfigurable;
    }

    @NotNull
    public List<DataSourceTemplate> getDataSourceTemplates() {
        List<DataSourceTemplate> list = Collections.singletonList(DEFAULT_TEMPLATE);
        if (list == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public DataSourceTemplate getDataSourceTemplate(DbDataSource element) {
        DatabaseSystem delegate = element.getDelegate();
        return delegate instanceof LocalDataSource ? ((LocalDataSource)delegate).getDatabaseDriver() : null;
    }

    public boolean canCreateDataSourceByFiles(Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            if (!(file.getFileType() instanceof DbStorageFileType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<DbDataSource> createDataSourceByFiles(Collection<VirtualFile> files) {
        final ArrayList result2 = ContainerUtil.newArrayList();
        DataSourceRegistry registry = new DataSourceRegistry(this.myDbFacade.getProject());
        DataSourceDetector.Callback callback = new DataSourceDetector.Callback(){

            public void onCreated(@NotNull DatabaseSystem dataSource) {
                if (dataSource == null) {
                    2.$$$reportNull$$$0(0);
                }
                ContainerUtil.addIfNotNull((Collection)result2, (Object)DefaultDbPsiManager.this.myDbFacade.findDataSource(dataSource.getUniqueId()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/DefaultDbPsiManager$2", "onCreated"));
            }
        };
        for (VirtualFile file : files) {
            String databaseName;
            JdbcDriversMappings.JdbcMapping jdbcMapping;
            FileType fileType = file.getFileType();
            if (!(fileType instanceof DbStorageFileType) || (jdbcMapping = JdbcDriversMappings.findMappingByDatabaseName(databaseName = ((DbStorageFileType)fileType).getDatabaseName())) == null) continue;
            String defaultName = DbUtil.createNewDataSourceName((Project)this.myDbFacade.getProject(), (String)file.getNameWithoutExtension());
            jdbcMapping.createDataSource(null, databaseName, defaultName, new FileBasedConfiguration(file), registry.getBuilder().onCreate(callback));
        }
        DataSourceConfigUtil.configureDetectedDataSources(this.myDbFacade.getProject(), registry, true, true);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void fireDataSourceUpdated(@NotNull DbDataSource element) {
        if (element == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(6);
        }
        this.fireDataSourceUpdated((LocalDataSource)element.getDelegate());
    }

    public void fireDataSourceUpdated(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(7);
        }
        this.myProjectStorage.updateDataSource(dataSource);
    }

    public void processAddOrRemove(final @NotNull LocalDataSource dataSource, final boolean added) {
        if (dataSource == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(8);
        }
        Project project = this.myDbFacade.getProject();
        GlobalUndoableAction action = new GlobalUndoableAction(){

            public void undo() {
                if (added) {
                    DefaultDbPsiManager.this.myProjectStorage.removeDataSource(dataSource);
                } else {
                    DefaultDbPsiManager.this.myProjectStorage.addDataSource(dataSource);
                }
            }

            public void redo() {
                if (added) {
                    DefaultDbPsiManager.this.myProjectStorage.addDataSource(dataSource);
                } else {
                    DefaultDbPsiManager.this.myProjectStorage.removeDataSource(dataSource);
                }
            }
        };
        new WriteCommandAction(project, added ? DatabaseMessages.message((String)"command.name.add.data.source", (Object[])new Object[0]) : DatabaseMessages.message((String)"command.name.remove.data.source", (Object[])new Object[0]), new PsiFile[0], (UndoableAction)action, project){
            final /* synthetic */ UndoableAction val$action;
            final /* synthetic */ Project val$project;
            {
                this.val$action = undoableAction;
                this.val$project = project;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.val$action.redo();
                UndoManager.getInstance((Project)this.val$project).undoableActionPerformed(this.val$action);
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/psi/DefaultDbPsiManager$4", "run"));
            }
        }.execute();
    }

    @Override
    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull DbDataSource element) {
        DatabaseSystem delegate;
        if (element == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(9);
        }
        return (delegate = element.getDelegate()) instanceof RawConnectionConfig ? DbImplUtil.guessDatabaseDialect((RawConnectionConfig)delegate) : null;
    }

    @Override
    @Nullable
    public SqlLanguageDialect getSqlDialect(@NotNull DbDataSource element) {
        DatabaseSystem delegate;
        if (element == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(10);
        }
        if ((delegate = element.getDelegate()) instanceof LocalDataSource) {
            return DbSqlUtil.findSqlDialect((LocalDataSource)delegate);
        }
        return DbSqlUtil.guessSqlDialect((RawConnectionConfig)ObjectUtils.tryCast((Object)delegate, RawConnectionConfig.class));
    }

    @Override
    public void addDataSource(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DefaultDbPsiManager.$$$reportNull$$$0(11);
        }
        this.processAddOrRemove(dataSource, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DefaultDbPsiManager";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DefaultDbPsiManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceTemplates";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDataSourceName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fireDataSourceUpdated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAddOrRemove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalDataSourceTemplate
    implements DataSourceTemplate {
        private LocalDataSourceTemplate() {
        }

        @NotNull
        public String getName() {
            if ("Data Source" == null) {
                LocalDataSourceTemplate.$$$reportNull$$$0(0);
            }
            return "Data Source";
        }

        @NotNull
        public String getFullName() {
            String string = this.getName();
            if (string == null) {
                LocalDataSourceTemplate.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<DataSourceTemplate> getSubConfigurations() {
            ArrayList arrayList = ContainerUtil.newArrayList(DatabaseDriverManager.getInstance().getDrivers());
            if (arrayList == null) {
                LocalDataSourceTemplate.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
            if (project == null) {
                LocalDataSourceTemplate.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException("Abstract DataSource creation not supported");
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return DatabaseIcons.Dbms;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/DefaultDbPsiManager$LocalDataSourceTemplate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubConfigurations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/DefaultDbPsiManager$LocalDataSourceTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDataSource";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FileBasedConfiguration
    implements DataSourceConfiguration {
        private final VirtualFile myFile;

        public FileBasedConfiguration(VirtualFile file) {
            this.myFile = file;
        }

        @Override
        @Nullable
        public String getDatabase() {
            return VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile).getAbsolutePath();
        }

        @Override
        @Nullable
        public String getHost() {
            return null;
        }

        @Override
        @Nullable
        public String getPort() {
            return null;
        }

        @Override
        @Nullable
        public String getUserName() {
            return null;
        }

        @Override
        @Nullable
        public String getPassword() {
            return null;
        }

        @Override
        @Nullable
        public String getOption(String name) {
            return null;
        }

        @Override
        @Nullable
        public VirtualFile getApplicationRoot() {
            return null;
        }
    }
}

