/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConsoleDataConsumer
implements DataConsumer {
    private static final String ID_RESULT = "ResultTab";
    private static final String DEFAULT_TITLE = "Result";
    private static final Key<GridInfo> GRID_INFO_KEY = Key.create((String)"GRID_INFO_KEY");
    private static final Key<TableEditorBase> FILE_EDITOR_KEY = Key.create((String)"ResultPanel.MyTableFileEditor");
    private final AbstractQueryLanguageConsole<?> myConsole;
    private int myMajorRequestCount;
    private int myMinorRequestCount;
    private Content myCurrentContent;
    private final MultiMap<DataRequest, Content> myPreparedContentMap = MultiMap.createWeakKey();

    public ConsoleDataConsumer(AbstractQueryLanguageConsole<?> console) {
        this.myConsole = console;
        this.myConsole.getMessageBus().addConsumer(DataGridUtil.createEDTSafeWrapper(this, console));
    }

    @NotNull
    protected abstract PlaceInGrid getPlaceInGrid();

    public void onSearchPathUpdate(@Nullable SearchPath schemaPaths) {
        for (Content content : this.myConsole.getUi().getContents()) {
            DataGrid grid = ConsoleDataConsumer.getDataGrid(content);
            if (grid == null) continue;
            Ref<SearchPath> searchPathRef = ((GridInfo)ConsoleDataConsumer.GRID_INFO_KEY.get((UserDataHolder)content)).path;
            ((TableResultPanel)grid).setReady(searchPathRef != null && Comparing.equal((Object)searchPathRef.get(), (Object)schemaPaths));
        }
    }

    @Override
    public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
        Content content;
        if (context == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(0);
        }
        if ((content = this.getValidCurrentContent()) == null) {
            return;
        }
        this.myCurrentContent = null;
        DataGrid dataGrid = ConsoleDataConsumer.getNotNullDataGrid(content);
        ConsoleDataConsumer.consumerFor(dataGrid).afterLastRowAdded(context, total);
    }

    public void resetOutputTabCounter() {
        this.myMajorRequestCount = 0;
        this.myMinorRequestCount = 0;
    }

    public boolean isReuseTab() {
        return DatabaseSettings.getSettings().isReuseResultTab();
    }

    @NotNull
    private Content reuseOrCreateContent(int resultSetIndex) {
        Content[] contents = this.myConsole.getUi().getContents();
        Content resultContent = null;
        if (this.isReuseTab()) {
            GridInfo curInfo = null;
            for (Content content : contents) {
                DataGrid dataGrid = ConsoleDataConsumer.getDataGrid(content);
                if (dataGrid == null || content.isPinned() || !ConsoleDataConsumer.isGeneratedName(content)) continue;
                GridInfo info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content);
                if (info.major == this.myMajorRequestCount || curInfo != null && curInfo.major <= info.major && (curInfo.major != info.major || curInfo.minor <= info.minor)) continue;
                resultContent = content;
                curInfo = info;
            }
        }
        if (resultContent == null) {
            resultContent = this.createNewContent();
        }
        String title = this.getNextTitle(resultSetIndex);
        resultContent.setDisplayName(title);
        GridInfo gridInfo = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)resultContent);
        gridInfo.originalTitle = DEFAULT_TITLE;
        gridInfo.major = this.myMajorRequestCount;
        gridInfo.minor = this.myMinorRequestCount;
        Content content = resultContent;
        if (content == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(1);
        }
        return content;
    }

    private static boolean isGeneratedName(@NotNull Content content) {
        GridInfo info;
        if (content == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(2);
        }
        return (info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content)) != null && content.getDisplayName().startsWith(info.originalTitle);
    }

    private String getNextTitle(int resultSetIndex) {
        StringBuilder title = new StringBuilder(DEFAULT_TITLE).append(" ").append(this.myMajorRequestCount);
        if (this.myMinorRequestCount > 1 || resultSetIndex > 1) {
            title.append("-").append(this.myMinorRequestCount);
        }
        if (resultSetIndex > 1) {
            title.append("-").append(resultSetIndex);
        }
        return title.toString();
    }

    @Override
    public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
        if (context == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(3);
        }
        if (!this.myConsole.isValid()) {
            return;
        }
        Content content = this.myCurrentContent = this.getPreparedContentFor(context, resultSetIndex);
        this.updateContentTitle(content, context, infos);
        DataGrid dataGrid = ConsoleDataConsumer.getNotNullDataGrid(content);
        this.myConsole.getUi().setBouncing(content, true);
        dataGrid.resetFilters();
        ConsoleDataConsumer.consumerFor(dataGrid).setColumns(context, resultSetIndex, infos, firstRowNum);
    }

    public void onRequestStartedEDT(@NotNull DataRequest.Context context) {
        int queryIndex;
        if (context == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(4);
        }
        if (!this.myConsole.isValid()) {
            return;
        }
        if (!(context.request instanceof DataRequest.QueryRequest)) {
            return;
        }
        int n = queryIndex = context.request instanceof ConsoleDataRequest ? ((ConsoleDataRequest)context.request).queryIndex : 0;
        if (queryIndex == 0) {
            ++this.myMajorRequestCount;
            this.myMinorRequestCount = 1;
        } else {
            ++this.myMinorRequestCount;
        }
    }

    public void onRequestTakesTimeEDT(@NotNull DataRequest.Context context) {
        ConsoleDataRequest request;
        SqlTableType type;
        if (context == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(5);
        }
        SqlTableType sqlTableType = type = (request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class)) != null ? (SqlTableType)ObjectUtils.tryCast((Object)request.resultType, SqlTableType.class) : null;
        if (type == null || !this.myConsole.isValid()) {
            return;
        }
        Content content = this.getPreparedContentFor(context, 1);
        this.updateContentTitle(content, context, null);
        DataGrid dataGrid = ConsoleDataConsumer.getNotNullDataGrid(content);
        if (dataGrid.isEmpty()) {
            DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
            List<DataConsumer.Column> columns2 = DbSqlUtil.createColumnsFromType(this.myConsole.getProject(), dialect, type, "", "", "");
            ConsoleDataConsumer.consumerFor(dataGrid).setColumns(context, 1, columns2.toArray(new DataConsumer.Column[columns2.size()]), 1);
        }
    }

    public void onRequestFinishedEDT(@NotNull DataRequest.Context context) {
        Collection contents;
        if (context == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(6);
        }
        if ((contents = this.myPreparedContentMap.remove((Object)context.request)) == null) {
            return;
        }
        for (Content content : contents) {
            if (!content.isValid()) continue;
            DataGrid dataGrid = ConsoleDataConsumer.getNotNullDataGrid(content);
            DataGridUtil.setProgressMessage(dataGrid, null);
        }
    }

    @NotNull
    public Content getPreparedContentFor(@NotNull DataRequest.Context context, int resultSetIndex) {
        if (context == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(7);
        }
        Content preparedContent = resultSetIndex == 1 ? (Content)ContainerUtil.getFirstItem((Collection)this.myPreparedContentMap.get((Object)context.request)) : null;
        Content content = preparedContent != null && preparedContent.isValid() ? preparedContent : this.reuseOrCreateContent(resultSetIndex);
        this.myPreparedContentMap.putValue((Object)context.request, (Object)content);
        content.setDescription(context.getQuery());
        DataGrid dataGrid = ConsoleDataConsumer.getNotNullDataGrid(content);
        DataGridUtil.setProgressMessage(dataGrid, "");
        this.myConsole.showConsole(true, false).done(unused -> {
            if (content.isValid()) {
                content.getManager().setSelectedContent(content, false, false);
            }
        });
        Content content2 = content;
        if (content2 == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(8);
        }
        return content2;
    }

    @Override
    public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
        Content content;
        if (context == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(9);
        }
        if ((content = this.getValidCurrentContent()) == null) {
            return;
        }
        DataGrid dataGrid = ConsoleDataConsumer.getNotNullDataGrid(content);
        ConsoleDataConsumer.consumerFor(dataGrid).addRows(context, rows);
    }

    @Nullable
    private Content getValidCurrentContent() {
        return this.myConsole.isValid() && this.myCurrentContent != null && this.myCurrentContent.isValid() ? this.myCurrentContent : null;
    }

    @NotNull
    private Content createNewContent() {
        DataGrid dataGrid = this.createTableResultPanel();
        Object target = this.myConsole.getTarget();
        if (target instanceof DatabaseSystem) {
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)this.myConsole.getProject()).findDataSource(((DatabaseSystem)target).getUniqueId());
            DatabaseGridDataHookUp hookup = (DatabaseGridDataHookUp)ObjectUtils.assertNotNull((Object)DataGridUtil.getDatabaseHookUp(dataGrid));
            hookup.setDataSource(dataSource);
            hookup.setAutoCommit(DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource).isAutoCommit());
        }
        Content content = this.addContent(this.myConsole.getUi(), dataGrid, "");
        GRID_INFO_KEY.set((UserDataHolder)content, (Object)new GridInfo(dataGrid));
        Disposer.register((Disposable)content, (Disposable)dataGrid);
        Content content2 = content;
        if (content2 == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(10);
        }
        return content2;
    }

    private void updateContentTitle(@NotNull Content content, @NotNull DataRequest.Context context, @Nullable DataConsumer.Column[] infos) {
        if (content == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(12);
        }
        DataGrid dataGrid = ConsoleDataConsumer.getNotNullDataGrid(content);
        ((GridInfo)ConsoleDataConsumer.GRID_INFO_KEY.get((UserDataHolder)content)).path = Ref.create((Object)context.getSearchPath());
        if (context.request instanceof ConsoleDataRequest && this.myConsole instanceof JdbcConsole) {
            String name;
            ConsoleDataRequest request = (ConsoleDataRequest)context.request;
            DasTable table = DbSqlUtil.detectTable(this.myConsole.getProject(), this.myConsole.getLanguageConsole().getLanguage(), DbSqlUtil.findAnyContext(this.myConsole.getProject(), ((JdbcConsole)this.myConsole).getDataSource(), ((JdbcConsole)this.myConsole).getCurrentNamespace()), context.getQuery(), request, infos == null ? Collections.emptyList() : Arrays.asList(infos));
            ((DatabaseGridDataHookUp)ObjectUtils.assertNotNull((Object)DataGridUtil.getDatabaseHookUp(dataGrid))).setDatabaseTable(table);
            DatabaseEditorHelper.updateToolbarColor(this.myConsole.getProject(), this.myConsole.getLanguageConsole().getVirtualFile(), (JComponent)ObjectUtils.tryCast((Object)dataGrid.getTopComponent(), EditorHeaderComponent.class));
            if (content.isPinned()) {
                return;
            }
            if (table != null) {
                name = QNameUtil.getQualifiedName((DasObject)table);
            } else if (request.resultType instanceof SqlTableType && ((SqlTableType)request.resultType).getColumnCount() == 1) {
                name = ((SqlTableType)request.resultType).getDisplayName();
                if (name.startsWith("(") && name.endsWith(")")) {
                    name = name.substring(1, name.length() - 1);
                }
            } else {
                name = null;
            }
            if (name != null) {
                String adjustedName = StringUtil.firstLast((String)name, (int)40);
                content.setDisplayName(new UniqueNameGenerator(Arrays.asList(this.myConsole.getUi().getContents()), c -> {
                    if (content == null) {
                        ConsoleDataConsumer.$$$reportNull$$$0(18);
                    }
                    return StringUtil.notNullize((String)(content == c ? null : c.getDisplayName()));
                }).generateUniqueName(adjustedName, "", "", " ", ""));
                ((GridInfo)ConsoleDataConsumer.GRID_INFO_KEY.get((UserDataHolder)content)).originalTitle = content.getDisplayName();
            }
        }
    }

    protected DataGrid createTableResultPanel() {
        Disposable hookUpParent = Disposer.newDisposable();
        GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp = this.myConsole.createGridDataHookUp(hookUpParent);
        ActionGroup popupGroup = DataGridUtil.getGridPopupActions();
        ActionGroup columnHeaderPopupGroup = DataGridUtil.getGridColumnHeaderPopupActions();
        TableResultPanel grid = new TableResultPanel(this.myConsole.getProject(), hookUp, popupGroup, popupGroup, columnHeaderPopupGroup, null, DataGrid.Place.EDITOR, true){
            {
                new DumbAwareAction("escape"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Project project;
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((project = e.getProject()) != null) {
                            ToolWindowManager.getInstance((Project)project).activateEditorComponent();
                        }
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        e.getPresentation().setEnabledAndVisible(!this.isEditing());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/database/run/ConsoleDataConsumer$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.registerCustomShortcutSet(27, 0, (JComponent)((Object)this.getTable()));
            }

            @Override
            @NotNull
            public String getDisplayName() {
                JBLoadingPanel component = this.getComponent();
                Content content = ConsoleDataConsumer.this.myConsole.getUi().getContentManager().getContent((JComponent)component);
                String string = "grid:" + (content == null ? "" : content.getTabName());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            protected Object getData(@NonNls String dataId) {
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    return ConsoleDataConsumer.this.getOrCreateEditorWrapper(this);
                }
                return super.getData(dataId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleDataConsumer$1", "getDisplayName"));
            }
        };
        Disposer.register((Disposable)grid, (Disposable)hookUpParent);
        DataGridUtil.setupProgressIndicatingAuditor(grid);
        return grid;
    }

    private FileEditor getOrCreateEditorWrapper(final DataGrid resultPanel) {
        JComponent dataGridComponent = resultPanel.getComponent();
        TableEditorBase editor = (TableEditorBase)((Object)UIUtil.getClientProperty((Object)dataGridComponent, FILE_EDITOR_KEY));
        if (editor == null) {
            editor = new TableEditorBase(this.myConsole.getProject()){

                @Override
                @NotNull
                public DataGrid getDataGrid() {
                    DataGrid dataGrid = resultPanel;
                    if (dataGrid == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return dataGrid;
                }

                @Override
                @NotNull
                public String getName() {
                    if (!ConsoleDataConsumer.this.myConsole.isValid()) {
                        String string = super.getName();
                        if (string == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    for (Content content : ConsoleDataConsumer.this.myConsole.getUi().getContents()) {
                        if (ConsoleDataConsumer.getDataGrid(content) != resultPanel) continue;
                        String string = content.getTabName();
                        if (string == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return string;
                    }
                    String string = super.getName();
                    if (string == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/database/run/ConsoleDataConsumer$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getDataGrid";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            dataGridComponent.putClientProperty(FILE_EDITOR_KEY, (Object)editor);
            Disposer.register((Disposable)resultPanel, (Disposable)editor);
        }
        return editor;
    }

    private Content addContent(RunnerLayoutUi ui, DataGrid dataGrid, String title) {
        String contentId = "ResultTab#" + this.myMajorRequestCount + "." + this.myMinorRequestCount;
        Content content = ui.createContent(contentId, (ComponentWithActions)new ComponentWithActions.Impl(dataGrid.getComponent()), title, DatabaseIcons.Table, dataGrid.getPreferredFocusedComponent());
        content.setCloseable(true);
        content.setPinnable(true);
        DataGridUtil.addGridHeaderComponent(dataGrid, this.myConsole.getLanguageConsole().getVirtualFile());
        ui.addContent(content, 0, this.getPlaceInGrid(), false);
        return content;
    }

    @NotNull
    private static DataGrid getNotNullDataGrid(@NotNull Content content) {
        if (content == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(13);
        }
        DataGrid dataGrid = ConsoleDataConsumer.getDataGrid(content);
        if (dataGrid == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(14);
        }
        return dataGrid;
    }

    @Nullable
    public static DataGrid getDataGrid(@NotNull Content content) {
        GridInfo info;
        if (content == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(15);
        }
        return (info = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content)) != null ? info.grid : null;
    }

    @NotNull
    private static DataConsumer consumerFor(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(16);
        }
        DataBusGridDataHookUp.DataBusLoader dataBusLoader = ((DataBusGridDataHookUp)ObjectUtils.assertNotNull((Object)DataGridUtil.getDataBusHookUp(dataGrid))).getLoader();
        if (dataBusLoader == null) {
            ConsoleDataConsumer.$$$reportNull$$$0(17);
        }
        return dataBusLoader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleDataConsumer";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleDataConsumer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "reuseOrCreateContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedContentFor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewContent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullDataGrid";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "consumerFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "afterLastRowAdded";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStartedEDT";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onRequestTakesTimeEDT";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinishedEDT";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedContentFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateContentTitle";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullDataGrid";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDataGrid";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "consumerFor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateContentTitle$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GridInfo {
        final DataGrid grid;
        String originalTitle;
        int major;
        int minor;
        Ref<SearchPath> path;

        GridInfo(DataGrid grid) {
            this.grid = grid;
        }
    }
}

