/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.GridAction;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class RenameTabAction
extends DumbAwareAction
implements GridAction {
    @Nullable
    private static Content getContent(DataContext dataContext) {
        Content[] contents = (Content[])ViewContext.CONTENT_KEY.getData(dataContext);
        if (contents == null || contents.length != 1) {
            return null;
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(DataManager.getInstance().getDataContext((Component)contents[0].getComponent()));
        return dataGrid != null ? contents[0] : null;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(RenameTabAction.getContent(e.getDataContext()) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Content content = RenameTabAction.getContent(e.getDataContext());
        if (content == null) {
            return;
        }
        String newName = Messages.showInputDialog((Project)RenameTabAction.getEventProject((AnActionEvent)e), (String)"Enter new name:", (String)("Rename '" + content.getDisplayName() + "' Tab"), (Icon)Messages.getQuestionIcon());
        if (StringUtil.isNotEmpty((String)newName)) {
            content.setDisplayName(newName);
            content.setPinned(true);
        }
    }
}

