/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.IntIntFunction;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.GridColorModelImpl;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.Mutation;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.actions.DeleteRowsAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.GridSelectionGrower;
import com.intellij.database.run.ui.HiddenColumnsSelectionHolder;
import com.intellij.database.run.ui.MutationSupport;
import com.intellij.database.run.ui.TableResultRowHeader;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.run.ui.grid.DefaultGridColumnLayout;
import com.intellij.database.run.ui.grid.DummyGridColumnLayout;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridCopyProvider;
import com.intellij.database.run.ui.grid.GridFilterPanel;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridMarkupModelImpl;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridPasteProvider;
import com.intellij.database.run.ui.grid.GridRawIndexConverter;
import com.intellij.database.run.ui.grid.GridRowComparator;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.grid.GridScrollPane;
import com.intellij.database.run.ui.grid.GridScrollPosition;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.database.run.ui.grid.GridSelection;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactories;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.RangeFormatResolver;
import com.intellij.database.run.ui.grid.selection.GridSelectionModel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.JBAutoscroller;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.table.JBTable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableResultPanel
extends UserDataHolderBase
implements DataGrid,
GridModel.Listener<DataConsumer.Row, DataConsumer.Column>,
MutationSupport,
GridSearchSession.Listener {
    private static final String XML_LANGUAGE_ID = "XML";
    private static final String JSON_LANGUAGE_ID = "JSON";
    private ErrorNotificationPanel myErrorNotificationPanel;
    private final GridMainPanel myMainPanel;
    private final TableResultView myTable;
    private final ActionGroup myPopupActionGroup;
    private final ColumnAttributes myColumnAttributes;
    private final GridColumnLayout<DataConsumer.Row, DataConsumer.Column> myColumnLayout;
    private final Project myProject;
    private final ObjectFormatter myConverter;
    protected final GridFilterPanel myFilterPanel;
    private final EventDispatcher<DataGridListener> myEventDispatcher;
    private final GridMarkupModel<DataConsumer.Row, DataConsumer.Column> myMarkupModel;
    private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myDataHookUp;
    private final JScrollPane myScrollPane;
    private final GridRowHeader myRowHeader;
    private final HiddenColumnsSelectionHolder myHiddenColumnSelectionHolder;
    private final JBAutoscroller.AutoscrollLocker myAutoscrollLocker;
    private final GridSelectionGrower myGrower;
    private final GridColorModel myColorModel;
    private final SelectionModel<DataConsumer.Row, DataConsumer.Column> mySelectionModel;
    private GridSearchSession<DataConsumer.Row, DataConsumer.Column> mySearchSession;
    private boolean myReady;

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions, @NotNull DataGrid.Place place) {
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            TableResultPanel.$$$reportNull$$$0(2);
        }
        if (place == null) {
            TableResultPanel.$$$reportNull$$$0(3);
        }
        this(project, dataHookUp, popupActions, popupActions, DataGridUtil.getGridColumnHeaderPopupActions(), null, place, false);
    }

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions, @NotNull ActionGroup gutterPopupActions, @NotNull ActionGroup columnHeaderPopupActions, @Nullable GridCellEditorFactoryProvider cellEditorFactoryProvider, @NotNull DataGrid.Place place, boolean useConsoleFonts) {
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(4);
        }
        if (dataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(5);
        }
        if (popupActions == null) {
            TableResultPanel.$$$reportNull$$$0(6);
        }
        if (gutterPopupActions == null) {
            TableResultPanel.$$$reportNull$$$0(7);
        }
        if (columnHeaderPopupActions == null) {
            TableResultPanel.$$$reportNull$$$0(8);
        }
        if (place == null) {
            TableResultPanel.$$$reportNull$$$0(9);
        }
        this.myConverter = new ObjectFormatter();
        this.myEventDispatcher = EventDispatcher.create(DataGridListener.class);
        this.myReady = true;
        this.myProject = project;
        this.myPopupActionGroup = popupActions;
        this.myMarkupModel = new GridMarkupModelImpl<DataConsumer.Row, DataConsumer.Column>();
        this.myHiddenColumnSelectionHolder = new HiddenColumnsSelectionHolder();
        this.myGrower = new GridSelectionGrower(this);
        this.myAutoscrollLocker = new JBAutoscroller.AutoscrollLocker();
        this.myDataHookUp = dataHookUp;
        this.installDataHookUpListeners();
        this.myFilterPanel = new GridFilterPanel(this.myProject, this);
        this.myFilterPanel.setVisible(this.isFilteringEnabledInModel());
        this.myMainPanel = new GridMainPanel(this);
        DataManager.registerDataProvider((JComponent)((Object)this.myMainPanel), this::getData);
        this.myMainPanel.setLoadingText("");
        this.myColumnAttributes = new ColumnAttributes();
        this.myTable = this.createTableView((GridCellEditorFactoryProvider)ObjectUtils.notNull((Object)cellEditorFactoryProvider, (Object)GridCellEditorFactories.getInstance()), useConsoleFonts, columnHeaderPopupActions);
        this.mySelectionModel = new GridSelectionModel(this.myTable, this, this.myAutoscrollLocker, this.myHiddenColumnSelectionHolder);
        this.myColorModel = new GridColorModelImpl(this, this.myTable, (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.getMutator(), DatabaseMutatorImpl.class));
        this.myRowHeader = this.createRowHeader(gutterPopupActions);
        this.myTable.getEmptyText().setText("");
        this.myTable.setSelectionMode(2);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setAutoResizeMode(0);
        this.myTable.setBackground(this.myMainPanel.getBackground());
        this.myTable.setShowGrid(true);
        this.registerEscapeAction();
        this.myScrollPane = new GridScrollPane((JTable)((Object)this.myTable), this.myTable.getTableHeader(), this.myRowHeader, (JComponent)((Object)new MyCornerToolsComponent()), this.myAutoscrollLocker){

            protected void processMouseWheelEvent(MouseWheelEvent e) {
                if (EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() && !MouseGestureManager.getInstance().hasTrackpad() && EditorUtil.isChangeFontSize((MouseWheelEvent)e)) {
                    int rotation = e.getWheelRotation();
                    if (rotation != 0) {
                        TableResultPanel.this.myTable.changeFontSize(-rotation, 1.0);
                    }
                    return;
                }
                super.processMouseWheelEvent(e);
            }

            public void paint(Graphics g) {
                TableResultPanel.this.myTable.startPaintingSession();
                try {
                    super.paint(g);
                }
                finally {
                    TableResultPanel.this.myTable.endPaintingSession();
                }
            }
        };
        this.myMainPanel.add(this.myScrollPane, "Center");
        this.myTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (JBSwingUtilities.isRightMouseButton((MouseEvent)e)) {
                    int rowIndex = TableResultPanel.this.myTable.rowAtPoint(e.getPoint());
                    int columnIndex = TableResultPanel.this.myTable.columnAtPoint(e.getPoint());
                    if (rowIndex >= 0 && columnIndex >= 0 && !TableResultPanel.this.myTable.isCellSelected(rowIndex, columnIndex)) {
                        GridSelection.setRowSelection((JTable)((Object)TableResultPanel.this.myTable), rowIndex);
                        GridSelection.setColumnSelection((JTable)((Object)TableResultPanel.this.myTable), columnIndex);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$2", "mousePressed"));
            }
        });
        this.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ((DataGridListener)TableResultPanel.this.myEventDispatcher.getMulticaster()).onSelectionChanged(TableResultPanel.this);
                TableResultPanel.this.getScrollPane().repaint();
                DataGridUtil.updateWidgets(TableResultPanel.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$3", "valueChanged"));
            }
        });
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                TableResultPanel.this.myHiddenColumnSelectionHolder.setWholeRowSelected(false);
                TableResultPanel.this.myGrower.reset();
                TableResultPanel.this.getScrollPane().repaint();
                DataGridUtil.updateWidgets(TableResultPanel.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$4", "valueChanged"));
            }
        });
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                if (!TableResultPanel.this.stopEditing()) {
                    TableResultPanel.this.cancelEditing();
                }
                if (TableResultPanel.this.myPopupActionGroup != ActionGroup.EMPTY_GROUP) {
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultPanel.this.myPopupActionGroup).getComponent().show(comp, x, y);
                }
            }
        });
        this.myColumnLayout = ApplicationManager.getApplication().isUnitTestMode() ? new DummyGridColumnLayout() : new DefaultGridColumnLayout(this);
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel != null) {
            sortingModel.addListener(new GridSortingModel.Listener(){

                @Override
                public void orderingChanged() {
                    TableResultPanel.this.updateColumnAttributes();
                    TableResultPanel.this.updateSortKeysFromColumnAttributes();
                }
            }, this);
        }
        if (this.getDataModel().getColumnCount() != 0) {
            DbUIUtil.invokeLaterIfNeeded(() -> {
                this.columnsAdded(this.getDataModel().getColumnIndices());
                this.myTable.layoutColumns();
            });
        }
        place.customize(this);
    }

    @NotNull
    public GridColorModel getColorModel() {
        GridColorModel gridColorModel = this.myColorModel;
        if (gridColorModel == null) {
            TableResultPanel.$$$reportNull$$$0(10);
        }
        return gridColorModel;
    }

    public GridColumnLayout<DataConsumer.Row, DataConsumer.Column> getColumnLayout() {
        return this.myColumnLayout;
    }

    public JBAutoscroller.AutoscrollLocker getAutoscrollLocker() {
        return this.myAutoscrollLocker;
    }

    HiddenColumnsSelectionHolder getHiddenColumnSelectionHolder() {
        return this.myHiddenColumnSelectionHolder;
    }

    ColumnAttributes getColumnAttributes() {
        return this.myColumnAttributes;
    }

    @NotNull
    protected GridRowHeader createRowHeader(ActionGroup popupActions) {
        TableResultRowHeader tableResultRowHeader = new TableResultRowHeader(this, popupActions);
        if (tableResultRowHeader == null) {
            TableResultPanel.$$$reportNull$$$0(11);
        }
        return tableResultRowHeader;
    }

    @NotNull
    protected TableResultView createTableView(@NotNull GridCellEditorFactoryProvider editorProvider, boolean useConsoleFonts, @NotNull ActionGroup headerActions) {
        if (editorProvider == null) {
            TableResultPanel.$$$reportNull$$$0(12);
        }
        if (headerActions == null) {
            TableResultPanel.$$$reportNull$$$0(13);
        }
        TableResultView tableResultView = new TableResultView(this, editorProvider, useConsoleFonts, headerActions);
        if (tableResultView == null) {
            TableResultPanel.$$$reportNull$$$0(14);
        }
        return tableResultView;
    }

    @NotNull
    protected RowFilter<TableModel, Integer> createFilter() {
        RowFilter rowFilter = this.isTransposed() ? new MyTransposedViewColumnFilter() : new MySearchRowFilter();
        if (rowFilter == null) {
            TableResultPanel.$$$reportNull$$$0(15);
        }
        return rowFilter;
    }

    private void installDataHookUpListeners() {
        this.myDataHookUp.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){

            @Override
            public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message, @Nullable Throwable th) {
                if (source == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (message != null) {
                    Throwable throwable = new Throwable(message);
                    throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
                    th = throwable;
                }
                if (th != null) {
                    TableResultPanel.this.handleError(source, th);
                }
                if (source.source instanceof DataGridRequestSource) {
                    ((DataGridRequestSource)((Object)source.source)).setErrorReported();
                }
            }

            @Override
            public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount) {
                if (source == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (source.source instanceof DataGridRequestSource) {
                    ((DataGridRequestSource)((Object)source.source)).setUpdateCount(updateCount);
                }
            }

            @Override
            public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                if (source == null) {
                    7.$$$reportNull$$$0(2);
                }
                this.doRepaint(source);
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                DataGridRequestSource requestSource = (DataGridRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, DataGridRequestSource.class));
                if (requestSource == null) {
                    return;
                }
                if (!requestSource.isForceSuccess()) {
                    this.countRows(requestSource, success);
                }
                requestSource.requestComplete(success);
            }

            private void countRows(@NotNull DataGridRequestSource requestSource, boolean success) {
                int actualUpdateCount;
                int expectedUpdateCount;
                if (requestSource == null) {
                    7.$$$reportNull$$$0(3);
                }
                if (success && !requestSource.isErrorReported() && DataGridUtil.getDataBusHookUp(TableResultPanel.this) != null && (expectedUpdateCount = requestSource.getRows().size()) != (actualUpdateCount = requestSource.getUpdateCount())) {
                    Exception e = new Exception(actualUpdateCount + " rows updated.");
                    e.setStackTrace(new StackTraceElement[0]);
                    TableResultPanel.this.showError(e, requestSource);
                }
            }

            private void doRepaint(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
                if (source == null) {
                    7.$$$reportNull$$$0(4);
                }
                if (!(source.source instanceof DataGridRequestSource)) {
                    return;
                }
                DataGridRequestSource requestSource = (DataGridRequestSource)((Object)source.source);
                if (!requestSource.isForceSuccess()) {
                    return;
                }
                TableResultPanel.this.myTable.repaint(50L);
                TableResultPanel.this.myRowHeader.repaint(50L);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "requestSource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCountReceived";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestFinished";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "countRows";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doRepaint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
        this.getDataModel().addListener(this, this);
    }

    @Override
    public void columnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        List<DataConsumer.Column> columns2 = this.getDataModel().getColumns();
        if (!this.isTransposed()) {
            this.myTable.getColumnCache().retainColumns(columns2);
        }
        this.myColumnAttributes.newColumns(this, columns2);
        this.updateColumnAttributes();
        this.updateSortKeysFromColumnAttributes();
        if (!this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myTable.getModel().columnsAdded(columnIndices);
        this.myTable.dropCaches();
        this.myColumnLayout.newColumnsAdded(columnIndices);
        this.trueLayout();
    }

    @Override
    public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns2) {
        this.myTable.getModel().columnsRemoved(columns2);
        if (!this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myTable.dropCaches();
        this.trueLayout();
    }

    @Override
    public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
        this.myTable.getModel().rowsAdded(rows);
        if (this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myColumnLayout.newRowsAdded(rows);
        this.trueLayout();
    }

    @Override
    public void setCommonEditorValue(@Nullable Object object) {
        this.myTable.setCommonEditorValue(object);
    }

    @Override
    public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
        this.myTable.getModel().rowsRemoved(rows);
        if (this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.trueLayout();
    }

    @Override
    public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns2) {
        this.myTable.getModel().cellsUpdated(rows, columns2);
        this.myColumnLayout.newRowsAdded(rows);
    }

    private void registerEscapeAction() {
        String action = "grid.escape";
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), action);
        this.myTable.getActionMap().put(action, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableResultPanel.this.myErrorNotificationPanel != null) {
                    TableResultPanel.this.hideErrorPanel();
                } else if (TableResultPanel.this.mySearchSession != null) {
                    TableResultPanel.this.mySearchSession.close();
                }
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && !TableResultPanel.this.isEditing() && (TableResultPanel.this.myErrorNotificationPanel != null || TableResultPanel.this.mySearchSession != null);
            }
        });
    }

    @Override
    public boolean isSortViaOrderBySupported() {
        return this.myDataHookUp.getSortingModel() != null;
    }

    @Override
    public boolean isSortViaOrderBy() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        return sortingModel != null && sortingModel.isSortingEnabled();
    }

    @Override
    public void setSortViaOrderBy(boolean sortViaOrderBy) {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return;
        }
        boolean reload = this.updateDataOrdering(false) || sortingModel.isSortingEnabled() != sortViaOrderBy;
        sortingModel.setSortingEnabled(sortViaOrderBy);
        if (reload && this.isSafeToReload()) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
    }

    public void setOrdering(List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering) {
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> o : ordering) {
            ModelIndex<DataConsumer.Column> columnIdx = o.getColumn();
            DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
            this.myColumnAttributes.changeSortOrder(column, o.getOrder());
        }
        this.updateSortKeysFromColumnAttributes();
    }

    @Override
    @NotNull
    public RowSortOrder.Type getSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        int sortOrder;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(16);
        }
        int n = sortOrder = this.shouldExposeSortingInfo() ? this.getSortOrder(this.getDataModel().getColumn(columnIdx)) : 0;
        RowSortOrder.Type type = sortOrder == 0 ? RowSortOrder.Type.UNSORTED : (sortOrder < 0 ? RowSortOrder.Type.ASC : RowSortOrder.Type.DESC);
        if (type == null) {
            TableResultPanel.$$$reportNull$$$0(17);
        }
        return type;
    }

    @Override
    public int getThenBySortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(18);
        }
        return this.shouldExposeSortingInfo() ? Math.abs(this.getSortOrder(this.getDataModel().getColumn(columnIdx))) : 0;
    }

    private boolean shouldExposeSortingInfo() {
        return !this.isTransposed() || this.isSortViaOrderBy();
    }

    protected int getSortOrder(@Nullable DataConsumer.Column column) {
        return column != null ? this.myColumnAttributes.getSortOrder(column) : 0;
    }

    @Override
    public void addDataGridListener(DataGridListener listener, Disposable disposable) {
        this.myEventDispatcher.addListener((EventListener)listener, disposable);
    }

    private void addSelectionListener(ListSelectionListener selectionListener) {
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
    }

    @Override
    @NotNull
    public GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myTable.getColorsScheme();
        if (gridColorsScheme == null) {
            TableResultPanel.$$$reportNull$$$0(19);
        }
        return gridColorsScheme;
    }

    @Override
    @Nullable
    public JComponent getCellRendererComponent(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        int column;
        if (rowIdx == null) {
            TableResultPanel.$$$reportNull$$$0(20);
        }
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(21);
        }
        ViewIndex<DataConsumer.Row> viewRow = rowIdx.toView(this);
        ViewIndex<DataConsumer.Column> viewColumn = columnIdx.toView(this);
        if (!viewRow.isValid(this) || !viewColumn.isValid(this)) {
            return null;
        }
        int row = (this.isTransposed() ? viewColumn : viewRow).asInteger();
        TableCellRenderer renderer = this.myTable.getCellRenderer(row, column = (this.isTransposed() ? viewRow : viewColumn).asInteger());
        if (renderer == null) {
            return null;
        }
        return (JComponent)this.myTable.prepareRenderer(renderer, row, column);
    }

    @Override
    public void searchSessionStarted(@NotNull GridSearchSession<DataConsumer.Row, DataConsumer.Column> searchSession) {
        if (searchSession == null) {
            TableResultPanel.$$$reportNull$$$0(22);
        }
        assert (this.mySearchSession == null);
        this.mySearchSession = searchSession;
        this.mySearchSession.addListener(this, this);
        this.searchSessionUpdated();
    }

    @Override
    public void searchSessionStopped(@NotNull GridSearchSession<DataConsumer.Row, DataConsumer.Column> searchSession) {
        if (searchSession == null) {
            TableResultPanel.$$$reportNull$$$0(23);
        }
        assert (this.mySearchSession == searchSession);
        this.mySearchSession = null;
        this.searchSessionUpdated();
    }

    @Override
    @Nullable
    public GridSearchSession<DataConsumer.Row, DataConsumer.Column> getSearchSession() {
        return this.mySearchSession;
    }

    @Override
    public void searchSessionUpdated() {
        this.myTable.updateRowFilter();
        this.getComponent().repaint();
    }

    protected TableResultView getTable() {
        return this.myTable;
    }

    public JBTable getTableView() {
        return this.myTable;
    }

    protected TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
        return this.myColumnAttributes.getSortOrderMap();
    }

    @Override
    public ObjectFormatter getObjectFormatter() {
        return this.myConverter;
    }

    @Override
    public boolean isEditable() {
        return !this.myDataHookUp.isReadOnly() && GridEditGuard.get(this) == null;
    }

    @Override
    public boolean isCellEditingAllowed() {
        return true;
    }

    @Override
    public void setCells(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns2, @Nullable Object value) {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(24);
        }
        if (columns2 == null) {
            TableResultPanel.$$$reportNull$$$0(25);
        }
        if ((mutator = this.myDataHookUp.getMutator()) != null && this.isSafeToUpdate(rows, columns2, value)) {
            DataGridRequestSource source = new DataGridRequestSource(rows, columns2);
            mutator.mutate(GridRequestSource.create(this, (Object)source), rows, columns2, value);
        }
    }

    @Override
    public boolean isEditingCellMaximized() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        return resizableCellEditorsSupport != null && resizableCellEditorsSupport.isEditingCellMaximized();
    }

    @Override
    public boolean canMaximizeEditingCell() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        return resizableCellEditorsSupport != null && resizableCellEditorsSupport.canMaximizeEditingCell();
    }

    @Override
    public void maximizeEditingCell() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        if (resizableCellEditorsSupport != null) {
            resizableCellEditorsSupport.maximizeEditingCell();
        }
    }

    Project getProject() {
        return this.myProject;
    }

    @Override
    public void insertRow() {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            this.submit().doWhenDone(() -> mutator.insertRow(this.newInsertOrCloneRowRequestSource()));
            return;
        }
        mutator.insertRow(this.newInsertOrCloneRowRequestSource());
    }

    @Override
    public void cloneRow(@NotNull ModelIndex<DataConsumer.Row> rowToClone) {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rowToClone == null) {
            TableResultPanel.$$$reportNull$$$0(26);
        }
        if ((mutator = this.getRowsMutator()) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            this.submit().doWhenDone(() -> {
                if (rowToClone == null) {
                    TableResultPanel.$$$reportNull$$$0(113);
                }
                mutator.cloneRow(this.newInsertOrCloneRowRequestSource(), rowToClone);
            });
            return;
        }
        mutator.cloneRow(this.newInsertOrCloneRowRequestSource(), rowToClone);
    }

    private GridRequestSource<DataConsumer.Row, DataConsumer.Column> newInsertOrCloneRowRequestSource() {
        DataGridRequestSource source = new DataGridRequestSource(this);
        source.doWhenDone(() -> {
            if (this.myTable.isEditing()) {
                return;
            }
            GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
            ModelIndex<DataConsumer.Row> row = mutator != null ? mutator.getLastInsertedRow() : ModelIndex.forRow(this, -1);
            row = row != null && row.isValid(this) ? row : ModelIndex.forRow(this, this.getDataModel().getRowCount() - 1);
            this.scrollToLocally(row.toView(this), ViewIndex.forColumn(this, 0));
        });
        return GridRequestSource.create(this, (Object)source);
    }

    @Override
    public void insertColumn() {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator == null) {
            return;
        }
        this.submit().doWhenDone(() -> mutator.insertColumn(GridRequestSource.create(this, (Object)this.newInsertOrCloneColumnRequestSource())));
    }

    @Override
    public void cloneColumn(@NotNull ModelIndex<DataConsumer.Column> columnToClone) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (columnToClone == null) {
            TableResultPanel.$$$reportNull$$$0(27);
        }
        if ((mutator = this.getColumnsMutator()) == null) {
            return;
        }
        this.submit().doWhenDone(() -> {
            if (columnToClone == null) {
                TableResultPanel.$$$reportNull$$$0(112);
            }
            mutator.cloneColumn(GridRequestSource.create(this, (Object)this.newInsertOrCloneColumnRequestSource()), columnToClone);
        });
    }

    private DataGridRequestSource newInsertOrCloneColumnRequestSource() {
        DataGridRequestSource source = new DataGridRequestSource(this);
        source.doWhenDone(() -> {
            ModelIndex<DataConsumer.Column> column = ModelIndex.forColumn(this, this.getDataModel().getColumnCount() - 1);
            this.scrollToLocally(ViewIndex.forRow(this, 0), column.toView(this));
        });
        return source;
    }

    @Override
    public void deleteRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        boolean canDelete;
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(28);
        }
        if ((mutator = this.getRowsMutator()) == null) {
            return;
        }
        boolean areRowsInserted = true;
        for (ModelIndex index : rows.asIterable()) {
            areRowsInserted &= mutator.isInsertedRow(index);
        }
        boolean bl = canDelete = !mutator.hasPendingChanges() || !mutator.isUpdateImmediately() || areRowsInserted || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
        if (!canDelete) {
            return;
        }
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        DataGridRequestSource source = new DataGridRequestSource(rows, ModelIndexSet.forColumns(this, new int[0]));
        mutator.deleteRows(GridRequestSource.create(this, (Object)source), rows);
        source.doWhenDone(() -> this.myAutoscrollLocker.runWithLock(() -> selection.fit((JTable)((Object)this.myTable)).restore((JTable)((Object)this.myTable))));
    }

    @Override
    public void deleteColumns(@NotNull ModelIndexSet<DataConsumer.Column> columns2) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (columns2 == null) {
            TableResultPanel.$$$reportNull$$$0(29);
        }
        if ((mutator = this.getColumnsMutator()) != null) {
            DataGridRequestSource source = new DataGridRequestSource(ModelIndexSet.forRows(this, new int[0]), columns2);
            mutator.deleteColumns(GridRequestSource.create(this, (Object)source), columns2);
        }
    }

    @Override
    public boolean isColumnsMutationSupported() {
        return this.getColumnsMutator() != null;
    }

    @Override
    @NotNull
    public ActionCallback submit() {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDatabaseMutator();
        if (mutator == null || !mutator.hasPendingChanges()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TableResultPanel.$$$reportNull$$$0(30);
            }
            return actionCallback;
        }
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        DataGridRequestSource source = new DataGridRequestSource(mutator.getAffectedRows(), ModelIndexSet.forColumns(this, -1));
        mutator.submit(GridRequestSource.create(this, (Object)source), true);
        ActionCallback actionCallback = source.doWhenDone(() -> selection.fit((JTable)((Object)this.myTable)).restore((JTable)((Object)this.myTable)));
        if (actionCallback == null) {
            TableResultPanel.$$$reportNull$$$0(31);
        }
        return actionCallback;
    }

    @NotNull
    public GridMutationModel getMutationModel() {
        GridMutationModel gridMutationModel = new GridMutationModel(this.myDataHookUp.getMutator(), this, this.getDataModel(), this.myTable);
        if (gridMutationModel == null) {
            TableResultPanel.$$$reportNull$$$0(32);
        }
        return gridMutationModel;
    }

    @Override
    @NotNull
    public GridDataSupport getDataSupport() {
        GridMutationModel gridMutationModel = new GridMutationModel(this.myDataHookUp.getMutator(), this, this.getDataModel(), this.myTable);
        if (gridMutationModel == null) {
            TableResultPanel.$$$reportNull$$$0(33);
        }
        return gridMutationModel;
    }

    @Nullable
    private GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> getColumnsMutator() {
        GridMutator.ColumnsMutator mutator = (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.ColumnsMutator.class);
        return mutator;
    }

    @Override
    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (row == null) {
            TableResultPanel.$$$reportNull$$$0(34);
        }
        return (mutator = this.getRowsMutator()) != null && mutator.isInsertedRow(row);
    }

    @Override
    @NotNull
    public SelectionModel<DataConsumer.Row, DataConsumer.Column> getSelectionModel() {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            TableResultPanel.$$$reportNull$$$0(35);
        }
        return selectionModel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        DataRequest.OwnerEx ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(this.getDataHookup(), DataRequest.OwnerEx.class);
        String string = ownerEx != null ? StringUtil.notNullize((String)ownerEx.getDisplayName()) : "";
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Override
    @NotNull
    public GridMarkupModel<DataConsumer.Row, DataConsumer.Column> getMarkupModel() {
        GridMarkupModel<DataConsumer.Row, DataConsumer.Column> gridMarkupModel = this.myMarkupModel;
        if (gridMarkupModel == null) {
            TableResultPanel.$$$reportNull$$$0(37);
        }
        return gridMarkupModel;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getDataModel(@NotNull DataAccessType reason) {
        if (reason == null) {
            TableResultPanel.$$$reportNull$$$0(38);
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = reason.getModel(this);
        if (gridModel == null) {
            TableResultPanel.$$$reportNull$$$0(39);
        }
        return gridModel;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getDataModel() {
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = this.myDataHookUp.getModel();
        if (gridModel == null) {
            TableResultPanel.$$$reportNull$$$0(40);
        }
        return gridModel;
    }

    @Override
    @NotNull
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> getDataHookup() {
        GridDataHookUp<DataConsumer.Row, DataConsumer.Column> gridDataHookUp = this.myDataHookUp;
        if (gridDataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(41);
        }
        return gridDataHookUp;
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        GridRawIndexConverter gridRawIndexConverter = this.myTable.getRawIndexConverter();
        if (gridRawIndexConverter == null) {
            TableResultPanel.$$$reportNull$$$0(42);
        }
        return gridRawIndexConverter;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        TableResultView tableResultView = this.myTable;
        if (tableResultView == null) {
            TableResultPanel.$$$reportNull$$$0(43);
        }
        return tableResultView;
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            TableResultPanel.$$$reportNull$$$0(44);
        }
        return jScrollPane;
    }

    @Override
    @NotNull
    public JBLoadingPanel getLoadingPanel() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            TableResultPanel.$$$reportNull$$$0(45);
        }
        return gridMainPanel;
    }

    @NotNull
    public JBLoadingPanel getComponent() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            TableResultPanel.$$$reportNull$$$0(46);
        }
        return gridMainPanel;
    }

    @Override
    public void setTopComponent(@Nullable Component component) {
        this.myMainPanel.setTopComponent(component);
    }

    @Override
    @Nullable
    public Component getTopComponent() {
        return this.myMainPanel.getTopComponent();
    }

    @Override
    @Nullable
    public GridColumn getLayoutColumn(@NotNull ModelIndex<?> column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(47);
        }
        GridRawIndexConverter rawIndexConverter = this.myTable.getRawIndexConverter();
        IntIntFunction toView = this.isTransposed() ? rawIndexConverter.row2View() : rawIndexConverter.column2View();
        int viewColumnIdx = toView.fun(column.asInteger());
        return viewColumnIdx != -1 ? this.myTable.getColumnCache().getOrCreateColumn(column.asInteger()) : null;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getVisibleColumns() {
        int visibleColumns = this.getVisibleColumnCount();
        int[] viewIndices = new int[visibleColumns];
        for (int i2 = 0; i2 < visibleColumns; ++i2) {
            viewIndices[i2] = i2;
        }
        ModelIndexSet<DataConsumer.Column> columnIndices = ViewIndexSet.forColumns(this, viewIndices).toModel(this);
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.validIndexSet(columnIndices, columnIndices1 -> ModelIndexSet.forColumns(this, columnIndices1));
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(48);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getVisibleRows() {
        int rowCount = this.isTransposed() ? this.myTable.getModel().getColumnCount() : this.myTable.getModel().getRowCount();
        int[] viewRowIndices = new int[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            viewRowIndices[i2] = i2;
        }
        ModelIndexSet<DataConsumer.Row> rowIndices = ViewIndexSet.forRows(this, viewRowIndices).toModel(this);
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.validIndexSet(rowIndices, rowIndices1 -> ModelIndexSet.forRows(this, rowIndices1));
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(49);
        }
        return modelIndexSet;
    }

    @Override
    public int getVisibleRowsCount() {
        return this.isTransposed() ? this.myTable.getColumnCount() : this.myTable.getRowCount();
    }

    @NotNull
    private <T> ModelIndexSet<T> validIndexSet(@NotNull ModelIndexSet<T> indexSet, @NotNull com.intellij.util.Function<int[], ModelIndexSet<T>> factory) {
        if (indexSet == null) {
            TableResultPanel.$$$reportNull$$$0(50);
        }
        if (factory == null) {
            TableResultPanel.$$$reportNull$$$0(51);
        }
        IntArrayList validIndices = new IntArrayList(indexSet.size());
        for (ModelIndex idx : indexSet.asIterable()) {
            if (!idx.isValid(this)) continue;
            validIndices.add(idx.asInteger());
        }
        ModelIndexSet modelIndexSet = (ModelIndexSet)factory.fun((Object)validIndices.toArray());
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(52);
        }
        return modelIndexSet;
    }

    @Override
    public void scrollSelectionToVisible() {
        TableUtil.scrollSelectionToVisible((JTable)((Object)this.myTable));
    }

    @Override
    public boolean isEditing() {
        return this.myTable.isEditing();
    }

    @Override
    public boolean stopEditing() {
        int[] nArray;
        int[] nArray2;
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor == null) {
            return true;
        }
        if (!this.myTable.isMultiEditingAllowed()) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = this.myTable.getEditingColumn();
        } else {
            nArray2 = this.myTable.getSelectedColumns();
        }
        int[] columnDataIdx = Arrays.stream(nArray2).map(arg_0 -> this.myTable.convertColumnIndexToModel(arg_0)).toArray();
        if (!this.myTable.isMultiEditingAllowed()) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = this.myTable.getEditingRow();
        } else {
            nArray = this.myTable.getSelectedRows();
        }
        int[] rowDataIdx = Arrays.stream(nArray).map(arg_0 -> this.myTable.convertRowIndexToModel(arg_0)).toArray();
        ModelIndexSet<DataConsumer.Row> myEditingRowIdx = ModelIndexSet.forRows(this, this.isTransposed() ? columnDataIdx : rowDataIdx);
        ModelIndexSet<DataConsumer.Column> myEditingColumnIdx = ModelIndexSet.forColumns(this, this.isTransposed() ? rowDataIdx : columnDataIdx);
        return this.isSafeToUpdate(myEditingRowIdx, myEditingColumnIdx, editor.getCellEditorValue()) && editor.stopCellEditing();
    }

    @Override
    public void cancelEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    @Override
    public void editSelectedCell() {
        int leadRow = this.myTable.getSelectionModel().getLeadSelectionIndex();
        int leadColumn = this.myTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (leadRow == -1 || leadColumn == -1) {
            return;
        }
        TableUtil.editCellAt((JTable)((Object)this.myTable), (int)leadRow, (int)leadColumn);
    }

    @Override
    public boolean isViewModified() {
        for (DataConsumer.Column column : this.getDataModel().getColumns()) {
            boolean sortOrderChanged;
            boolean shouldBeShown = column == null || !DbImplUtil.isRowId(column);
            boolean shown = this.myColumnAttributes.isEnabled(column);
            boolean bl = sortOrderChanged = this.getSortOrder(column) != 0;
            if (shown == shouldBeShown && !sortOrderChanged) continue;
            return true;
        }
        return this.myTable.isViewModified();
    }

    public int getVisibleColumnCount() {
        return this.isTransposed() ? this.myTable.getRowCount() : this.myTable.getColumnCount();
    }

    private void showError(@NotNull Throwable error, @Nullable DataGridRequestSource source) {
        if (error == null) {
            TableResultPanel.$$$reportNull$$$0(53);
        }
        this.hideErrorPanel();
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(null, error, (JComponent)((Object)this.myMainPanel));
        if (source != null && source.getRows().size() == 1) {
            ModelIndex modelRowIdx = (ModelIndex)source.getRows().first();
            ModelIndex modelColumnIdx = (ModelIndex)source.getColumns().first();
            ViewIndex viewRowIdx = modelRowIdx.toView(this);
            ViewIndex viewColumnIdx = modelColumnIdx.toView(this);
            int r = viewRowIdx.asInteger() + 1;
            int c = viewColumnIdx.asInteger() + 1;
            String title = "[row:" + r + (c < 1 ? "" : " col:" + c) + "]";
            builder.addLink("navigate", title, () -> {
                if (viewRowIdx.isValid(this) && viewColumnIdx.isValid(this)) {
                    this.scrollToLocally(viewRowIdx, viewColumnIdx);
                }
            });
        }
        this.myErrorNotificationPanel = builder.addDetailsButton().addCloseButton(this::hideErrorPanel).build();
        this.myMainPanel.setBottomComponent(this.myErrorNotificationPanel);
        this.myErrorNotificationPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void hideErrorPanel() {
        if (this.myErrorNotificationPanel == null) {
            return;
        }
        this.myMainPanel.setBottomComponent(null);
        this.myErrorNotificationPanel = null;
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void handleError(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> requestSource, @NotNull Throwable error) {
        if (requestSource == null) {
            TableResultPanel.$$$reportNull$$$0(54);
        }
        if (error == null) {
            TableResultPanel.$$$reportNull$$$0(55);
        }
        Object source = requestSource.source;
        DbUIUtil.invokeLater(() -> {
            if (error == null) {
                TableResultPanel.$$$reportNull$$$0(111);
            }
            if (source == this.myFilterPanel) {
                this.myFilterPanel.onError(error);
                return;
            }
            this.showError(error, (DataGridRequestSource)((Object)((Object)ObjectUtils.tryCast((Object)source, DataGridRequestSource.class))));
        });
    }

    @Nullable
    protected Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return new GridCopyProvider(this);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new DeleteRowsAction();
        }
        if (DatabaseDataKeys.DATA_GRID_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.getPsiElementForSelection();
        }
        if (LangDataKeys.NO_NEW_ACTION.is(dataId)) {
            return Boolean.TRUE;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new GridPasteProvider(this);
        }
        return null;
    }

    private PsiElement getPsiElementForSelection() {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = this.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            return DataGridPomTarget.wrapDataGrid(this.myProject, this);
        }
        return DataGridPomTarget.wrapCell(this.myProject, this, selectionModel.getSelectedRows(), selectionModel.getSelectedColumns());
    }

    @Override
    public void sortColumns(@NotNull List<ModelIndex<DataConsumer.Column>> columns2, @NotNull RowSortOrder.Type order) {
        if (columns2 == null) {
            TableResultPanel.$$$reportNull$$$0(56);
        }
        if (order == null) {
            TableResultPanel.$$$reportNull$$$0(57);
        }
        boolean updated = false;
        for (ModelIndex<DataConsumer.Column> column : columns2) {
            updated |= this.changeSortOrder(column, order, true);
        }
        if (updated) {
            this.updateSortKeysFromColumnAttributes();
            this.updateDataOrderingIfNeeded();
        }
    }

    @Override
    @NotNull
    public Language getContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        DataConsumer.Column column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(58);
        }
        Language language = (column = this.getDataModel().getColumn(columnIdx)) != null ? this.getContentLanguage(column) : Language.ANY;
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(59);
        }
        return language;
    }

    @NotNull
    Language getContentLanguage(@NotNull DataConsumer.Column column) {
        Language fromAttributes;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(60);
        }
        if ((fromAttributes = this.myColumnAttributes.getContentLanguage(column)) != Language.ANY) {
            Language language = fromAttributes;
            if (language == null) {
                TableResultPanel.$$$reportNull$$$0(61);
            }
            return language;
        }
        DatabaseFamilyId family = DataGridUtil.getDatabaseDialect(this).getFamilyId();
        if (ObjectFormatter.isJson(column, family)) {
            Language language = TableResultPanel.getLanguageByIdOrAny(JSON_LANGUAGE_ID);
            if (language == null) {
                TableResultPanel.$$$reportNull$$$0(62);
            }
            return language;
        }
        if (family.isTransactSql() && StringUtil.equalsIgnoreCase((CharSequence)"xml", (CharSequence)column.typeName)) {
            Language language = TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
            if (language == null) {
                TableResultPanel.$$$reportNull$$$0(63);
            }
            return language;
        }
        if (column.type == 2009) {
            Language language = TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
            if (language == null) {
                TableResultPanel.$$$reportNull$$$0(64);
            }
            return language;
        }
        Language language = Language.ANY;
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(65);
        }
        return language;
    }

    @NotNull
    private static Language getLanguageByIdOrAny(@NotNull String languageId) {
        if (languageId == null) {
            TableResultPanel.$$$reportNull$$$0(66);
        }
        Language language = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)languageId), (Object)Language.ANY);
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(67);
        }
        return language;
    }

    @Override
    public void setContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
        DataConsumer.Column column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(68);
        }
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(69);
        }
        if ((column = this.getDataModel().getColumn(columnIdx)) != null) {
            this.myColumnAttributes.setContentLanguage(column, language);
        }
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getContextColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = this.myTable.getClickedHeaderColumnIdx();
        if (modelIndex == null) {
            TableResultPanel.$$$reportNull$$$0(70);
        }
        return modelIndex;
    }

    @Override
    public void setFilterText(String filter, int caretPosition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isFilteringEnabled() && !StringUtil.isEmptyOrSpaces((String)filter)) {
            this.toggleFiltering();
        }
        this.myFilterPanel.setFilterText(filter, caretPosition);
    }

    @Override
    public void applyFilter() {
        GridFilteringModel model = this.myDataHookUp.getFilteringModel();
        if (this.isSafeToReload() && model != null) {
            model.applyFilter(GridRequestSource.create(this, (Object)this.myFilterPanel));
        }
    }

    @Override
    public boolean isReady() {
        return this.myReady && !this.getDataModel().isUpdatingNow();
    }

    public void setReady(boolean b) {
        this.myReady = b;
    }

    @Override
    public boolean isEmpty() {
        return this.myTable.isEmpty();
    }

    public void dispose() {
        this.myTable.removeEditor();
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> uiRow(int uiRow) {
        ModelIndex<DataConsumer.Row> modelIndex = ModelIndex.forRow(this, uiRow < 1 ? -1 : uiRow - 1);
        if (modelIndex == null) {
            TableResultPanel.$$$reportNull$$$0(71);
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> uiColumn(int uiColumn) {
        int modelIndex = uiColumn < 1 || uiColumn >= this.getVisibleColumnCount() + 1 ? -1 : this.myTable.getRawIndexConverter().column2Model().fun(uiColumn - 1);
        ModelIndex<DataConsumer.Column> modelIndex2 = ModelIndex.forColumn(this, modelIndex);
        if (modelIndex2 == null) {
            TableResultPanel.$$$reportNull$$$0(72);
        }
        return modelIndex2;
    }

    @Override
    public void showCell(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            TableResultPanel.$$$reportNull$$$0(73);
        }
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(74);
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            if (row == null) {
                TableResultPanel.$$$reportNull$$$0(109);
            }
            if (column == null) {
                TableResultPanel.$$$reportNull$$$0(110);
            }
            int rawRowIndex = row.asInteger() + 1;
            this.scrollTo(rawRowIndex, column.toView(this).asInteger());
        });
    }

    private void scrollTo(int dataRowIndex, int viewColumnIndex) {
        GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel = this.myDataHookUp.getPageModel();
        Runnable localScrollRunnable = () -> {
            ViewIndex<DataConsumer.Row> row = pageModel.findRow(dataRowIndex).toView(this);
            ViewIndex<DataConsumer.Column> column = ViewIndex.forColumn(this, viewColumnIndex);
            this.scrollToLocally(row, column);
        };
        if (pageModel.findRow(dataRowIndex).isValid(this)) {
            localScrollRunnable.run();
        } else {
            GridLoader<DataConsumer.Row, DataConsumer.Column> loader = this.myDataHookUp.getLoader();
            int startIdx = Math.max(1, dataRowIndex - pageModel.getPageSize() / 2);
            loader.load(GridRequestSource.create(this, new DataGridRequestSource(this).doWhenDone(localScrollRunnable)), startIdx);
        }
    }

    private void scrollToLocally(ViewIndex<DataConsumer.Row> row, ViewIndex<DataConsumer.Column> column) {
        this.mySelectionModel.setRowSelection(row.toModel(this));
        this.mySelectionModel.setColumnSelection(column.toModel(this));
    }

    @Override
    public boolean isFilteringSupported() {
        return this.getDataHookup().getFilteringModel() != null;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.isFilteringEnabledInModel() && this.myFilterPanel.isVisible();
    }

    private boolean isFilteringEnabledInModel() {
        GridFilteringModel filteringModel = this.getDataHookup().getFilteringModel();
        return filteringModel != null && filteringModel.isFilteringEnabled();
    }

    @Override
    public boolean toggleFiltering() {
        if (!this.isFilteringEnabledInModel()) {
            return false;
        }
        boolean enabled = !this.isFilteringEnabled();
        this.myFilterPanel.setVisible(enabled);
        if (enabled) {
            this.myFilterPanel.requestFocusInWindow();
        }
        return enabled;
    }

    @Override
    public void changeSelectedColumnsWidth(int delta) {
        int[] columns2 = this.myTable.getSelectedColumns();
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int column : columns2) {
            if (column < 0) continue;
            GridColumn tableColumn = (GridColumn)((Object)columnModel.getColumn(column));
            int width = tableColumn.getColumnWidth();
            tableColumn.setColumnWidth(Math.max(0, width + delta));
        }
    }

    @Override
    public void growSelection() {
        this.myGrower.growSelection();
    }

    @Override
    public void doLayout() {
        this.myColumnLayout.doLayout();
    }

    public void fireContentChanged() {
        if (this.myRowHeader instanceof TableResultRowHeader) {
            this.myRowHeader.updatePreferredSize();
            this.myRowHeader.revalidate();
            this.myRowHeader.repaint();
        }
        ((DataGridListener)this.myEventDispatcher.getMulticaster()).onContentChanged(this);
    }

    protected boolean isInitiallyDisabled(@NotNull DataConsumer.Column column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(75);
        }
        return DbImplUtil.isRowId(column);
    }

    protected Language getInitialContentLanguage(@NotNull DataConsumer.Column column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(76);
        }
        return Language.ANY;
    }

    private Formatter getDateFormat(@NotNull DataConsumer.Column column) {
        boolean isPostgresRange;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(77);
        }
        int jdbcType = ExtractorsUtil.guessJdbcType(column);
        ObjectFormatter converter = this.getObjectFormatter();
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(this);
        boolean bl = isPostgresRange = dialect.getFamilyId().isPostgres() && StringUtil.findIgnoreCase((String)column.typeName, (String[])new String[]{"tstzrange", "tsrange"});
        if (isPostgresRange) {
            return RangeFormatResolver.resolveFormatter(converter, column, dialect);
        }
        if (DbImplUtil.isZonedTimestampColumn(column, dialect)) {
            return converter.getZonedTimestampFormat(column, dialect);
        }
        if (DbImplUtil.isZonedTimeColumn(column, dialect)) {
            return converter.getZonedTimeFormat();
        }
        return jdbcType == 91 ? converter.getDateFormat(column, dialect) : (jdbcType == 92 ? converter.getTimeFormat() : (jdbcType == 93 ? converter.getTimestampFormat(column, dialect) : null));
    }

    void setValueAt(@NotNull ViewIndexSet<DataConsumer.Row> viewRows, @NotNull ViewIndexSet<DataConsumer.Column> viewColumns, @Nullable Object value) {
        if (viewRows == null) {
            TableResultPanel.$$$reportNull$$$0(78);
        }
        if (viewColumns == null) {
            TableResultPanel.$$$reportNull$$$0(79);
        }
        this.hideErrorPanel();
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDataHookup().getMutator();
        int[] validRows = this.valid(viewRows);
        int[] validColumns = this.valid(viewColumns);
        ModelIndexSet<DataConsumer.Row> rows = validRows.length > 0 ? ViewIndexSet.forRows(this, validRows).toModel(this) : null;
        ModelIndexSet<DataConsumer.Column> columns2 = validRows.length > 0 ? ViewIndexSet.forColumns(this, validColumns).toModel(this) : null;
        Runnable moveToNextCellRunnable = this.newMoveToNextCellRunnable((ViewIndex)viewRows.last(), (ViewIndex)viewColumns.last());
        if (mutator == null || rows == null || columns2 == null || this.getMutationModel().allValuesEqualTo(rows, columns2, value)) {
            DbUIUtil.invokeLater(moveToNextCellRunnable);
            return;
        }
        ModelIndexSet<DataConsumer.Row> rowsIdxs = viewRows.toModel(this);
        ModelIndexSet<DataConsumer.Column> columnsIdxs = viewColumns.toModel(this);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (mutator.isUpdateImmediately()) {
                this.setValueImmediately(rowsIdxs, columnsIdxs, moveToNextCellRunnable, mutator, value);
                return;
            }
            DataGridRequestSource requestSource = new DataGridRequestSource(rows, columns2);
            requestSource.doWhenDone(moveToNextCellRunnable);
            mutator.mutate(GridRequestSource.create(this, (Object)requestSource), rowsIdxs, columnsIdxs, value);
        });
    }

    private void setValueImmediately(@NotNull ModelIndexSet<DataConsumer.Row> rowsIdxs, @NotNull ModelIndexSet<DataConsumer.Column> columnsIdxs, @NotNull Runnable moveToNextCellRunnable, @NotNull GridMutator<DataConsumer.Row, DataConsumer.Column> mutator, @Nullable Object value) {
        if (rowsIdxs == null) {
            TableResultPanel.$$$reportNull$$$0(80);
        }
        if (columnsIdxs == null) {
            TableResultPanel.$$$reportNull$$$0(81);
        }
        if (moveToNextCellRunnable == null) {
            TableResultPanel.$$$reportNull$$$0(82);
        }
        if (mutator == null) {
            TableResultPanel.$$$reportNull$$$0(83);
        }
        List<CellMutation> mutations = this.toCellMutations(rowsIdxs, columnsIdxs, value);
        ModelIndexSet<DataConsumer.Row> filteredRows = TableResultPanel.getIndices(mutations, rowArray -> ModelIndexSet.forRows(this, rowArray), Mutation::getRow);
        ModelIndexSet<DataConsumer.Column> filteredCols = TableResultPanel.getIndices(mutations, colArray -> ModelIndexSet.forColumns(this, colArray), CellMutation::getColumn);
        DataGridRequestSource requestSource = new DataGridRequestSource(filteredRows, filteredCols);
        requestSource.doWhenDone(moveToNextCellRunnable);
        mutator.mutate(GridRequestSource.create(this, (Object)requestSource), mutations);
    }

    @NotNull
    private List<CellMutation> toCellMutations(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns2, @Nullable Object value) {
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(84);
        }
        if (columns2 == null) {
            TableResultPanel.$$$reportNull$$$0(85);
        }
        ArrayList mutations = ContainerUtil.newArrayList();
        GridMutationModel model = this.getMutationModel();
        for (ModelIndex row : rows.asIterable()) {
            for (ModelIndex column : columns2.asIterable()) {
                int rowIdx = row.asInteger();
                int colIdx = column.asInteger();
                if (model.allValuesEqualTo(ModelIndexSet.forRows(this, rowIdx), ModelIndexSet.forColumns(this, colIdx), value)) continue;
                mutations.add(new CellMutation(row, column, this.isInsertedRow(row) ? MutationType.INSERT : MutationType.MODIFY, value));
            }
        }
        ArrayList arrayList = mutations;
        if (arrayList == null) {
            TableResultPanel.$$$reportNull$$$0(86);
        }
        return arrayList;
    }

    @NotNull
    private static <T> ModelIndexSet<T> getIndices(@NotNull List<CellMutation> mutations, @NotNull Function<int[], ModelIndexSet<T>> setCreator, @NotNull Function<CellMutation, ModelIndex<T>> indexSupplier) {
        if (mutations == null) {
            TableResultPanel.$$$reportNull$$$0(87);
        }
        if (setCreator == null) {
            TableResultPanel.$$$reportNull$$$0(88);
        }
        if (indexSupplier == null) {
            TableResultPanel.$$$reportNull$$$0(89);
        }
        int[] values = mutations.stream().map(indexSupplier).mapToInt(Index::asInteger).distinct().toArray();
        ModelIndexSet<T> modelIndexSet = setCreator.apply(values);
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(90);
        }
        return modelIndexSet;
    }

    private <T> int[] valid(ViewIndexSet<T> set) {
        return set.asList().stream().filter(idx -> idx.isValid(this)).mapToInt(Index::asInteger).toArray();
    }

    private Runnable newMoveToNextCellRunnable(ViewIndex<DataConsumer.Row> row, ViewIndex<DataConsumer.Column> col) {
        return () -> IdeFocusManager.findInstanceByComponent((Component)((Object)this.myTable)).doWhenFocusSettlesDown(() -> this.moveToNextCell(row, col));
    }

    private void moveToNextCell(@NotNull ViewIndex<DataConsumer.Row> rowIndex, @NotNull ViewIndex<DataConsumer.Column> colIndex) {
        if (rowIndex == null) {
            TableResultPanel.$$$reportNull$$$0(91);
        }
        if (colIndex == null) {
            TableResultPanel.$$$reportNull$$$0(92);
        }
        if (this.mySelectionModel.getSelectedRowCount() != 1 || this.mySelectionModel.getSelectedColumnCount() != 1 || !ApplicationManager.getApplication().isUnitTestMode() && (!UIUtil.isFocusAncestor((JComponent)((Object)this.myTable)) || this.isEditing())) {
            return;
        }
        if (!Comparing.equal(this.mySelectionModel.getSelectedRow(), rowIndex.toModel(this)) || !Comparing.equal(this.mySelectionModel.getSelectedColumn(), colIndex.toModel(this))) {
            return;
        }
        if (this.isInsertedRow(rowIndex.toModel(this))) {
            ViewIndex<DataConsumer.Column> nextColumn = ViewIndex.forColumn(this, colIndex.asInteger() + 1);
            colIndex = nextColumn.isValid(this) ? nextColumn : colIndex;
        } else {
            ViewIndex<DataConsumer.Row> nextRow = ViewIndex.forRow(this, rowIndex.asInteger() + 1);
            rowIndex = nextRow.isValid(this) ? nextRow : rowIndex;
        }
        this.scrollToLocally(rowIndex, colIndex);
    }

    protected boolean isHeaderSelecting() {
        return false;
    }

    protected boolean allowHeaderActionsInTransposeMode() {
        return false;
    }

    private void updateColumnAttributes() {
        if (!this.isSortViaOrderBy()) {
            return;
        }
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> order : this.getOrderingFromModel()) {
            this.changeSortOrder(order.getColumn(), order.getOrder(), true);
        }
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> getOrderingFromModel() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> list = sortingModel != null ? sortingModel.getOrdering() : ContainerUtil.emptyList();
        if (list == null) {
            TableResultPanel.$$$reportNull$$$0(93);
        }
        return list;
    }

    private void updateSortKeysFromColumnAttributes() {
        RowSorter rowSorter = this.myTable.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(this.isTransposed() || this.isSortViaOrderBy() ? null : this.createSortKeys());
        }
        this.fireContentChanged();
    }

    @Nullable
    private List<RowSorter.SortKey> createSortKeys() {
        if (this.isTransposed()) {
            return ContainerUtil.emptyList();
        }
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.getSortOrderMap();
        int orderIdx = 0;
        Object[] keys = new RowSorter.SortKey[sortOrderMap.size()];
        for (DataConsumer.Column column : sortOrderMap.values()) {
            RowSorter.SortKey key = new RowSorter.SortKey(column.columnNum, this.getSortOrder(column) < 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING);
            keys[orderIdx++] = key;
        }
        return ContainerUtil.newArrayList((Object[])keys);
    }

    boolean changeSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable RowSortOrder.Type targetSortOrder, boolean silent) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(94);
        }
        boolean updated = false;
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        if (column != null) {
            updated = this.myColumnAttributes.changeSortOrder(column, targetSortOrder);
        }
        if (!silent && updated) {
            this.updateSortKeysFromColumnAttributes();
            this.updateDataOrderingIfNeeded();
        }
        return updated;
    }

    private void updateDataOrderingIfNeeded() {
        if (this.isSortViaOrderBy()) {
            this.updateDataOrdering(true);
        }
    }

    private boolean updateDataOrdering(boolean reloadIfUpdated) {
        List newOrdering;
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return false;
        }
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> oldOrdering = this.getOrderingFromModel();
        if (TableResultPanel.isSameOrdering(oldOrdering, newOrdering = this.createOrdering())) {
            return false;
        }
        if (reloadIfUpdated && !this.isSafeToReload()) {
            return false;
        }
        sortingModel.setOrdering(newOrdering);
        if (reloadIfUpdated) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
        return true;
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> createOrdering() {
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.getSortOrderMap();
        ArrayList ordering = ContainerUtil.newArrayListWithCapacity((int)sortOrderMap.size());
        for (DataConsumer.Column column : sortOrderMap.values()) {
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this, column.columnNum);
            ordering.add(this.getSortOrder(column) < 0 ? RowSortOrder.asc(columnIdx) : RowSortOrder.desc(columnIdx));
        }
        ArrayList arrayList = ordering;
        if (arrayList == null) {
            TableResultPanel.$$$reportNull$$$0(95);
        }
        return arrayList;
    }

    private static boolean isSameOrdering(@NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering1, @NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering2) {
        if (ordering1 == null) {
            TableResultPanel.$$$reportNull$$$0(96);
        }
        if (ordering2 == null) {
            TableResultPanel.$$$reportNull$$$0(97);
        }
        if (ordering1.size() != ordering2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < ordering1.size(); ++i2) {
            RowSortOrder<ModelIndex<DataConsumer.Column>> o1 = ordering1.get(i2);
            RowSortOrder<ModelIndex<DataConsumer.Column>> o2 = ordering2.get(i2);
            if (Comparing.equal((Object)((Object)o1.getOrder()), (Object)((Object)o2.getOrder())) && Comparing.equal(o1.getColumn(), o2.getColumn())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(98);
        }
        return column.isValid(this) && this.myColumnAttributes.isEnabled(this.getDataModel().getColumn(column));
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state) {
        DataConsumer.Column column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(99);
        }
        if ((column = this.getDataModel().getColumn(columnIdx)) == null || this.myColumnAttributes.isEnabled(column) == state) {
            return;
        }
        if (this.isTransposed()) {
            GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
            this.myColumnAttributes.setEnabled(column, state);
            this.storeOrRestoreSelection(columnIdx, state, selection);
            this.runWithIgnoreSelectionChanges(() -> {
                this.myTable.getModel().fireTableDataChanged();
                selection.restore((JTable)((Object)this.myTable));
            });
        } else {
            this.setColumnEnabled(columnIdx.asInteger(), state);
        }
    }

    private void storeOrRestoreSelection(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state, @NotNull GridSelection selection) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(100);
        }
        if (selection == null) {
            TableResultPanel.$$$reportNull$$$0(101);
        }
        int modelIndex = columnIdx.asInteger();
        if (state && this.myHiddenColumnSelectionHolder.contains(modelIndex)) {
            if (this.isTransposed()) {
                selection.addSelectedRows(modelIndex);
            } else {
                selection.addSelectedColumns(modelIndex);
            }
            this.myHiddenColumnSelectionHolder.columnShown(modelIndex);
        } else if (!state) {
            boolean selected;
            int viewIndex = columnIdx.toView(this).asInteger();
            boolean bl = selected = this.isTransposed() ? this.myTable.isRowSelected(viewIndex) : this.myTable.isColumnSelected(viewIndex);
            if (selected) {
                this.myHiddenColumnSelectionHolder.columnHidden(modelIndex);
            }
        }
    }

    @Override
    public void transpose() {
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        GridScrollPosition scrollPosition = GridScrollPosition.store((JTable)((Object)this.myTable));
        this.doTranspose();
        DbUIUtil.invokeLater(() -> {
            selection.transpose().restore((JTable)((Object)this.myTable));
            scrollPosition.transpose().restore((JTable)((Object)this.myTable));
        });
    }

    private void doTranspose() {
        this.myTable.doTranspose();
        this.myColumnLayout.setTransposed(this.isTransposed());
        this.myTable.createDefaultColumnsFromModel();
    }

    @Override
    public boolean isTransposed() {
        return this.myTable != null && this.myTable.isTransposed();
    }

    protected void setColumnEnabled(int columnDataIdx, boolean enable) {
        ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(this, columnDataIdx);
        if (!this.isTransposed()) {
            DataConsumer.Column column = this.getDataModel().getColumn(modelIndex);
            this.myColumnAttributes.setEnabled(column, enable);
        }
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        int viewColumnIdx = this.myTable.convertColumnIndexToView(columnDataIdx);
        if (enable && viewColumnIdx < 0) {
            boolean firstTimeShown = !this.myTable.getColumnCache().hasCachedColumn(columnDataIdx);
            this.myTable.addColumn(this.myTable.getColumnCache().getOrCreateColumn(columnDataIdx));
            int lastColumnIndex = this.myTable.getColumnCount() - 1;
            this.runWithIgnoreSelectionChanges(() -> {
                for (int viewTargetColumnIdx = 0; viewTargetColumnIdx < lastColumnIndex; ++viewTargetColumnIdx) {
                    if (columnModel.getColumn(viewTargetColumnIdx).getModelIndex() <= columnDataIdx) continue;
                    this.myTable.moveColumn(lastColumnIndex, viewTargetColumnIdx);
                    break;
                }
            });
            if (firstTimeShown) {
                this.myColumnLayout.columnsShown(this.isTransposed() ? ModelIndexSet.forColumns(this, columnDataIdx) : ModelIndexSet.forRows(this, columnDataIdx));
            }
            this.storeOrRestoreSelection(modelIndex, true, selection);
        } else if (!enable && viewColumnIdx >= 0) {
            this.myTable.getTableHeader().setDraggedColumn(null);
            this.storeOrRestoreSelection(modelIndex, false, selection);
            this.runWithIgnoreSelectionChanges(() -> columnModel.removeColumn(columnModel.getColumn(viewColumnIdx)));
        } else {
            return;
        }
        this.runWithIgnoreSelectionChanges(() -> selection.restore((JTable)((Object)this.myTable)));
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
        if (!this.isTransposed()) {
            this.updateSortKeysFromColumnAttributes();
        }
    }

    private void runWithIgnoreSelectionChanges(Runnable runnable) {
        try {
            this.myHiddenColumnSelectionHolder.startAdjusting();
            runnable.run();
        }
        finally {
            this.myHiddenColumnSelectionHolder.endAdjusting();
        }
    }

    private boolean isSafeToReload() {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        return mutator == null || !mutator.hasPendingChanges() || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    private boolean isSafeToUpdate(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns2, @Nullable Object newValue) {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(102);
        }
        if (columns2 == null) {
            TableResultPanel.$$$reportNull$$$0(103);
        }
        return (mutator = this.myDataHookUp.getMutator()) == null || mutator.isUpdateSafe(rows, columns2, newValue) || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    @Override
    @NotNull
    public JPanel getFilterPanel() {
        GridFilterPanel gridFilterPanel = this.myFilterPanel;
        if (gridFilterPanel == null) {
            TableResultPanel.$$$reportNull$$$0(104);
        }
        return gridFilterPanel;
    }

    @Override
    public void resetFilters() {
        this.setFilterText("", -1);
        this.resetOrderingAndVisibility();
    }

    @Override
    public void resetView() {
        if (this.isSortViaOrderBy() && !this.isSafeToReload()) {
            return;
        }
        HiddenColumnsSelectionHolder copy = this.myHiddenColumnSelectionHolder.copy();
        this.myHiddenColumnSelectionHolder.reset();
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        this.resetOrderingAndVisibility();
        this.resetRowHeights();
        this.myTable.createDefaultColumnsFromModel();
        this.myColumnLayout.doLayout();
        int[] indices = copy.selectedIndices((JTable)((Object)this.myTable));
        if (this.isTransposed()) {
            selection.addSelectedRows(indices);
        } else {
            selection.addSelectedColumns(indices);
        }
        selection.restore((JTable)((Object)this.myTable));
        if (this.isSortViaOrderBy()) {
            this.myDataHookUp.getLoader().reloadCurrentPage(GridRequestSource.create(this, null));
        }
    }

    void trueLayout() {
        Container parent;
        Container container = parent = this.myTable != null ? this.myTable.getParent() : null;
        if (parent == null) {
            return;
        }
        Dimension size = parent.getSize();
        this.myTable.setPreferredSize(this.getDataModel().getColumnCount() == 0 ? size : null);
        this.myScrollPane.revalidate();
        this.myScrollPane.repaint(50L);
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        GridMutator.RowsMutator mutator = (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.RowsMutator.class);
        return mutator;
    }

    @Nullable
    private GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> getDatabaseMutator() {
        GridMutator.RowsMutator mutator = (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.DatabaseMutator.class);
        return (GridMutator.DatabaseMutator)mutator;
    }

    @Nullable
    private GridMutator<DataConsumer.Row, DataConsumer.Column> getMutator() {
        return this.myDataHookUp.getMutator();
    }

    private void resetOrderingAndVisibility() {
        this.myColumnAttributes.resetOrdering();
        this.myColumnAttributes.resetVisibility();
        this.updateSortKeysFromColumnAttributes();
        this.updateDataOrderingIfNeeded();
        this.myTable.getModel().fireTableDataChanged();
    }

    private void resetRowHeights() {
        int defaultRowHeight = this.myTable.getRowHeight();
        for (int i2 = 0; i2 < this.myTable.getRowCount(); ++i2) {
            if (this.myTable.getRowHeight(i2) == defaultRowHeight) continue;
            this.myTable.setRowHeight(i2, defaultRowHeight);
        }
    }

    @NotNull
    String getColumnTooltipHtml(@Nullable DataConsumer.Column column) {
        if (column == null) {
            if ("" == null) {
                TableResultPanel.$$$reportNull$$$0(105);
            }
            return "";
        }
        String type = DataGridUtil.getSqlType(this, column);
        String string = "<html><b>" + this.myColumnAttributes.getName(column) + "</b>" + (StringUtil.isNotEmpty((String)type) ? ": " + type : "") + this.getDateFormatSuffix(column) + "</html>";
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(106);
        }
        return string;
    }

    @NotNull
    private String getDateFormatSuffix(@NotNull DataConsumer.Column column) {
        Formatter dateFormat;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(107);
        }
        String string = (dateFormat = this.getDateFormat(column)) != null ? " (" + dateFormat + ") " : "";
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(108);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 86: 
            case 90: 
            case 93: 
            case 95: 
            case 104: 
            case 105: 
            case 106: 
            case 108: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 86: 
            case 90: 
            case 93: 
            case 95: 
            case 104: 
            case 105: 
            case 106: 
            case 108: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterPopupActions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaderPopupActions";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 86: 
            case 90: 
            case 93: 
            case 95: 
            case 104: 
            case 105: 
            case 106: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/TableResultPanel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerActions";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 58: 
            case 68: 
            case 94: 
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchSession";
                break;
            }
            case 24: 
            case 28: 
            case 84: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 25: 
            case 29: 
            case 56: 
            case 85: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 26: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowToClone";
                break;
            }
            case 27: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnToClone";
                break;
            }
            case 34: 
            case 73: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 47: 
            case 60: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 98: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSet";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 53: 
            case 55: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestSource";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRows";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewColumns";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowsIdxs";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsIdxs";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveToNextCellRunnable";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setCreator";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSupplier";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndex";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colIndex";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering1";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering2";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRowHeader";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableView";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationModel";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSupport";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModel";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataHookup";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIndexConverter";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPanel";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRows";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "validIndexSet";
                break;
            }
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLanguage";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageByIdOrAny";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextColumn";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "uiRow";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "uiColumn";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "toCellMutations";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderingFromModel";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrdering";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterPanel";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnTooltipHtml";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormatSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 86: 
            case 90: 
            case 93: 
            case 95: 
            case 104: 
            case 105: 
            case 106: 
            case 108: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTableView";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getThenBySortOrder";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCellRendererComponent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStarted";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStopped";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setCells";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "cloneRow";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "cloneColumn";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "deleteRows";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumns";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDataModel";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutColumn";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "validIndexSet";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sortColumns";
                break;
            }
            case 58: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getContentLanguage";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageByIdOrAny";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "setContentLanguage";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "showCell";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isInitiallyDisabled";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getInitialContentLanguage";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormat";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "setValueImmediately";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "toCellMutations";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "moveToNextCell";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "changeSortOrder";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isSameOrdering";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isColumnEnabled";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "storeOrRestoreSelection";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToUpdate";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormatSuffix";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showCell$14";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleError$13";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "lambda$cloneColumn$5";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "lambda$cloneRow$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 86: 
            case 90: 
            case 93: 
            case 95: 
            case 104: 
            case 105: 
            case 106: 
            case 108: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCornerToolsComponent
    extends JBViewport {
        private final ActionButton myButton;

        MyCornerToolsComponent() {
            EditorHeaderComponent view2 = new EditorHeaderComponent(){

                public void uiSettingsChanged(UISettings uiSettings) {
                }
            };
            view2.setOpaque(false);
            this.add((Component)view2);
            DumbAwareAction action = new DumbAwareAction(){

                public void actionPerformed(AnActionEvent e) {
                    MyCornerToolsComponent.this.selectAll();
                    if (!TableResultPanel.this.myTable.hasFocus()) {
                        IdeFocusManager.getInstance((Project)TableResultPanel.this.myProject).requestFocus((Component)((Object)TableResultPanel.this.myTable), true);
                    }
                }
            };
            action.getTemplatePresentation().setText("Select All");
            this.myButton = new ActionButton((AnAction)action, action.getTemplatePresentation(), "", (Dimension)JBUI.emptySize());
            view2.add((Component)this.myButton, (Object)"Center");
            view2.setBorder((Border)new CustomLineBorder(null, 0, 0, 1, 1){

                protected Color getColor() {
                    return TableResultPanel.this.myTable.getGridColor();
                }
            });
        }

        public Color getBackground() {
            return DbUIUtil.softHighlightOf(TableResultPanel.this.myTable.getBackground());
        }

        void selectAll() {
            boolean deselect;
            ListSelectionModel rowModel = TableResultPanel.this.myTable.getSelectionModel();
            int r0 = rowModel.getMinSelectionIndex();
            int r1 = rowModel.getMaxSelectionIndex();
            ListSelectionModel columnModel = TableResultPanel.this.myTable.getColumnModel().getSelectionModel();
            int c0 = columnModel.getMinSelectionIndex();
            int c1 = columnModel.getMaxSelectionIndex();
            boolean bl = deselect = r1 - r0 + 1 == TableResultPanel.this.myTable.getRowCount() && c1 - c0 + 1 == TableResultPanel.this.myTable.getColumnCount();
            if (deselect) {
                TableResultPanel.this.myTable.clearSelection();
            } else {
                TableResultPanel.this.myAutoscrollLocker.runWithLock(() -> {
                    GridSelection.setRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), 0, TableResultPanel.this.myTable.getRowCount());
                    GridSelection.setColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), 0, TableResultPanel.this.myTable.getColumnCount());
                });
            }
            TableResultPanel.this.myHiddenColumnSelectionHolder.setWholeRowSelected(!deselect);
        }
    }

    private class MySearchRowFilter
    extends RowFilter<TableModel, Integer> {
        private MySearchRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            if (TableResultPanel.this.mySearchSession == null || !TableResultPanel.this.mySearchSession.isFilteringEnabled() || StringUtil.isEmpty((String)TableResultPanel.this.mySearchSession.getFindModel().getStringToFind())) {
                return true;
            }
            ModelIndex<DataConsumer.Row> row = ModelIndex.forRow(TableResultPanel.this, (int)entry.getIdentifier());
            return !TableResultPanel.this.getVisibleColumns().asIterable().filter(column -> TableResultPanel.this.mySearchSession.isMatchedCell(row, column)).isEmpty();
        }
    }

    private class MyTransposedViewColumnFilter
    extends RowFilter<TableModel, Integer> {
        private MyTransposedViewColumnFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            ModelIndex<DataConsumer.Column> column = ModelIndex.forColumn(TableResultPanel.this, (int)entry.getIdentifier());
            return column.isValid(TableResultPanel.this) && TableResultPanel.this.myColumnAttributes.isEnabled(TableResultPanel.this.getDataModel().getColumn(column));
        }
    }

    static class ColumnAttributes {
        private final Map<DataConsumer.Column, Attributes> myAttributesMap = ContainerUtil.newHashMap();
        private List<String> myUnambiguousColumnNames;

        ColumnAttributes() {
        }

        @NotNull
        public String getName(DataConsumer.Column column) {
            String name = column.columnNum < this.myUnambiguousColumnNames.size() ? this.myUnambiguousColumnNames.get(column.columnNum) : column.name;
            String string = StringUtil.isNotEmpty((String)name) ? name : "<anonymous>";
            if (string == null) {
                ColumnAttributes.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public Language getContentLanguage(DataConsumer.Column column) {
            Language language = this.myAttributesMap.get((Object)column).myContentLanguage;
            if (language == null) {
                ColumnAttributes.$$$reportNull$$$0(1);
            }
            return language;
        }

        public void setContentLanguage(DataConsumer.Column column, @NotNull Language language) {
            if (language == null) {
                ColumnAttributes.$$$reportNull$$$0(2);
            }
            this.myAttributesMap.get((Object)column).myContentLanguage = language;
        }

        public Comparator<DataConsumer.Row> getComparator(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).myComparator;
        }

        public boolean isEnabled(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).myEnabled;
        }

        public void setEnabled(DataConsumer.Column column, boolean enabled) {
            this.myAttributesMap.get((Object)column).myEnabled = enabled;
        }

        public int getSortOrder(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).mySortOrder;
        }

        public void resetOrdering() {
            for (Attributes attr : this.myAttributesMap.values()) {
                attr.mySortOrder = 0;
            }
        }

        public void resetVisibility() {
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                this.setEnabled(column, !DbImplUtil.isRowId(column));
            }
        }

        public boolean changeSortOrder(DataConsumer.Column targetColumn, @Nullable RowSortOrder.Type targetSortOrder) {
            if (this.getComparator(targetColumn) == null) {
                return false;
            }
            int prevOrder = this.getSortOrder(targetColumn);
            int maxOrder = 0;
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                if (Comparing.equal((Object)column, (Object)targetColumn)) continue;
                int order = this.getSortOrder(column);
                if (prevOrder != 0 && Math.abs(order) > Math.abs(prevOrder)) {
                    order = order > 0 ? order - 1 : order + 1;
                    this.setSortOrder(column, order);
                }
                maxOrder = Math.max(maxOrder, Math.abs(order));
            }
            int asc = -maxOrder - 1;
            int desc = maxOrder + 1;
            int newOrder = targetSortOrder == RowSortOrder.Type.ASC ? asc : (targetSortOrder == RowSortOrder.Type.DESC ? desc : (targetSortOrder == null ? (prevOrder == 0 ? asc : (prevOrder < 0 ? desc : 0)) : 0));
            this.setSortOrder(targetColumn, newOrder);
            return prevOrder != newOrder;
        }

        public TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
            TreeMap<Integer, DataConsumer.Column> sortOrderMap = new TreeMap<Integer, DataConsumer.Column>();
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                int sortOrder = this.getSortOrder(column);
                if (sortOrder == 0) continue;
                sortOrderMap.put(Math.abs(sortOrder), column);
            }
            return sortOrderMap;
        }

        private void updateColumnNames(TableResultPanel resultPanel) {
            DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(resultPanel);
            SqlTableType type = hookup != null ? hookup.getTableType() : null;
            this.myUnambiguousColumnNames = type == null ? ContainerUtil.emptyList() : DbSqlUtil.getUnambiguousColumnNames(resultPanel.getProject(), hookup.getDatabaseDialect(), type);
        }

        public void newColumns(TableResultPanel resultPanel, Collection<DataConsumer.Column> columnsToRetain) {
            this.updateColumnNames(resultPanel);
            this.myAttributesMap.keySet().retainAll(columnsToRetain);
            columnsToRetain.stream().filter(column -> !this.myAttributesMap.containsKey(column)).forEach(column -> this.myAttributesMap.put((DataConsumer.Column)column, ColumnAttributes.createAttributes(resultPanel, column)));
            this.updateSortOrders();
        }

        private void setSortOrder(DataConsumer.Column column, int sortOrder) {
            this.myAttributesMap.get((Object)column).mySortOrder = sortOrder;
        }

        private void updateSortOrders() {
            int order = 1;
            for (DataConsumer.Column column : this.getSortOrderMap().values()) {
                this.setSortOrder(column, (this.getSortOrder(column) < 0 ? -1 : 1) * order++);
            }
        }

        private static Attributes createAttributes(TableResultPanel resultPanel, DataConsumer.Column column) {
            Attributes attributes = new Attributes();
            attributes.myComparator = GridRowComparator.create(resultPanel, column);
            attributes.myEnabled = !resultPanel.isInitiallyDisabled(column);
            attributes.myContentLanguage = resultPanel.getInitialContentLanguage(column);
            return attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setContentLanguage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static final class Attributes {
            public Language myContentLanguage;
            public Comparator<DataConsumer.Row> myComparator;
            public boolean myEnabled;
            public int mySortOrder;

            Attributes() {
            }
        }
    }
}

