/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.oracle.OraBody;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.oracle.OraMatLog;
import com.intellij.database.model.oracle.OraMatView;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraSequence;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.model.oracle.OraSourceAware;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraTableColumn;
import com.intellij.database.model.oracle.OraTrigger;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.OraNamingService;
import com.intellij.database.scripting.OraScriptingService;
import com.intellij.database.scripting.OraScriptingService$OraCreatingGenerator$WhenMappings;
import com.intellij.database.scripting.OraScriptingService$OraRefreshMatViewGenerator$WhenMappings;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003\u001c\u001d\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0011\u001a\u00180\u0012R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J&\u0010\u0015\u001a\u00180\u0012R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\r\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/scripting/OraScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "model", "(Lcom/intellij/database/model/oracle/OraModel;)V", "statementDelimiter", "", "getStatementDelimiter", "()Ljava/lang/String;", "supportsCreateOrReplace", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSupportsCreateOrReplace", "()Ljava/util/Set;", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createRefreshingGenerator", "init", "", "init$database_scripting", "script", "d", "Lcom/intellij/database/model/DataType;", "OraCreatingGenerator", "OraRefreshMatViewGenerator", "VERSION", "database-scripting"})
public final class OraScriptingService
extends AbstractScriptingService<OraModel, OraRoot, OraSchema> {
    @NotNull
    private final Set<ObjectKind> supportsCreateOrReplace;

    @Override
    public void init$database_scripting() {
        super.init$database_scripting();
        this.setNaming(OraNamingService.INSTANCE);
    }

    @Override
    @NotNull
    public String getStatementDelimiter() {
        return "/";
    }

    @Override
    @NotNull
    protected String script(@NotNull DataType d) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        if (d.getPrecision() == 0x7FFFFFFE && d.scale == 0 && !d.custom) {
            String string2 = d.typeName;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"d.typeName");
        } else if (d.size == 1 && Intrinsics.areEqual((Object)d.typeName, (Object)"CHAR") && !d.sizeUnitExplicit && !d.custom) {
            String string3 = d.typeName;
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"d.typeName");
        } else if (Intrinsics.areEqual((Object)d.schemaName, (Object)"PUBLIC")) {
            String string4 = d.typeName;
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"d.typeName");
        } else if (Intrinsics.areEqual((Object)d.typeName, (Object)"VARCHAR2") && !d.custom && this.getOptions().get(ScriptingOptionStatic.VARCHAR2_TO_VARCHAR).booleanValue()) {
            string = StringsKt.replace$default((String)d.getSpecification(), (String)"VARCHAR2", (String)"VARCHAR", (boolean)false, (int)4, null);
        } else {
            String string5 = d.getSpecification();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"d.specification");
        }
        return string;
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new OraCreatingGenerator(task);
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createRefreshingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new OraRefreshMatViewGenerator(task);
    }

    @Override
    @NotNull
    protected Set<ObjectKind> getSupportsCreateOrReplace() {
        return this.supportsCreateOrReplace;
    }

    public OraScriptingService(@NotNull OraModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicModel basicModel = model;
        OraRoot oraRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)oraRoot, (String)"model.root");
        super(basicModel, (BasicDatabase)oraRoot);
        this.supportsCreateOrReplace = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.VIEW, ObjectKind.MAT_VIEW, ObjectKind.OBJECT_TYPE, ObjectKind.PACKAGE, ObjectKind.BODY, ObjectKind.ROUTINE, ObjectKind.TRIGGER});
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u000200H\u0002J\u000e\u00101\u001a\u00020\n2\u0006\u00102\u001a\u000203J\u0010\u00104\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u00105\u001a\u00020\n2\u0006\u0010)\u001a\u000206H\u0014J\u0010\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209H\u0014J\u000e\u0010:\u001a\u00020\n2\u0006\u0010#\u001a\u00020;J\u0012\u0010<\u001a\u0004\u0018\u00010\u000f2\u0006\u0010=\u001a\u00020>H\u0014J\u0010\u0010?\u001a\u00020@2\u0006\u0010)\u001a\u000206H\u0014\u00a8\u0006A"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$OraCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/OraScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "gatherSequenceIdentityParameters", "", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "parameters", "", "", "generateBody", "body", "Lcom/intellij/database/model/oracle/OraBody;", "generateCluster", "cluster", "Lcom/intellij/database/model/oracle/OraCluster;", "generateClusterIndex", "index", "Lcom/intellij/database/model/oracle/OraClusterIndex;", "generateCollectionType", "col", "Lcom/intellij/database/model/oracle/OraCollectionType;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateMatLog", "ml", "Lcom/intellij/database/model/oracle/OraMatLog;", "generateMatView", "view", "Lcom/intellij/database/model/oracle/OraMatView;", "generateModule", "module", "Lcom/intellij/database/model/oracle/OraModule;", "generateObjectTable", "table", "Lcom/intellij/database/model/oracle/OraTable;", "generatePublicSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateSimpleSourceAwareObject", "obj", "Lcom/intellij/database/model/oracle/OraSourceAware;", "generateSingleRoutine", "routine", "Lcom/intellij/database/model/oracle/OraSingleRoutine;", "generateSynonym", "generateTable", "Lcom/intellij/database/model/basic/BasicTable;", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateView", "Lcom/intellij/database/model/oracle/OraView;", "makeColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "database-scripting"})
    private final class OraCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof OraCluster) {
                this.generateCluster((OraCluster)element);
            } else if (basicElement instanceof OraClusterIndex) {
                this.generateClusterIndex((OraClusterIndex)element);
            } else if (basicElement instanceof OraCollectionType) {
                this.generateCollectionType((OraCollectionType)element);
            } else if (basicElement instanceof OraModule) {
                this.generateModule((OraModule)element);
            } else if (basicElement instanceof OraBody) {
                this.generateBody((OraBody)element);
            } else if (basicElement instanceof OraSingleRoutine) {
                this.generateSingleRoutine((OraSingleRoutine)element);
            } else if (basicElement instanceof OraMatLog) {
                this.generateMatLog((OraMatLog)element);
            } else if (basicElement instanceof OraMatView) {
                this.generateMatView((OraMatView)element);
            } else if (basicElement instanceof OraView) {
                this.generateView((OraView)element);
            } else {
                super.generateElement(element);
            }
        }

        @Override
        protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            super.gatherSequenceIdentityParameters(sequence, parameters);
            if (sequence instanceof OraSequence) {
                if (((OraSequence)sequence).isOrdered()) {
                    parameters.add("order");
                }
                if (((OraSequence)sequence).isCycled()) {
                    parameters.add("cycle");
                }
                if (((OraSequence)sequence).getCacheSize() > 0) {
                    parameters.add("cache " + ((OraSequence)sequence).getCacheSize());
                }
                if (((OraSequence)sequence).getCacheSize() < 0) {
                    parameters.add("nocache");
                }
            }
        }

        @Override
        protected void generateTable(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            if (table instanceof OraTable && ((OraTable)table).getRowTypeObjectName() != null) {
                this.generateObjectTable((OraTable)table);
            } else {
                super.generateTable(table);
            }
        }

        private final void generateObjectTable(OraTable table) {
            String string;
            String $receiver$iv;
            OraScriptingService this_$iv;
            String objectSchemaName = table.getRowTypeSchemaName();
            if (Intrinsics.areEqual((Object)objectSchemaName, (Object)table.getSchemaName())) {
                objectSchemaName = null;
            }
            String string2 = table.getRowTypeObjectName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String objectName = string2;
            if (objectSchemaName == null) {
                String string3 = objectName;
                this_$iv = OraScriptingService.this;
                string = this_$iv.getNaming().nameToScript($receiver$iv);
            } else {
                $receiver$iv = objectSchemaName;
                this_$iv = OraScriptingService.this;
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = this_$iv.getNaming().nameToScript($receiver$iv);
                $receiver$iv = objectName;
                this_$iv = OraScriptingService.this;
                stringBuilder = stringBuilder.append(string4).append('.');
                string4 = this_$iv.getNaming().nameToScript($receiver$iv);
                string = stringBuilder.append(string4).toString();
            }
            String n = string;
            String[] stringArray = new String[5];
            stringArray[0] = "create table";
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"TABLE");
            stringArray[1] = this.ifNotExists(objectKind);
            stringArray[2] = OraScriptingService.this.currentScopeName(table);
            stringArray[3] = "of";
            stringArray[4] = n;
            String s = ScriptingUtilsKt.phrase(stringArray);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        @Nullable
        protected String makeColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String s = super.makeColumnSpecification(column);
            if (column instanceof OraTableColumn && ((OraTableColumn)column).isAutoInc()) {
                Collection collection;
                String x = ((OraTableColumn)column).isDefaultOnNull() ? " generated by default on null as identity" : " generated as identity";
                ArrayList parameters = new ArrayList();
                SequenceIdentity sequenceIdentity = ((OraTableColumn)column).getSequenceIdentity();
                if (sequenceIdentity != null) {
                    this.gatherSequenceIdentityParameters(sequenceIdentity, (List<String>)parameters);
                }
                if (!(collection = (Collection)parameters).isEmpty()) {
                    x = x + " (" + CollectionsKt.joinToString$default((Iterable)parameters, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ')';
                }
                s = Intrinsics.stringPlus((String)s, (Object)x);
            }
            return s;
        }

        private final void generateCluster(OraCluster cluster) {
            String name = OraScriptingService.this.currentScopeName(cluster);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, cluster){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ OraCluster $cluster;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create cluster " + this.$name, null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    AbstractScriptingService.CodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateCluster.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            for (OraClusterColumn oraClusterColumn : this.this$0.$cluster.getColumns()) {
                                void $receiver$iv;
                                String string = oraClusterColumn.getName();
                                OraScriptingService this_$iv = this.this$0.this$0.OraScriptingService.this;
                                String name1 = this_$iv.getNaming().nameToScript((String)$receiver$iv);
                                String type1 = oraClusterColumn.getDataType().getSpecification();
                                String suffix = oraClusterColumn.isSorted() ? " sort" : "";
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "" + name1 + ' ' + type1 + "" + suffix + ',', null, false, 6, null);
                            }
                            if (this.this$0.$cluster.getColumns().isEmpty()) {
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "-- looks like columns were not retrieved because the user had no SELECT_CATALOG_ROLE :(", null, false, 6, null);
                            }
                            this.this$0.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$cluster.getBlockSize() > 0) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "size " + this.$cluster.getBlockSize(), null, false, 6, null);
                        }
                        String singleTableClause = this.$cluster.isSingleTable() ? "single table" : null;
                        String cardinalityClause = this.$cluster.getHashCardinality() != 0 ? "hashkeys " + this.$cluster.getHashCardinality() : null;
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), ScriptingUtilsKt.concatWithSpace(singleTableClause, cardinalityClause), null, false, 6, null);
                        if (this.$cluster.getHashExpression() != null) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "hash is " + this.$cluster.getHashExpression(), null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$name = string;
                    this.$cluster = oraCluster;
                    super(0);
                }
            }, 3, null);
            OraClusterIndex index = cluster.getIndices().get();
            if (index != null) {
                this.generateClusterIndex(index);
            }
        }

        private final void generateClusterIndex(OraClusterIndex index) {
            OraCluster oraCluster = index.getCluster();
            if (oraCluster == null) {
                return;
            }
            OraCluster cluster = oraCluster;
            String clusterName = OraScriptingService.this.currentScopeName(cluster);
            String indexName = OraScriptingService.this.currentScopeName(index);
            ClusterType clusterType = cluster.getClusterType();
            if (clusterType != null) {
                switch (OraScriptingService$OraCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[clusterType.ordinal()]) {
                    case 1: {
                        AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, indexName, clusterName){
                            final /* synthetic */ OraCreatingGenerator this$0;
                            final /* synthetic */ String $indexName;
                            final /* synthetic */ String $clusterName;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void invoke() {
                                CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                                CharSequence[] charSequenceArray = new CharSequence[3];
                                charSequenceArray[0] = "create index";
                                ObjectKind objectKind = ObjectKind.INDEX;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"INDEX");
                                charSequenceArray[1] = this.this$0.ifNotExists(objectKind);
                                charSequenceArray[2] = this.$indexName;
                                codeTextBuilder.phrase(charSequenceArray);
                                CodeTextBuilder this_$iv = this.this$0.getBuilder();
                                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                                try {
                                    this.this$0.getBuilder().phrase("on cluster", this.$clusterName);
                                }
                                finally {
                                    this_$iv.unindent();
                                }
                            }
                            {
                                this.this$0 = oraCreatingGenerator;
                                this.$indexName = string;
                                this.$clusterName = string2;
                                super(0);
                            }
                        }, 3, null);
                    }
                }
            }
            OraScriptingService.this.getGenerated().add(index);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            OraTable tab = (OraTable)table;
            String name = OraScriptingService.this.currentScopeName(table);
            String[] stringArray = new String[3];
            stringArray[0] = "create table";
            ObjectKind objectKind = ((OraTable)table).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"table.kind");
            stringArray[1] = this.ifNotExists(objectKind);
            stringArray[2] = name;
            String string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String h = string;
            String f = null;
            if (tab.getClusterName() != null) {
                void $receiver$iv;
                void $receiver$iv2;
                String string2 = tab.getClusterName();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = string2;
                OraScriptingService this_$iv = OraScriptingService.this;
                String cn = this_$iv.getNaming().nameToScript((String)$receiver$iv2);
                Iterable $i$f$getScr = ((OraTable)table).getClusterColNames();
                OraScriptingService this_$iv2 = OraScriptingService.this;
                String cols = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((AbstractScriptingService)this_$iv2){
                    final /* synthetic */ AbstractScriptingService this$0;

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        String $receiver$iv = it;
                        AbstractScriptingService this_$iv = this.this$0;
                        return this_$iv.getNaming().nameToScript($receiver$iv);
                    }
                    {
                        this.this$0 = abstractScriptingService;
                        super(1);
                    }
                }), (int)31, null);
                f = "\tcluster " + cn + " (" + cols + ')';
            } else if (Intrinsics.areEqual((Object)((Object)tab.getOrganization()), (Object)((Object)TableOrganization.INDEX))) {
                f = "\torganization index";
            } else if (tab.isTemporary()) {
                String string4;
                String[] stringArray2 = new String[3];
                stringArray2[0] = "create global temporary table";
                ObjectKind objectKind2 = ((OraTable)table).getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"table.kind");
                stringArray2[1] = this.ifNotExists(objectKind2);
                stringArray2[2] = name;
                String string5 = ScriptingUtilsKt.phrase(stringArray2);
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                h = string5;
                boolean bl = tab.isTemporaryPreserve();
                if (!bl) {
                    string4 = "\ton commit delete rows";
                } else if (bl) {
                    string4 = "\ton commit preserve rows";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                f = string4;
            }
            return new HeaderFooter(h, f);
        }

        public final void generateCollectionType(@NotNull OraCollectionType col) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
            String name = OraScriptingService.this.currentScopeName(col);
            int n = col.getUpperBound();
            DataType dataType = col.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"col.elementType");
            String d = OraScriptingService.this.script(dataType);
            if (col.isArray() && n > 0) {
                String[] stringArray = new String[4];
                ObjectKind objectKind = col.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
                stringArray[0] = this.createOrReplace(objectKind);
                stringArray[1] = "type";
                stringArray[2] = name;
                stringArray[3] = "is varray(" + n + ") of " + d;
                string = ScriptingUtilsKt.phrase(stringArray);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                String[] stringArray = new String[5];
                ObjectKind objectKind = col.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
                stringArray[0] = this.createOrReplace(objectKind);
                stringArray[1] = "type";
                stringArray[2] = name;
                stringArray[3] = "as table of";
                stringArray[4] = d;
                string = ScriptingUtilsKt.phrase(stringArray);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            }
            String s1 = string;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s1){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $s1;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s1, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$s1 = string;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateTrigger(@NotNull BasicTrigger trigger2) {
            OraTable table;
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            OraTrigger cfr_ignored_0 = (OraTrigger)trigger2;
            String triggerName = OraScriptingService.this.currentScopeName(trigger2);
            CharSequence charSequence = ((OraTrigger)trigger2).getOriginalSourceText();
            if (charSequence == null) {
                return;
            }
            CharSequence text = charSequence;
            BasicLikeTable basicLikeTable = ((OraTrigger)trigger2).getTable();
            if (!(basicLikeTable instanceof OraTable)) {
                basicLikeTable = null;
            }
            if ((table = (OraTable)basicLikeTable) == null) {
                AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName){
                    final /* synthetic */ OraCreatingGenerator this$0;
                    final /* synthetic */ String $triggerName;

                    public final void invoke() {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- Cannot generate trigger " + this.$triggerName + ": the table is unknown", null, false, 6, null);
                    }
                    {
                        this.this$0 = oraCreatingGenerator;
                        this.$triggerName = string;
                        super(0);
                    }
                }, 3, null);
                return;
            }
            String tableName = OraScriptingService.this.currentScopeName(table);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger2, tableName, text){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ BasicTrigger $trigger;
                final /* synthetic */ String $tableName;
                final /* synthetic */ CharSequence $text;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[3];
                    ObjectKind objectKind = ObjectKind.TRIGGER;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"TRIGGER");
                    charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                    charSequenceArray[1] = "trigger";
                    charSequenceArray[2] = this.$triggerName;
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), ev, null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "on " + this.$tableName, null, false, 6, null);
                        TrigTurn turn = ((OraTrigger)this.$trigger).getTurn();
                        if (Intrinsics.areEqual((Object)turn, (Object)TrigTurn.BEFORE_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.AFTER_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.INSTEAD_OF)) {
                            String c;
                            String string;
                            CharSequence charSequence;
                            String s = "for each row";
                            String string2 = ((OraTrigger)this.$trigger).getCondition();
                            if (string2 != null) {
                                charSequence = string2;
                                String string3 = charSequence;
                                if (string3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                            } else {
                                string = c = null;
                            }
                            if (c != null && (charSequence = (CharSequence)c).length() > 0) {
                                s = s + " when (" + s + ')';
                            }
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), s, null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, CompositeText.Kind.ORIGINAL_TEXT, false, 4, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$triggerName = string;
                    this.$trigger = basicTrigger;
                    this.$tableName = string2;
                    this.$text = charSequence;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateMatLog(@NotNull OraMatLog ml) {
            OraTable logTable;
            Intrinsics.checkParameterIsNotNull((Object)ml, (String)"ml");
            OraTable oraTable = ml.getTable();
            if (oraTable == null) {
                return;
            }
            OraTable masterTable = oraTable;
            String string = masterTable.getRealName();
            if (string == null) {
                return;
            }
            String masterName = string;
            String withOptions = ml.withOptions();
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, masterName, withOptions, ml){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $masterName;
                final /* synthetic */ String $withOptions;
                final /* synthetic */ OraMatLog $ml;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    this.this$0.getBuilder().phrase("create materialized view log on " + this.$masterName);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$withOptions, null, false, 6, null);
                        if (this.$ml.isWithNewValues()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "including new values", null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$masterName = string;
                    this.$withOptions = string2;
                    this.$ml = oraMatLog;
                    super(0);
                }
            }, 3, null);
            OraSchema schema = masterTable.getSchema();
            BasicNode basicNode = schema;
            OraTable oraTable2 = basicNode != null && (basicNode = basicNode.getTables()) != null ? (OraTable)basicNode.get(ml.getName()) : (logTable = null);
            if (logTable != null) {
                OraScriptingService.this.getGenerated().add(logTable);
            }
        }

        public final void generateMatView(@NotNull OraMatView view2) {
            Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
            String name = OraScriptingService.this.currentScopeName(view2);
            Object object = view2.getSourceText();
            if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
                return;
            }
            Object sourceText = object;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view2, name, (CompositeText.Fragment)sourceText){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ OraMatView $view;
                final /* synthetic */ String $name;
                final /* synthetic */ CompositeText.Fragment $sourceText;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[3];
                    ObjectKind objectKind = this.$view.getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"view.kind");
                    charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                    charSequenceArray[1] = "materialized view";
                    charSequenceArray[2] = this.$name;
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$view.isPrebuilt()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "on prebuilt table", null, false, 6, null);
                        }
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$view.getRefreshSpecification(), null, false, 6, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "as", null, false, 6, null);
                    this.this$0.getBuilder().append(this.$sourceText);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$view = oraMatView;
                    this.$name = string;
                    this.$sourceText = fragment;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateView(@NotNull OraView view2) {
            Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
            String name = OraScriptingService.this.currentScopeName(view2);
            Object object = view2.getSourceText();
            if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
                return;
            }
            Object sourceText = object;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view2, name, (CompositeText.Fragment)sourceText){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ OraView $view;
                final /* synthetic */ String $name;
                final /* synthetic */ CompositeText.Fragment $sourceText;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    ObjectKind objectKind = this.$view.getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"view.kind");
                    charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                    charSequenceArray[1] = "view";
                    charSequenceArray[2] = this.$name;
                    charSequenceArray[3] = "as";
                    codeTextBuilder.phrase(charSequenceArray);
                    this.this$0.getBuilder().append(this.$sourceText);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$view = oraView;
                    this.$name = string;
                    this.$sourceText = fragment;
                    super(0);
                }
            }, 3, null);
        }

        public final void generateModule(@NotNull OraModule module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.generateSimpleSourceAwareObject(module);
            OraBody body = module.getBodies().get();
            if (body != null) {
                this.process(body);
            }
        }

        public final void generateBody(@NotNull OraBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            this.generateSimpleSourceAwareObject(body);
        }

        public final void generateSingleRoutine(@NotNull OraSingleRoutine routine2) {
            Intrinsics.checkParameterIsNotNull((Object)routine2, (String)"routine");
            this.generateSimpleSourceAwareObject(routine2);
        }

        private final void generateSimpleSourceAwareObject(OraSourceAware obj) {
            Object object = obj.getSourceText();
            if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
                return;
            }
            Object sourceText = object;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, obj, (CompositeText.Fragment)sourceText){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ OraSourceAware $obj;
                final /* synthetic */ CompositeText.Fragment $sourceText;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    StringBuilder stringBuilder = new StringBuilder();
                    ObjectKind objectKind = this.$obj.getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"obj.kind");
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(this.this$0.createOrReplace(objectKind)).append(" ").toString(), null, false, 2, null);
                    this.this$0.getBuilder().append(this.$sourceText);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$obj = oraSourceAware;
                    this.$sourceText = fragment;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateSynonym(@NotNull BasicSynonym synonym) {
            Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
            if (Intrinsics.areEqual((Object)synonym.getSchemaName(), (Object)"PUBLIC")) {
                this.generatePublicSynonym(synonym);
            } else {
                super.generateSynonym(synonym);
            }
        }

        private final void generatePublicSynonym(BasicSynonym synonym) {
            String text;
            String targetSpec = this.makeSynonymTargetSpec(synonym);
            String name = OraScriptingService.this.currentScopeName(synonym);
            if (targetSpec != null) {
                String[] stringArray = new String[5];
                ObjectKind objectKind = ObjectKind.SYNONYM;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"SYNONYM");
                stringArray[0] = this.createOrReplace(objectKind);
                stringArray[1] = "public synonym";
                stringArray[2] = name;
                stringArray[3] = "for";
                stringArray[4] = targetSpec;
                text = ScriptingUtilsKt.phrase(stringArray);
            } else {
                text = "-- unknown what the public synonym " + name + " references on :(";
            }
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $text;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$text = string;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$OraRefreshMatViewGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$RefreshMatViewGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/OraScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateRefreshMatView", "", "view", "Lcom/intellij/database/model/basic/BasicMatView;", "database-scripting"})
    private final class OraRefreshMatViewGenerator
    extends AbstractScriptingService.RefreshMatViewGenerator {
        @Override
        protected void generateRefreshMatView(@NotNull BasicMatView view2) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
            OraMatView cfr_ignored_0 = (OraMatView)view2;
            switch (OraScriptingService$OraRefreshMatViewGenerator$WhenMappings.$EnumSwitchMapping$0[((OraMatView)view2).getRefreshMethod().ordinal()]) {
                case 1: 
                case 2: {
                    string = "force";
                    break;
                }
                default: {
                    string = "complete";
                }
            }
            String methodString = string;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view2, methodString){
                final /* synthetic */ OraRefreshMatViewGenerator this$0;
                final /* synthetic */ BasicMatView $view;
                final /* synthetic */ String $methodString;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("alter materialized view", ((OraMatView)this.$view).getName(), "refresh", this.$methodString);
                }
                {
                    this.this$0 = oraRefreshMatViewGenerator;
                    this.$view = basicMatView;
                    this.$methodString = string;
                    super(0);
                }
            }, 3, null);
        }

        public OraRefreshMatViewGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/OraScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
            INSTANCE = this;
        }

        static {
            new VERSION();
        }
    }
}

