/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class DataViewsComponent
implements ConfigurableUi<DatabaseSettings> {
    private JPanel myPanel;
    private JTextField myResultPageSizeTextField;
    private JTextField myFilterHistorySizeField;
    private JTextField myLobLengthLimitField;
    private JTextField myPrefetchSizeTextField;
    private JBCheckBox mySubmitImmediatelyCheckBox;

    public DataViewsComponent() {
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(0);
        }
        this.myResultPageSizeTextField.setText(String.valueOf(settings.getPageSize()));
        this.myFilterHistorySizeField.setText(String.valueOf(settings.getFiltersHistorySize()));
        this.myLobLengthLimitField.setText(String.valueOf(settings.getMaxLobLength()));
        this.myPrefetchSizeTextField.setText(String.valueOf(settings.getPrefetchSize()));
        this.mySubmitImmediatelyCheckBox.setSelected(settings.isSubmitImmediately());
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(1);
        }
        if (settings.getPageSize() != StringUtil.parseInt((String)this.myResultPageSizeTextField.getText(), (int)0)) {
            return true;
        }
        if (settings.getFiltersHistorySize() != StringUtil.parseInt((String)this.myFilterHistorySizeField.getText(), (int)0)) {
            return true;
        }
        if (settings.getMaxLobLength() != StringUtil.parseInt((String)this.myLobLengthLimitField.getText(), (int)0)) {
            return true;
        }
        if (settings.getPrefetchSize() != StringUtil.parseInt((String)this.myPrefetchSizeTextField.getText(), (int)0)) {
            return true;
        }
        return settings.isSubmitImmediately() != this.mySubmitImmediatelyCheckBox.isSelected();
    }

    public void apply(@NotNull DatabaseSettings settings) throws ConfigurationException {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(2);
        }
        settings.setPageSize(StringUtil.parseInt((String)this.myResultPageSizeTextField.getText(), (int)0));
        settings.setFiltersHistorySize(StringUtil.parseInt((String)this.myFilterHistorySizeField.getText(), (int)0));
        settings.setMaxLobLength(StringUtil.parseInt((String)this.myLobLengthLimitField.getText(), (int)0));
        settings.setPrefetchSize(StringUtil.parseInt((String)this.myPrefetchSizeTextField.getText(), (int)0));
        settings.setSubmitImmediately(this.mySubmitImmediatelyCheckBox.isSelected());
        DatabaseSettings.fireSettingsChanged();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DataViewsComponent.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/DataViewsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/DataViewsComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBTextField jBTextField = new JBTextField();
        this.myResultPageSizeTextField = jBTextField;
        jBTextField.setColumns(6);
        jBTextField.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Result set page size:");
        jBLabel.setDisplayedMnemonic('P');
        jBLabel.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Filter history size:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBTextField jBTextField2 = new JBTextField();
        this.myFilterHistorySizeField = jBTextField2;
        jBTextField2.setColumns(6);
        jBTextField2.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField2, new GridConstraints(2, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Max LOB length (bytes):");
        jBLabel3.setDisplayedMnemonic('L');
        jBLabel3.setDisplayedMnemonicIndex(8);
        jBLabel3.setToolTipText("LOB values exceeding the limit will not be loaded and displayed");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBTextField jBTextField3 = new JBTextField();
        this.myLobLengthLimitField = jBTextField3;
        jBTextField3.setColumns(6);
        jBTextField3.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField3, new GridConstraints(3, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBTextField jBTextField4 = new JBTextField();
        this.myPrefetchSizeTextField = jBTextField4;
        jBTextField4.setColumns(6);
        jBTextField4.setHorizontalAlignment(4);
        jPanel.add((Component)jBTextField4, new GridConstraints(1, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Result set prefetch size:");
        jBLabel4.setDisplayedMnemonic('F');
        jBLabel4.setDisplayedMnemonicIndex(14);
        jBLabel4.setToolTipText("Default number of rows to be preloaded by a jdbc driver when fetching a result set");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySubmitImmediatelyCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Submit changes immediately");
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Data Modification");
        jPanel.add((Component)titledSeparator, new GridConstraints(4, 0, 1, 3, 0, 3, 6, 0, null, null, null));
        jBLabel.setLabelFor((Component)jBTextField);
        jBLabel2.setLabelFor((Component)jBTextField2);
        jBLabel3.setLabelFor((Component)jBTextField3);
        jBLabel4.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

