/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.db2;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.util.PairConsumer;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class Db2DefinitionProvider
extends DefinitionProviderImpl {
    public static final Db2DefinitionProvider INSTANCE = new Db2DefinitionProvider();
    private static final String VIEW_STMT = "SELECT VIEW_DEFINITION FROM SYSIBM.VIEWS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
    private static final String ROUTINE_STMT = "SELECT ROUTINE_DEFINITION FROM SYSIBM.ROUTINES WHERE ROUTINE_SCHEMA = ? AND ROUTINE_NAME = ?";
    private static final String TABLE_STMT1 = "CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)";
    private static final String TABLE_STMT2 = "SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = ?";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            Db2DefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.TABLE || kind == ObjectKind.ROUTINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            Db2DefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            Db2DefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            Db2DefinitionProvider.$$$reportNull$$$0(3);
        }
        PreparedStatement routineStmt = null;
        PreparedStatement viewStmt = null;
        CallableStatement tableCall = null;
        PreparedStatement tableStmt = null;
        try {
            for (DasObject dasObject : objects) {
                PreparedStatement statement;
                ObjectKind kind = dasObject.getKind();
                if (kind == ObjectKind.ROUTINE) {
                    statement = routineStmt == null ? connection.prepareStatement(ROUTINE_STMT) : routineStmt;
                } else if (kind == ObjectKind.VIEW) {
                    statement = viewStmt == null ? connection.prepareStatement(VIEW_STMT) : viewStmt;
                } else {
                    if (kind != ObjectKind.TABLE) continue;
                    if (tableCall == null) {
                        tableCall = connection.prepareCall(TABLE_STMT1);
                        tableCall.registerOutParameter(2, 4);
                    }
                    PreparedStatement preparedStatement = statement = tableStmt == null ? connection.prepareStatement(TABLE_STMT2) : tableStmt;
                }
                if (kind == ObjectKind.TABLE) {
                    tableCall.setString(1, QNameUtil.getQualifiedName(dasObject));
                    tableCall.executeUpdate();
                    int token = tableCall.getInt(2);
                    statement.setInt(1, token);
                } else {
                    statement.setString(1, DasUtil.getSchema((DasObject)dasObject));
                    statement.setString(2, dasObject.getName());
                }
                try {
                    ResultSet rs = statement.executeQuery();
                    Throwable throwable = null;
                    try {
                        consumer.consume((Object)dasObject, !rs.next() ? null : rs.getString(1));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    consumer.consume((Object)dasObject, (Object)e);
                }
            }
        }
        finally {
            JdbcUtil.closeStatementSafe(routineStmt);
            JdbcUtil.closeStatementSafe(viewStmt);
            JdbcUtil.closeStatementSafe(tableCall);
            JdbcUtil.closeStatementSafe(tableStmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/db2/Db2DefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

