/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.h2;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.util.PairConsumer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class H2DefinitionProvider
extends DefinitionProviderImpl {
    public static final H2DefinitionProvider INSTANCE = new H2DefinitionProvider();
    private static final String INDEX_STMT = "SELECT SQL FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND INDEX_NAME=?";
    private static final String TABLE_STMT = "SELECT SQL FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?";
    private static final String TRIGGER_STMT = "SELECT SQL FROM INFORMATION_SCHEMA.TRIGGERS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND TRIGGER_NAME=?";
    private static final String VIEW_STMT = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA=? AND TABLE_NAME=?";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            H2DefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.INDEX || kind == ObjectKind.TABLE || kind == ObjectKind.TRIGGER || kind == ObjectKind.VIEW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            H2DefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            H2DefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            H2DefinitionProvider.$$$reportNull$$$0(3);
        }
        PreparedStatement indexStmt = null;
        PreparedStatement tableStmt = null;
        PreparedStatement triggerStmt = null;
        PreparedStatement viewStmt = null;
        try {
            for (DasObject dasObject : objects) {
                PreparedStatement statement;
                ObjectKind kind = dasObject.getKind();
                if (kind == ObjectKind.INDEX) {
                    statement = indexStmt == null ? connection.prepareStatement(INDEX_STMT) : indexStmt;
                } else if (kind == ObjectKind.TABLE) {
                    statement = tableStmt == null ? connection.prepareStatement(TABLE_STMT) : tableStmt;
                } else if (kind == ObjectKind.TRIGGER) {
                    statement = triggerStmt == null ? connection.prepareStatement(TRIGGER_STMT) : triggerStmt;
                } else {
                    if (kind != ObjectKind.VIEW) continue;
                    statement = viewStmt == null ? connection.prepareStatement(VIEW_STMT) : viewStmt;
                }
                statement.setString(1, DasUtil.getSchema((DasObject)dasObject));
                if (kind == ObjectKind.INDEX || kind == ObjectKind.TRIGGER) {
                    statement.setString(2, DasUtil.getName((DasObject)dasObject.getDbParent()));
                    statement.setString(3, dasObject.getName());
                } else {
                    statement.setString(2, dasObject.getName());
                }
                try {
                    ResultSet rs = statement.executeQuery();
                    Throwable throwable = null;
                    try {
                        consumer.consume((Object)dasObject, !rs.next() ? null : rs.getString(1));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    consumer.consume((Object)dasObject, (Object)e);
                }
            }
        }
        finally {
            JdbcUtil.closeStatementSafe(indexStmt);
            JdbcUtil.closeStatementSafe(tableStmt);
            JdbcUtil.closeStatementSafe(triggerStmt);
            JdbcUtil.closeStatementSafe(viewStmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/h2/H2DefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

