/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.sql.SqlFileType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=ElementPresentation.class)
public class DatabaseElementVirtualFileImpl
extends VirtualFile
implements VirtualFilePathWrapper,
SmartPsiElementPointer<DbElement> {
    public static final Function<String, String> ESCAPER = DatabaseElementVirtualFileImpl::escape;
    public static final Function<DasObject, String> NAMER = Functions.compose((Function)DasUtil.TO_NAME, ESCAPER);
    private final String myProjectId;
    private final String myDataSourceId;
    private String myName;
    private final ObjectKind myKind;
    private boolean myWritable;
    private boolean mySource;
    private Pair<Reference<DbElement>, Long> myCachedPsi;
    private volatile boolean myBusy;
    private volatile String myContent;

    protected DatabaseElementVirtualFileImpl(@NotNull String projectId, @NotNull String dataSourceId, @NotNull String name, @NotNull ObjectKind kind, boolean source) {
        if (projectId == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(0);
        }
        if (dataSourceId == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(1);
        }
        if (name == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(3);
        }
        this.myWritable = true;
        this.myProjectId = projectId;
        this.myDataSourceId = dataSourceId;
        this.myName = name;
        this.myKind = kind;
        this.mySource = source;
    }

    public boolean isSource() {
        return this.mySource;
    }

    @NotNull
    public Project getProject() {
        Project project = DatabaseVirtualFileSystem.getDatabaseFileSystem().getProjectOrFail(this.myProjectId);
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public String getPath() {
        String string = DatabaseVirtualFileSystem.getPath(this.myProjectId, this.myDataSourceId, this.myName, this.myKind, this.mySource);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = DatabaseElementVirtualFileImpl.unescape(this.myName.substring(this.myName.lastIndexOf(46) + 1));
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getNameWithoutExtension() {
        String string = this.getName();
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String getDataSourceId() {
        return this.myDataSourceId;
    }

    @Nullable
    public DbDataSource findDataSource() {
        return DbPsiFacade.getInstance((Project)this.getProject()).findDataSource(this.myDataSourceId);
    }

    @NotNull
    public ObjectKind getObjectKind() {
        ObjectKind objectKind = this.myKind;
        if (objectKind == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(8);
        }
        return objectKind;
    }

    @Nullable
    public DbElement findElement() {
        return this.findElementInner(this.findDataSource());
    }

    @Nullable
    private DbElement findElementInner(@Nullable DbDataSource dataSource) {
        DbElement cached;
        if (dataSource == null) {
            return null;
        }
        if (this.myKind == ObjectKind.ROOT) {
            return dataSource;
        }
        long timestamp = DbPsiFacade.getInstance((Project)dataSource.getProject()).getModificationCount();
        Pair<Reference<DbElement>, Long> cachedPsi = this.myCachedPsi;
        DbElement dbElement = cached = cachedPsi != null && (Long)cachedPsi.second == timestamp ? (DbElement)((Reference)cachedPsi.first).get() : null;
        if (cached != null) {
            return cached;
        }
        DbElement found = ((DbDataSourceImpl)dataSource).findElement(this.myName, this.myKind);
        this.myCachedPsi = found != null ? Pair.create(new WeakReference<DbElement>(found), (Object)timestamp) : null;
        return found;
    }

    @NotNull
    public FileType getFileType() {
        if (this.mySource) {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(9);
            }
            return sqlFileType;
        }
        if (DbImplUtil.isDataTable(this.myKind)) {
            FileType fileType = super.getFileType();
            if (fileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(10);
            }
            return fileType;
        }
        if (DatabaseEditorHelper.isDefinitionAvailable(this.findElement())) {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(11);
            }
            return sqlFileType;
        }
        FileType fileType = super.getFileType();
        if (fileType == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(12);
        }
        return fileType;
    }

    @NotNull
    public DatabaseVirtualFileSystem getFileSystem() {
        DatabaseVirtualFileSystem databaseVirtualFileSystem = DatabaseVirtualFileSystem.getDatabaseFileSystem();
        if (databaseVirtualFileSystem == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(13);
        }
        return databaseVirtualFileSystem;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    public void setWritable(boolean writable) {
        boolean prev = this.myWritable;
        DbDataSource dataSource = !writable ? null : this.findDataSource();
        boolean bl = this.myWritable = dataSource != null && dataSource.isWritable();
        if (prev != this.myWritable) {
            BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, (VirtualFile)this, "writable", (Object)prev, (Object)this.myWritable, false));
            publisher.before(events);
            publisher.after(events);
        }
    }

    public final void setWritableInner(boolean writable) {
        this.myWritable = writable;
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public InputStream getInputStream() {
        return null;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        if (!this.getFileType().isBinary()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

                @Override
                public void close() {
                    DatabaseElementVirtualFileImpl.this.myContent = new String(this.buf, 0, this.count, DatabaseElementVirtualFileImpl.this.getCharset());
                    FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{DatabaseElementVirtualFileImpl.this});
                }
            };
            if (byteArrayOutputStream == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(14);
            }
            return byteArrayOutputStream;
        }
        throw new IOException("Unsupported operation");
    }

    public void setContent(@NotNull String content) {
        if (content == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(15);
        }
        this.myContent = content;
    }

    public String getContent() {
        return this.myContent;
    }

    public boolean isBusy() {
        return this.myBusy;
    }

    public void setBusy(boolean busy) {
        this.myBusy = busy;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.myContent != null ? this.myContent.getBytes(this.getCharset()) : ArrayUtil.EMPTY_BYTE_ARRAY;
        if (byArray == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(16);
        }
        return byArray;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public boolean isValid() {
        Project project = DatabaseVirtualFileSystem.getDatabaseFileSystem().getProject(this.myProjectId);
        if (project == null || project.isDisposed()) {
            return false;
        }
        DbDataSource dataSource = this.findDataSource();
        if (dataSource == null) {
            return false;
        }
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DatabaseSystem)dataSource);
        if (localDataSource != null && localDataSource.isLoading()) {
            return true;
        }
        return this.findElementInner(dataSource) != null;
    }

    @Nullable
    public DbElement getElement() {
        return this.findElement();
    }

    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    public VirtualFile getVirtualFile() {
        return this;
    }

    @Nullable
    public Segment getRange() {
        return null;
    }

    @Nullable
    public Segment getPsiRange() {
        return null;
    }

    @Nullable
    public static DatabaseElementVirtualFileImpl findFile(@Nullable DbElement element, boolean source) {
        if (element == null || !element.isValid()) {
            return null;
        }
        String path = DatabaseElementVirtualFileImpl.getPath(element, source);
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
        if (ApplicationManager.getApplication().isUnitTestMode() && file != null && file.findElement() != element) {
            throw new AssertionError((Object)path);
        }
        return file;
    }

    @Nullable
    public static DatabaseElementVirtualFileImpl findFile(@Nullable Project project, @Nullable DatabaseSystem dataSource, @Nullable ObjectPath objectPath) {
        DbDataSource dbDataSource;
        if (project == null || dataSource == null) {
            return null;
        }
        String name = objectPath == null ? "" : StringUtil.join(objectPath.path, ESCAPER, (String)".");
        ObjectKind kind = objectPath == null ? ObjectKind.ROOT : objectPath.kind;
        String path = DatabaseVirtualFileSystem.getPath(project, dataSource.getUniqueId(), name, kind, false);
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
        if (ApplicationManager.getApplication().isUnitTestMode() && file != null && ((dbDataSource = file.findDataSource()) == null || DbImplUtil.unwrapDS((DatabaseSystem)dbDataSource) != DbImplUtil.unwrapDS(dataSource))) {
            throw new AssertionError((Object)path);
        }
        return file;
    }

    public static String getPath(@NotNull Project project, @NotNull DatabaseSystem dataSource, @NotNull DasObject object, boolean source) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(17);
        }
        if (dataSource == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(18);
        }
        if (object == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(19);
        }
        return DatabaseVirtualFileSystem.getPath(project, dataSource.getUniqueId(), DatabaseElementVirtualFileImpl.encodeQName(object), object.getKind(), source);
    }

    private static String getPath(@NotNull DbElement element, boolean source) {
        if (element == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(20);
        }
        return DatabaseElementVirtualFileImpl.getPath(element.getProject(), (DatabaseSystem)element.getDataSource(), (DasObject)element, source);
    }

    private static String encodeQName(@NotNull DasObject obj) {
        if (obj == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(21);
        }
        return QNameUtil.getQualifiedName(obj, NAMER);
    }

    static String[] decodeQName(String name) {
        String[] strings = ArrayUtil.toStringArray((Collection)StringUtil.split((String)name, (String)".", (boolean)true, (boolean)false));
        int stringsLength = strings.length;
        for (int i2 = 0; i2 < stringsLength; ++i2) {
            strings[i2] = DatabaseElementVirtualFileImpl.unescape(strings[i2]);
        }
        return strings;
    }

    public static String escape(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String[])new String[]{"/", "&", "."}, (String[])new String[]{"&eslash;", "&amp;", "&dot;"});
    }

    public static String unescape(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String[])new String[]{"&eslash;", "&amp;", "&dot;"}, (String[])new String[]{"/", "&", "."});
    }

    public Language getLanguage() {
        return DbSqlUtil.getSqlDialect((DbElement)this.findDataSource());
    }

    public String getPresentableName() {
        return this.adjustPresentableName(this.getName());
    }

    @NotNull
    public String getPresentablePath() {
        String string = this.adjustPresentableName(DatabaseElementVirtualFileImpl.unescape(this.myName));
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private String adjustPresentableName(@NotNull String name) {
        if (name == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(23);
        }
        DbDataSource dataSource = this.findDataSource();
        String string = (this.mySource ? name + " (DDL)" : name) + (dataSource == null || this.myKind == ObjectKind.ROOT ? "" : " [" + dataSource.getName() + "]");
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    public boolean enforcePresentableName() {
        return false;
    }

    public String toString() {
        return "DB VirtualFile: " + this.myKind + ", " + this.getPresentableUrl();
    }

    @Nullable
    public static String getEditorTabTitleImpl(Project project, VirtualFile file) {
        UISettings uiSettings = UISettings.getInstance();
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        return uiSettings.getEditorTabPlacement() == 0 ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file) : UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePathWithinOpenedFileEditors(project, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectKind";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 24: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "encodeQName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "adjustPresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ElementPresentation
    extends PresentationProvider<DatabaseElementVirtualFileImpl>
    implements EditorTabTitleProvider {
        public Icon getIcon(DatabaseElementVirtualFileImpl file) {
            DbElement element = file.findElement();
            return element == null ? null : element.getIcon();
        }

        @Nullable
        public String getEditorTabTitle(Project project, VirtualFile file) {
            if (!(file instanceof DatabaseElementVirtualFileImpl)) {
                return null;
            }
            return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, file);
        }
    }
}

