/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.Searchable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.AbstractTreeModel;
import gnu.trove.TObjectHashingStrategy;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DatabaseStructure
extends AbstractTreeModel
implements Disposable,
InvokerSupplier,
Searchable,
ChildrenProvider<Object> {
    private static final String ROOT = "<root>";
    private final Invoker myInvoker = new Invoker.BackgroundThread((Disposable)this);
    private final DbPsiFacade myFacade;
    private final DatabaseViewOptions myViewOptions;
    private static final Key<ConcurrentMap<DasObject, ConcurrentMap<ObjectKind, GroupElement>>> DB_VIEW_GROUP_KEY = Key.create((String)"DB_VIEW_GROUP_KEY");

    DatabaseStructure(DbPsiFacade facade, DatabaseViewOptions viewOptions) {
        this.myViewOptions = viewOptions;
        this.myFacade = facade;
    }

    public void refreshAll() {
        this.treeStructureChanged(null, null, null);
    }

    public Object getRoot() {
        return ROOT;
    }

    public Object getChild(Object parent, int index) {
        throw new UnsupportedOperationException();
    }

    public int getChildCount(Object parent) {
        throw new UnsupportedOperationException();
    }

    public boolean isLeaf(Object node) {
        return DatabaseStructure.isAlwaysLeafImpl(node);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            DatabaseStructure.$$$reportNull$$$0(0);
        }
        return invoker;
    }

    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        LinkedList result2 = ContainerUtil.newLinkedList();
        Object cur = object;
        while (cur != null) {
            result2.addFirst(cur);
            cur = DatabaseStructure.getParentImpl(cur, this.myViewOptions, this.myFacade);
        }
        result2.addFirst(ROOT);
        Promise promise = Promise.resolve((Object)new TreePath(ArrayUtil.toObjectArray((Collection)result2)));
        if (promise == null) {
            DatabaseStructure.$$$reportNull$$$0(1);
        }
        return promise;
    }

    private int compareNodes(@NotNull Object o1, @NotNull Object o2) {
        int weightDiff;
        if (o1 == null) {
            DatabaseStructure.$$$reportNull$$$0(2);
        }
        if (o2 == null) {
            DatabaseStructure.$$$reportNull$$$0(3);
        }
        return (weightDiff = DbPresentation.getWeight(o1, this.myViewOptions.SORT_POSITIONED) - DbPresentation.getWeight(o2, this.myViewOptions.SORT_POSITIONED)) != 0 ? weightDiff : StringUtil.naturalCompare((String)DatabaseStructure.getName(o1), (String)DatabaseStructure.getName(o2));
    }

    @NotNull
    public List<Object> getChildren(Object parent) {
        List children = (List)this.getChildElements(parent).addAllTo((Collection)ContainerUtil.newArrayList());
        Collections.sort(children, this::compareNodes);
        if (parent instanceof GroupElement) {
            ((GroupElement)((Object)parent)).size = children.size();
        }
        List list = children;
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static String getName(@NotNull Object o) {
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(5);
        }
        return o instanceof DasObject ? DbPresentation.getPresentableName((DasObject)o, true) : (o instanceof PsiNamedElement ? ((PsiNamedElement)o).getName() : null);
    }

    @NotNull
    private JBIterable<?> getChildElements(Object element) {
        if (element == ROOT || element == this.myFacade) {
            JBIterable jBIterable = JBIterable.from((Iterable)this.myFacade.getDataSources());
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        JBIterable<?> jBIterable = DatabaseStructure.getChildrenImpl(element, this.myViewOptions, this.myFacade);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    public static boolean isAlwaysLeafImpl(Object o) {
        BasicElement basic = o instanceof DasObject ? DbImplUtil.getMaybeBasicElement((DasObject)o) : null;
        return basic != null && basic.getFamilyKinds().isEmpty() || o instanceof DasObject && (((DasObject)o).getKind() == ObjectKind.SEQUENCE || o instanceof DasTableChild || o instanceof DasRoutine || o instanceof DasSynonym);
    }

    public static boolean isDatabaseObject(Object element) {
        return element instanceof DasObject || element instanceof GroupElement;
    }

    @NotNull
    public static JBIterable<?> getChildrenImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions, @NotNull DbPsiFacade facade) {
        boolean groupOption;
        DasObject root0;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(9);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(10);
        }
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(11);
        }
        Object object = o instanceof GroupElement ? ((GroupElement)((Object)o)).parentElement : (o instanceof DbDataSource && !viewOptions.SHOW_INTERMEDIATE ? DatabaseStructure.getTopSingleRoot((DbDataSource)o) : (o instanceof DasNamespace && !viewOptions.SHOW_INTERMEDIATE ? DatabaseStructure.getTopSingleRoot((DasObject)o) : (root0 = o instanceof DasObject ? (DasObject)o : null)));
        if (root0 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        DasObject root2 = root0;
        DbDataSource dataSource = facade.findDataSource(root2);
        if (dataSource == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        ObjectKind kidKind = o instanceof GroupElement ? ((GroupElement)((Object)o)).childKind : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        MetaModel metaModel = dialect.getMetaModel();
        boolean isNamespace = rootKind == ObjectKind.ROOT || metaModel.getNamespaces().contains(rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind == ObjectKind.NONE) {
            List groups = ContainerUtil.newSmartList();
            int count = 0;
            for (ObjectKind childKind : DatabaseStructure.getChildKinds(root2, metaModel, rootKind)) {
                int weight = DbPresentation.getWeight(childKind, ++count);
                JBIterable<DasObject> kids = DatabaseStructure.getChildObjects(root2, childKind);
                if (!viewOptions.SHOW_EMPTY_GROUPS && kids.isEmpty()) continue;
                GroupElement groupElement = DatabaseStructure.getGroup(root2, childKind, weight, dialect, dataSource);
                groupElement.size = kids.size();
                groups.add(groupElement);
            }
            if (groups.size() > 1) {
                JBIterable jBIterable = JBIterable.from((Iterable)groups);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(14);
                }
                return jBIterable;
            }
        }
        JBIterable children = DatabaseStructure.getChildObjects(root2, kidKind);
        if (root2 instanceof DbDataSource || root2 instanceof BasicNamespaceOwner) {
            IntrospectionScope scope;
            IntrospectionScope introspectionScope = scope = dataSource.getDelegate() instanceof LocalDataSource ? ((LocalDataSource)dataSource.getDelegate()).getIntrospectionScope() : null;
            if (scope != null) {
                children = children.filter(oo -> DatabaseModelLoader.matches(oo, scope));
            }
        }
        if (!viewOptions.SHOW_TABLE_DETAILS && o instanceof DasTable) {
            children = children.filter(DasUtil.byKind((ObjectKind)ObjectKind.COLUMN));
        }
        if (root2 instanceof DasNamespace) {
            try {
                Condition<DasObject> condition = DataSourceUiUtil.buildObjectFilter((DatabaseSystem)dataSource);
                children = children.filter(condition);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        JBIterable jBIterable = children;
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DasObject> getChildObjects(DasObject element, ObjectKind kidKind) {
        DasModel model;
        DasModel dasModel = model = element instanceof DbDataSource ? ((DbDataSource)element).getModel() : null;
        JBIterable jBIterable = model instanceof BasicModel ? ((BasicModel)model).getRoot().getDbChildren(DasObject.class, kidKind) : (model != null ? model.getModelRoots().filter(DasObject.class).filter(DasUtil.byKind((ObjectKind)kidKind)) : element.getDbChildren(DasObject.class, kidKind));
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    private static Iterable<ObjectKind> getChildKinds(@NotNull Object element, @NotNull MetaModel mm, @NotNull ObjectKind parentKind) {
        Object delegate;
        DasModel model;
        if (element == null) {
            DatabaseStructure.$$$reportNull$$$0(17);
        }
        if (mm == null) {
            DatabaseStructure.$$$reportNull$$$0(18);
        }
        if (parentKind == null) {
            DatabaseStructure.$$$reportNull$$$0(19);
        }
        DasModel dasModel = model = element instanceof DbDataSource ? ((DbDataSource)element).getModel() : null;
        Object object = model instanceof BasicModel ? ((BasicModel)model).getRoot() : (delegate = element instanceof DbElement ? ((DbElement)element).getDelegate() : element);
        if (delegate instanceof BasicElement) {
            List<ObjectKind> list = ((BasicElement)delegate).getFamilyKinds();
            if (list == null) {
                DatabaseStructure.$$$reportNull$$$0(20);
            }
            return list;
        }
        JBIterable jBIterable = JBIterable.from((Iterable)mm.getKindCouples()).filter(c -> {
            if (parentKind == null) {
                DatabaseStructure.$$$reportNull$$$0(33);
            }
            return c.first == parentKind;
        }).map(c -> (ObjectKind)c.second);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @Nullable
    public static <T extends DasModel> T getModel(DatabaseSystem ds, Class<T> clazz) {
        LocalDataSource local = DatabaseStructure.getLocalDataSource(ds);
        return (T)(local == null ? null : (DasModel)ObjectUtils.tryCast((Object)local.getModel(), clazz));
    }

    @Nullable
    public static LocalDataSource getLocalDataSource(DatabaseSystem ds) {
        if (ds instanceof LocalDataSource) {
            return (LocalDataSource)ds;
        }
        if (ds instanceof DbDataSource) {
            return DatabaseStructure.getLocalDataSource(((DbDataSource)ds).getDelegate());
        }
        return null;
    }

    @Nullable
    public static PsiElement getParentImpl(@NotNull PsiElement o, DatabaseViewOptions viewOptions) {
        Object delegate;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(22);
        }
        if (!o.isValid()) {
            return null;
        }
        if (o instanceof DbDataSource) {
            return null;
        }
        Object object = o instanceof DbElement ? ((DbElement)o).getDelegate() : (delegate = o instanceof GroupElement ? o : null);
        if (delegate == null) {
            return null;
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)o.getProject());
        Object parent = DatabaseStructure.getParentImpl(delegate, viewOptions, facade);
        if (parent instanceof DasObject) {
            DbDataSource dataSource = facade.findDataSource((DasObject)parent);
            return dataSource == null ? null : DbImplUtil.findElement(dataSource, (DasObject)parent);
        }
        return parent instanceof PsiElement ? (PsiElement)parent : null;
    }

    @Nullable
    public static Object getParentImpl(@NotNull Object o, DatabaseViewOptions viewOptions, DbPsiFacade facade) {
        boolean groupOption;
        DasObject grandPa;
        DasObject root0;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(23);
        }
        Object object = o instanceof GroupElement ? ((GroupElement)((Object)o)).parentElement : (root0 = o instanceof DasObject ? ((DasObject)o).getDbParent() : null);
        while (root0 instanceof DasNamespace && (grandPa = ((DasNamespace)root0).getDbParent()) != null && !viewOptions.SHOW_INTERMEDIATE && DatabaseStructure.getTopSingleRoot(grandPa) != grandPa) {
            root0 = grandPa;
        }
        DasObject root1 = root0;
        if (root1 == null) {
            return null;
        }
        DbDataSource dataSource = facade.findDataSource(root1);
        if (dataSource == null) {
            return JBIterable.empty();
        }
        DbDataSource root2 = root1.getKind() == ObjectKind.ROOT ? dataSource : root1;
        ObjectKind kidKind = o instanceof DasObject ? ((DasObject)o).getKind() : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        MetaModel metaModel = dialect.getMetaModel();
        boolean isNamespace = metaModel.getNamespaces().contains(rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind != ObjectKind.NONE) {
            GroupElement result2 = null;
            int visible = 0;
            int count = 0;
            for (ObjectKind kind : DatabaseStructure.getChildKinds(root2, metaModel, rootKind)) {
                int weight = DbPresentation.getWeight(kind, ++count);
                visible += viewOptions.SHOW_EMPTY_GROUPS ? 1 : DatabaseStructure.getChildObjects((DasObject)root2, kind).take(1).size();
                if (kind != kidKind) continue;
                result2 = DatabaseStructure.getGroup((DasObject)root2, kidKind, weight, dialect, dataSource);
            }
            if (visible > 1 && result2 != null) {
                return result2;
            }
        }
        if (root2 instanceof BasicRoot) {
            return dataSource;
        }
        return root2;
    }

    @Nullable
    static <T> T getFirstAndOnly(@NotNull JBIterable<T> element) {
        if (element == null) {
            DatabaseStructure.$$$reportNull$$$0(24);
        }
        T first = null;
        for (Object t : element) {
            if (first == null) {
                first = (T)t;
                continue;
            }
            return null;
        }
        return first;
    }

    @NotNull
    static Object getTopSingleRoot(@NotNull DbDataSource databaseSystem) {
        if (databaseSystem == null) {
            DatabaseStructure.$$$reportNull$$$0(25);
        }
        Object object = ObjectUtils.notNull(DatabaseStructure.getFirstAndOnly(databaseSystem.getDelegate().getModel().getModelRoots()), (Object)databaseSystem);
        if (object == null) {
            DatabaseStructure.$$$reportNull$$$0(26);
        }
        return object;
    }

    @NotNull
    static DasObject getTopSingleRoot(@NotNull DasObject element) {
        DasNamespace value;
        if (element == null) {
            DatabaseStructure.$$$reportNull$$$0(27);
        }
        DasObject e = element;
        while ((value = (DasNamespace)DatabaseStructure.getFirstAndOnly(e.getDbChildren(DasNamespace.class, ObjectKind.NONE))) != null) {
            e = value;
        }
        DasObject dasObject = e;
        if (dasObject == null) {
            DatabaseStructure.$$$reportNull$$$0(28);
        }
        return dasObject;
    }

    static GroupElement getGroup(@NotNull DasObject parentElement, @NotNull ObjectKind childKind, int weight, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource) {
        GroupElement result2;
        ConcurrentMap groupMap;
        ConcurrentMap map2;
        if (parentElement == null) {
            DatabaseStructure.$$$reportNull$$$0(29);
        }
        if (childKind == null) {
            DatabaseStructure.$$$reportNull$$$0(30);
        }
        if (dialect == null) {
            DatabaseStructure.$$$reportNull$$$0(31);
        }
        if (dataSource == null) {
            DatabaseStructure.$$$reportNull$$$0(32);
        }
        if ((map2 = (ConcurrentMap)dataSource.getUserData(DB_VIEW_GROUP_KEY)) == null) {
            map2 = (ConcurrentMap)((UserDataHolderEx)dataSource).putUserDataIfAbsent(DB_VIEW_GROUP_KEY, (Object)ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy()));
        }
        if ((groupMap = (ConcurrentMap)map2.get(parentElement)) == null) {
            groupMap = (ConcurrentMap)ConcurrencyUtil.cacheOrGet((ConcurrentMap)map2, (Object)parentElement, (Object)ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)ContainerUtil.identityStrategy()));
        }
        if ((result2 = (GroupElement)((Object)groupMap.get(childKind))) == null || result2.weight != weight) {
            String name = StringUtil.pluralize((String)DbPresentation.getPresentableName(childKind, dialect));
            result2 = (GroupElement)((Object)ConcurrencyUtil.cacheOrGet((ConcurrentMap)groupMap, (Object)childKind, (Object)((Object)new GroupElement(dataSource, parentElement, childKind, name, weight))));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 5: 
            case 9: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 17: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mm";
                break;
            }
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentKind";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childKind";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildObjects";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopSingleRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareNodes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenImpl";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getParentImpl";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAndOnly";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTopSingleRoot";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChildKinds$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GroupElement
    extends FakePsiElement
    implements NavigationItem,
    WeighedItem {
        public final DbDataSource dataSource;
        public final DasObject parentElement;
        public final ObjectKind childKind;
        public final String name;
        final int weight;
        final PresentationData presentation;
        int size;

        GroupElement(@NotNull DbDataSource dataSource, @NotNull DasObject parentElement, @NotNull ObjectKind childKind, @NotNull String name, int weight) {
            if (dataSource == null) {
                GroupElement.$$$reportNull$$$0(0);
            }
            if (parentElement == null) {
                GroupElement.$$$reportNull$$$0(1);
            }
            if (childKind == null) {
                GroupElement.$$$reportNull$$$0(2);
            }
            if (name == null) {
                GroupElement.$$$reportNull$$$0(3);
            }
            this.presentation = new PresentationData();
            this.dataSource = dataSource;
            this.childKind = childKind;
            this.parentElement = parentElement;
            this.name = name;
            this.weight = weight;
        }

        public String getName() {
            return this.name;
        }

        public ItemPresentation getPresentation() {
            this.presentation.clear();
            this.presentation.setIcon(DatabaseIcons.ObjectGroup);
            this.presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (this.size > 0) {
                this.presentation.addText(" " + this.size, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
            return this.presentation;
        }

        public int getWeight() {
            return this.weight;
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return DatabaseIcons.ObjectGroup;
        }

        public PsiElement getParent() {
            return this.dataSource;
        }

        public String toString() {
            return "/" + this.name + "/";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "childKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/view/DatabaseStructure$GroupElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

