/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectRefEditor<Das extends DasObject> {
    private final EditorTextField myEditor;
    private final DatabaseEditorContext myContext;
    private JBIterable<Das> myItems;

    public DatabaseObjectRefEditor(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(0);
        }
        this.myItems = JBIterable.empty();
        this.myContext = context;
        this.myEditor = new TextFieldWithAutoCompletion(this.myContext.getProject(), (TextFieldWithAutoCompletionListProvider)new MyCompletionProvider(), false, "");
        this.myEditor.addSettingsProvider(editor -> {
            editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(editor.getColorsScheme().getAttributes(HighlighterColors.TEXT)));
            this.updateAdditionalHighlighting((Editor)editor);
        });
    }

    public void setItems(@NotNull JBIterable<Das> items) {
        if (items == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(1);
        }
        this.myItems = items;
    }

    @NotNull
    public EditorTextField getEditor() {
        EditorTextField editorTextField = this.myEditor;
        if (editorTextField == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(2);
        }
        return editorTextField;
    }

    @NotNull
    public String getName() {
        String string = this.myContext.getDialect().unquoteIdentifier(this.myEditor.getText());
        if (string == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Das getObject() {
        return this.getObject(this.myItems);
    }

    @Nullable
    protected Das getObject(JBIterable<Das> items) {
        return (Das)((DasObject)items.filter(DasUtil.byName((String)this.getName(), (CasingProvider)this.myContext.getModel())).first());
    }

    @Nullable
    protected Icon getIcon(@NotNull Das item) {
        if (item == null) {
            DatabaseObjectRefEditor.$$$reportNull$$$0(4);
        }
        return null;
    }

    public void setObject(@Nullable Das obj) {
        String text;
        String string = text = obj == null ? "" : obj.getName();
        if (!text.equals(this.getName())) {
            this.myEditor.setText(obj == null ? "" : this.myContext.getDialect().quoteIdentifier(obj.getName(), false, false));
        }
        this.updateAdditionalHighlighting(this.myEditor.getEditor());
    }

    protected void updateAdditionalHighlighting(@Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        editor.getMarkupModel().removeAllHighlighters();
        if (this.getObject() == null) {
            TextAttributes attributes = editor.getColorsScheme().getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES);
            editor.getMarkupModel().addRangeHighlighter(0, this.myEditor.getText().length(), 3000, attributes, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseObjectRefEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseObjectRefEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<Das> {
        public MyCompletionProvider() {
            super(Collections.emptyList());
        }

        @Nullable
        protected Icon getIcon(@NotNull Das item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(0);
            }
            return DatabaseObjectRefEditor.this.getIcon(item);
        }

        @NotNull
        protected String getLookupString(@NotNull Das item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(1);
            }
            String string = DatabaseObjectRefEditor.this.myContext.getDialect().quoteIdentifier(item.getName(), false, false);
            if (string == null) {
                MyCompletionProvider.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull Das item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Nullable
        protected String getTypeText(@NotNull Das item) {
            DasObject parent;
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(4);
            }
            return (parent = item.getDbParent()) == null ? null : parent.getName();
        }

        public int compare(Das item1, Das item2) {
            return StringUtil.naturalCompare((String)item1.getName(), (String)item2.getName());
        }

        @NotNull
        public Collection<Das> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            PrefixMatcher matcher = this.createPrefixMatcher(prefix);
            JBIterable items = DatabaseObjectRefEditor.this.myItems;
            if (matcher != null) {
                items = items.filter(de -> matcher.prefixMatches(de.getName()));
            }
            ArrayList res = ContainerUtil.newArrayList((Iterable)items.take(100));
            Collections.sort(res, (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
            ArrayList arrayList = res;
            if (arrayList == null) {
                MyCompletionProvider.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

