/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShutSplitter
extends Splitter {
    private String myText;
    private final String myKey;
    private boolean myShut;
    private float myOldProportion;
    private JComponent mySecondWrapper;
    private JComponent mySecond;
    private JComponent mySecondFocus;
    private JComponent myLeadComp;
    private JComponent myTrailComp;

    public ShutSplitter(@NotNull String text, @Nullable String key) {
        if (text == null) {
            ShutSplitter.$$$reportNull$$$0(0);
        }
        super(true);
        this.myOldProportion = 0.7f;
        this.mySecondWrapper = new JPanel(new BorderLayout());
        this.myText = text;
        this.myKey = key;
        this.getDivider().updateData();
        this.loadState();
        super.setSecondComponent(this.mySecondWrapper);
    }

    public void setSecondComponent(@Nullable JComponent component) {
        this.mySecondWrapper.removeAll();
        this.mySecond = component;
        if (component != null && !this.myShut) {
            this.mySecondWrapper.add((Component)component, "Center");
        }
    }

    @NotNull
    private String getProportionKey() {
        String string = this.myKey + ".proportion";
        if (string == null) {
            ShutSplitter.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void loadState() {
        boolean shut;
        float prop = this.myKey == null ? 0.7f : PropertiesComponent.getInstance().getFloat(this.getProportionKey(), 0.7f);
        boolean bl = shut = prop < 0.0f;
        if (shut) {
            prop = -prop;
        }
        this.setProportion(prop);
        this.myOldProportion = prop;
        this.setShut(shut);
    }

    private void saveState() {
        if (this.myKey == null) {
            return;
        }
        PropertiesComponent.getInstance().setValue(this.getProportionKey(), (float)(this.myShut ? -1 : 1) * this.myOldProportion, 0.7f);
    }

    public Dimension getPreferredSize() {
        int dividerWidth = this.getDividerWidth();
        JComponent first = this.getFirstComponent();
        JComponent second = this.getSecondComponent();
        if (first != null && first.isVisible() && second != null && second.isVisible()) {
            Dimension firstSize = first.getPreferredSize();
            Dimension secondSize = second.getPreferredSize();
            assert (this.isVertical());
            float prop = this.getProportion();
            int h1 = prop < 0.01f ? -1 : Math.round((float)firstSize.height / prop);
            int h2 = prop > 0.99f ? -1 : Math.round((float)secondSize.height / (1.0f - prop));
            return new Dimension(Math.max(firstSize.width, secondSize.width), Math.max(h1, h2) + dividerWidth);
        }
        return super.getPreferredSize();
    }

    protected Divider createDivider() {
        return new MyDividerImpl();
    }

    public MyDividerImpl getDivider() {
        return (MyDividerImpl)((Object)super.getDivider());
    }

    public int getDividerWidth() {
        return this.getDivider().getPreferredSize().height + JBUI.scale((int)10);
    }

    public void setShut(boolean shut) {
        if (this.myShut == shut) {
            return;
        }
        this.myShut = shut;
        this.getDivider().updateData();
        this.setProportion(shut ? 1.0f : this.myOldProportion);
        this.setResizeEnabled(!shut);
        this.mySecondWrapper.setMinimumSize(shut ? new Dimension(0, 0) : null);
        if (this.mySecond != null) {
            if (!this.myShut) {
                this.mySecondWrapper.add((Component)this.mySecond, "Center");
                this.getDivider().mySeparator.setLabelFor((Component)this.mySecondFocus);
            } else {
                this.mySecondWrapper.remove(this.mySecond);
                this.getDivider().mySeparator.setLabelFor(null);
            }
        }
    }

    public void setLeadWidged(@Nullable JComponent comp) {
        if (this.myLeadComp != null) {
            this.getDivider().myLeadPlaceholder.remove(this.myLeadComp);
        }
        this.myLeadComp = comp;
        if (this.myLeadComp != null) {
            this.getDivider().myLeadPlaceholder.add((Component)this.myLeadComp, "Center");
        }
    }

    public void setTrailWidged(@Nullable JComponent comp) {
        if (this.myTrailComp != null) {
            this.getDivider().myTrailPlaceholder.remove(this.myTrailComp);
        }
        this.myTrailComp = comp;
        if (this.myTrailComp != null) {
            this.getDivider().myTrailPlaceholder.add((Component)this.myTrailComp, "Center");
        }
    }

    public void setProportion(float proportion) {
        super.setProportion(proportion);
        if (!this.myShut) {
            this.myOldProportion = proportion;
        }
        this.saveState();
    }

    public void setTitleLabelFor(JComponent component) {
        this.mySecondFocus = component;
        if (!this.myShut) {
            this.getDivider().myIcon.setLabelFor((Component)component);
        }
    }

    public boolean isShut() {
        return this.myShut;
    }

    public void setDividerToolTipText(String tooltip) {
        this.getDivider().setToolTipText(tooltip);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/ShutSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/ShutSplitter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProportionKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDividerImpl
    extends Splitter.DividerImpl {
        private TitledSeparator mySeparator;
        private JBLabel myIcon;
        private JComponent myLeadPlaceholder;
        private JComponent myTrailPlaceholder;

        private MyDividerImpl() {
            super((Splitter)ShutSplitter.this);
        }

        public void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.setCursor(ShutSplitter.this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
            this.myLeadPlaceholder = new JPanel(new BorderLayout());
            this.myTrailPlaceholder = new JPanel(new BorderLayout());
            if (ShutSplitter.this.myLeadComp != null) {
                this.myLeadPlaceholder.add((Component)ShutSplitter.this.myLeadComp, "Center");
            }
            if (ShutSplitter.this.myTrailComp != null) {
                this.myTrailPlaceholder.add((Component)ShutSplitter.this.myTrailComp, "Center");
            }
            this.myIcon = new JBLabel(this.getIcon());
            this.myLeadPlaceholder.add((Component)this.myIcon, "West");
            this.add(this.myLeadPlaceholder, "West");
            this.add(Box.createVerticalStrut(JBUI.scale((int)5)), "North");
            this.myIcon.setFont(UIUtil.getTitledBorderFont());
            this.myIcon.setText(UIUtil.replaceMnemonicAmpersand((String)ShutSplitter.this.myText));
            this.mySeparator = new TitledSeparator();
            this.add((Component)this.mySeparator, "Center");
            this.add(this.myTrailPlaceholder, "East");
            this.mySeparator.getLabel().setCursor(Cursor.getPredefinedCursor(12));
            this.revalidate();
            this.repaint();
        }

        public void updateData() {
            this.myIcon.setIcon(this.getIcon());
            this.myIcon.setText(UIUtil.replaceMnemonicAmpersand((String)ShutSplitter.this.myText));
            ShutSplitter.this.getDivider().mySeparator.revalidate();
            ShutSplitter.this.getDivider().mySeparator.repaint();
        }

        protected void processMouseEvent(MouseEvent e) {
            if (e.getID() == 500) {
                if (e.getClickCount() == 2) {
                    return;
                }
                if (!(e.getClickCount() != 1 || !SwingUtilities.isLeftMouseButton(e) || e.isAltDown() || e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
                    ShutSplitter.this.setShut(!ShutSplitter.this.myShut);
                }
            }
            super.processMouseEvent(e);
        }

        public void setResizeEnabled(boolean resizeEnabled) {
            super.setResizeEnabled(resizeEnabled);
            if (!resizeEnabled) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        private Icon getIcon() {
            return ShutSplitter.this.myShut ? AllIcons.Actions.UP : AllIcons.Actions.Down;
        }
    }
}

