/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DefaultDbPsiManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceSettings;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceManagerDialog
extends SingleConfigurableEditor {
    private DataSourceManagerDialog(@NotNull DbPsiFacade facade, @NotNull DataSourceSettings settings) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(1);
        }
        super(facade.getProject(), (Configurable)new MyConfigurable(settings));
        this.setTitle("Data Sources and Drivers");
        this.setHorizontalStretch(1.3f);
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(2);
        }
        return dialogStyle;
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull Project project, @Nullable DbDataSource selection) {
        if (project == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(3);
        }
        List<DbDataSource> list = DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)project), selection);
        if (list == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull DbPsiFacade facade, @Nullable DbDataSource selection) {
        DatabaseView view2;
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(5);
        }
        DataSourceSettings settings = new DataSourceSettings(facade, selection);
        if (selection != null && !selection.isValid()) {
            settings.addNewDataSource(selection);
        }
        HashSet existing = ContainerUtil.newHashSet(settings.getDataSources());
        DataSourceManagerDialog dialog = new DataSourceManagerDialog(facade, settings);
        dialog.show();
        ArrayList result2 = ContainerUtil.newArrayList();
        if (ModalityState.current() == ModalityState.NON_MODAL) {
            for (DbDataSource element : settings.getDataSources()) {
                if (existing.contains(element)) continue;
                result2.add(element);
                if (!DbImplUtil.canConnectTo((DbElement)element)) continue;
                DatabaseEditorHelper.openConsoleFile((DbElement)element);
            }
        }
        if ((view2 = DatabaseView.getDatabaseView(facade.getProject())) != null && !result2.isEmpty()) {
            view2.selectElements((DasObject[])result2.toArray(new DbElement[result2.size()]));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static void showDialog(final @NotNull DbPsiFacade facade, final @NotNull DataSourceRegistry registry) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(7);
        }
        if (registry == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(8);
        }
        new DialogCreator(facade){

            @Override
            protected void doCreate() {
                DataSourceStorage storage = DataSourceStorage.getProjectStorage(facade.getProject());
                Map<String, LocalDataSource> importedNames = this.getAlreadyImportedNames(storage);
                for (LocalDataSource o : registry.getDataSources()) {
                    LocalDataSource existing = importedNames.get(o.getName());
                    if (existing != null) continue;
                    this.addDataSource(o);
                }
            }

            @Override
            protected void doUpdate(@NotNull DatabaseConfigEditor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                DataSourceStorage storage = DataSourceStorage.getProjectStorage(facade.getProject());
                Map<String, LocalDataSource> importedNames = this.getAlreadyImportedNames(storage);
                for (LocalDataSource o : registry.getDataSources()) {
                    DataSourceConfigurable configurable;
                    LocalDataSource existing = importedNames.get(o.getName());
                    if (existing == null || (configurable = editor.getConfigurable(existing, true, DataSourceConfigurable.class)) == null) continue;
                    LocalDataSource temp = configurable.getTempDataSource();
                    temp.setUrlSmart(o.getUrl());
                    configurable.resetFromTemp();
                }
            }

            @NotNull
            private Map<String, LocalDataSource> getAlreadyImportedNames(@NotNull DataSourceStorage storage) {
                if (storage == null) {
                    1.$$$reportNull$$$0(1);
                }
                Map map2 = JBIterable.from(storage.getDataSources()).filter(LocalDataSource.class).filter(LocalDataSource::isImported).toReverseMap(AbstractDataSource::getName);
                if (map2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "storage";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DataSourceManagerDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DataSourceManagerDialog$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAlreadyImportedNames";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doUpdate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getAlreadyImportedNames";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.create();
        DataSourceConfigUtil.runRegistryCallbacks(facade.getProject(), registry);
    }

    public static void showLocalDataSourcesDialog(@NotNull DbPsiFacade facade, final @NotNull Collection<LocalDataSource> dataSources) {
        if (facade == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(9);
        }
        if (dataSources == null) {
            DataSourceManagerDialog.$$$reportNull$$$0(10);
        }
        new DialogCreator(facade){

            @Override
            protected void doCreate() {
                for (LocalDataSource dataSource : dataSources) {
                    this.addDataSource(dataSource);
                }
            }

            @Override
            protected void doUpdate(@NotNull DatabaseConfigEditor editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/DataSourceManagerDialog$2", "doUpdate"));
            }
        }.create();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.execution.impl.EditConfigurationsDialog";
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DataSourceManagerDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DataSourceManagerDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showLocalDataSourcesDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyConfigurable
    extends SettingsEditorConfigurable<DataSourceSettings> {
        public MyConfigurable(DataSourceSettings settings) {
            super((SettingsEditor)new DatabaseConfigEditorImpl(settings), (Object)settings);
        }

        public String getDisplayName() {
            return "Data Sources";
        }

        public String getHelpTopic() {
            String topic = this.getEditor().getHelpTopic();
            if (topic == null) {
                topic = "reference.tools.datasource.properties";
            }
            return topic;
        }

        public DatabaseConfigEditorImpl getEditor() {
            return (DatabaseConfigEditorImpl)super.getEditor();
        }

        public boolean isModified() {
            return this.getEditor().isAnyEditorModified();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.getEditor().getPreferredFocusedComponent();
        }
    }

    private static abstract class DialogCreator {
        private final DbPsiFacade myFacade;
        private final DataSourceSettings mySettings;
        private final DefaultDbPsiManager myPsiManager;

        public DialogCreator(DbPsiFacade facade) {
            this.myFacade = facade;
            this.mySettings = new DataSourceSettings(this.myFacade, null);
            this.myPsiManager = (DefaultDbPsiManager)((Object)ContainerUtil.findInstance((Iterable)this.myFacade.getDbManagers(), DefaultDbPsiManager.class));
        }

        public void create() {
            if (this.myPsiManager != null) {
                this.doCreate();
            }
            DataSourceManagerDialog dialog = new DataSourceManagerDialog(this.myFacade, this.mySettings);
            DatabaseConfigEditorImpl editor = ((MyConfigurable)dialog.getConfigurable()).getEditor();
            this.doUpdate(editor);
            editor.clearModifiedCache();
            dialog.show();
        }

        protected void addDataSource(LocalDataSource dataSource) {
            if (dataSource.getDatabaseDriver() == null) {
                if (StringUtil.isEmpty((String)dataSource.getDriverClass())) {
                    return;
                }
                DatabaseDriver newDriver = null;
                for (DatabaseDriver driver : this.mySettings.getNewDrivers()) {
                    if (!dataSource.getDriverClass().equals(driver.getDriverClass())) continue;
                    newDriver = driver;
                    break;
                }
                if (newDriver == null) {
                    newDriver = DatabaseDriverManager.getInstance().createDriver(dataSource.getDriverClass(), dataSource.getDriverClass(), null);
                    this.mySettings.addNewDriver(newDriver);
                }
                dataSource.setDatabaseDriver(newDriver);
            } else if (!DatabaseDriverManager.getInstance().getDrivers().contains(dataSource.getDatabaseDriver())) {
                this.mySettings.addNewDriver(dataSource.getDatabaseDriver());
            }
            DbDataSource element = ((DbPsiFacadeImpl)this.myFacade).createDataSourceWrapperElement(dataSource, this.myPsiManager);
            this.mySettings.addNewDataSource(element);
            if (this.mySettings.getNewDataSources().size() == 1) {
                this.mySettings.setCurrentDataSource(element);
            }
        }

        protected abstract void doCreate();

        protected abstract void doUpdate(@NotNull DatabaseConfigEditor var1);
    }
}

