/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabasePreviewDialog
extends DialogWrapper {
    private final Project myProject;
    private final DbDataSource mySource;
    private final List<DasNamespace> mySearchPath;
    private final String myQuery;
    private SqlPreviewPanel myPreviewPanel;
    private String myLabelText;
    @NotNull
    private final List<String> myMessages;

    public DatabasePreviewDialog(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull String title, @NotNull String labelText, @NotNull String query, @NotNull List<String> messages) {
        if (project == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(2);
        }
        if (labelText == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(3);
        }
        if (query == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(4);
        }
        if (messages == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(5);
        }
        super(project);
        this.myProject = project;
        this.mySource = dataSource;
        this.mySearchPath = searchPath;
        this.myQuery = query;
        this.myLabelText = labelText;
        this.myMessages = messages;
        this.setTitle(title);
        this.init();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DatabasePreviewDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myPreviewPanel = new SqlPreviewPanel(this.myProject, this.mySource, this.mySearchPath, this.myQuery, this.getDimensionServiceKey(), () -> this.close(1));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)new JLabel(this.myLabelText), "Center");
        if (!this.myMessages.isEmpty()) {
            ErrorLabel error = new ErrorLabel("There are errors!", UIUtil.getBalloonErrorIcon());
            error.setErrorText(StringUtil.join(this.myMessages, (String)"\n"), (Color)JBColor.RED);
            northPanel.add((Component)error, "East");
        }
        panel.add((Component)northPanel, "North");
        panel.add((Component)this.myPreviewPanel, "Center");
        return panel;
    }

    public String getStatement() {
        return this.myPreviewPanel.getQuery();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabasePreviewDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabasePreviewDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

