/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.sql.database.SqlModelBuilderUtils;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DasPath {
    @Nullable
    public final DasPath parent;
    @NotNull
    public final ObjectName name;
    @Nullable
    public final String subName;
    @NotNull
    public final ObjectKind kind;

    public DasPath(@Nullable DasPath parent, @NotNull ObjectName name, @Nullable String subName, @NotNull ObjectKind kind) {
        if (name == null) {
            DasPath.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            DasPath.$$$reportNull$$$0(1);
        }
        this.parent = parent;
        this.name = name;
        this.subName = subName;
        this.kind = kind;
    }

    public DasPath(@Nullable DasPath parent, @NotNull ObjectName name, @NotNull ObjectKind kind) {
        if (name == null) {
            DasPath.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            DasPath.$$$reportNull$$$0(3);
        }
        this(parent, name, null, kind);
    }

    @NotNull
    public DasPath append(@NotNull ObjectName name, @NotNull ObjectKind kind) {
        if (name == null) {
            DasPath.$$$reportNull$$$0(4);
        }
        if (kind == null) {
            DasPath.$$$reportNull$$$0(5);
        }
        DasPath dasPath = new DasPath(this, name, kind);
        if (dasPath == null) {
            DasPath.$$$reportNull$$$0(6);
        }
        return dasPath;
    }

    public static DasPath of(@Nullable DasObject object, @NotNull DatabaseFamilyId familyId, @Nullable Map<DasObject, DasPath> cache) {
        DasPath path;
        if (familyId == null) {
            DasPath.$$$reportNull$$$0(7);
        }
        if (object == null) {
            return null;
        }
        DasPath dasPath = path = cache == null ? null : cache.get(object);
        if (path != null) {
            return path;
        }
        DasPath parent = DasPath.of(object.getDbParent(), familyId, cache);
        DasPath dasPath2 = path = cache == null ? null : cache.get(object);
        if (path != null) {
            return path;
        }
        path = new DasPath(parent, DasPath.getName(object), DasPath.getSubName(object, familyId), object.getKind());
        if (cache != null) {
            cache.put(object, path);
        }
        return path;
    }

    @NotNull
    public static ObjectName getName(@NotNull DasObject obj) {
        SqlNameElement element;
        if (obj == null) {
            DasPath.$$$reportNull$$$0(8);
        }
        String name = obj.getName();
        boolean quoted = true;
        if (obj instanceof SqlDefinition && (element = ((SqlDefinition)obj).getNameElement()) != null) {
            quoted = element.isQuotedIdentifier();
        }
        ObjectName objectName = new ObjectName(name, quoted);
        if (objectName == null) {
            DasPath.$$$reportNull$$$0(9);
        }
        return objectName;
    }

    @Nullable
    public static String getSubName(@NotNull DasObject obj, @NotNull DatabaseFamilyId family) {
        if (obj == null) {
            DasPath.$$$reportNull$$$0(10);
        }
        if (family == null) {
            DasPath.$$$reportNull$$$0(11);
        }
        String name = obj.getName();
        if (obj instanceof BasicElement) {
            String id = obj instanceof BasicOverloadable ? ((BasicOverloadable)obj).identity(true) : null;
            return id == null || id.equals(name) ? null : id;
        }
        if (family.isSybase() && obj instanceof DasRoutine && ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.PROCEDURE) {
            short pos = SqlModelBuilderUtils.getSybaseNumber(obj);
            return ModelUtil.calculateSybProcedureIdentity(pos);
        }
        if (!(obj instanceof DasRoutine)) {
            return null;
        }
        String id = DasPath.hasOverloads(family) ? ModelUtil.calculateRoutineIdentity(name, ((DasRoutine)obj).getArguments()) : null;
        return name.equals(id) ? null : id;
    }

    private static boolean hasOverloads(DatabaseFamilyId familyId) {
        return familyId.isDb2() || familyId.isDerby() || familyId == DatabaseFamilyId.UNKNOWN || familyId.isH2() || familyId.isHsqldb() || familyId.isMysql() || familyId.isPostgres();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DasPath path = (DasPath)o;
        if (!this.kind.equals(path.kind)) {
            return false;
        }
        if (!this.name.equals((Object)path.name)) {
            return false;
        }
        return !(this.parent != null ? !this.parent.equals(path.parent) : path.parent != null);
    }

    public int hashCode() {
        int result2 = this.parent != null ? this.parent.hashCode() : 0;
        result2 = 31 * result2 + this.name.hashCode();
        result2 = 31 * result2 + this.kind.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/DasPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/DasPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSubName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

