/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceUpdateQueue;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceImpl
extends AbstractDataSource
implements SqlDataSource,
PersistentStateComponent<State>,
Iconable,
ModificationTracker {
    private final Project myProject;
    private String myParentID;
    private String[] myUrls;
    private Disposable myDisposable;
    private VirtualFilePointerContainer myContainer;
    private final AtomicLong myInnerVersion;
    private ComputedModel myComputedModel;

    public SqlDataSourceImpl(@NotNull String name, @NotNull Project project, @Nullable DatabaseSystem parent) {
        if (name == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(1);
        }
        this.myUrls = ArrayUtil.EMPTY_STRING_ARRAY;
        this.myInnerVersion = new AtomicLong();
        this.myComputedModel = null;
        this.setName(name);
        this.myProject = project;
        this.myParentID = parent == null ? null : parent.getUniqueId();
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return null;
    }

    public void resetCaches() {
        this.myComputedModel.check();
    }

    public String getDatabaseProductName() {
        DbDataSource parent = this.getParentDataSource();
        return parent != null ? parent.getDatabaseProductName() : null;
    }

    public String getDatabaseProductVersion() {
        DbDataSource parent = this.getParentDataSource();
        return parent != null ? parent.getDatabaseProductVersion() : null;
    }

    @NotNull
    public List<String> getUrls() {
        List<String> list = Arrays.asList(this.myContainer != null ? this.myContainer.getUrls() : this.myUrls);
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public List<VirtualFile> getFiles() {
        return Arrays.asList(this.myContainer != null ? this.myContainer.getFiles() : VirtualFile.EMPTY_ARRAY);
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(3);
        }
        this.incModificationCount();
        this.myUrls = ArrayUtil.toStringArray(urls);
        if (this.myContainer != null) {
            this.myContainer.clear();
            for (String url : urls) {
                this.myContainer.add(url);
            }
        }
    }

    public void setParent(DatabaseSystem parent) {
        this.myParentID = parent == null ? null : parent.getUniqueId();
    }

    @NotNull
    public JBIterable<SqlFile> getSqlFiles() {
        if (this.myContainer == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDataSourceImpl.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        JBIterable jBIterable = JBIterable.of((Object[])this.myContainer.getFiles()).transform(file -> (SqlFile)ObjectUtils.tryCast((Object)psiManager.findFile(file), SqlFile.class)).filter(Condition.NOT_NULL);
        if (jBIterable == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myComputedModel == null ? DasUtil.emptyModel() : this.myComputedModel.getModel();
        if (dasModel == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(6);
        }
        return dasModel;
    }

    @Nullable
    public DbDataSource getParentDataSource() {
        return this.myParentID == null ? null : DbPsiFacade.getInstance((Project)this.myProject).findDataSource(this.myParentID);
    }

    public String getParentID() {
        return this.myParentID;
    }

    public SqlDataSourceImpl copy() {
        SqlDataSourceImpl result2 = new SqlDataSourceImpl(this.getName(), this.myProject, null);
        result2.myParentID = this.myParentID;
        result2.myUrls = ArrayUtil.toStringArray(this.getUrls());
        return result2;
    }

    public State getState() {
        State state = new State();
        state.id = this.getUniqueId();
        state.name = this.getName();
        state.parent = this.myParentID;
        state.urls = ArrayUtil.toStringArray(this.getUrls());
        state.remarks = this.getComment();
        return state;
    }

    public void loadState(State state) {
        this.setUniqueId(state.id);
        this.setName(state.name);
        this.setComment(state.remarks);
        this.myUrls = state.urls != null ? state.urls : ArrayUtil.EMPTY_STRING_ARRAY;
        this.myParentID = state.parent;
        this.myDisposable = null;
        this.myContainer = null;
    }

    void dropFilePointers() {
        if (this.myDisposable != null) {
            this.myUrls = this.myContainer.getUrls();
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
            this.myContainer = null;
            this.myComputedModel = null;
        }
    }

    void initFilePointers() {
        assert (this.myDisposable == null);
        this.myDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myProject, () -> this.dropFilePointers());
        this.myContainer = VirtualFilePointerManager.getInstance().createContainer(this.myDisposable);
        for (String url : this.myUrls) {
            this.myContainer.add(url);
        }
        this.myComputedModel = new ComputedModel();
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myComputedModel);
    }

    public void setFiles(VirtualFile[] virtualFiles) {
        this.incModificationCount();
        if (this.myContainer != null) {
            this.myContainer.clear();
        }
        this.myUrls = new String[virtualFiles.length];
        for (int i2 = 0; i2 < virtualFiles.length; ++i2) {
            this.myUrls[i2] = virtualFiles[i2].getUrl();
            if (this.myContainer == null) continue;
            this.myContainer.add(virtualFiles[i2]);
        }
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect() {
        SqlLanguageDialect dialect = this.getSqlDialectFromFiles();
        if (dialect != null) {
            return (DatabaseDialectEx)dialect.getDatabaseDialect();
        }
        DbDataSource parent = this.getParentDataSource();
        return parent == null ? null : DbImplUtil.getDatabaseDialect((DbElement)parent);
    }

    @Nullable
    public SqlLanguageDialect getSqlDialect() {
        SqlLanguageDialect dialect = this.getSqlDialectFromFiles();
        if (dialect != null) {
            return dialect;
        }
        DbDataSource parent = this.getParentDataSource();
        return parent == null ? null : DbSqlUtil.getSqlDialect((DbElement)parent);
    }

    @Nullable
    private SqlLanguageDialect getSqlDialectFromFiles() {
        for (VirtualFile file : this.getFiles()) {
            SqlLanguageDialect dialect = (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file), SqlLanguageDialect.class);
            if (dialect == null) continue;
            return dialect;
        }
        return null;
    }

    public Icon getIcon(int flags) {
        return DatabaseIcons.DdlDbms;
    }

    private long getPartialVersion(@NotNull Iterable<SqlFile> files, @Nullable SqlFile latest) {
        if (files == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(7);
        }
        long result2 = super.getModificationCount();
        for (SqlFile file : files) {
            result2 += file.getModificationStamp();
            if (file != latest) continue;
            break;
        }
        return result2;
    }

    public long getModificationCount() {
        return this.getDataModificationCount() + this.myInnerVersion.get();
    }

    public long getDataModificationCount() {
        return this.getPartialVersion((Iterable<SqlFile>)this.getSqlFiles(), null);
    }

    public boolean equalConfiguration(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(8);
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myParentID, (CharSequence)o.myParentID)) {
            return false;
        }
        return this.getUrls().equals(o.getUrls());
    }

    @Nullable
    public SqlElement fromModel(@Nullable DasObject delegate) {
        if (delegate == null || this.myComputedModel == null) {
            return null;
        }
        return this.myComputedModel.fromModel(delegate);
    }

    public void waitComputed() {
        ComputedModel model = this.myComputedModel;
        if (model == null) {
            return;
        }
        while (!model.isReady()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        return;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPartialVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ComputedModel
    extends SqlDataSourceUpdateQueue.ComputedModel {
        private ComputedModel() {
        }

        @Override
        protected long computeRevision() {
            return SqlDataSourceImpl.this.getDataModificationCount();
        }

        @Override
        protected void introspect(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                ComputedModel.$$$reportNull$$$0(0);
            }
            Map elements = this.myElements;
            SqlModelBuilder builder = new SqlModelBuilder(SqlDataSourceImpl.this.myProject, this.ensureProperModel(SqlDataSourceImpl.this.getDatabaseDialect()), elements);
            List<SqlFile> files = SqlDataSourceImpl.this.getSqlFiles().toList();
            Pair prev = this.myIncomplete;
            int doneIdx = -1;
            if (prev != null && (doneIdx = files.indexOf(prev.first)) != -1 && SqlDataSourceImpl.this.getPartialVersion(files, (SqlFile)prev.first) != (Long)prev.second) {
                doneIdx = -1;
            }
            int fromIdx = doneIdx + 1;
            this.myIncomplete = null;
            try {
                indicator.setText("Building `" + SqlDataSourceImpl.this.getName() + "`");
                builder.introspect(fromIdx == 0 ? files : files.subList(fromIdx, files.size()), fromIdx == 0, 2000L, (PairConsumer<Integer, Map<BasicElement, SmartPsiElementPointer<SqlElement>>>)((PairConsumer)(idx, revMap) -> {
                    int index = fromIdx + idx;
                    SqlFile done = (SqlFile)files.get(index);
                    this.myIncomplete = Pair.create((Object)done, (Object)SqlDataSourceImpl.this.getPartialVersion(files, done));
                    this.myElements = revMap;
                    SqlDataSourceImpl.this.myInnerVersion.incrementAndGet();
                    if (index + 1 != files.size()) {
                        this.changed();
                    } else {
                        this.myIncomplete = null;
                    }
                }));
            }
            catch (ProcessCanceledException pce) {
                indicator.setText2("Interrupted");
                if (this.myIncomplete == null) {
                    this.myIncomplete = prev;
                }
                throw pce;
            }
        }

        @Override
        protected Project getProject() {
            return SqlDataSourceImpl.this.myProject;
        }

        @Override
        protected void changed() {
            UIUtil.invokeLaterIfNeeded(() -> {
                DbPsiFacade facade = DbPsiFacade.getInstance((Project)SqlDataSourceImpl.this.myProject);
                DbDataSource dataSource = facade.findDataSource(SqlDataSourceImpl.this.getUniqueId());
                if (dataSource != null) {
                    facade.clearCaches(dataSource);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/sql/database/SqlDataSourceImpl$ComputedModel", "introspect"));
        }
    }

    public static class State {
        public String id;
        public String name;
        public String parent;
        public String[] urls;
        public String remarks;
    }
}

