/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.BasicDbPsiManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceConfigurable;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceStorage;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import icons.DatabaseIcons;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDbManager
extends BasicDbPsiManager<SqlDataSource> {
    static final DataSourceTemplate DEFAULT_TEMPLATE = new SqlDataSourceTemplate();
    private final SqlDataSourceStorage myStorage;

    public SqlDbManager(DbPsiFacade dbFacade, final SqlDataSourceStorage storage) {
        super(dbFacade, storage.getDataSources());
        this.myStorage = storage;
        Project project = this.myDbFacade.getProject();
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            private void processChanges(PsiElement element) {
                VirtualFile file;
                PsiFile containingFile = element == null ? null : (element.isValid() ? element.getContainingFile() : null);
                boolean isDirectory = element instanceof PsiDirectory;
                if (isDirectory) {
                    file = ((PsiDirectory)element).getVirtualFile();
                } else {
                    VirtualFile vf = containingFile == null ? null : containingFile.getVirtualFile();
                    VirtualFile virtualFile = file = vf != null && vf.getFileType() == SqlFileType.INSTANCE ? vf : null;
                }
                if (file == null) {
                    return;
                }
                boolean valid = file.isValid();
                List<DbDataSource> dataSourceElements = SqlDbManager.this.getDataSources();
                THashSet dataSourcesToClean = new THashSet();
                for (DbDataSource sourceElement : dataSourceElements) {
                    String url;
                    SqlDataSourceImpl source = (SqlDataSourceImpl)sourceElement.getDelegate();
                    if (!isDirectory && valid && ContainerUtil.find(source.getFiles(), (Object)file) != null) {
                        dataSourcesToClean.add(source.getUniqueId());
                        continue;
                    }
                    if (valid && !isDirectory) continue;
                    String string = url = isDirectory ? file.getUrl() + "/" : file.getUrl();
                    if (null == ContainerUtil.find(source.getUrls(), s -> isDirectory ? s.startsWith(url) : s.equals(url))) continue;
                    dataSourcesToClean.add(source.getUniqueId());
                }
                if (!dataSourcesToClean.isEmpty()) {
                    SqlDbManager.this.clearCaches(dataSourceElements, (Set)dataSourcesToClean, false);
                }
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.processChanges(event.getChild());
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.processChanges(event.getParent());
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.processChanges(event.getNewChild());
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.processChanges(event.getOldParent());
                this.processChanges(event.getChild());
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.processChanges(event.getParent());
            }

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.processChanges(event.getElement());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/sql/database/SqlDbManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
        DataSourceStorage.getProjectStorage(project).addDataSourceListener(new DataSourceListener(){

            private void processChanges(AbstractDataSource dataSource, boolean force) {
                if (dataSource == null) {
                    SqlDbManager.this.resetElementMap(storage.getDataSources());
                    SqlDbManager.this.myDbFacade.clearCaches(null);
                } else {
                    SqlDbManager.this.clearCaches(dataSource, force);
                }
            }

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.processChanges(dataSource, true);
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.processChanges(dataSource, true);
            }

            @Override
            public void dataSourceChanged(LocalDataSource dataSource) {
                this.processChanges(dataSource, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/sql/database/SqlDbManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    public void clearCaches(DatabaseSystem info, boolean force) {
        this.clearCaches(this.getDataSources(), ContainerUtil.newHashSet((Object[])new String[]{info.getUniqueId()}), force);
    }

    private void clearCaches(List<DbDataSource> dataSourceElements, Set<String> uniqueIdsToClean, boolean force) {
        for (int i2 = 0; i2 < dataSourceElements.size(); ++i2) {
            boolean changed = false;
            for (DbDataSource sourceElement : dataSourceElements) {
                String parentID;
                if (uniqueIdsToClean.contains(sourceElement.getUniqueId()) || !StringUtil.isNotEmpty((String)(parentID = ((SqlDataSourceImpl)sourceElement.getDelegate()).getParentID())) || !uniqueIdsToClean.contains(parentID)) continue;
                uniqueIdsToClean.add(sourceElement.getUniqueId());
                changed = true;
            }
            if (!changed) break;
        }
        for (DbDataSource element : dataSourceElements) {
            if (!uniqueIdsToClean.contains(element.getUniqueId())) continue;
            this.myDbFacade.clearCaches(element);
            SqlDataSourceImpl sqlDataSource = (SqlDataSourceImpl)((Object)ObjectUtils.tryCast((Object)element.getDelegate(), SqlDataSourceImpl.class));
            if (sqlDataSource == null) continue;
            sqlDataSource.resetCaches();
        }
        if (force) {
            this.myDbFacade.clearCaches(null);
        }
    }

    public void removeDataSource(DbDataSource element) {
        if (!(element.getDelegate() instanceof SqlDataSource)) {
            throw new UnsupportedOperationException();
        }
        SqlDataSourceImpl dataSource = (SqlDataSourceImpl)element.getDelegate();
        this.processAddOrRemove(dataSource, false);
    }

    @Override
    public void setDataSourceName(@NotNull DbDataSource element, String name) {
        if (element == null) {
            SqlDbManager.$$$reportNull$$$0(0);
        }
        if (!(element.getDelegate() instanceof SqlDataSource)) {
            throw new UnsupportedOperationException();
        }
        SqlDataSourceImpl dataSource = (SqlDataSourceImpl)element.getDelegate();
        dataSource.setName(name);
        this.myDbFacade.clearCaches(element);
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker(@NotNull DbElement element) {
        if (element == null) {
            SqlDbManager.$$$reportNull$$$0(1);
        }
        ModificationTracker modificationTracker = (ModificationTracker)element.getDataSource().getDelegate();
        if (modificationTracker == null) {
            SqlDbManager.$$$reportNull$$$0(2);
        }
        return modificationTracker;
    }

    @NotNull
    public Configurable createDataSourceEditor(DbDataSource template) {
        if (!(template.getDelegate() instanceof SqlDataSource)) {
            throw new UnsupportedOperationException();
        }
        SqlDataSourceImpl dataSource = (SqlDataSourceImpl)template.getDelegate();
        SqlDataSourceConfigurable sqlDataSourceConfigurable = new SqlDataSourceConfigurable(this, template.getProject(), dataSource, false);
        if (sqlDataSourceConfigurable == null) {
            SqlDbManager.$$$reportNull$$$0(3);
        }
        return sqlDataSourceConfigurable;
    }

    @NotNull
    public List<DataSourceTemplate> getDataSourceTemplates() {
        List<DataSourceTemplate> list = Collections.singletonList(DEFAULT_TEMPLATE);
        if (list == null) {
            SqlDbManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public DataSourceTemplate getDataSourceTemplate(DbDataSource element) {
        return DEFAULT_TEMPLATE;
    }

    public boolean canCreateDataSourceByFiles(Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            if (file.getFileType() != SqlFileType.INSTANCE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<DbDataSource> createDataSourceByFiles(Collection<VirtualFile> files) {
        ArrayList<VirtualFile> sqlFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            if (virtualFile.getFileType() != SqlFileType.INSTANCE) continue;
            sqlFiles.add(virtualFile);
        }
        if (sqlFiles.isEmpty()) {
            List<DbDataSource> list = Collections.emptyList();
            if (list == null) {
                SqlDbManager.$$$reportNull$$$0(5);
            }
            return list;
        }
        String defaultName = DbUtil.createNewDataSourceName((Project)this.myDbFacade.getProject(), (String)((VirtualFile)sqlFiles.get(0)).getNameWithoutExtension());
        SqlDataSourceImpl dataSource = new SqlDataSourceImpl(defaultName, this.myDbFacade.getProject(), null);
        dataSource.setFiles(sqlFiles.toArray(new VirtualFile[sqlFiles.size()]));
        this.addDataSourceInner(dataSource);
        List list = ContainerUtil.createMaybeSingletonList((Object)this.myDbFacade.findDataSource(dataSource.getUniqueId()));
        if (list == null) {
            SqlDbManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void fireDataSourceUpdated(DbDataSource element) {
    }

    public void processAddOrRemove(final SqlDataSourceImpl dataSource, final boolean added) {
        Project project = this.myDbFacade.getProject();
        GlobalUndoableAction action = new GlobalUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                if (added) {
                    SqlDbManager.this.removeDataSourceInner(dataSource);
                } else {
                    SqlDbManager.this.addDataSourceInner(dataSource);
                }
            }

            public void redo() throws UnexpectedUndoException {
                if (added) {
                    SqlDbManager.this.addDataSourceInner(dataSource);
                } else {
                    SqlDbManager.this.removeDataSourceInner(dataSource);
                }
            }
        };
        new WriteCommandAction(project, added ? DatabaseMessages.message((String)"command.name.add.data.source", (Object[])new Object[0]) : DatabaseMessages.message((String)"command.name.remove.data.source", (Object[])new Object[0]), new PsiFile[0], (UndoableAction)action, project){
            final /* synthetic */ UndoableAction val$action;
            final /* synthetic */ Project val$project;
            {
                this.val$action = undoableAction;
                this.val$project = project;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.val$action.redo();
                UndoManager.getInstance((Project)this.val$project).undoableActionPerformed(this.val$action);
            }

            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/database/SqlDbManager$4", "run"));
            }
        }.execute();
    }

    public void removeDataSourceInner(SqlDataSourceImpl dataSource) {
        this.myStorage.removeDataSource(dataSource);
        this.detachDataSource(dataSource);
        this.clearCaches(dataSource, true);
    }

    public void addDataSourceInner(SqlDataSourceImpl dataSource) {
        this.myStorage.addDataSource(dataSource);
        this.attachDataSource(dataSource);
        this.clearCaches(dataSource, true);
    }

    private static List<String> getFileUrls(DnDEvent aEvent) {
        try {
            PsiElement[] elements = AbstractProjectViewPane.getTransferedPsiElements((Transferable)aEvent);
            if (elements != null) {
                ArrayList<String> result2 = new ArrayList<String>();
                for (PsiElement element : elements) {
                    VirtualFile file;
                    if (!(element instanceof PsiFile) || (file = ((PsiFile)element).getVirtualFile()) == null || file.getFileType() != SqlFileType.INSTANCE) continue;
                    result2.add(file.getUrl());
                }
                return result2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public DatabaseDialectEx getDatabaseDialect(@NotNull DbDataSource element) {
        if (element == null) {
            SqlDbManager.$$$reportNull$$$0(7);
        }
        return ((SqlDataSourceImpl)element.getDelegate()).getDatabaseDialect();
    }

    @Override
    @Nullable
    public SqlLanguageDialect getSqlDialect(@NotNull DbDataSource element) {
        if (element == null) {
            SqlDbManager.$$$reportNull$$$0(8);
        }
        return ((SqlDataSourceImpl)element.getDelegate()).getSqlDialect();
    }

    @Override
    @NotNull
    protected DbDataSource createDataSourceElement(@NotNull SqlDataSource info) {
        if (info == null) {
            SqlDbManager.$$$reportNull$$$0(9);
        }
        DbDataSource element = super.createDataSourceElement(info);
        element.putUserData(DatabaseDataKeys.DND_TARGET_KEY, (Object)new MyDnDTarget(element));
        DbDataSource dbDataSource = element;
        if (dbDataSource == null) {
            SqlDbManager.$$$reportNull$$$0(10);
        }
        return dbDataSource;
    }

    @Override
    public void addDataSource(@NotNull SqlDataSource dataSource) {
        if (dataSource == null) {
            SqlDbManager.$$$reportNull$$$0(11);
        }
        this.processAddOrRemove((SqlDataSourceImpl)dataSource, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDbManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDbManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceTemplates";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDataSourceName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlDataSourceTemplate
    implements DataSourceTemplate {
        private SqlDataSourceTemplate() {
        }

        @NotNull
        public String getName() {
            String string = SqlMessages.message("action.text.create.sql.datasource", new Object[0]);
            if (string == null) {
                SqlDataSourceTemplate.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFullName() {
            String string = this.getName();
            if (string == null) {
                SqlDataSourceTemplate.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public List<DataSourceTemplate> getSubConfigurations() {
            List<DataSourceTemplate> list = Collections.emptyList();
            if (list == null) {
                SqlDataSourceTemplate.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
            if (project == null) {
                SqlDataSourceTemplate.$$$reportNull$$$0(3);
            }
            SqlDataSourceImpl result2 = copyFrom instanceof SqlDataSourceImpl ? ((SqlDataSourceImpl)copyFrom).copy() : new SqlDataSourceImpl(DasUtil.NO_NAME, project, null);
            result2.setName(StringUtil.notNullize((String)newName, (String)"DDL data source"));
            SqlDataSourceImpl sqlDataSourceImpl = result2;
            if (sqlDataSourceImpl == null) {
                SqlDataSourceTemplate.$$$reportNull$$$0(4);
            }
            return sqlDataSourceImpl;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return DatabaseIcons.DdlDbms;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/database/SqlDbManager$SqlDataSourceTemplate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubConfigurations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/database/SqlDbManager$SqlDataSourceTemplate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDataSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDataSource";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyDnDTarget
    implements DnDTarget {
        private final DbDataSource myElement;

        public MyDnDTarget(DbDataSource element) {
            this.myElement = element;
        }

        public boolean update(DnDEvent aEvent) {
            List files = SqlDbManager.getFileUrls(aEvent);
            return !files.isEmpty();
        }

        public void drop(DnDEvent aEvent) {
            List files = SqlDbManager.getFileUrls(aEvent);
            ArrayList<String> newList = new ArrayList<String>();
            SqlDataSourceImpl sqlDataSource = (SqlDataSourceImpl)this.myElement.getDelegate();
            ContainerUtil.addAll(newList, sqlDataSource.getUrls());
            newList.removeAll(files);
            newList.addAll(files);
            if (!SqlDataSourceConfigurable.checkGenericDialectUsage(this.myElement.getProject(), newList)) {
                return;
            }
            sqlDataSource.setUrls(newList);
            ((SqlDbManager)this.myElement.getDbManager()).clearCaches((DatabaseSystem)this.myElement, false);
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }
}

